/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.directory;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.resource.platform.resourcebase.client.Directory;
import com.sas.svcs.resource.platform.resourcebase.client.File;
import com.sas.svcs.web.data.content.ContentObjectAttrData;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="file")
public class FileData
extends ContentObjectAttrData {
    private static final String FILE_DATA_VERSION = "1";
    private File file;

    public FileData() {
        this(new File());
    }

    public FileData(File file) {
        super((ContentComponent)file);
        this.file = file;
    }

    public Properties getProperties() {
        return this.file.getProperties();
    }

    public void setProperties(Properties properties) {
        this.file.setProperties(properties);
    }

    @XmlAttribute
    public String getFileExtension() {
        return this.file.getFileExtension();
    }

    public void setFileExtension(String fileExtension) {
        this.file.setFileExtension(fileExtension);
    }

    @XmlAttribute
    public String getFileName() {
        return this.file.getFileName();
    }

    public void setFileName(String fileName) {
        this.file.setFileName(fileName);
    }

    @XmlAttribute
    public boolean isRelativeName() {
        return this.file.isRelativeName();
    }

    public void setRelativeName(boolean isRelativeName) {
        this.file.setRelativeName(isRelativeName);
    }

    @XmlAttribute
    public String getTextRole() {
        return this.file.getTextRole();
    }

    public void setTextRole(String textRole) {
        this.file.setTextRole(textRole);
    }

    @XmlAttribute
    public String getTextType() {
        return this.file.getTextType();
    }

    public void setTextType(String textType) {
        this.file.setTextType(textType);
    }

    @XmlAttribute
    public String getVersion() {
        return FILE_DATA_VERSION;
    }

    @XmlElement(name="links")
    public Links getLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        if (this.file != null) {
            result.add(new Link("GET", "self", "/content/files/" + ContentRESTUtils.getIdForLink((String)this.file.getId())));
            ReferenceList directoryRef = this.file.getDirectories();
            if (directoryRef != null && directoryRef.getTargetList() != null) {
                for (Directory nextDirectory : (ArrayList)directoryRef.getTargetList()) {
                    Link dLink = new Link("GET", "up", "/content/directories/" + ContentRESTUtils.getIdForLink((String)nextDirectory.getId()));
                    result.add(dLink);
                }
            }
        }
        return new Links(result);
    }
}

