/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.util;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.registry.client.RESTServiceFilter;
import com.sas.svcs.registry.client.RegisteredService;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;

@PreAuthorize(value="isAuthenticated()")
public class RegistryUtil {
    private ServiceRegistryInterface registry;
    private Map<Long, String> objectTypeToUrl = new HashMap<Long, String>();
    private static final String NULL_URL = "NULL_URL";

    @Autowired
    public void setServiceRegistry(ServiceRegistryInterface registry) {
        this.registry = registry;
    }

    private RegisteredService getServiceForObjectType(long objectType) {
        Map restServiceMap = this.registry.getServices(Arrays.asList(new RESTServiceFilter()));
        for (RegisteredService service : restServiceMap.values()) {
            String prop = service.getProperty("ObjectType");
            if (prop == null || Long.parseLong(prop) != objectType) continue;
            return service;
        }
        return null;
    }

    public String getUrlForObjectType(long objectType) {
        String ret = this.objectTypeToUrl.get(objectType);
        if (NULL_URL.equals(ret)) {
            return null;
        }
        if (null != ret) {
            return ret;
        }
        RegisteredService service = this.getServiceForObjectType(objectType);
        if (service == null) {
            this.objectTypeToUrl.put(objectType, NULL_URL);
        } else {
            ret = service.getUrl();
            this.objectTypeToUrl.put(objectType, ret);
        }
        return ret;
    }

    public String getRestUrl(ObjectIdentity objectId) {
        String url = this.getUrlForObjectType(objectId.getObjectType());
        if (url != null) {
            url = url.replaceAll("\\{object-type-id\\}", Long.toString(objectId.getObjectType()));
            url = url.replaceAll("\\{object-id\\}", ContentRESTUtils.getIdForLink((String)objectId.getId()));
        }
        return url;
    }
}

