/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.util;

import com.sas.svcs.labeledentity.client.Label;
import com.sas.svcs.labeledentity.client.LabeledEntity;
import com.sas.svcs.web.data.authorization.AuthorizationLabel;
import com.sas.svcs.web.data.authorization.AuthorizationLabels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AuthorizationUtil {
    public static AuthorizationLabels restLabelsForLabeledEntities(LabeledEntity le) {
        if (null == le) {
            return null;
        }
        Collection leLabels = le.getLabels().values();
        ArrayList<AuthorizationLabel> labels = new ArrayList<AuthorizationLabel>(leLabels.size());
        for (Label leLabel : leLabels) {
            labels.add(new AuthorizationLabel(leLabel.getLocale().toString(), leLabel.getValue()));
        }
        return new AuthorizationLabels(labels);
    }

    public static Locale localeFromString(String locale) {
        if (null == locale) {
            return null;
        }
        String[] parts = locale.split("_");
        Locale loc = null;
        if (parts.length == 3) {
            loc = new Locale(parts[0], parts[1], parts[2]);
        } else if (parts.length == 2) {
            loc = new Locale(parts[0], parts[1]);
        } else if (parts.length == 1) {
            loc = new Locale(parts[0]);
        } else {
            throw new IllegalArgumentException("Locale '" + locale + "' could not be converted to a valid locale");
        }
        return loc;
    }

    public static Map<Locale, Label> labelsForRestLabel(AuthorizationLabels authorizationLabels) {
        if (null == authorizationLabels) {
            return Collections.emptyMap();
        }
        List<AuthorizationLabel> labelList = authorizationLabels.labels;
        HashMap<Locale, Label> labels = new HashMap<Locale, Label>(labelList.size());
        for (AuthorizationLabel pl : labelList) {
            Locale loc = AuthorizationUtil.localeFromString(pl.locale);
            labels.put(loc, new Label(loc, pl.value));
        }
        return labels;
    }
}

