/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.relationships;

import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.RelationshipModel;
import com.sas.svcs.content.relationship.client.RelationshipService;
import com.sas.svcs.content.relationship.client.Resource;
import com.sas.svcs.web.data.relationships.RelationshipModelData;
import com.sas.svcs.web.data.relationships.RelationshipModels;
import com.sas.svcs.web.data.relationships.ResourceData;
import com.sas.svcs.web.data.relationships.Resources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RelationshipController {
    RelationshipService service;

    @Autowired
    public void setRelationshipService(RelationshipService relationshipService) {
        this.service = relationshipService;
    }

    @RequestMapping(value={"/relsvc/{objectTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Resources> getResourcesByType(@PathVariable long objectTypeId) throws RelationshipException {
        List lrt = this.service.getResourcesByType(new long[]{objectTypeId});
        return new ResponseEntity((Object)new Resources(lrt), HttpStatus.OK);
    }

    @RequestMapping(value={"/relsvc/{objectTypeId}/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ResourceData> getResource(@PathVariable long objectTypeId, @PathVariable String objectId) throws RelationshipException {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Resource rt = this.service.getResource(objectTypeId, id);
        if (rt != null) {
            return new ResponseEntity((Object)new ResourceData(rt), HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/relsvc"}, method={RequestMethod.POST}, consumes={"application/json", "application/xml"})
    @ResponseBody
    public ResponseEntity<ResourceData> createResource(@RequestBody ResourceData resource) throws RelationshipException {
        try {
            Resource newResource = this.service.createResource(resource.toResource());
            return new ResponseEntity((Object)new ResourceData(newResource), HttpStatus.CREATED);
        }
        catch (ObjectExistsException e) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(value={"/relsvc/{objectTypeId}/{objectId}"}, method={RequestMethod.PUT}, consumes={"application/json", "application/xml"})
    @ResponseBody
    public ResponseEntity<ResourceData> updateResource(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestBody ResourceData resource) throws RelationshipException {
        Resource r = resource.toResource();
        try {
            r = this.service.updateResource(r);
        }
        catch (RelationshipException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new ResourceData(r), HttpStatus.OK);
    }

    @RequestMapping(value={"/relsvc/{objectTypeId}/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteResource(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Resource r = new Resource();
        r.setObjectType(objectTypeId);
        r.setId(id);
        try {
            this.service.deleteResource(r);
        }
        catch (RelationshipException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/relsvc/{objectTypeId}/{objectId}/relationships"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<RelationshipModels> getRelationships(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestParam(value="relationshipTypes", required=false) String[] relationshipTypes, @RequestParam(value="direction", defaultValue="1") int direction, @RequestParam(value="objectTypes", required=false) Long[] objectTypes, @RequestParam(value="depth", defaultValue="1") int depth) throws RelationshipException {
        List l;
        List<String> rtl = null;
        List<Long> otl = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Resource r = new Resource();
        r.setId(id);
        r.setObjectType(objectTypeId);
        if (relationshipTypes != null) {
            rtl = Arrays.asList(relationshipTypes);
        }
        if (objectTypes != null) {
            otl = Arrays.asList(objectTypes);
        }
        RelationshipDirection d = RelationshipDirection.TO;
        if (direction == 2) {
            d = RelationshipDirection.FROM;
        } else if (direction == 3) {
            d = RelationshipDirection.BOTH;
        }
        if (depth == 1) {
            RelationshipModel rm = this.service.getRelationships(r, rtl, d, otl);
            if (rm != null) {
                RelationshipModelData rmData = new RelationshipModelData(rm);
                ArrayList<RelationshipModel> l2 = new ArrayList<RelationshipModel>();
                l2.add(rmData.toRelationshipModel());
                return new ResponseEntity((Object)new RelationshipModels(l2), HttpStatus.OK);
            }
        } else if (depth > 1 && (l = this.service.getRelationships(r, rtl, d, otl, depth)) != null) {
            return new ResponseEntity((Object)new RelationshipModels(l), HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/relsvc/relationships"}, method={RequestMethod.PUT}, consumes={"application/json", "application/xml"})
    @ResponseBody
    public ResponseEntity<RelationshipModels> updateRelationships(@RequestBody RelationshipModels relationshipModels) throws RelationshipException {
        try {
            ArrayList<RelationshipModel> returnList = new ArrayList<RelationshipModel>();
            List<RelationshipModelData> rml = relationshipModels.getRelationshipModels();
            for (RelationshipModelData rmData : rml) {
                RelationshipModel rm = this.service.replaceRelationships(rmData.toRelationshipModel());
                returnList.add(rm);
            }
            return new ResponseEntity((Object)new RelationshipModels(returnList), HttpStatus.CREATED);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/relsvc/relationships"}, method={RequestMethod.POST}, consumes={"application/json", "application/xml"})
    @ResponseBody
    public ResponseEntity<RelationshipModels> addRelationships(@RequestBody RelationshipModels relationshipModels) throws RelationshipException {
        ArrayList<RelationshipModel> returnList = new ArrayList<RelationshipModel>();
        List<RelationshipModelData> rml = relationshipModels.getRelationshipModels();
        for (RelationshipModelData rmData : rml) {
            RelationshipModel rm = this.service.addRelationships(rmData.toRelationshipModel());
            returnList.add(rm);
        }
        return new ResponseEntity((Object)new RelationshipModels(returnList), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/relsvc/{objectTypeId}/{objectId}/relationships"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> removeAllRelationships(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestParam(value="relationshipType", required=false) String relationshipType) throws RelationshipException {
        try {
            String id = ContentRESTUtils.getIdFromLink((String)objectId);
            Resource r = new Resource();
            r.setObjectType(objectTypeId);
            r.setId(id);
            if (relationshipType != null) {
                this.service.removeRelationships(r, relationshipType, null);
            } else {
                this.service.removeAllRelationships(r);
            }
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

