/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.relationships;

import com.sas.commons.expr.BaseVisitor;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.Function;
import com.sas.commons.rest.util.Timestamp;
import com.sas.svcs.common.client.ContentMatchType;
import com.sas.svcs.content.relationship.client.report.RelationshipContentFilterCriteria;
import com.sas.svcs.web.controllers.rest.relationships.RESTRelationshipException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpStatus;

public class ContentFilterExpressionVisitor
extends BaseVisitor {
    private static final String FILTER_TYPE = "type";
    private static final String FILTER_NAME = "name";
    private static final String FILTER_DESCRIPTION = "includeDesc";
    private static final String FILTER_CREATED_DATE = "creationTimeStamp";
    private static final String FILTER_MODIFIED_DATE = "modifiedTimeStamp";
    private static final String OPERATOR_EQUALS = "eq";
    private static final String OPERATOR_CONTAINS = "contains";
    private static final String OPERATOR_STARTSWITH = "startsWith";
    private static final String OPERATOR_LT = "lt";
    private static final String OPERATOR_LTE = "le";
    private static final String OPERATOR_GT = "gt";
    private static final String OPERATOR_GTE = "ge";
    private static final String OPERATOR_IN = "in";
    private static final String OPERATOR_AND = "and";
    private static Set<String> supportedOperators = new HashSet<String>();
    private String filterName;
    private ContentMatchType filterNameMatchType;
    private boolean filterDescription;
    private Set<String> filterTypes;
    private boolean filterUseModifiedDates;
    private Date filterBefore;
    private Date filterSince;

    public ContentFilterExpressionVisitor() {
        supportedOperators.add(OPERATOR_EQUALS);
        supportedOperators.add(OPERATOR_CONTAINS);
        supportedOperators.add(OPERATOR_STARTSWITH);
        supportedOperators.add(OPERATOR_LT);
        supportedOperators.add(OPERATOR_LTE);
        supportedOperators.add(OPERATOR_GT);
        supportedOperators.add(OPERATOR_GTE);
        this.filterNameMatchType = ContentMatchType.MATCH_CONTAINS;
    }

    public RelationshipContentFilterCriteria getContentFilter() {
        RelationshipContentFilterCriteria filter = new RelationshipContentFilterCriteria();
        filter.setUseModifiedDate(this.filterUseModifiedDates);
        if (this.filterName != null) {
            filter.setName(this.filterName);
            filter.setNameTypeMatch(this.filterNameMatchType);
            filter.setIncludeDescription(this.filterDescription);
        }
        if (this.filterTypes != null) {
            filter.setTypes(new ArrayList<String>(this.filterTypes));
        }
        if (this.filterBefore != null) {
            filter.setBefore(this.filterBefore);
        }
        if (this.filterSince != null) {
            filter.setSince(this.filterSince);
        }
        return filter;
    }

    public Expression visitFunction(Function function) {
        String name = function.getFunctionName();
        if (OPERATOR_AND.equalsIgnoreCase(name)) {
            this.parseLogicalFunction(function);
        } else if (OPERATOR_IN.equalsIgnoreCase(name)) {
            this.parseInFunction(function, name);
        } else if (supportedOperators.contains(name)) {
            this.parseArguments(function, name);
        } else {
            for (Expression expr : function.getArguments()) {
                expr.accept((ExpressionVisitor)this);
            }
        }
        return function;
    }

    private void parseInFunction(Function function, String name) {
        List args = function.getArguments();
        this.validateArgs(name, args);
        String key = this.decodeString(((Expression)args.get(0)).toString());
        if (!FILTER_TYPE.equalsIgnoreCase(key)) {
            throw new RESTRelationshipException(HttpStatus.BAD_REQUEST, "Invalid filter syntax.  The \"in\" operator may only be used on the \"type\" field.");
        }
        int index = 0;
        LinkedHashSet<String> values = new LinkedHashSet<String>(args.size() - 1);
        for (Expression arg : args) {
            if (index++ == 0) continue;
            String value = this.decodeString(arg.toString());
            values.add(value);
        }
        for (String value : values) {
            this.addTypeFilter(value);
        }
    }

    private void parseLogicalFunction(Function function) {
        for (Expression expr : function.getArguments()) {
            expr.accept((ExpressionVisitor)this);
        }
    }

    private void parseArguments(Function function, String operator) {
        List args = function.getArguments();
        this.validateArgs(operator, args);
        String key = this.decodeString(((Expression)args.get(0)).toString());
        String value = this.decodeString(((Expression)args.get(1)).toString());
        if (FILTER_NAME.equalsIgnoreCase(key)) {
            this.validateOperator(key, operator, OPERATOR_EQUALS, OPERATOR_CONTAINS, OPERATOR_STARTSWITH);
            this.setNameFilter(value);
            if (OPERATOR_EQUALS.equalsIgnoreCase(operator)) {
                this.setNameMatchType(ContentMatchType.MATCH_EQUALS);
            } else if (OPERATOR_CONTAINS.equalsIgnoreCase(operator)) {
                this.setNameMatchType(ContentMatchType.MATCH_CONTAINS);
            } else if (OPERATOR_STARTSWITH.equalsIgnoreCase(operator)) {
                this.setNameMatchType(ContentMatchType.MATCH_STARTSWITH);
            }
        } else if (FILTER_DESCRIPTION.equalsIgnoreCase(key)) {
            this.validateOperator(key, operator, OPERATOR_EQUALS);
            this.setDescriptionFilter(value);
        } else if (FILTER_TYPE.equalsIgnoreCase(key)) {
            this.validateOperator(key, operator, OPERATOR_EQUALS);
            this.addTypeFilter(value);
        } else if (FILTER_CREATED_DATE.equalsIgnoreCase(key)) {
            this.validateOperator(key, operator, OPERATOR_LT, OPERATOR_LTE, OPERATOR_GT, OPERATOR_GTE);
            this.setDateFilter(key, operator, value, false);
        } else if (FILTER_MODIFIED_DATE.equalsIgnoreCase(key)) {
            this.validateOperator(key, operator, OPERATOR_EQUALS, OPERATOR_LT, OPERATOR_LTE, OPERATOR_GT, OPERATOR_GTE);
            this.setDateFilter(key, operator, value, true);
        }
    }

    private void validateOperator(String filterName, String operator, String ... validOperators) {
        for (String validOperator : validOperators) {
            if (!operator.equalsIgnoreCase(validOperator)) continue;
            return;
        }
        throw new RESTRelationshipException(HttpStatus.BAD_REQUEST, "Invalid operator (" + operator + ") specified for " + filterName);
    }

    private void addTypeFilter(String value) {
        if (this.filterTypes == null) {
            this.filterTypes = new HashSet<String>();
        }
        this.filterTypes.add(value);
    }

    private void setNameFilter(String value) {
        this.filterName = value;
    }

    private void setNameMatchType(ContentMatchType matchType) {
        this.filterNameMatchType = matchType;
    }

    private void setDescriptionFilter(String value) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            this.filterDescription = true;
        }
    }

    private void setDateFilter(String filterName, String operator, String value, boolean useModifiedDate) {
        Date date;
        try {
            date = Timestamp.parseTimestampAsDate((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new RESTRelationshipException(HttpStatus.BAD_REQUEST, "Invalid date format: " + value);
        }
        this.filterUseModifiedDates = useModifiedDate;
        if (OPERATOR_LT.equalsIgnoreCase(operator) || OPERATOR_LTE.equalsIgnoreCase(operator)) {
            this.filterBefore = date;
        } else if (OPERATOR_GT.equalsIgnoreCase(operator) || OPERATOR_GTE.equalsIgnoreCase(operator)) {
            this.filterSince = date;
        }
    }

    private void validateArgs(String name, List<Expression> args) {
        if (args == null || args.size() <= 1) {
            throw new RESTRelationshipException(HttpStatus.BAD_REQUEST, "Invalid argument list.  Arguments must be provided for the " + name + " function.");
        }
    }

    private String decodeString(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

