/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.content;

import com.sas.commons.rest.spring.ErrorResponseFactory;
import com.sas.commons.rest.util.Error;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.InvalidLengthException;
import com.sas.svcs.content.framework.client.InvalidNameException;
import com.sas.svcs.content.framework.client.InvalidParentException;
import com.sas.svcs.content.framework.client.NameInUseException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.lifecycle.client.ContentValidationService;
import com.sas.svcs.web.controllers.rest.content.ValidationMethod;
import com.sas.svcs.web.data.content.ContentRelationship;
import com.sas.svcs.web.data.content.Validation;
import com.sas.svcs.web.data.content.ValidationProperty;
import com.sas.svcs.web.data.content.ValidationPropertyType;
import com.sas.svcs.web.data.content.ValidationRequest;
import java.util.Arrays;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

class NameValidation
implements ValidationMethod {
    private ContentValidationService validationService;

    public NameValidation(ContentValidationService validationService) {
        this.validationService = validationService;
    }

    @Override
    public ResponseEntity<?> submitValidation(ValidationRequest request, String language) {
        String parentUri;
        String resourceName = null;
        ValidationProperty property = request.getProperty("name", ValidationPropertyType.STRING);
        if (property != null) {
            resourceName = property.getValue();
        }
        if (resourceName == null) {
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Missing resource name.", null);
        }
        ObjectIdentity parentIdentity = null;
        ContentRelationship relationship = request.getRelationship("parent");
        if (relationship != null && (parentUri = relationship.getTarget()) != null) {
            try {
                parentIdentity = ContentRESTUtils.parseContentUri((String)parentUri);
            }
            catch (IllegalArgumentException e) {
                return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getLocalizedMessage(), null);
            }
        }
        Validation response = new Validation();
        try {
            boolean result = this.validationService.canCreate(resourceName, request.getObjectType(), parentIdentity);
            if (result) {
                response.setValid(true);
            } else {
                response.setValid(false);
                response.setError(new Error(HttpStatus.OK.value(), 100, "The content object could not be validated."));
            }
        }
        catch (InvalidLengthException e) {
            response.setValid(false);
            Error error = new Error(HttpStatus.OK.value(), 101, e.getMessage());
            error.setDetails(Arrays.asList("minLength=" + e.getMinLength(), "maxLength=" + e.getMaxLength()));
            response.setError(error);
        }
        catch (InvalidNameException e) {
            response.setValid(false);
            Error error = new Error(HttpStatus.OK.value(), 102, e.getMessage());
            String illegalChars = "";
            char[] chars = e.getIllegalChars();
            if (chars != null) {
                int count = 0;
                for (char c : chars) {
                    if (count > 0) {
                        illegalChars = illegalChars + " ";
                    }
                    illegalChars = illegalChars + c;
                    ++count;
                }
            }
            error.setDetails(Arrays.asList("illegalChars=" + illegalChars, "containsLeadingTrailingSpaces=" + e.containsLeadingTrailingSpaces()));
            response.setError(error);
        }
        catch (NameInUseException e) {
            response.setValid(false);
            response.setError(new Error(HttpStatus.OK.value(), 103, e.getMessage()));
        }
        catch (InvalidParentException e) {
            response.setValid(false);
            response.setError(new Error(HttpStatus.OK.value(), 104, e.getMessage()));
        }
        catch (ValidationException e) {
            response.setValid(false);
            response.setError(new Error(HttpStatus.OK.value(), 100, e.getMessage()));
        }
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }
}

