/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.content;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.ResourceCollection;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIDescriptor;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.svcs.web.data.types.ObjectTypeUIDescriptorData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ContentTypeController {
    private static final String COLLECTION_TYPE = "objectTypes";
    private ObjectTypeService objectTypeService;
    private ObjectTypeUIService uiService;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    @Autowired
    public void setObjectTypeUIService(ObjectTypeUIService uiService) {
        this.uiService = uiService;
    }

    @RequestMapping(value={"/content/objectTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public ResourceCollection<ObjectTypeUIDescriptorData> getObjectTypeUIDescriptors(@RequestParam(value="id", required=false) String idStr, Locale locale) {
        ArrayList<ObjectTypeUIDescriptor> objectTypeUis;
        List<Long> ids = this.toIds(idStr);
        if (ids != null && !ids.isEmpty()) {
            objectTypeUis = new ArrayList<ObjectTypeUIDescriptor>(ids.size());
            for (long id : ids) {
                ObjectTypeUIDescriptor type = this.uiService.getObjectTypeDescriptor(id);
                if (type == null) continue;
                objectTypeUis.add(type);
            }
        } else {
            objectTypeUis = this.uiService.getAllObjectTypeDescriptors();
        }
        ArrayList<ObjectTypeUIDescriptorData> objectTypeList = new ArrayList<ObjectTypeUIDescriptorData>(objectTypeUis.size());
        for (ObjectTypeUIDescriptor ui : objectTypeUis) {
            objectTypeList.add(new ObjectTypeUIDescriptorData(this.objectTypeService.getTypeById(ui.getId()), ui, locale, this.getLinks(ui)));
        }
        ArrayList<Link> links = new ArrayList<Link>(idStr == null ? 1 : 2);
        String uri = idStr == null ? "/content/objectTypes" : "/content/objectTypes?id=" + idStr;
        links.add(new Link("GET", "self", uri));
        if (idStr != null) {
            links.add(new Link("GET", "alternative", "/content/objectTypes"));
        }
        return new ResourceCollection(objectTypeList, null, null, Long.valueOf(objectTypeList.size()), new Links(links), "application/vnd.sas.content.object.type", COLLECTION_TYPE);
    }

    @RequestMapping(value={"/content/objectTypes"}, method={RequestMethod.GET}, params={"name"})
    @ResponseBody
    public ResourceCollection<ObjectTypeUIDescriptorData> getObjectTypeUIDescriptorsByName(@RequestParam(value="name") String nameStr, Locale locale) {
        ArrayList<ObjectTypeUIDescriptor> objectTypeUis;
        List<String> names = this.toNames(nameStr);
        if (names != null && !names.isEmpty()) {
            objectTypeUis = new ArrayList<ObjectTypeUIDescriptor>(names.size());
            for (String string : names) {
                ObjectTypeUIDescriptor type = this.uiService.getObjectTypeDescriptorByName(string);
                if (type == null) continue;
                objectTypeUis.add(type);
            }
        } else {
            objectTypeUis = this.uiService.getAllObjectTypeDescriptors();
        }
        ArrayList<ObjectTypeUIDescriptorData> objectTypeList = new ArrayList<ObjectTypeUIDescriptorData>();
        for (ObjectTypeUIDescriptor ui : objectTypeUis) {
            objectTypeList.add(new ObjectTypeUIDescriptorData(this.objectTypeService.getTypeById(ui.getId()), ui, locale, this.getLinks(ui)));
        }
        ArrayList<Link> arrayList = new ArrayList<Link>(2);
        arrayList.add(new Link("GET", "self", "/content/objectTypes?name=" + nameStr));
        arrayList.add(new Link("GET", "alternative", "/content/objectTypes"));
        return new ResourceCollection(objectTypeList, null, null, Long.valueOf(objectTypeList.size()), new Links(arrayList), "application/vnd.sas.content.object.type", COLLECTION_TYPE);
    }

    @RequestMapping(value={"/content/objectTypes/{objectTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ObjectTypeUIDescriptorData> getObjectTypeUIDescriptor(@PathVariable long objectTypeId, Locale locale) {
        ObjectTypeUIDescriptor ui = this.uiService.getObjectTypeDescriptor(objectTypeId);
        if (ui == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new ObjectTypeUIDescriptorData(this.objectTypeService.getTypeById(ui.getId()), ui, locale, this.getLinks(ui)), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/objectTypes/{objectTypeId}/icon"}, method={RequestMethod.GET})
    public void getIcon(@PathVariable long objectTypeId, HttpServletResponse response) throws IOException {
        ObjectTypeUIDescriptor ui = this.uiService.getObjectTypeDescriptor(objectTypeId);
        if (ui == null) {
            response.sendError(404);
            return;
        }
        byte[] contents = ui.getIconContents();
        if (contents == null) {
            response.sendError(404);
            return;
        }
        response.setContentType(MediaType.IMAGE_GIF.toString());
        response.setContentLength(contents.length);
        response.getOutputStream().write(contents);
    }

    private List<String> toNames(String nameStr) {
        if (nameStr != null) {
            String[] names = nameStr.split("[|]");
            return Arrays.asList(names);
        }
        return null;
    }

    private List<Long> toIds(String idStr) {
        if (idStr != null) {
            String[] ids = idStr.split("[|]");
            ArrayList<Long> ret = new ArrayList<Long>(ids.length);
            for (String id : ids) {
                try {
                    long idLong = Long.parseLong(id);
                    ret.add(idLong);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return ret;
        }
        return null;
    }

    private List<Link> getLinks(ObjectTypeUIDescriptor ui) {
        ArrayList<Link> links = new ArrayList<Link>(3);
        links.add(new Link("", "self", "/content/objectTypes/" + ui.getId()));
        Link icon = new Link("GET", "icon", "/content/objectTypes/" + ui.getId() + "/icon");
        icon.setType("image/gif");
        links.add(icon);
        return links;
    }
}

