/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.spring.ErrorResponseFactory;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.lifecycle.client.LifecycleService;
import com.sas.svcs.content.storedprocess.client.StoredProcess;
import com.sas.svcs.content.storedprocess.client.StoredProcessService;
import com.sas.svcs.content.storedprocessreport.client.StoredProcessReport;
import com.sas.svcs.content.storedprocessreport.client.StoredProcessReportService;
import com.sas.svcs.web.data.storedprocess.StoredProcessReportData;
import com.sas.svcs.web.data.storedprocess.StoredProcessReports;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/content/114"})
public class StoredProcessReportController {
    private static final Logger _logger = LogManager.getLogger(StoredProcessReportController.class);
    public static final String SP_URI_PREFIX = "/content/52/";
    @Autowired
    private StoredProcessReportService _storedProcessReportService;
    @Autowired
    private StoredProcessService _storedProcessService;
    @Autowired
    private LifecycleService _lifecycleService;
    @Autowired
    private AuthorizationService authorizationService;

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<StoredProcessReportData> getStoredProcessReport(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        StoredProcessReport storedProcessReport = this._storedProcessReportService.getStoredProcessReportById(new ObjectIdentity(114L, id));
        if (storedProcessReport == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        StoredProcessReportData data = this.createDataObject(storedProcessReport);
        return new ResponseEntity((Object)data, HttpStatus.OK);
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> createStoredProcessReport(@PathVariable String objectId, @RequestBody StoredProcessReportData data) {
        StoredProcessReportData returnedData;
        String parentId = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity parentOid = new ObjectIdentity(28L, parentId);
        StoredProcessReport storedProcessReport = (StoredProcessReport)data.toContentComponent();
        try {
            this.updateLinks(data, null);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            _logger.error(msg);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)msg, null);
        }
        try {
            StoredProcessReport createdReport = this._storedProcessReportService.createStoredProcessReport(parentOid, storedProcessReport);
            returnedData = this.createDataObject(createdReport);
        }
        catch (Exception e) {
            _logger.error("Error creating stored process report.", (Throwable)e);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage(), null);
        }
        return new ResponseEntity((Object)returnedData, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{objectId}/name"}, method={RequestMethod.PUT}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> renameStoredProcessReport(@PathVariable String objectId, @RequestBody String newName) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity oid = new ObjectIdentity(114L, id);
        StoredProcessReport storedProcessReport = this._storedProcessReportService.getStoredProcessReportById(oid);
        if (storedProcessReport == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (storedProcessReport.getName().equals(newName)) {
            String msg = "Name specified \"" + newName + "\" is the same as original name.";
            _logger.error(msg);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)msg, null);
        }
        try {
            boolean success = this._lifecycleService.renameObject(oid, newName);
            return new ResponseEntity(success ? HttpStatus.NO_CONTENT : HttpStatus.CONFLICT);
        }
        catch (ObjectNotFoundException onfe) {
            _logger.error("Error renaming stored process report.", (Throwable)onfe);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.NOT_FOUND, (String)onfe.getMessage(), null);
        }
        catch (ObjectExistsException onfe) {
            _logger.error("Error renaming stored process report.", (Throwable)onfe);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.CONFLICT, (String)onfe.getMessage(), null);
        }
        catch (ValidationException onfe) {
            _logger.error("Error renaming stored process report.", (Throwable)onfe);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)onfe.getMessage(), null);
        }
        catch (Exception e) {
            _logger.error("Error renaming stored process report.", (Throwable)e);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> updateStoredProcessReport(@PathVariable String objectId, @RequestBody StoredProcessReportData data) {
        StoredProcessReportData returnedData;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity oid = new ObjectIdentity(114L, id);
        StoredProcessReport storedProcessReport = this._storedProcessReportService.getStoredProcessReportById(oid);
        if (storedProcessReport == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        StoredProcessReport incomingDto = (StoredProcessReport)data.toContentComponent();
        String reportIdFromRequestBody = incomingDto.getId();
        if (reportIdFromRequestBody != null && reportIdFromRequestBody.length() > 0) {
            if (!id.equalsIgnoreCase(reportIdFromRequestBody)) {
                String msg = "Request body id (" + reportIdFromRequestBody + ") different from id in uri (" + objectId + ")";
                _logger.error(msg);
                return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)msg, null);
            }
        } else {
            incomingDto.setId(id);
        }
        if (!storedProcessReport.getName().equals(incomingDto.getName())) {
            String msg = "This method cannot be called to rename the stored process report.";
            _logger.error(msg);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)msg, null);
        }
        try {
            this.updateLinks(data, storedProcessReport);
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage(), null);
        }
        try {
            StoredProcessReport updatedReport = this._storedProcessReportService.updateStoredProcessReport(incomingDto);
            returnedData = this.createDataObject(updatedReport);
        }
        catch (Exception e) {
            _logger.error("Error updating stored process report.", (Throwable)e);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage(), null);
        }
        return new ResponseEntity((Object)returnedData, HttpStatus.OK);
    }

    private void updateLinks(StoredProcessReportData incomingData, StoredProcessReport storedProcessReport) throws Exception {
        boolean hadIncomingSP = false;
        StoredProcessReport incomingDto = (StoredProcessReport)incomingData.toContentComponent();
        List<Link> linkList = incomingData.getLinks();
        if (linkList != null) {
            for (Link link : linkList) {
                if (!link.getMethod().equalsIgnoreCase("put") || !link.getRel().equals("storedprocess")) continue;
                String uri = link.getUri();
                if (!uri.startsWith(SP_URI_PREFIX)) {
                    throw new Exception("Stored process link uri does not start with /content/114");
                }
                String webKey = uri.substring(SP_URI_PREFIX.length());
                String spId = ContentRESTUtils.getIdFromLink((String)webKey);
                StoredProcess sp = this._storedProcessService.getStoredProcessDescriptor(new ObjectIdentity(52L, spId));
                if (sp == null) {
                    throw new Exception("Could not find stored process corresponding to " + uri);
                }
                incomingDto.getStoredProcess().setTarget((Identifiable)sp);
                hadIncomingSP = true;
            }
        }
        if (!hadIncomingSP && storedProcessReport != null) {
            incomingDto.getStoredProcess().setTarget((Identifiable)((StoredProcess)storedProcessReport.getStoredProcess().getTarget()));
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<StoredProcessReports> getStoredProcessReports(@RequestParam(value="id", required=false) List<String> ids) {
        ArrayList<StoredProcessReport> storedProcessReports;
        if (ids == null) {
            storedProcessReports = this._storedProcessReportService.getAllStoredProcessReports();
        } else {
            storedProcessReports = new ArrayList<StoredProcessReport>(ids.size());
            for (String id : ids) {
                StoredProcessReport storedProcessReport = this._storedProcessReportService.getStoredProcessReportDescriptor(new ObjectIdentity(114L, ContentRESTUtils.getIdFromLink((String)id)));
                if (storedProcessReport == null) continue;
                storedProcessReports.add(storedProcessReport);
            }
        }
        ArrayList<StoredProcessReportData> storedProcessReportDataList = new ArrayList<StoredProcessReportData>(storedProcessReports.size());
        for (StoredProcessReport storedProcessReport : storedProcessReports) {
            storedProcessReportDataList.add(this.createDataObject(storedProcessReport));
        }
        return new ResponseEntity((Object)new StoredProcessReports(storedProcessReportDataList), HttpStatus.OK);
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteStoredProcessReport(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        StoredProcessReport storedProcessReport = this._storedProcessReportService.getStoredProcessReportDescriptor(new ObjectIdentity(114L, id));
        if (storedProcessReport == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            EffectivePermissions permissions = this.authorizationService.getEffectivePermissions(ObjectIdentityUtils.createObjectIdentity((Identifiable)storedProcessReport));
            if (permissions == null || !permissions.isDeleteAllowed()) {
                return new ResponseEntity(HttpStatus.FORBIDDEN);
            }
            this._storedProcessReportService.deleteStoredProcessReport(storedProcessReport);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private StoredProcessReportData createDataObject(StoredProcessReport storedProcessReport) {
        StoredProcessReportData data = new StoredProcessReportData(storedProcessReport, true);
        return data;
    }
}

