/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.spring.ErrorResponseFactory;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.lifecycle.client.LifecycleService;
import com.sas.svcs.content.storedprocess.client.StoredProcess;
import com.sas.svcs.content.storedprocess.client.StoredProcessService;
import com.sas.svcs.resource.platform.resourcebase.client.Directory;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerContext;
import com.sas.svcs.resource.platform.serverdata.client.ServerDataService;
import com.sas.svcs.resource.platform.software.client.SoftwareResourceBase;
import com.sas.svcs.web.data.storedprocess.StoredProcessData;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/content/52"})
public class StoredProcessController {
    private static final Logger _logger = LogManager.getLogger(StoredProcessController.class);
    public static final String LINK_REL_SOURCE_CODE_REPOSITORY = "sourceCodeRepository";
    public static final String LINK_REL_SERVER_CONTEXT = "serverContext";
    public static final String LINK_REL_LOGICAL_SERVER = "logicalServer";
    public static final String SCR_URI_PREFIX = "/content/51/";
    public static final String SC_URI_PREFIX = "/content/42/";
    public static final String LSPS_URI_PREFIX = "/content/36/";
    public static final String LWKS_URI_PREFIX = "/content/37/";
    @Autowired
    private StoredProcessService _storedProcessService;
    @Autowired
    private LifecycleService _lifecycleService;
    @Autowired
    private ServerDataService _serverDataService;
    @Autowired
    private AuthorizationService authorizationService;

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<StoredProcessData> getStoredProcess(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        StoredProcess storedProcess = this._storedProcessService.getStoredProcessById(new ObjectIdentity(52L, id));
        if (storedProcess == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        StoredProcessData retData = this.createDataObject(storedProcess);
        return new ResponseEntity((Object)retData, HttpStatus.OK);
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> createStoredProcess(@PathVariable String objectId, @RequestBody StoredProcessData data) {
        StoredProcessData returnedData;
        String parentId = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity parentOid = new ObjectIdentity(28L, parentId);
        StoredProcess storedProcess = (StoredProcess)data.toContentComponent();
        try {
            this.updateLinks(data, null);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            _logger.error(msg);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)msg, null);
        }
        try {
            StoredProcess createdSP = this._storedProcessService.createStoredProcess(parentOid, storedProcess);
            returnedData = this.createDataObject(createdSP);
        }
        catch (Exception e) {
            _logger.error("Error creating stored process report.", (Throwable)e);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage(), null);
        }
        return new ResponseEntity((Object)returnedData, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{objectId}/name"}, method={RequestMethod.PUT}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> renameStoredProcess(@PathVariable String objectId, @RequestBody String newName) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity oid = new ObjectIdentity(52L, id);
        StoredProcess storedProcess = this._storedProcessService.getStoredProcessById(oid);
        if (storedProcess == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (storedProcess.getName().equals(newName)) {
            String msg = "Name specified \"" + newName + "\" is the same as original name.";
            _logger.error(msg);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)msg, null);
        }
        try {
            boolean success = this._lifecycleService.renameObject(oid, newName);
            return new ResponseEntity(success ? HttpStatus.NO_CONTENT : HttpStatus.CONFLICT);
        }
        catch (ObjectNotFoundException onfe) {
            _logger.error("Error renaming stored process.", (Throwable)onfe);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.NOT_FOUND, (String)onfe.getMessage(), null);
        }
        catch (ObjectExistsException onfe) {
            _logger.error("Error renaming stored process.", (Throwable)onfe);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.CONFLICT, (String)onfe.getMessage(), null);
        }
        catch (ValidationException onfe) {
            _logger.error("Error renaming stored process.", (Throwable)onfe);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)onfe.getMessage(), null);
        }
        catch (Exception e) {
            _logger.error("Error renaming stored process.", (Throwable)e);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage(), null);
        }
    }

    private void updateLinks(StoredProcessData incomingData, StoredProcess storedProcess) throws Exception {
        boolean hadIncomingSCR = false;
        boolean hadIncomingSC = false;
        boolean hadIncomingLS = false;
        boolean needSCR = incomingData.getSourceCodeLocation() == StoredProcess.SourceCodeLocation.FILE_SYSTEM;
        boolean needSC = incomingData.getVersion() == StoredProcessData.StoredProcessVersion.V2;
        StoredProcess incomingDto = (StoredProcess)incomingData.toContentComponent();
        List<Link> linkList = incomingData.getLinks();
        if (linkList != null) {
            for (Link link : linkList) {
                String webKey;
                String uri;
                if (needSCR && link.getMethod().equalsIgnoreCase("put") && link.getRel().equals(LINK_REL_SOURCE_CODE_REPOSITORY)) {
                    uri = link.getUri();
                    if (!uri.startsWith(SCR_URI_PREFIX)) {
                        throw new Exception("Source code repository link uri does not start with /content/51/");
                    }
                    webKey = uri.substring(SCR_URI_PREFIX.length());
                    String scrId = ContentRESTUtils.getIdFromLink((String)webKey);
                    Directory dir = this._storedProcessService.getSourceCodeRepositoryById(new ObjectIdentity(51L, scrId));
                    if (dir == null) {
                        throw new Exception("Could not find source code repository corresponding to " + uri);
                    }
                    incomingDto.getSourceCodeRepository().setTarget((Identifiable)dir);
                    hadIncomingSCR = true;
                }
                if (needSC) {
                    if (!link.getMethod().equalsIgnoreCase("put") || !link.getRel().equals(LINK_REL_SERVER_CONTEXT)) continue;
                    uri = link.getUri();
                    if (!uri.startsWith(SC_URI_PREFIX)) {
                        throw new Exception("Server context link uri does not start with /content/42/");
                    }
                    webKey = uri.substring(SCR_URI_PREFIX.length());
                    String scId = ContentRESTUtils.getIdFromLink((String)webKey);
                    ServerContext sc = this._serverDataService.getServerContextDescriptor(new ObjectIdentity(42L, scId));
                    if (sc == null) {
                        throw new Exception("Could not find server context corresponding to " + uri);
                    }
                    incomingDto.getServerContext().setTarget((Identifiable)sc);
                    hadIncomingSC = true;
                    continue;
                }
                if (!link.getMethod().equalsIgnoreCase("put") || !link.getRel().equals(LINK_REL_LOGICAL_SERVER)) continue;
                uri = link.getUri();
                boolean wks = uri.startsWith(LWKS_URI_PREFIX);
                if (!uri.startsWith(LSPS_URI_PREFIX) && !wks) {
                    throw new Exception("Logical server link uri does not start with /content/36/ or /content/37/");
                }
                String webKey2 = uri.substring((wks ? LWKS_URI_PREFIX : LSPS_URI_PREFIX).length());
                String scId = ContentRESTUtils.getIdFromLink((String)webKey2);
                SoftwareResourceBase srb = this._serverDataService.getServerById(new ObjectIdentity(42L, scId));
                if (srb == null) {
                    throw new Exception("Could not find logical server corresponding to " + uri);
                }
                incomingDto.getLogicalServer().setTarget((Identifiable)((LogicalServer)srb));
                hadIncomingSC = true;
            }
        }
        if (storedProcess != null) {
            if (needSCR && !hadIncomingSCR && storedProcess.getSourceCodeLocation() == StoredProcess.SourceCodeLocation.FILE_SYSTEM) {
                incomingDto.getSourceCodeRepository().setTarget((Identifiable)((Directory)storedProcess.getSourceCodeRepository().getTarget()));
            }
            if (needSC) {
                if (!hadIncomingSC) {
                    incomingDto.getServerContext().setTarget((Identifiable)((ServerContext)storedProcess.getServerContext().getTarget()));
                }
            } else if (!hadIncomingLS) {
                incomingDto.getLogicalServer().setTarget((Identifiable)((LogicalServer)storedProcess.getLogicalServer().getTarget()));
            }
        }
    }

    private StoredProcessData createDataObject(StoredProcess storedProcess) {
        StoredProcessData data = new StoredProcessData(storedProcess, true);
        return data;
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteStoredProcess(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        StoredProcess storedProcess = this._storedProcessService.getStoredProcessDescriptor(new ObjectIdentity(52L, id));
        if (storedProcess == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            EffectivePermissions permissions = this.authorizationService.getEffectivePermissions(ObjectIdentityUtils.createObjectIdentity((Identifiable)storedProcess));
            if (permissions == null || !permissions.isDeleteAllowed()) {
                return new ResponseEntity(HttpStatus.FORBIDDEN);
            }
            this._storedProcessService.deleteStoredProcess(storedProcess);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

