/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.prefs.client.SASPreferencesAdmin;
import com.sas.svcs.web.controllers.rest.AbstractUserController;
import com.sas.svcs.web.data.prefs.PreferenceData;
import com.sas.svcs.web.data.prefs.Preferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/users/{userId}/preferences"})
public class PreferencesController
extends AbstractUserController {
    private SASPreferencesAdmin preferenceAdminService;

    @Autowired
    public void setPreferenceAdminService(SASPreferencesAdmin preferenceAdminService) {
        this.preferenceAdminService = preferenceAdminService;
    }

    @RequestMapping(method={RequestMethod.PUT})
    public ResponseEntity<String> updateUserPreferences(@PathVariable String userId, @RequestBody Preferences prefs) {
        Map<String, String> prefMap = this.fromPrefList(prefs.getPreferences());
        this.preferenceAdminService.setPreferences(userId, prefMap);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Map<String, String> fromPrefList(Collection<PreferenceData> prefs) {
        HashMap<String, String> prefMap = new HashMap<String, String>(prefs.size());
        for (PreferenceData pref : prefs) {
            prefMap.put(pref.getKey(), pref.getValue());
        }
        return prefMap;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"name"})
    public ResponseEntity<Preferences> getSelectedUserPreferences(@PathVariable String userId, @RequestParam(value="name") Set<String> names) {
        Map prefs = this.preferenceAdminService.getPreferences(userId, names, Collections.emptyMap());
        ArrayList<PreferenceData> prefList = new ArrayList<PreferenceData>(names.size());
        for (String name : names) {
            String val = (String)prefs.get(name);
            if (null == val) continue;
            prefList.add(new PreferenceData(name, val));
        }
        return new ResponseEntity((Object)new Preferences(prefList), HttpStatus.OK);
    }
}

