/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.authorization.acl.client.AccessControlEntry;
import com.sas.svcs.authorization.acl.client.AccessControlList;
import com.sas.svcs.authorization.acl.client.AclService;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.authorization.client.PrincipalResolver;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.web.data.ObjectIdentityData;
import com.sas.svcs.web.data.authorization.AccessControlData;
import com.sas.svcs.web.data.authorization.AccessControls;
import com.sas.svcs.web.data.authorization.Permission;
import com.sas.svcs.web.data.authorization.PrincipalData;
import com.sas.svcs.web.data.authorization.PrincipalType;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PermissionsController {
    private AclService aclService;
    private AuthorizationService authorizationService;

    @Autowired
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Autowired
    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    static Permission restEntityForServiceEntity(AccessControlEntry.PermissionValue permission) {
        switch (permission) {
            case DENIED: {
                return Permission.DENIED;
            }
            case GRANTED: {
                return Permission.GRANTED;
            }
        }
        return Permission.UNSET;
    }

    static AccessControlData restEntityForServiceEntity(EffectivePermissions ep, AuthorizationPrincipal principal) {
        AccessControlData acd = new AccessControlData();
        acd.administer = ep.isAdminAllowed() ? Permission.GRANTED : Permission.DENIED;
        acd.create = ep.isAddAllowed() ? Permission.GRANTED : Permission.DENIED;
        acd.delete = ep.isDeleteAllowed() ? Permission.GRANTED : Permission.DENIED;
        acd.read = ep.isReadAllowed() ? Permission.GRANTED : Permission.DENIED;
        acd.write = ep.isWriteAllowed() ? Permission.GRANTED : Permission.DENIED;
        acd.principal = PermissionsController.restEntityForServiceEntity(principal);
        return acd;
    }

    static AccessControlData restEntityForServiceEntity(AccessControlEntry ace) {
        AccessControlData acd = new AccessControlData();
        acd.administer = PermissionsController.restEntityForServiceEntity(ace.getAdministrationPermission());
        acd.create = PermissionsController.restEntityForServiceEntity(ace.getCreatePermission());
        acd.delete = PermissionsController.restEntityForServiceEntity(ace.getDeletePermission());
        acd.read = PermissionsController.restEntityForServiceEntity(ace.getReadPermission());
        acd.write = PermissionsController.restEntityForServiceEntity(ace.getWritePermission());
        acd.principal = PermissionsController.restEntityForServiceEntity(ace.getPrincipal());
        return acd;
    }

    static PrincipalData restEntityForServiceEntity(AuthorizationPrincipal principal) {
        PrincipalData pd = new PrincipalData();
        pd.name = principal.getName();
        pd.type = AuthorizationPrincipal.PrincipalType.User.equals((Object)principal.getType()) ? PrincipalType.USER : PrincipalType.GROUP;
        return pd;
    }

    static AccessControlEntry serviceEntityForRestEntity(AccessControlData accessControl) {
        AccessControlEntry.PermissionValue read = PermissionsController.serviceEntityForRestEntity(accessControl.read);
        AccessControlEntry.PermissionValue write = PermissionsController.serviceEntityForRestEntity(accessControl.write);
        AccessControlEntry.PermissionValue delete = PermissionsController.serviceEntityForRestEntity(accessControl.delete);
        AccessControlEntry.PermissionValue administer = PermissionsController.serviceEntityForRestEntity(accessControl.administer);
        AccessControlEntry.PermissionValue create = PermissionsController.serviceEntityForRestEntity(accessControl.create);
        AccessControlEntry ace = new AccessControlEntry(PermissionsController.serviceEntityForRestEntity(accessControl.principal), read, write, administer, delete, create);
        return ace;
    }

    static AccessControlEntry.PermissionValue serviceEntityForRestEntity(Permission permission) {
        switch (permission) {
            case GRANTED: {
                return AccessControlEntry.PermissionValue.GRANTED;
            }
            case DENIED: {
                return AccessControlEntry.PermissionValue.DENIED;
            }
        }
        return AccessControlEntry.PermissionValue.UNSET;
    }

    static ObjectIdentityData restEntityForServiceEntity(ObjectIdentity oid) {
        if (null == oid) {
            return null;
        }
        ObjectIdentityData oidd = new ObjectIdentityData();
        oidd.objectId = oid.getId();
        oidd.objectTypeId = oid.getObjectType();
        return oidd;
    }

    static AuthorizationPrincipal serviceEntityForRestEntity(PrincipalData pd) {
        if (PrincipalType.GROUP.equals((Object)pd.type)) {
            return new AuthorizationPrincipal(pd.name, AuthorizationPrincipal.PrincipalType.Group);
        }
        return new AuthorizationPrincipal(pd.name);
    }

    static ObjectIdentity serviceEntityForRestEntity(ObjectIdentityData oidd) {
        if (null == oidd) {
            return null;
        }
        return new ObjectIdentity(oidd.objectTypeId, oidd.objectId);
    }

    static AccessControlList serviceEntityForRestEntity(AccessControls accessControls) {
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>(accessControls.accessControlEntries.size());
        for (AccessControlData acd : accessControls.accessControlEntries) {
            aces.add(PermissionsController.serviceEntityForRestEntity(acd));
        }
        return new AccessControlList(aces, PermissionsController.serviceEntityForRestEntity(accessControls.owner), PermissionsController.serviceEntityForRestEntity(accessControls.parent), accessControls.inheritable);
    }

    static AccessControls restEntityForServiceEntity(AccessControlList acl) {
        ArrayList<AccessControlData> acds = new ArrayList<AccessControlData>(acl.getAces().size());
        for (AccessControlEntry entry : acl.getAces()) {
            acds.add(PermissionsController.restEntityForServiceEntity(entry));
        }
        AccessControls accessControls = new AccessControls(acds);
        accessControls.inheritable = acl.isInheritable();
        accessControls.owner = PermissionsController.restEntityForServiceEntity(acl.getOwner());
        accessControls.parent = PermissionsController.restEntityForServiceEntity(acl.getParentAclId());
        return accessControls;
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/effectivePermissions"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AccessControlData> getEffectivePermissions(@PathVariable long objectTypeId, @PathVariable String objectId) {
        ObjectIdentity identity = new ObjectIdentity(objectTypeId, ContentRESTUtils.getIdFromLink((String)objectId));
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        AuthorizationPrincipal principal = PrincipalResolver.authorizationPrincipalForPrincipalObject((Object)authentication.getPrincipal());
        try {
            EffectivePermissions effectivePermissions = this.authorizationService.getEffectivePermissions(identity);
            AccessControlData authorizations = PermissionsController.restEntityForServiceEntity(effectivePermissions, principal);
            return new ResponseEntity((Object)authorizations, HttpStatus.OK);
        }
        catch (ObjectNotFoundException ex) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/permissions"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AccessControls> getObjectPermissions(@PathVariable long objectTypeId, @PathVariable String objectId) {
        AccessControlList acl = this.aclService.getAcl(new ObjectIdentity(objectTypeId, objectId));
        if (null == acl) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)PermissionsController.restEntityForServiceEntity(acl), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/permissions"}, method={RequestMethod.PUT})
    @ResponseBody
    public AccessControls setObjectPermissions(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestBody AccessControls permissions) {
        ObjectIdentity securedObject = new ObjectIdentity(objectTypeId, objectId);
        AccessControlList acl = PermissionsController.serviceEntityForRestEntity(permissions);
        acl = this.aclService.aclExists(securedObject) ? this.aclService.updateAcl(securedObject, acl) : this.aclService.createAcl(securedObject, acl);
        return PermissionsController.restEntityForServiceEntity(acl);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/permissions"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteAllPermission(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestParam(required=false, defaultValue="false") boolean includeChildren) {
        ObjectIdentity securedObject = new ObjectIdentity(objectTypeId, objectId);
        this.aclService.deleteAcl(securedObject, includeChildren);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

