/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.RandomPolicy;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.document.client.Document;
import com.sas.svcs.content.document.client.DocumentService;
import com.sas.svcs.content.folder.client.Folder;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.web.data.document.DocumentData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DocumentController {
    private DocumentService documentService;
    private FolderService folderService;
    private ServiceURLDAO serviceURLDAO;
    private RandomPolicy policy;

    @Autowired
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Autowired
    public void setFolderService(FolderService folderService) {
        this.folderService = folderService;
    }

    @Autowired
    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this.serviceURLDAO = serviceURLDAO;
        this.policy = new RandomPolicy();
        this.policy.setServiceURLDAO(serviceURLDAO);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/content/82/{objectId}"})
    @ResponseBody
    public ResponseEntity<DocumentData> getDocumentByIdType(@PathVariable String objectId, @RequestParam(value="version", required=false) String version) {
        return this.getDocumentById(objectId, version);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/content/documents/{objectId}"})
    @ResponseBody
    public ResponseEntity<DocumentData> getDocumentById(@PathVariable String objectId, @RequestParam(value="version", required=false) String version) {
        String identifier = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity identity = new ObjectIdentity(82L, identifier);
        Document document = null;
        document = version != null ? this.documentService.getDocumentVersionById(identity, version) : this.documentService.getDocumentById(identity);
        if (document == null) {
            return new ResponseEntity((Object)null, HttpStatus.NOT_FOUND);
        }
        DocumentData result = new DocumentData(document);
        this.setDocumentContentLinks(result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/content/82"})
    @ResponseBody
    public ResponseEntity<DocumentData> getDocumentByPathType(@RequestParam(value="path", required=true) String path, @RequestParam(value="version", required=false) String version) {
        return this.getDocumentByPath(path, version);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/content/documents"})
    @ResponseBody
    public ResponseEntity<DocumentData> getDocumentByPath(@RequestParam(value="path", required=true) String path, @RequestParam(value="version", required=false) String version) {
        try {
            String decodePath = URLDecoder.decode(path, "UTF-8");
            Document document = null;
            document = version != null ? this.documentService.getDocumentVersionByPath(path, version) : this.documentService.getDocumentByPath(decodePath);
            if (document == null) {
                return new ResponseEntity((Object)null, HttpStatus.NOT_FOUND);
            }
            DocumentData result = new DocumentData(document);
            this.setDocumentContentLinks(result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (UnsupportedEncodingException ex) {
            return new ResponseEntity((Object)null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/content/82"})
    @ResponseBody
    public ResponseEntity<DocumentData> createDocumentType(@RequestBody DocumentData documentData, @RequestParam(value="path", required=true) String path) {
        return this.createDocument(documentData, path);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/content/documents"})
    @ResponseBody
    public ResponseEntity<DocumentData> createDocument(@RequestBody DocumentData documentData, @RequestParam(value="path", required=true) String path) {
        try {
            String decodePath = URLDecoder.decode(path, "UTF-8");
            Folder folder = this.folderService.getFolderByPath(decodePath, 79L);
            if (folder == null) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Document document = documentData.toDocument();
            Document resultDocument = this.documentService.createDocument(folder, document);
            DocumentData result = new DocumentData(resultDocument);
            this.setDocumentContentLinks(result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (UnsupportedEncodingException ex) {
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (ValidationException ex) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (ObjectExistsException ex) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        catch (ObjectNotFoundException ex) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/content/82"})
    @ResponseBody
    public ResponseEntity<DocumentData> updateDocumentType(@RequestBody DocumentData documentData) {
        return this.updateDocument(documentData);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/content/documents"})
    @ResponseBody
    public ResponseEntity<DocumentData> updateDocument(@RequestBody DocumentData documentData) {
        try {
            Document document = documentData.toDocument();
            Document document2 = this.documentService.updateDocument(document);
            DocumentData result = new DocumentData(document2);
            this.setDocumentContentLinks(result);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (ObjectNotFoundException ex) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (ObjectModifiedException ex) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/content/82/{objectId}"})
    @ResponseBody
    public ResponseEntity<String> deleteDocumentType(@PathVariable String objectId) {
        return this.deleteDocument(objectId);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/content/documents/{objectId}"})
    @ResponseBody
    public ResponseEntity<String> deleteDocument(@PathVariable String objectId) {
        String identifier = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity identity = new ObjectIdentity(82L, identifier);
        Document document = null;
        document = this.documentService.getDocumentById(identity);
        if (document == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            this.documentService.deleteDocument(document);
        }
        catch (ObjectNotFoundException ex) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void setDocumentContentLinks(DocumentData documentData) {
        try {
            String uri = (String)this.policy.choose((Object)"/sas/auto/stream/com.sas.svcs.content.streaming.spi.StreamSupportService-jcrStreamingFile");
            uri = uri + "/ContentDocument/" + documentData.getId();
            Link getLink = new Link();
            getLink.setHref(uri);
            getLink.setUri(uri);
            getLink.setMethod("Get");
            getLink.setRel("getContent");
            documentData.addContentLink(getLink);
            Link putLink = new Link();
            putLink.setHref(uri);
            putLink.setUri(uri);
            putLink.setMethod("Put");
            putLink.setRel("putContent");
            documentData.addContentLink(putLink);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

