/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.comments.client.Comment;
import com.sas.svcs.comments.client.CommentAdminServiceInterface;
import com.sas.svcs.comments.client.CommentServiceInterface;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.web.controllers.rest.UnauthorizedCommentAccessException;
import com.sas.svcs.web.data.comments.CommentData;
import com.sas.svcs.web.data.comments.CommentSummaries;
import com.sas.svcs.web.data.comments.Comments;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CommentsController {
    private static final Logger logger = LogManager.getLogger(CommentsController.class);
    private boolean accessByNumericIdAllowed = !Boolean.getBoolean("_SAS_REF_BY_UUID_ONLY");
    CommentServiceInterface commentService;
    CommentAdminServiceInterface commentAdminService;

    public void setAccessByNumericIdAllowed(boolean allowed) {
        this.accessByNumericIdAllowed = allowed;
    }

    @Autowired
    public void setComments(CommentServiceInterface commentService) {
        this.commentService = commentService;
    }

    @Autowired
    public void setCommentAdministration(CommentAdminServiceInterface commentAdminService) {
        this.commentAdminService = commentAdminService;
    }

    @ExceptionHandler(value={UnauthorizedCommentAccessException.class})
    public void handleAuthorizationException(UnauthorizedCommentAccessException e, HttpServletResponse response) throws IOException {
        if (e.getCode() == UnauthorizedCommentAccessException.Code.Authorization) {
            logger.warn("Authorization failure, returning FORBIDDEN.", (Throwable)e);
            response.sendError(403);
        } else {
            logger.warn("Authentication failure, returning UNAUTHORIZED.", (Throwable)e);
            response.sendError(401);
        }
    }

    private Long safeGetLongId(String id) throws ForbiddenException {
        try {
            long commentId = Long.parseLong(id);
            if (!this.accessByNumericIdAllowed) {
                logger.warn("The system is configured to disallow referencing comments by numeric ID, but a caller specified a numeric ID: " + id);
                throw new ForbiddenException();
            }
            return commentId;
        }
        catch (NumberFormatException e) {
            logger.debug("id did not appear to be a number, assuming uuid: " + id);
            return null;
        }
    }

    private Comment getComment(String id) throws ForbiddenException {
        Long commentId = this.safeGetLongId(id);
        return null == commentId ? this.commentService.getById(id) : this.commentService.getById(commentId.longValue());
    }

    private boolean commentExists(String id) throws ForbiddenException {
        Long commentId = this.safeGetLongId(id);
        return null == commentId ? this.commentService.exists(id) : this.commentService.exists(commentId.longValue());
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/comments"}, method={RequestMethod.GET})
    @ResponseBody
    public Comments getComments(@PathVariable long objectTypeId, @PathVariable String objectId) {
        ArrayList<CommentData> value = new ArrayList<CommentData>();
        List results = this.commentService.find(objectTypeId, objectId);
        if (!results.isEmpty()) {
            results = this.commentService.getAttachmentsForComments(results);
        }
        for (Comment comment : results) {
            value.add(new CommentData(comment));
        }
        return new Comments(objectTypeId, objectId, value);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/{elementId}/comments"}, method={RequestMethod.GET})
    @ResponseBody
    public Comments getComments(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String elementId) {
        ArrayList<CommentData> value = new ArrayList<CommentData>();
        List results = this.commentService.find(objectTypeId, objectId, elementId);
        if (!results.isEmpty()) {
            results = this.commentService.getAttachmentsForComments(results);
        }
        for (Comment comment : results) {
            value.add(new CommentData(comment));
        }
        return new Comments(objectTypeId, objectId, elementId, value);
    }

    boolean parentExists(CommentData commentData) {
        long parent = commentData.getParentId();
        if (0L != parent && !this.commentService.exists(parent)) {
            return false;
        }
        return !StringUtils.hasText((String)commentData.getParentUuid()) || this.commentService.exists(commentData.getParentUuid());
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/comments"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Comments> publishComment(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestBody Comments comments) {
        List<CommentData> commentDataList = comments.getCommentList();
        for (CommentData commentData : commentDataList) {
            commentData.setCreatedOn(new Date());
            Comment c = commentData.toComment();
            c.setObjectId(objectId);
            c.setObjectType(objectTypeId);
            if (!this.parentExists(commentData)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            String uuid = this.commentService.createComment(c);
            Comment updatedComment = this.commentService.getById(uuid);
            commentData.setId(updatedComment.getId());
            commentData.setUuid(updatedComment.getCommentId());
        }
        comments.setObjectTypeId(objectTypeId);
        comments.setObjectId(objectId);
        return new ResponseEntity((Object)comments, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/{elementId}/comments"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Comments> publishComment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String elementId, @RequestBody Comments comments) {
        List<CommentData> commentDataList = comments.getCommentList();
        for (CommentData commentData : commentDataList) {
            commentData.setCreatedOn(new Date());
            Comment c = commentData.toComment();
            c.setObjectType(objectTypeId);
            c.setObjectId(objectId);
            c.setElementId(elementId);
            if (!this.parentExists(commentData)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            String uuid = this.commentService.createComment(c);
            Comment updatedComment = this.commentService.getById(uuid);
            commentData.setId(updatedComment.getId());
            commentData.setUuid(updatedComment.getCommentId());
        }
        comments.setObjectTypeId(objectTypeId);
        comments.setObjectId(objectId);
        comments.setElementId(elementId);
        return new ResponseEntity((Object)comments, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/content/{objectTypeId}/comments"}, method={RequestMethod.GET})
    @ResponseBody
    public CommentSummaries getCommentSummaries(@PathVariable long objectTypeId, @RequestParam(value="id") String[] ids) {
        ArrayList<ObjectIdentity> identities = new ArrayList<ObjectIdentity>();
        for (String id : ids) {
            identities.add(new ObjectIdentity(objectTypeId, id));
        }
        return this.getCommentSummaries(identities);
    }

    private CommentSummaries getCommentSummaries(List<ObjectIdentity> identities) {
        List objectCommentData = this.commentService.getObjectCommentData(identities);
        return new CommentSummaries(objectCommentData);
    }

    @RequestMapping(value={"/content/comments"}, method={RequestMethod.GET})
    @ResponseBody
    public CommentSummaries getCommentSummaries(@RequestParam(value="id") String[] ids) {
        ArrayList<ObjectIdentity> objectIdentities = new ArrayList<ObjectIdentity>();
        for (String identity : ids) {
            String[] parts = identity.split("_");
            String objectTypeId = parts[0];
            String objectId = parts[1];
            objectIdentities.add(new ObjectIdentity(Long.valueOf(objectTypeId).longValue(), objectId));
        }
        return this.getCommentSummaries(objectIdentities);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/comments/{commentId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<CommentData> updateComment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String commentId, @RequestBody CommentData commentData) {
        try {
            if (!this.commentExists(commentId)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Comment c = this.getComment(commentId);
            if (!objectId.equals(c.getObjectId()) || objectTypeId != c.getObjectType()) {
                return new ResponseEntity(HttpStatus.FORBIDDEN);
            }
            return this.updateComment(c, commentData);
        }
        catch (ForbiddenException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/{elementId}/comments/{commentId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<CommentData> updateComment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String elementId, @PathVariable String commentId, @RequestBody CommentData commentData) {
        try {
            if (!this.commentExists(commentId)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Comment c = this.getComment(commentId);
            if (!objectId.equals(c.getObjectId()) || !elementId.equals(c.getElementId()) || objectTypeId != c.getObjectType()) {
                return new ResponseEntity(HttpStatus.FORBIDDEN);
            }
            return this.updateComment(c, commentData);
        }
        catch (ForbiddenException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    private ResponseEntity<CommentData> updateComment(Comment c, CommentData commentData) {
        c.setParentId(commentData.getParentId());
        c.setParentCommentId(commentData.getParentUuid());
        c.setPriority(commentData.getPriority());
        c.setText(commentData.getText());
        if (null != commentData.getSubject()) {
            c.setSubject(commentData.getSubject());
        }
        c.setAuthor(commentData.getAuthor());
        this.commentAdminService.update(c, true);
        return new ResponseEntity((Object)new CommentData(c), HttpStatus.OK);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/comments/{commentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteComment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String commentId) {
        try {
            if (!this.commentExists(commentId)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Comment comment = this.getComment(commentId);
            if (objectTypeId != comment.getObjectType() || !objectId.equals(comment.getObjectId())) {
                return new ResponseEntity(HttpStatus.FORBIDDEN);
            }
            this.commentAdminService.delete(comment.getCommentId());
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (ForbiddenException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/{elementId}/comments/{commentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteComment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String elementId, @PathVariable String commentId) {
        try {
            if (!this.commentExists(commentId)) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Comment comment = this.getComment(commentId);
            if (objectTypeId != comment.getObjectType() || !objectId.equals(comment.getObjectId()) || !elementId.equals(comment.getElementId())) {
                return new ResponseEntity(HttpStatus.FORBIDDEN);
            }
            this.commentAdminService.delete(comment.getCommentId());
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (ForbiddenException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    private static final class ForbiddenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ForbiddenException() {
        }
    }
}

