/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authentication.helper.UserSessionFactory;
import com.sas.svcs.web.controllers.rest.UnauthorizedCommentAccessException;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Aspect
public class CommentAuthorizationInterceptor {
    UserSessionFactory userSessionFactory;
    InformationServiceInterface informationService;
    List<String> protocols = Arrays.asList("omi");

    @Autowired
    public void setUserSessionFactory(UserSessionFactory userSessionFactory) {
        this.userSessionFactory = userSessionFactory;
    }

    @Autowired
    public void setInformationService(InformationServiceInterface informationService) {
        this.informationService = informationService;
    }

    @Pointcut(value="target(com.sas.svcs.comments.client.CommentServiceInterface) && execution(* com.sas.svcs.comments.client.CommentServiceInterface.find(..))")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void verifyAuthorization(JoinPoint jp) throws Throwable {
        Object[] args = jp.getArgs();
        Long objectTypeId = (Long)args[0];
        if (0L == objectTypeId) {
            String objectId = (String)args[1];
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (null == securityContext) {
                throw new UnauthorizedCommentAccessException("SecurityContext was not provided...", UnauthorizedCommentAccessException.Code.Authentication);
            }
            try {
                UserContextInterface userContext = this.userSessionFactory.getLocalUser();
                if (null == userContext) {
                    throw new UnauthorizedCommentAccessException("", UnauthorizedCommentAccessException.Code.Authentication);
                }
                Filter filter = new Filter("Identifier", 0, objectId);
                filter.setType("ExternalIdentity");
                List results = this.informationService.browseSearchProtocols(userContext, this.protocols, filter);
                if (null == results || results.size() <= 0) {
                    throw new UnauthorizedCommentAccessException("User does not have access to backing document...", UnauthorizedCommentAccessException.Code.Authorization);
                }
            }
            catch (Exception e) {
                throw new UnauthorizedCommentAccessException("Exception occurred processing authorization request...", e, UnauthorizedCommentAccessException.Code.Authorization);
            }
        }
    }
}

