/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ExceptionHandler;

public abstract class AbstractUserController {
    @ExceptionHandler(value={InvalidUserException.class})
    public void handleInvalidUser(InvalidUserException e, HttpServletResponse response) throws IOException {
        response.sendError(403);
    }

    @ExceptionHandler(value={NoUserProvidedException.class})
    public void handleNoUser(NoUserProvidedException e, HttpServletResponse response) throws IOException {
        response.sendError(401);
    }

    protected void checkUser(String userid) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (null == securityContext) {
            throw new NoUserProvidedException();
        }
        String calculatedUserid = securityContext.getAuthentication().getName();
        if (!userid.equals(calculatedUserid)) {
            throw new InvalidUserException();
        }
    }

    static class NoUserProvidedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        NoUserProvidedException() {
        }
    }

    static class InvalidUserException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InvalidUserException() {
        }
    }
}

