/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security.omipermissions;

import com.sas.security.omipermissions.OMIPermission;
import com.sas.services.security.login.OMIServerPrincipal;
import java.io.FilePermission;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OMIFilePermission
extends OMIPermission {
    static final long serialVersionUID = 1239421432826157574L;

    public OMIFilePermission(FilePermission permission) {
        this(permission.getName(), permission.getActions());
    }

    public OMIFilePermission(String resource, String actions) {
        super(resource, actions);
    }

    @Override
    protected String getAuthorizationURN(OMIServerPrincipal principal) {
        String[][] metadataTypes = this.getSearchMetadataTypes();
        String prefix = "";
        if (this.getName().length() > 7) {
            prefix = this.getName().substring(0, 7);
        }
        String metadataName = prefix.equalsIgnoreCase("http://") ? this.getName() : (prefix.equalsIgnoreCase("file://") ? this.getName().substring(7) : this.getName());
        StringHolder outXMLHolder = new StringHolder();
        String type = "";
        String id = "";
        for (int i = 0; i < metadataTypes.length; ++i) {
            String options = "<XMLSelect search=\"@" + metadataTypes[i][1] + "='" + metadataName + "'\"/>";
            try {
                Element element;
                Node node;
                Node lnode;
                int rc = this.getIOMI(principal).GetMetadataObjects(this.getRepositoryID(), metadataTypes[i][0], outXMLHolder, bundle.getString("NameSpace.SAS"), 128, options);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                StringReader strReader = new StringReader(outXMLHolder.value);
                Document doc = db.parse(new InputSource(strReader));
                if (doc == null || (lnode = OMIFilePermission.getNode(node = doc.getFirstChild(), metadataTypes[i][0])) == null || (id = (element = (Element)lnode).getAttribute(bundle.getString("OMIPermission.ID"))).length() <= 0) continue;
                type = metadataTypes[i][0];
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "OMSOBJ:" + type + "/" + id;
    }

    private String[][] getSearchMetadataTypes() {
        int rows = 0;
        int columns = 0;
        int k = 0;
        String prefix = "";
        if (this.getName().length() > 7) {
            prefix = this.getName().substring(0, 7);
        }
        if (prefix.equalsIgnoreCase("http://")) {
            rows = Integer.parseInt(bundle.getString("OMIFilePermission.HTTPURL.Rows"));
            columns = Integer.parseInt(bundle.getString("OMIFilePermission.HTTPURL.Columns"));
        } else {
            rows = Integer.parseInt(bundle.getString("OMIFilePermission.FileURL.Rows"));
            columns = Integer.parseInt(bundle.getString("OMIFilePermission.FileURL.Columns"));
        }
        String[][] metadataTypes = new String[rows][columns];
        for (int i = 0; i < metadataTypes.length; ++i) {
            for (int j = 0; j < columns; ++j) {
                metadataTypes[i][j] = bundle.getString("metadata" + Integer.toString(k));
                ++k;
            }
        }
        return metadataTypes;
    }

    protected static Node getNode(Node start, String path) {
        int index = path.indexOf("/");
        String firstElement = null;
        String remainder = null;
        if (index == 0) {
            path = path.substring(1);
            index = path.indexOf("/");
        }
        if (index < 0) {
            firstElement = path;
        } else {
            firstElement = path.substring(0, index);
            remainder = path.substring(index + 1);
        }
        NodeList nodeList = start.getChildNodes();
        int mapSize = nodeList.getLength();
        for (int i = 0; i < mapSize; ++i) {
            Node mapNode = nodeList.item(i);
            if (!mapNode.getNodeName().equals(firstElement)) continue;
            if (remainder == null) {
                return mapNode;
            }
            return OMIFilePermission.getNode(mapNode, remainder);
        }
        return null;
    }
}

