/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.weblogic;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jndi.JndiTemplate;

public class ConnectionFactoryDecorator
implements ConnectionFactory {
    private static final Logger logger = LogManager.getLogger(ConnectionFactoryDecorator.class);
    private static InitialContext context;
    private Hashtable _env;
    private String jndiName;

    public void setJndiEnvironment(Hashtable env) {
        this._env = env;
    }

    public void setJndiTemplate(JndiTemplate template) {
        this._env = new Hashtable();
        this._env.putAll(template.getEnvironment());
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    private InitialContext getInitialContext() throws NamingException {
        logger.info("Getting InitialContext");
        if (context == null) {
            context = new InitialContext(this._env);
        }
        return context;
    }

    private ConnectionFactory getConnectionFactory() throws JMSException {
        logger.info("Getting Connection Factory");
        try {
            context = this.getInitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(this.jndiName);
            return connectionFactory;
        }
        catch (NamingException namingException) {
            JMSException jmsException = new JMSException("Error looking up jndi name:" + this.jndiName);
            jmsException.setLinkedException((Exception)namingException);
            logger.error(jmsException.getMessage(), (Throwable)jmsException);
            throw jmsException;
        }
    }

    public Connection createConnection() throws JMSException {
        logger.info("createConnection without credentials");
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        return connectionFactory.createConnection();
    }

    public Connection createConnection(String username, String password) throws JMSException, JMSSecurityException {
        logger.info("createConnection() with credentials, user " + username);
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        return connectionFactory.createConnection(username, password);
    }
}

