/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.traversal;

import MITI.expression.analyzer.decoration.MIRDecor;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.decoration.MIRDecors;
import MITI.expression.traversal.ExpressionTraversal;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRStatementNode;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ReferenceTraversal
extends ExpressionTraversal {
    private static final String ANY_OBJECT = "*";
    private Set<MIRExpressionNode> processedNodes = new HashSet<MIRExpressionNode>();
    private Stack<String> conditions = new Stack();
    private Stack<List<MIRElement>> results = new Stack();
    private MIRDecors decors;

    private ReferenceTraversal(MIRDecors mIRDecors) {
        this.decors = mIRDecors;
    }

    public static void traverse(MIRExpressionNode mIRExpressionNode, MIRDecors mIRDecors) {
        new ReferenceTraversal(mIRDecors).traverseExpressionNode(mIRExpressionNode);
    }

    @Override
    protected void traverseExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (this.processedNodes.add(mIRExpressionNode)) {
            super.traverseExpressionNode(mIRExpressionNode);
        }
    }

    @Override
    protected void traverseStatementNode(MIRStatementNode mIRStatementNode) {
        if (!this.conditions.isEmpty() && ANY_OBJECT.equals(this.conditions.peek())) {
            this.results.peek().add(mIRStatementNode);
        } else {
            for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodeByPosition()) {
                MIRDecor mIRDecor = this.decors.getDecor(mIRExpressionNode);
                if (mIRDecor == null || mIRDecor.isCondition()) continue;
                this.traverseExpressionNode(mIRExpressionNode);
            }
        }
    }

    @Override
    protected void traverseOperationNode(MIROperationNode mIROperationNode) {
        MIRElementNamePart mIRElementNamePart;
        if (this.conditions.isEmpty() || !ANY_OBJECT.equals(this.conditions.peek())) {
            super.traverseOperationNode(mIROperationNode);
        }
        if (this.match(mIRElementNamePart = MIRDecorUtil.getLastPart(mIROperationNode))) {
            this.results.peek().add(mIROperationNode);
            return;
        }
        this.traverseElementNameParts(mIROperationNode.getElementNamePartByPosition());
    }

    @Override
    protected void traverseOperatorNode(MIROperatorNode mIROperatorNode) {
        if (mIROperatorNode.getLeftExpressionNode() instanceof MIRElementNode && ((MIRElementNode)mIROperatorNode.getLeftExpressionNode()).getKind() == 2) {
            if (this.conditions.isEmpty() || !ANY_OBJECT.equals(this.conditions.peek())) {
                this.traverseExpressionNode(mIROperatorNode.getLeftExpressionNode());
            } else {
                this.traverseExpressionNode(mIROperatorNode.getRightExpressionNode());
            }
        } else if (mIROperatorNode.getRightExpressionNode() instanceof MIRElementNode && ((MIRElementNode)mIROperatorNode.getRightExpressionNode()).getKind() == 2) {
            if (this.conditions.isEmpty() || !ANY_OBJECT.equals(this.conditions.peek())) {
                this.traverseExpressionNode(mIROperatorNode.getRightExpressionNode());
            } else {
                this.traverseExpressionNode(mIROperatorNode.getLeftExpressionNode());
            }
        } else if (this.conditions.isEmpty() || !ANY_OBJECT.equals(this.conditions.peek())) {
            super.traverseOperatorNode(mIROperatorNode);
        } else if (ANY_OBJECT.equals(this.conditions.peek())) {
            this.results.peek().add(mIROperatorNode);
        }
    }

    @Override
    protected void traverseElementNode(MIRElementNode mIRElementNode) {
        super.traverseElementNode(mIRElementNode);
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
        if (this.match(mIRElementNamePart)) {
            this.results.peek().add(mIRElementNode);
            return;
        }
        this.traverseElementNameParts(mIRElementNode.getElementNamePartByPosition());
    }

    private void traverseElementNameParts(List<MIRElementNamePart> list) {
        MIRElementNamePart mIRElementNamePart;
        if (list.isEmpty()) {
            return;
        }
        MIRElementNamePart mIRElementNamePart2 = list.get(list.size() - 1);
        if (mIRElementNamePart2.getReferencedElementCount() > 0) {
            LinkedList<MIRElement> linkedList = new LinkedList<MIRElement>();
            for (MIRElement mIRElement : mIRElementNamePart2.getReferencedElements()) {
                if (!(mIRElement instanceof MIRExpressionNode)) continue;
                if (this.conditions.isEmpty() && mIRElementNamePart2.getSourceElementType() == 77 && (mIRElement instanceof MIRElementNode && ((MIRElementNode)mIRElement).getDestinationElementType() == 75 || mIRElement instanceof MIRStatementNode)) {
                    linkedList.add(mIRElement);
                    continue;
                }
                this.traverseExpressionNode((MIRExpressionNode)mIRElement);
            }
            for (MIRElement mIRElement : linkedList) {
                this.push(ANY_OBJECT);
                this.traverseExpressionNode((MIRExpressionNode)mIRElement);
                this.pop(mIRElementNamePart2, mIRElement);
            }
        } else if (list.size() > 1 && (mIRElementNamePart = list.get(list.size() - 2)).getReferencedElementCount() > 0) {
            this.push(mIRElementNamePart2.getName());
            for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
                if (!(mIRElement instanceof MIRExpressionNode)) continue;
                this.traverseExpressionNode((MIRExpressionNode)mIRElement);
            }
            this.pop(mIRElementNamePart2, null);
        }
    }

    private void push(String string) {
        this.conditions.push(string);
        this.results.push(new LinkedList());
    }

    private void pop(MIRElementNamePart mIRElementNamePart, MIRElement mIRElement) {
        this.conditions.pop();
        List<MIRElement> list = this.results.pop();
        if (list.size() > 0) {
            if (mIRElement == null) {
                mIRElementNamePart.removeReferencedElements();
            } else {
                mIRElementNamePart.removeReferencedElement(mIRElement);
            }
            for (MIRElement mIRElement2 : list) {
                if (mIRElementNamePart.containsReferencedElement(mIRElement2)) continue;
                mIRElementNamePart.addReferencedElement(mIRElement2);
            }
        }
    }

    private boolean match(MIRElementNamePart mIRElementNamePart) {
        if (this.conditions.isEmpty()) {
            return false;
        }
        if (mIRElementNamePart.getSourceElementType() == 24 && mIRElementNamePart.getElementNode().getKind() == 1) {
            return true;
        }
        return !(mIRElementNamePart.getSourceElementType() != 77 && mIRElementNamePart.getSourceElementType() != 0 || !this.conditions.peek().equals(ANY_OBJECT) && !this.conditions.peek().equals(mIRElementNamePart.getName()));
    }
}

