/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.functions;

import MITI.expression.MIRExpressionLangType;
import MITI.expression.MIRExpressionToolType;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.functions.DaxFunctionMapping;
import MITI.expression.functions.Function;
import MITI.expression.functions.FunctionFormat;
import MITI.expression.functions.FunctionImplementation;
import MITI.expression.functions.Functions;
import MITI.expression.functions.HiveFunctionMapping;
import MITI.messages.MIRExpressionLib.EXPLIB;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIROperationNode;
import MITI.util.XmlUtil;
import MITI.util.config.MimbConfiguration;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class MIRFunctionMapping {
    private static Functions<FunctionFormat> formats = new Functions();
    private static Functions<FunctionImplementation> implementations = new Functions();
    private static Map<String, DynamicFunctionMapping> dynamicImplementations = new HashMap<String, DynamicFunctionMapping>();
    private static TreeSet<Function> aggregations = new TreeSet();
    private static TreeSet<Function> castFunctions = new TreeSet();
    private int toolType;
    private int dbType;
    private Set<String> unknownFunctions;

    public MIRFunctionMapping(int n, int n2) {
        this.toolType = n;
        this.dbType = n2;
        this.unknownFunctions = new HashSet<String>();
    }

    public FunctionImplementation getImplementation(MIROperationNode mIROperationNode, int n) {
        DynamicFunctionMapping dynamicFunctionMapping;
        if (this.toolType == 0 && this.dbType == 0) {
            return null;
        }
        String string = MIRDecorUtil.getLastPart(mIROperationNode).getName();
        FunctionImplementation functionImplementation = implementations.get(string, String.valueOf(n), this.dbType, this.toolType);
        if (functionImplementation == null && (dynamicFunctionMapping = dynamicImplementations.get(MIRFunctionMapping.getMappingKey(this.dbType, this.toolType))) != null) {
            functionImplementation = dynamicFunctionMapping.getImplementation(mIROperationNode);
        }
        if (functionImplementation == null && !this.unknownFunctions.contains(string)) {
            this.unknownFunctions.add(string);
            EXPLIB.IMPL_NOT_FOUND.log(string, String.valueOf(n), MIRExpressionToolType.getName(this.toolType), MIRExpressionLangType.getName(this.dbType));
        }
        return functionImplementation;
    }

    public FunctionFormat getFormat(String string, int n) {
        if (this.toolType == 0 && this.dbType == 0) {
            return null;
        }
        FunctionFormat functionFormat = formats.get(string, String.valueOf(n), this.dbType, this.toolType);
        if (functionFormat == null && !this.unknownFunctions.contains(string)) {
            this.unknownFunctions.add(string);
            EXPLIB.FUNC_NOT_FOUND.log(string, String.valueOf(n), MIRExpressionToolType.getName(this.toolType), MIRExpressionLangType.getName(this.dbType));
        }
        return functionFormat;
    }

    public boolean isAggregation(String string, int n) {
        Function function = new Function(string, String.valueOf(n), 0, 0);
        return aggregations.contains(function);
    }

    public boolean isCast(String string, int n) {
        Function function = new Function(string, String.valueOf(n), 0, 0);
        return castFunctions.contains(function);
    }

    private static void loadFunctions(Element element) {
        NodeList nodeList = element.getElementsByTagName("Section");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("fn");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string = element3.getAttribute("name");
                boolean bl = element3.getAttribute("aggregate").equals("true");
                boolean bl2 = element3.getAttribute("cast").equals("true");
                NodeList nodeList3 = element3.getElementsByTagName("impls");
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    Element element4 = (Element)nodeList3.item(k);
                    String string2 = element4.getAttribute("argc");
                    if (string2.isEmpty()) {
                        EXPLIB.MISSING_ARGC.log(string);
                    }
                    NodeList nodeList4 = element4.getElementsByTagName("impl");
                    for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                        int n;
                        Object object;
                        Object object2;
                        Element element5 = (Element)nodeList4.item(i2);
                        String string3 = element5.getAttribute("target");
                        String string4 = element5.getAttribute("name");
                        String string5 = element5.getAttribute("format");
                        String string6 = element5.getAttribute("returnType");
                        String string7 = element5.getAttribute("returnValue");
                        String string8 = element5.getAttribute("returnLength");
                        int n2 = MIRExpressionLangType.getByName(string3);
                        int n3 = MIRExpressionToolType.getByName(string3);
                        if (n2 == -1 && n3 == -1) {
                            EXPLIB.INVALID_TARGET.log(string, string3);
                            continue;
                        }
                        if (!string4.isEmpty()) {
                            object2 = new FunctionImplementation(string, string4, string2, n2, n3, string6, string7, string8, false);
                            if (!implementations.add((FunctionImplementation)object2)) {
                                EXPLIB.CANNOT_BUILD_IMPLEMENTATION.log(string, string3, string4, string2);
                                object = implementations.get(string4, string2, n2, n3);
                                if (object != null) {
                                    EXPLIB.PREVIOUS_IMPLEMENTATION.log(((FunctionImplementation)object).getMirName());
                                }
                            } else {
                                Object object3;
                                object = XmlUtil.getFirstElement(element5, "res");
                                if (object != null) {
                                    object3 = object.getAttribute("type");
                                    ((FunctionImplementation)object2).setLookupFunction("feature".equalsIgnoreCase((String)object3));
                                }
                                object3 = element5.getElementsByTagName("arg");
                                for (int i3 = 0; i3 < object3.getLength(); ++i3) {
                                    Element element6 = (Element)object3.item(i3);
                                    String string9 = element6.getAttribute("pos");
                                    String string10 = element6.getAttribute("data");
                                    String string11 = element6.getAttribute("condition");
                                    String string12 = element6.getAttribute("elementType");
                                    boolean bl3 = !"false".equalsIgnoreCase(string10);
                                    boolean bl4 = "true".equalsIgnoreCase(string11);
                                    short s = string12 != null && !string12.isEmpty() ? (short)MIRElementType.getByName(string12) : (short)77;
                                    ((FunctionImplementation)object2).addArgument(string9, bl3, bl4, s);
                                }
                            }
                            if (bl) {
                                object = new Function(string, string2, 0, 0);
                                aggregations.add((Function)object);
                            }
                            if (bl2) {
                                object = new Function(string, string2, 0, 0);
                                castFunctions.add((Function)object);
                            }
                        }
                        if (!(string4.isEmpty() && string5.isEmpty() || formats.add((FunctionFormat)(object2 = new FunctionFormat(string, string4, string5, string2, n2, n3))) || string5.isEmpty())) {
                            EXPLIB.CANNOT_BUILD_FORMAT.log(string, string3, string5);
                            object = formats.get(string, string2, n2, n3);
                            if (object != null) {
                                EXPLIB.PREVIOUS_FORMAT.log(((FunctionFormat)object).getMirName());
                            }
                        }
                        if (!string4.isEmpty()) continue;
                        object2 = XmlUtil.getFirstElement(element5, "res");
                        if (object2 != null) {
                            EXPLIB.RES_IGNORED.log(string, string3, string5);
                        }
                        if ((n = element5.getElementsByTagName("arg").getLength()) != 0) {
                            EXPLIB.ARG_IGNORED.log(string, string3, string5);
                        }
                        if (!string5.isEmpty()) continue;
                        EXPLIB.TARGET_IGNORED.log(string, string3);
                    }
                    if (nodeList4.getLength() != 0) continue;
                    EXPLIB.NO_IMPLEMENTATION.log(string);
                }
                if (nodeList3.getLength() != 0) continue;
                EXPLIB.NO_IMPLEMENTATION.log(string);
            }
        }
    }

    private static String getMappingKey(int n, int n2) {
        return String.valueOf(n) + "_" + String.valueOf(n2);
    }

    static {
        dynamicImplementations.put(MIRFunctionMapping.getMappingKey(9, 22), new DaxFunctionMapping());
        dynamicImplementations.put(MIRFunctionMapping.getMappingKey(11, 0), new HiveFunctionMapping());
        try {
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = null;
            File file = new File(MimbConfiguration.getMimbHome(), "conf/MIRFunctionMapping/MIR_Neutral_Function.xml");
            if (file.exists()) {
                document = documentBuilder.parse(file);
            } else {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("MIR_Neutral_Function.xml");
                document = documentBuilder.parse(inputStream);
            }
            if (document != null) {
                MIRFunctionMapping.loadFunctions(document.getDocumentElement());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface DynamicFunctionMapping {
        public FunctionImplementation getImplementation(MIROperationNode var1);
    }
}

