/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.converter;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.parser.MIRParserHelper;
import MITI.expression.converter.MIRExpressionConverter;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MIRRefExpressionPrinter
extends MIRExpressionConverter {
    private static final int MAX_EXP_LENGTH = Short.MAX_VALUE;
    private Map<MIRElementNode, MIRRefExpressionPrinter> nodeExps = new HashMap<MIRElementNode, MIRRefExpressionPrinter>();
    private boolean expTooComplex = false;
    private boolean captureConstantExpressions;

    public MIRRefExpressionPrinter() {
        this(false);
    }

    public MIRRefExpressionPrinter(boolean bl) {
        super(0, 0);
        this.captureConstantExpressions = bl;
    }

    @Override
    protected void clearExpression() {
        super.clearExpression();
        if (this.nodeExps != null) {
            this.nodeExps.clear();
        }
    }

    @Override
    public String toString() {
        if (!this.expTooComplex) {
            return super.toString();
        }
        return "### Expression is too complex ###";
    }

    @Override
    protected String getElementName(MIRElement mIRElement) {
        return mIRElement.getName();
    }

    @Override
    protected String formatString(String string) {
        return string.trim();
    }

    @Override
    protected String getNodeText(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode.getOriginalText().isEmpty() && (mIRExpressionNode.getElementType() == 111 || mIRExpressionNode.getElementType() == 107)) {
            return mIRExpressionNode.getName();
        }
        return mIRExpressionNode.getOriginalText();
    }

    protected void merge(MIRRefExpressionPrinter mIRRefExpressionPrinter) {
        if (!mIRRefExpressionPrinter.isSimple()) {
            this.setComplex();
        }
        this.expTooComplex |= mIRRefExpressionPrinter.expTooComplex;
    }

    protected MIRRefExpressionPrinter getNewExpressionPrinter() {
        MIRRefExpressionPrinter mIRRefExpressionPrinter = new MIRRefExpressionPrinter();
        mIRRefExpressionPrinter.followRefs = this.followRefs;
        mIRRefExpressionPrinter.captureConstantExpressions = this.captureConstantExpressions;
        return mIRRefExpressionPrinter;
    }

    protected boolean handleElement() {
        return false;
    }

    @Override
    protected void printOperatorNode(MIROperatorNode mIROperatorNode) {
        if (mIROperatorNode.getLeftExpressionNode() != null) {
            boolean bl = this.followRefs;
            this.followRefs = !(mIROperatorNode.getLeftExpressionNode() instanceof MIRElementNode) || mIROperatorNode.getRightExpressionNode() == null || !MIRDecorUtil.getLastPart((MIRElementNode)mIROperatorNode.getLeftExpressionNode()).getReferencedElements().contains(MIRParserHelper.SKIP_PREDICATE_NODE(mIROperatorNode.getRightExpressionNode()));
            this.printExpressionNode(mIROperatorNode.getLeftExpressionNode());
            this.followRefs = bl;
        }
        this.addNode(mIROperatorNode);
        if (mIROperatorNode.getRightExpressionNode() != null) {
            this.printExpressionNode(mIROperatorNode.getRightExpressionNode());
        }
        if (mIROperatorNode.getConditionExpressionNode() != null) {
            this.printExpressionNode(mIROperatorNode.getConditionExpressionNode());
        }
    }

    @Override
    protected void printElementNode(MIRElementNode mIRElementNode) {
        MIRRefExpressionPrinter mIRRefExpressionPrinter = this.nodeExps.get(mIRElementNode);
        if (mIRRefExpressionPrinter == null) {
            mIRRefExpressionPrinter = this.getNewExpressionPrinter();
            mIRRefExpressionPrinter.expTooComplex |= this.expTooComplex;
            MIRElementNamePart mIRElementNamePart = mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
            int n = mIRElementNamePart.getReferencedElementCount();
            if (this.followRefs && n > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
                    String string;
                    MIRRefExpressionPrinter mIRRefExpressionPrinter2 = this.getNewExpressionPrinter();
                    if (mIRElement == mIRElementNode.getQueryNode()) continue;
                    if (mIRElement.isInstanceOf((short)113)) {
                        mIRRefExpressionPrinter2.nodeExps.putAll(this.nodeExps);
                        mIRRefExpressionPrinter2.nodeExps.put(mIRElementNode, mIRRefExpressionPrinter);
                        mIRRefExpressionPrinter2.printExpressionNode((MIRExpressionNode)mIRElement);
                        if (!mIRRefExpressionPrinter2.isSimple()) {
                            mIRRefExpressionPrinter.setComplex();
                        }
                        if (!(string = mIRRefExpressionPrinter2.toString()).isEmpty()) {
                            arrayList.add(string);
                        }
                    } else if (this.handleElement()) {
                        mIRRefExpressionPrinter2.addElement(mIRElement);
                        string = mIRRefExpressionPrinter2.toString();
                        if (!string.isEmpty()) {
                            arrayList.add(string);
                        }
                    }
                    mIRRefExpressionPrinter.merge(mIRRefExpressionPrinter2);
                    this.nodeExps.putAll(mIRRefExpressionPrinter2.nodeExps);
                }
                if (mIRRefExpressionPrinter.expTooComplex || mIRElementNamePart.getReferencedElementCount() != arrayList.size()) {
                    mIRRefExpressionPrinter.addNode(mIRElementNode);
                } else {
                    Collections.sort(arrayList);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        mIRRefExpressionPrinter.addText((String)iterator.next());
                        if (!iterator.hasNext()) continue;
                        mIRRefExpressionPrinter.addDelimiter(this.getUnionSeparator());
                    }
                }
            } else {
                mIRRefExpressionPrinter.addNode(mIRElementNode);
            }
            mIRRefExpressionPrinter.expTooComplex = mIRRefExpressionPrinter.expTooComplex | mIRRefExpressionPrinter.length() > Short.MAX_VALUE;
            this.nodeExps.put(mIRElementNode, mIRRefExpressionPrinter);
        }
        this.merge(mIRRefExpressionPrinter);
        this.addText(mIRRefExpressionPrinter.toString());
    }

    @Override
    protected void printStatementNode(MIRStatementNode mIRStatementNode) {
        this.followRefs = true;
        int n = mIRStatementNode.getReferencedExpressionNodeCount();
        if (n > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getReferencedExpressionNodes()) {
                MIRRefExpressionPrinter mIRRefExpressionPrinter = this.getNewExpressionPrinter();
                mIRRefExpressionPrinter.printExpressionNode(mIRExpressionNode);
                arrayList.add(mIRRefExpressionPrinter.toString());
                this.merge(mIRRefExpressionPrinter);
            }
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.addText((String)iterator.next());
                if (!iterator.hasNext()) continue;
                this.addDelimiter(this.getUnionSeparator());
            }
        } else {
            super.printStatementNode(mIRStatementNode);
        }
    }

    @Override
    protected void addNode(MIRExpressionNode mIRExpressionNode) {
        super.addNode(mIRExpressionNode);
        if (this.captureConstantExpressions && mIRExpressionNode.getElementType() == 104) {
            this.setComplex();
        }
    }
}

