/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.converter;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.functions.FunctionFormat;
import MITI.expression.functions.MIRFunctionMapping;
import MITI.messages.MIRExpressionLib.EXPLIB;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicate;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class MIRExpressionConverter {
    private MIRFunctionMapping functions;
    private StringBuffer exp = new StringBuffer();
    private boolean simple = true;
    protected boolean followRefs = false;
    Set<MIRExpressionNode> processedNodes = new HashSet<MIRExpressionNode>();

    public MIRExpressionConverter(int n, int n2) {
        this.functions = new MIRFunctionMapping(n, n2);
        this.clearExpression();
    }

    protected MIRFunctionMapping getFunctions() {
        return this.functions;
    }

    protected void clearExpression() {
        this.exp = new StringBuffer();
        this.simple = true;
        this.followRefs = false;
    }

    protected int length() {
        return this.exp.length();
    }

    public String toString() {
        return this.exp.toString();
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple() {
        this.simple = true;
    }

    public void setComplex() {
        this.simple = false;
    }

    protected abstract String getElementName(MIRElement var1);

    public final String convertExpression(MIRClassifierMap mIRClassifierMap) {
        this.clearExpression();
        MIRExpression mIRExpression = mIRClassifierMap.getExpression();
        if (mIRExpression == null) {
            this.addText(mIRClassifierMap.getOperation());
        } else {
            this.printExpression(mIRExpression);
        }
        return this.toString();
    }

    public final String convertExpression(MIRFeatureMap mIRFeatureMap) {
        this.clearExpression();
        MIRExpression mIRExpression = mIRFeatureMap.getExpression();
        if (mIRExpression == null) {
            if (mIRFeatureMap.getOperation().isEmpty()) {
                MIRFeature mIRFeature = mIRFeatureMap.getDestinationFeature();
                if (mIRFeatureMap.getSourceFeatureCount() == 1) {
                    this.addElement(mIRFeatureMap.getSourceFeature(null));
                } else if (mIRFeatureMap.getSourceFeatureCount() == 2 && mIRFeature.getElementType() == 84 && mIRFeature.getClassifier() != null && mIRFeature.getClassifier().getElementType() == 92) {
                    Iterator<MIRFeature> iterator = mIRFeatureMap.getSourceFeatureIterator();
                    this.addElement(iterator.next());
                    this.addText("=");
                    this.addElement(iterator.next());
                }
            } else {
                this.addText(mIRFeatureMap.getOperation());
            }
        } else {
            this.printExpression(mIRExpression);
        }
        return this.toString();
    }

    protected void printExpression(MIRExpression mIRExpression) {
        List<MIRStatementNode> list = mIRExpression.getStatementNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                this.addDelimiter(this.getStatementSeparator());
            }
            this.printExpressionNode(list.get(i));
        }
    }

    protected void printExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (!this.processedNodes.add(mIRExpressionNode)) {
            EXPLIB.WRN_EXPRESSION_TREE_LOOP.log(new Object[0]);
            return;
        }
        if (mIRExpressionNode.getBlock()) {
            if (this.exp.length() > 0 && this.exp.charAt(this.exp.length() - 1) != '(') {
                this.addText(" ", false);
            }
            this.addDelimiter("(");
        }
        switch (mIRExpressionNode.getElementType()) {
            case 103: {
                this.printBranchingNode((MIRBranchingNode)mIRExpressionNode);
                break;
            }
            case 104: {
                this.printConstantNode((MIRConstantNode)mIRExpressionNode);
                break;
            }
            case 107: {
                this.printDelimiterNode((MIRDelimiterNode)mIRExpressionNode);
                break;
            }
            case 111: {
                this.printElementNode((MIRElementNode)mIRExpressionNode);
                break;
            }
            case 114: {
                this.printOperationNode((MIROperationNode)mIRExpressionNode);
                break;
            }
            case 115: {
                this.printOperatorNode((MIROperatorNode)mIRExpressionNode);
                break;
            }
            case 118: {
                this.printPredicateNode((MIRPredicateNode)mIRExpressionNode);
                break;
            }
            case 339: {
                this.printQueryNode((MIRQueryNode)mIRExpressionNode);
                break;
            }
            case 134: {
                this.printStatementNode((MIRStatementNode)mIRExpressionNode);
                break;
            }
        }
        if (mIRExpressionNode.getBlock()) {
            this.addDelimiter(")");
        }
        this.processedNodes.remove(mIRExpressionNode);
    }

    protected void printBranchingNode(MIRBranchingNode mIRBranchingNode) {
        this.addNode(mIRBranchingNode);
        if (mIRBranchingNode.getConditionExpressionNode() != null) {
            this.printExpressionNode(mIRBranchingNode.getConditionExpressionNode());
        }
        List<MIRExpressionNode> list = mIRBranchingNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            this.printExpressionNode(list.get(i));
        }
    }

    protected void printConstantNode(MIRConstantNode mIRConstantNode) {
        this.addNode(mIRConstantNode);
    }

    protected void printDelimiterNode(MIRDelimiterNode mIRDelimiterNode) {
        this.addNode(mIRDelimiterNode);
        if (mIRDelimiterNode.getName().equals("*") && mIRDelimiterNode.getDelimiter().equals(",")) {
            return;
        }
        List<MIRExpressionNode> list = mIRDelimiterNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                this.addDelimiter(mIRDelimiterNode.getDelimiter());
            }
            this.printExpressionNode(list.get(i));
        }
        if (mIRDelimiterNode.getConditionExpressionNode() != null) {
            this.printExpressionNode(mIRDelimiterNode.getConditionExpressionNode());
        }
    }

    protected void printElementNode(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        int n = mIRElementNamePart.getReferencedElementCount();
        if (n > 0) {
            Iterator<MIRElement> iterator = mIRElementNamePart.getReferencedElementIterator();
            for (int i = 0; i < n; ++i) {
                MIRElement mIRElement = iterator.next();
                if (mIRElement == mIRElementNode.getQueryNode()) continue;
                if (this.followRefs && mIRElement.isInstanceOf((short)113)) {
                    if (i != 0) {
                        this.addDelimiter(this.getUnionSeparator());
                    }
                    this.printExpressionNode((MIRExpressionNode)mIRElement);
                    continue;
                }
                if (n > 1 || mIRElement.isInstanceOf((short)113)) {
                    this.addNode(mIRElementNode);
                } else {
                    this.addElement(mIRElement);
                }
                break;
            }
        } else {
            this.addNode(mIRElementNode);
        }
    }

    protected void printOperationNode(MIROperationNode mIROperationNode) {
        List<MIRExpressionNode> list = mIROperationNode.getExpressionNodeByPosition();
        FunctionFormat functionFormat = this.functions.getFormat(mIROperationNode.getName(), list.size());
        if (functionFormat != null && !functionFormat.isDefaultFormat()) {
            String string = functionFormat.getFormat();
            int n = string.indexOf(36);
            while (n != -1) {
                this.addText(string.substring(0, n));
                int n2 = string.charAt(n + 1) - 48;
                MIRExpressionNode mIRExpressionNode = list.get(n2 - 1);
                if (mIRExpressionNode != null) {
                    this.printExpressionNode(mIRExpressionNode);
                }
                string = string.substring(n + 2);
                n = string.indexOf(36);
            }
            this.addText(string);
        } else {
            if (functionFormat == null) {
                this.addNode(mIROperationNode);
            } else {
                this.addText(functionFormat.getImplName());
            }
            this.addDelimiter("(");
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    this.addDelimiter(",");
                }
                this.printExpressionNode(list.get(i));
            }
            this.addDelimiter(")");
        }
    }

    protected void printOperatorNode(MIROperatorNode mIROperatorNode) {
        if (mIROperatorNode.getLeftExpressionNode() != null) {
            if (mIROperatorNode.getLeftExpressionNode() instanceof MIRElementNode && MIRDecorUtil.getLastReference((MIRElementNode)mIROperatorNode.getLeftExpressionNode()) == mIROperatorNode.getRightExpressionNode()) {
                this.addNode(mIROperatorNode.getLeftExpressionNode());
            } else {
                this.printExpressionNode(mIROperatorNode.getLeftExpressionNode());
            }
        }
        this.addNode(mIROperatorNode);
        if (mIROperatorNode.getRightExpressionNode() != null) {
            if (mIROperatorNode.getRightExpressionNode() instanceof MIRElementNode && MIRDecorUtil.getLastReference((MIRElementNode)mIROperatorNode.getRightExpressionNode()) == mIROperatorNode.getLeftExpressionNode()) {
                this.addNode(mIROperatorNode.getRightExpressionNode());
            } else {
                this.printExpressionNode(mIROperatorNode.getRightExpressionNode());
            }
        }
        if (mIROperatorNode.getConditionExpressionNode() != null) {
            this.printExpressionNode(mIROperatorNode.getConditionExpressionNode());
        }
    }

    protected void printPredicateNode(MIRPredicateNode mIRPredicateNode) {
        MIRPredicate mIRPredicate;
        int n;
        List<MIRPredicate> list = mIRPredicateNode.getPredicateByPosition();
        for (n = 0; n < list.size(); ++n) {
            mIRPredicate = list.get(n);
            if (!mIRPredicate.getPrefix()) continue;
            this.addText(mIRPredicate.getName());
        }
        if (mIRPredicateNode.getExpressionNode() != null) {
            this.printExpressionNode(mIRPredicateNode.getExpressionNode());
        }
        for (n = 0; n < list.size(); ++n) {
            mIRPredicate = list.get(n);
            if (mIRPredicate.getPrefix()) continue;
            this.addText(mIRPredicate.getName());
        }
    }

    protected void printQueryNode(MIRQueryNode mIRQueryNode) {
        if (mIRQueryNode.getClassifierElementNode() != null) {
            this.printExpressionNode(mIRQueryNode.getClassifierElementNode());
        }
        if (mIRQueryNode.getFeatureDelimiterNode() != null) {
            this.printExpressionNode(mIRQueryNode.getFeatureDelimiterNode());
        }
        this.addNode(mIRQueryNode);
        if (mIRQueryNode.getQueryStatementNode() != null) {
            this.printExpressionNode(mIRQueryNode.getQueryStatementNode());
        }
    }

    protected void printStatementNode(MIRStatementNode mIRStatementNode) {
        if (mIRStatementNode.getReferencedExpressionNodeCount() > 0) {
            this.followRefs = true;
            ArrayList<MIRExpressionNode> arrayList = new ArrayList<MIRExpressionNode>();
            arrayList.addAll(mIRStatementNode.getReferencedExpressionNodes());
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i != 0) {
                    this.addDelimiter(this.getUnionSeparator());
                }
                this.printExpressionNode(this.getRefNode((MIRExpressionNode)arrayList.get(i)));
            }
        } else {
            this.addNode(mIRStatementNode);
            List<MIRExpressionNode> list = mIRStatementNode.getExpressionNodeByPosition();
            for (int i = 0; i < list.size(); ++i) {
                this.printExpressionNode(list.get(i));
            }
        }
    }

    private MIRExpressionNode getRefNode(MIRExpressionNode mIRExpressionNode) {
        MIRElement mIRElement;
        List<MIRElementNamePart> list;
        MIRElementNamePart mIRElementNamePart;
        MIRElementNode mIRElementNode;
        if (mIRExpressionNode.getElementType() == 111 && (mIRElementNode = (MIRElementNode)mIRExpressionNode).getKind() == 2 && (mIRElementNamePart = (list = mIRElementNode.getElementNamePartByPosition()).get(list.size() - 1)).getReferencedElementCount() == 1 && (mIRElement = mIRElementNamePart.getReferencedElement(null)).isInstanceOf((short)113)) {
            return (MIRExpressionNode)mIRElement;
        }
        return mIRExpressionNode;
    }

    protected String formatString(String string) {
        return string;
    }

    protected String getNodeText(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode.getElementType() == 104 || mIRExpressionNode.getElementType() == 114) {
            return mIRExpressionNode.getOriginalText();
        }
        return mIRExpressionNode.getName();
    }

    protected void addElement(MIRElement mIRElement) {
        this.addText(this.getElementName(mIRElement), true);
    }

    protected void addNode(MIRExpressionNode mIRExpressionNode) {
        short s;
        if (this.simple && (s = mIRExpressionNode.getElementType()) != 104 && s != 111 && s != 117) {
            this.simple = false;
        }
        this.addText(this.formatString(this.getNodeText(mIRExpressionNode)), true);
    }

    protected void addDelimiter(String string) {
        this.addText(this.formatString(string), false);
    }

    protected void addText(String string) {
        this.addText(this.formatString(string), true);
    }

    private void addText(String string, boolean bl) {
        if (!string.isEmpty()) {
            char c;
            if (bl && this.exp.length() > 0 && (c = this.exp.charAt(this.exp.length() - 1)) != '(' && c != '.' && c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                this.exp.append(' ');
            }
            this.exp.append(string);
        }
    }

    protected String getStatementSeparator() {
        return "\n";
    }

    protected String getUnionSeparator() {
        return ";";
    }
}

