/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.converter;

import MITI.expression.converter.MIRExpressionConverter;
import MITI.expression.functions.FunctionFormat;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class MIRDataStageTalendConverter
extends MIRExpressionConverter {
    private static Map<String, String> operators = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public MIRDataStageTalendConverter(int n, int n2) {
        super(n, n2);
    }

    @Override
    protected void printBranchingNode(MIRBranchingNode mIRBranchingNode) {
        if (this.isSimpleIfThenElse(mIRBranchingNode)) {
            MIROperationNode mIROperationNode = new MIROperationNode();
            mIROperationNode.setName("IIF");
            mIROperationNode.addExpressionNode(mIRBranchingNode.getConditionExpressionNode());
            List<MIRExpressionNode> list = mIRBranchingNode.getExpressionNodeByPosition();
            mIROperationNode.addExpressionNode(((MIRDelimiterNode)list.get(0)).getExpressionNodeByPosition().get(0));
            mIROperationNode.addExpressionNode(((MIRDelimiterNode)list.get(1)).getExpressionNodeByPosition().get(0));
            this.printOperationNode(mIROperationNode);
        } else {
            super.printBranchingNode(mIRBranchingNode);
        }
    }

    @Override
    protected void printOperationNode(MIROperationNode mIROperationNode) {
        FunctionFormat functionFormat = this.getFunctions().getFormat(mIROperationNode.getName(), mIROperationNode.getExpressionNodeCount());
        if (functionFormat == null) {
            this.addText("Custom.");
        }
        super.printOperationNode(mIROperationNode);
    }

    @Override
    protected void printOperatorNode(MIROperatorNode mIROperatorNode) {
        if (mIROperatorNode.getLeftExpressionNode() != null) {
            this.printExpressionNode(mIROperatorNode.getLeftExpressionNode());
        }
        this.addText(this.getOperatorText(mIROperatorNode));
        if (mIROperatorNode.getRightExpressionNode() != null) {
            this.printExpressionNode(mIROperatorNode.getRightExpressionNode());
        }
    }

    private String getOperatorText(MIROperatorNode mIROperatorNode) {
        String string = mIROperatorNode.getName();
        String string2 = operators.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private boolean isSimpleIfThenElse(MIRBranchingNode mIRBranchingNode) {
        List<MIRExpressionNode> list;
        if (mIRBranchingNode.getName().equalsIgnoreCase("IF") && mIRBranchingNode.getConditionExpressionNode() != null && (list = mIRBranchingNode.getExpressionNodeByPosition()).size() == 2) {
            MIRExpressionNode mIRExpressionNode = list.get(0);
            MIRExpressionNode mIRExpressionNode2 = list.get(1);
            if (mIRExpressionNode.getElementType() == 107 && mIRExpressionNode.getName().equalsIgnoreCase("THEN") && mIRExpressionNode2.getElementType() == 107 && mIRExpressionNode2.getName().equalsIgnoreCase("ELSE") && ((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeCount() == 1 && ((MIRDelimiterNode)mIRExpressionNode2).getExpressionNodeCount() == 1) {
                return true;
            }
        }
        return false;
    }

    static {
        operators.put(":", "+");
        operators.put("AND", "&&");
        operators.put("OR", "||");
        operators.put("=", "==");
        operators.put("<>", "!=");
        operators.put("NOT", "!");
        operators.put("Int", "Integer");
    }
}

