/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.rules;

import MITI.expression.analyzer.engine.MIRParser;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.engine.MIRToken;
import MITI.expression.analyzer.rules.MIRBisonRule;
import MITI.expression.analyzer.rules.MIRFlexRule;
import MITI.expression.analyzer.rules.MIRGenericRules;
import MITI.expression.analyzer.rules.MIRMdxRules;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class MIRRuleEngine {
    private MIRParser parser = null;
    private ArrayList<MIRToken> tokens = new ArrayList();
    private ArrayList<MIRFlexRule> flexRules = new ArrayList();
    private ArrayList<MIRBisonRule> bisonRules = new ArrayList();
    private Set<String> keywords = new HashSet<String>();

    public static MIRRuleEngine createGenericRuleEngine(MIRParser mIRParser) {
        MIRGenericRules mIRGenericRules = new MIRGenericRules();
        mIRGenericRules.parser = mIRParser;
        mIRGenericRules.init(true);
        return mIRGenericRules;
    }

    public static MIRRuleEngine createMdxRuleEngine(MIRParser mIRParser) {
        MIRMdxRules mIRMdxRules = new MIRMdxRules();
        mIRMdxRules.parser = mIRParser;
        mIRMdxRules.init(true);
        return mIRMdxRules;
    }

    public void init(boolean bl) {
        this.cleanup();
        if (bl) {
            this.flexRules.clear();
            this.bisonRules.clear();
            this.loadRules(this.parser.getOptions());
        }
    }

    public MIRToken getNextToken() {
        MIRBisonRule mIRBisonRule = null;
        if (this.peekFlexToken() != 256) {
            for (MIRBisonRule mIRBisonRule2 : this.bisonRules) {
                MIRBisonRule.MatchType matchType = MIRBisonRule.MatchType.NONE;
                do {
                    if ((matchType = mIRBisonRule2.match(this.tokens, this.keywords, this.parser.getFlags().getParserFlags())) != MIRBisonRule.MatchType.PARTIAL) continue;
                    this.readFlexToken();
                } while (matchType == MIRBisonRule.MatchType.PARTIAL);
                if (matchType != MIRBisonRule.MatchType.EXACT || !mIRBisonRule2.isBetterMatch(mIRBisonRule)) continue;
                mIRBisonRule = mIRBisonRule2;
            }
            this.parser.getFlags().flagNewLine(false);
        } else if (MIRBisonRule.isEOL(this.tokens.get(0))) {
            this.parser.getFlags().flagNewLine(true);
        }
        Object object = null;
        if (mIRBisonRule != null) {
            object = mIRBisonRule.processRule(this.tokens);
        } else {
            object = this.tokens.remove(0);
            object = new MIRToken(((MIRToken)object).getText(), ((MIRToken)object).getOriginalText(), this.getBisonCode(((MIRToken)object).getCode()), ((MIRToken)object).getLine(), ((MIRToken)object).getColumn());
        }
        return object;
    }

    public void unput(MIRToken mIRToken) {
        this.tokens.add(mIRToken);
    }

    protected MIRRuleEngine() {
    }

    protected abstract int getBisonCode(int var1);

    protected abstract void loadRules(MIRParserOptions var1);

    private void cleanup() {
        this.tokens.clear();
    }

    private void readFlexToken() {
        MIRFlexRule mIRFlexRule = null;
        MIRToken mIRToken = this.parser.getFlexToken();
        for (MIRFlexRule mIRFlexRule2 : this.flexRules) {
            if (!mIRFlexRule2.match(mIRToken)) continue;
            mIRFlexRule = mIRFlexRule2;
            break;
        }
        if (mIRFlexRule != null) {
            mIRFlexRule.processRule(mIRToken, this.tokens);
        } else {
            this.tokens.add(mIRToken);
        }
    }

    private int peekFlexToken() {
        if (this.tokens.isEmpty()) {
            this.readFlexToken();
        }
        MIRToken mIRToken = this.tokens.get(0);
        return mIRToken.getCode();
    }

    protected void ADD_ALL_BISON_RULES(MIRBisonRule[] mIRBisonRuleArray) {
        for (MIRBisonRule mIRBisonRule : mIRBisonRuleArray) {
            this.bisonRules.add(mIRBisonRule);
            if (mIRBisonRule.getCode() == this.getBisonCode(65535) || mIRBisonRule.getText().contains(" ")) continue;
            this.keywords.add(mIRBisonRule.getText());
        }
    }

    protected void ADD_ALL_FLEX_RULES(MIRFlexRule[] mIRFlexRuleArray) {
        for (MIRFlexRule mIRFlexRule : mIRFlexRuleArray) {
            this.flexRules.add(mIRFlexRule);
        }
    }
}

