/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.rules;

import MITI.expression.analyzer.engine.MIRParserFlags;
import MITI.expression.analyzer.engine.MIRToken;
import MITI.expression.analyzer.rules.MIRRuleToken;
import java.util.ArrayList;
import java.util.Set;

public class MIRBisonRule {
    private String text = null;
    private int code = 0;
    private ArrayList<MIRRuleToken> ruleTokens = new ArrayList();
    private int condition;
    private boolean byTheEOL;

    public MIRBisonRule(String string, String string2, int n) {
        this(string, string2, n, MIRParserFlags.NONE);
    }

    public MIRBisonRule(String string, String string2, int n, int n2) {
        this.text = string2;
        this.code = n;
        int n3 = 0;
        int n4 = -1;
        while ((n4 = string.indexOf(32, n3)) != -1) {
            this.addRuleToken(string.substring(n3, n4));
            n3 = n4 + 1;
        }
        this.addRuleToken(string.substring(n3));
        this.condition = n2;
    }

    public MIRBisonRule(String string, String string2, int n, int n2, boolean bl) {
        this(string, string2, n, n2);
        this.byTheEOL = bl;
    }

    public String getText() {
        return this.text;
    }

    public int getCode() {
        return this.code;
    }

    public MatchType match(ArrayList<MIRToken> arrayList, Set<String> set, int n) {
        if (this.condition != MIRParserFlags.NONE && (n & this.condition) != this.condition) {
            return MatchType.NONE;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < arrayList.size() && n3 < this.ruleTokens.size()) {
            MIRToken mIRToken = arrayList.get(n2++);
            MIRRuleToken mIRRuleToken = this.ruleTokens.get(n3);
            if (mIRRuleToken.match(mIRToken, set)) {
                ++n3;
                continue;
            }
            if (mIRToken.getCode() == 256) continue;
            return MatchType.NONE;
        }
        if (n3 == this.ruleTokens.size()) {
            if (!this.byTheEOL) {
                return MatchType.EXACT;
            }
        } else if (n2 == arrayList.size()) {
            return MatchType.PARTIAL;
        }
        if (this.byTheEOL) {
            while (n2 < arrayList.size()) {
                if (MIRBisonRule.isEOL(arrayList.get(n2))) {
                    return MatchType.EXACT;
                }
                ++n2;
            }
            return MatchType.PARTIAL;
        }
        return MatchType.NONE;
    }

    public boolean isBetterMatch(MIRBisonRule mIRBisonRule) {
        return mIRBisonRule == null || this.ruleTokens.size() > mIRBisonRule.ruleTokens.size() || this.ruleTokens.size() == mIRBisonRule.ruleTokens.size() && !this.ruleTokens.get(0).isPattern();
    }

    public MIRToken processRule(ArrayList<MIRToken> arrayList) {
        Object object;
        Object object2;
        int n = this.ruleTokens.size();
        if (n > 1 && ((MIRRuleToken)(object2 = this.ruleTokens.get(n - 1))).getCode() == 40) {
            --n;
        }
        object2 = new MIRToken("", "", this.code, 0, 0);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = 0;
        do {
            object = arrayList.remove(0);
            if (this.byTheEOL && MIRBisonRule.isEOL((MIRToken)object)) break;
            if (256 != ((MIRToken)object).getCode() || MIRBisonRule.isEOL((MIRToken)object) && ((MIRToken)object).getCode() == this.ruleTokens.get(n2).getCode()) {
                ++n2;
                arrayList2.add(((MIRToken)object).getText());
            }
            ((MIRToken)object2).merge((MIRToken)object);
        } while (n2 < n || this.byTheEOL && !arrayList.isEmpty());
        if (!this.text.isEmpty()) {
            ((MIRToken)object2).setText(this.text);
            for (n2 = 0; n2 < n; ++n2) {
                object = this.ruleTokens.get(n2);
                if (!((MIRRuleToken)object).isRegexp()) continue;
                String string = String.format("${%d}", n2 + 1);
                ((MIRToken)object2).setText(((MIRToken)object2).getText().replace(string, (CharSequence)arrayList2.get(n2)));
            }
        }
        return object2;
    }

    private void addRuleToken(String string) {
        MIRRuleToken mIRRuleToken = new MIRRuleToken(string);
        this.ruleTokens.add(mIRRuleToken);
        String string2 = String.format("${%d}", this.ruleTokens.size());
        if (this.text.contains(string2)) {
            mIRRuleToken.markRegexp();
        }
    }

    static boolean isEOL(MIRToken mIRToken) {
        return mIRToken.getCode() == 256 && mIRToken.getOriginalText().endsWith("\n");
    }

    public static enum MatchType {
        EXACT,
        PARTIAL,
        NONE;

    }
}

