/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.parser;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.engine.MIRToken;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MIRParserHelper {
    public static void ADD_ALL_NODES(MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2) {
        MIRExpressionNode mIRExpressionNode3 = mIRExpressionNode2;
        while (mIRExpressionNode3 != null) {
            MIRParserHelper.ADD_TO_PARENT(mIRExpressionNode, mIRExpressionNode3, -1);
            if ((mIRExpressionNode3 = mIRExpressionNode3.getNextExpressionNode()) == null) continue;
            mIRExpressionNode3.removePreviousExpressionNode();
        }
    }

    public static void ADD_TO_PARENT(MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2, int n) {
        List<MIRExpressionNode> list = null;
        if (mIRExpressionNode instanceof MIRDelimiterNode) {
            list = ((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeByPosition();
            ((MIRDelimiterNode)mIRExpressionNode).addExpressionNode(mIRExpressionNode2);
        } else if (mIRExpressionNode instanceof MIRStatementNode) {
            list = ((MIRStatementNode)mIRExpressionNode).getExpressionNodeByPosition();
            ((MIRStatementNode)mIRExpressionNode).addExpressionNode(mIRExpressionNode2);
        } else if (mIRExpressionNode instanceof MIRBranchingNode) {
            list = ((MIRBranchingNode)mIRExpressionNode).getExpressionNodeByPosition();
            ((MIRBranchingNode)mIRExpressionNode).addExpressionNode(mIRExpressionNode2);
        } else if (mIRExpressionNode instanceof MIROperationNode) {
            list = ((MIROperationNode)mIRExpressionNode).getExpressionNodeByPosition();
            ((MIROperationNode)mIRExpressionNode).addExpressionNode(mIRExpressionNode2);
        }
        if (list != null) {
            if (n < 0) {
                mIRExpressionNode2.setPosition((short)list.size());
            } else {
                mIRExpressionNode2.setPosition((short)n);
                int n2 = -1;
                for (MIRExpressionNode mIRExpressionNode3 : list) {
                    if (mIRExpressionNode3.getPosition() == n || n2 >= n && mIRExpressionNode3.getPosition() <= n2) {
                        mIRExpressionNode3.setPosition((short)(Math.max(n2, mIRExpressionNode3.getPosition()) + 1));
                    }
                    n2 = mIRExpressionNode3.getPosition();
                }
            }
        }
    }

    public static void ADD_TO_LAST_NODE(MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2) {
        if (mIRExpressionNode2 == null || mIRExpressionNode == null || mIRExpressionNode2 == mIRExpressionNode) {
            return;
        }
        MIRExpressionNode mIRExpressionNode3 = mIRExpressionNode;
        while (mIRExpressionNode3.getNextExpressionNode() != null) {
            mIRExpressionNode3 = mIRExpressionNode3.getNextExpressionNode();
        }
        mIRExpressionNode2.removePreviousExpressionNode();
        mIRExpressionNode3.addNextExpressionNode(mIRExpressionNode2);
    }

    public static MIRExpressionNode SKIP_PREDICATE_NODE(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && mIRExpressionNode.getElementType() == 118) {
            return ((MIRPredicateNode)mIRExpressionNode).getExpressionNode();
        }
        return mIRExpressionNode;
    }

    public static MIRExpressionNode GET_OUTPUT_NODE(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode.getElementType() == 115 && mIRExpressionNode.getName().equals("AS")) {
            return ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode();
        }
        return mIRExpressionNode;
    }

    public static void ADD_REFERENCED_NODE(MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2) {
        if (mIRExpressionNode == null || mIRExpressionNode2 == null) {
            return;
        }
        mIRExpressionNode = MIRParserHelper.SKIP_PREDICATE_NODE(mIRExpressionNode);
        if ((mIRExpressionNode2 = MIRParserHelper.SKIP_PREDICATE_NODE(mIRExpressionNode2)) instanceof MIROperatorNode && "AS".equals(mIRExpressionNode2.getName())) {
            mIRExpressionNode2 = ((MIROperatorNode)mIRExpressionNode2).getRightExpressionNode();
        }
        if (mIRExpressionNode instanceof MIRQueryNode) {
            MIRStatementNode mIRStatementNode = ((MIRQueryNode)mIRExpressionNode).getQueryStatementNode();
            if (mIRStatementNode != null && mIRStatementNode.getStatementType() == 4) {
                mIRStatementNode.addReferencedExpressionNode(mIRExpressionNode2);
            }
        } else {
            if (mIRExpressionNode instanceof MIRElementNode) {
                while (mIRExpressionNode != null) {
                    List<MIRElementNamePart> list = ((MIRElementNode)mIRExpressionNode).getElementNamePartByPosition();
                    MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
                    if (!mIRElementNamePart.containsReferencedElement(mIRExpressionNode2)) {
                        mIRElementNamePart.addReferencedElement(mIRExpressionNode2);
                    }
                    mIRExpressionNode = mIRExpressionNode.getNextExpressionNode();
                }
                return;
            }
            if (mIRExpressionNode instanceof MIROperationNode) {
                while (mIRExpressionNode != null) {
                    ((MIROperationNode)mIRExpressionNode).addReferencedElement(mIRExpressionNode2);
                    mIRExpressionNode = mIRExpressionNode.getNextExpressionNode();
                }
                return;
            }
        }
    }

    public static void SET_ELEMENT_NODE_TYPE(MIRExpressionNode mIRExpressionNode, short n) {
        for (mIRExpressionNode = MIRParserHelper.SKIP_PREDICATE_NODE(mIRExpressionNode); mIRExpressionNode != null; mIRExpressionNode = mIRExpressionNode.getNextExpressionNode()) {
            Object object;
            if (mIRExpressionNode.getElementType() == 339) {
                object = ((MIRQueryNode)mIRExpressionNode).getClassifierElementNode();
                if (object == null) continue;
                MIRParserHelper.SET_ELEMENT_NODE_TYPE((MIRExpressionNode)object, (short)n);
                continue;
            }
            if (mIRExpressionNode.getElementType() != 111) continue;
            ((MIRElementNode)mIRExpressionNode).setDestinationElementType((short)n);
            object = ((MIRElementNode)mIRExpressionNode).getElementNamePartByPosition();
            int n2 = n;
            for (int i = object.size(); i > 0; --i) {
                MIRElementNamePart mIRElementNamePart = (MIRElementNamePart)object.get(i - 1);
                mIRElementNamePart.setSourceElementType((short)n2);
                if (n2 == 77) {
                    n2 = 75;
                    continue;
                }
                if (n2 == 0) continue;
                n2 = 144;
            }
        }
    }

    public static void SET_ELEMENT_NODE_KIND(MIRExpressionNode mIRExpressionNode, byte by) {
        while (mIRExpressionNode != null) {
            if ((mIRExpressionNode = MIRParserHelper.SKIP_PREDICATE_NODE(mIRExpressionNode)).getElementType() == 339) {
                MIRElementNode mIRElementNode = ((MIRQueryNode)mIRExpressionNode).getClassifierElementNode();
                if (mIRElementNode != null) {
                    MIRParserHelper.SET_ELEMENT_NODE_KIND(mIRElementNode, by);
                }
            } else if (mIRExpressionNode.getElementType() == 111) {
                ((MIRElementNode)mIRExpressionNode).setKind(by);
            }
            mIRExpressionNode = mIRExpressionNode.getNextExpressionNode();
        }
    }

    public static void INCREMENT_PART_POSITION(MIRElementNode mIRElementNode) {
        for (MIRElementNamePart mIRElementNamePart : mIRElementNode.getElementNameParts()) {
            mIRElementNamePart.setPosition((short)(mIRElementNamePart.getPosition() + 1));
        }
    }

    public static MIROperatorNode ADD_TO_UNION(MIROperatorNode mIROperatorNode, MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2) {
        ArrayList<MIRExpressionNode> arrayList = new ArrayList<MIRExpressionNode>();
        arrayList.add(mIRExpressionNode);
        MIRExpressionNode mIRExpressionNode3 = MIRParserHelper.getFirstLeaf(arrayList);
        if (mIRExpressionNode3 == null) {
            mIROperatorNode.addLeftExpressionNode(mIRExpressionNode);
            mIROperatorNode.addRightExpressionNode(mIRExpressionNode2);
            return mIROperatorNode;
        }
        MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRExpressionNode;
        MIROperatorNode mIROperatorNode2 = (MIROperatorNode)mIRStatementNode.getExpressionNodeByPosition().get(0);
        mIRStatementNode.removeExpressionNodes();
        mIRStatementNode.addExpressionNode(mIROperatorNode);
        MIROperatorNode mIROperatorNode3 = mIRExpressionNode3.getLeftOfOperatorNode();
        do {
            if ((mIROperatorNode3 = mIRExpressionNode3.getLeftOfOperatorNode()) == null) continue;
            mIRExpressionNode3 = (MIRExpressionNode)mIROperatorNode3.getParent();
        } while (mIROperatorNode3 != null && mIRExpressionNode3.getLeftOfOperatorNode() != null);
        MIROperatorNode mIROperatorNode4 = mIRExpressionNode3.getRightOfOperatorNode();
        if (mIROperatorNode3 != null) {
            mIROperatorNode4.removeRightExpressionNode();
            mIROperatorNode4.addRightExpressionNode(mIRExpressionNode);
            mIROperatorNode.addLeftExpressionNode(MIRParserHelper.removeFromOperator(mIRExpressionNode3));
            mIROperatorNode.addRightExpressionNode(mIRExpressionNode2);
        } else {
            mIROperatorNode3 = mIROperatorNode4;
            if (mIROperatorNode3 != null) {
                mIROperatorNode.addLeftExpressionNode(MIRParserHelper.removeFromOperator(mIRExpressionNode3));
                mIROperatorNode.addRightExpressionNode(mIRExpressionNode2);
                mIROperatorNode3.addRightExpressionNode(mIRExpressionNode);
            }
        }
        return mIROperatorNode2;
    }

    public static int POSTPROCESS_EXPRESSION(MIRExpressionNode mIRExpressionNode, MIRParserOptions mIRParserOptions) {
        MIROperatorNode mIROperatorNode;
        int n = 0;
        if (mIRParserOptions.getLangType() == 5 && mIRExpressionNode.getElementType() == 115 && "=".equals(mIRExpressionNode.getName()) && (mIROperatorNode = (MIROperatorNode)mIRExpressionNode).getLeftExpressionNode().getElementType() == 111) {
            MIRParserHelper.SET_ELEMENT_NODE_KIND(mIROperatorNode.getLeftExpressionNode(), (byte)2);
            MIRParserHelper.ADD_REFERENCED_NODE(mIROperatorNode.getLeftExpressionNode(), mIROperatorNode.getRightExpressionNode());
            n = 15;
        }
        return n;
    }

    public static MIRElementNode CREATE_ELEMENT_NODE(MIRToken mIRToken) {
        if (mIRToken != null) {
            return MIRParserHelper.CREATE_ELEMENT_NODE(mIRToken.getText(), mIRToken.getOriginalText(), mIRToken.getCode() == 397);
        }
        return MIRParserHelper.CREATE_ELEMENT_NODE(null, null, false);
    }

    public static MIRElementNode CREATE_ELEMENT_NODE(String string, String string2, boolean bl) {
        MIRElementNode mIRElementNode = new MIRElementNode();
        MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
        mIRElementNode.addElementNamePart(mIRElementNamePart);
        if (string != null) {
            mIRElementNode.setName(string);
            mIRElementNamePart.setName(string);
            if (string2 != null) {
                mIRElementNode.setOriginalText(string2);
                mIRElementNamePart.setQuoted(bl);
            }
        }
        return mIRElementNode;
    }

    public static MIRElementNode CONVERTTO_ELEMENT_NODE(MIRExpressionNode mIRExpressionNode) {
        MIRElementNode mIRElementNode = new MIRElementNode();
        MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
        mIRElementNode.addElementNamePart(mIRElementNamePart);
        if (mIRExpressionNode != null) {
            mIRElementNode.setName(mIRExpressionNode.getName());
            mIRElementNode.setOriginalText(mIRExpressionNode.getOriginalText());
            mIRElementNamePart.setName(mIRExpressionNode.getName());
        }
        return mIRElementNode;
    }

    public static MIROperationNode CREATE_OPERATION_NODE(MIRElementNode mIRElementNode) {
        MIROperationNode mIROperationNode = new MIROperationNode();
        mIROperationNode.setFrom(mIRElementNode);
        MIRElementNamePart mIRElementNamePart = null;
        for (MIRElementNamePart mIRElementNamePart2 : mIRElementNode.getElementNamePartByPosition()) {
            mIRElementNamePart = new MIRElementNamePart(mIRElementNamePart2);
            mIROperationNode.addElementNamePart(mIRElementNamePart);
        }
        if (mIRElementNamePart != null) {
            mIRElementNamePart.setSourceElementType((short)23);
        }
        return mIROperationNode;
    }

    public static MIROperationNode CREATE_OPERATION_NODE(MIRToken mIRToken) {
        String string = mIRToken != null ? mIRToken.getText() : "";
        return MIRParserHelper.CREATE_OPERATION_NODE(mIRToken, string);
    }

    public static MIROperationNode CREATE_OPERATION_NODE(MIRToken mIRToken, String string) {
        MIROperationNode mIROperationNode = new MIROperationNode();
        MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
        mIROperationNode.addElementNamePart(mIRElementNamePart);
        mIROperationNode.setName(string);
        mIRElementNamePart.setName(string);
        mIRElementNamePart.setSourceElementType((short)23);
        if (mIRToken != null) {
            mIROperationNode.setOriginalText(mIRToken.getOriginalText());
            mIRElementNamePart.setQuoted(mIRToken.getCode() == 270);
        }
        return mIROperationNode;
    }

    public static MIRDelimiterNode CREATE_DELIMITER_NODE(String string, String string2) {
        MIRDelimiterNode mIRDelimiterNode = new MIRDelimiterNode();
        mIRDelimiterNode.setName(string);
        mIRDelimiterNode.setOriginalText(string2);
        return mIRDelimiterNode;
    }

    public static MIRDelimiterNode CREATE_DELIMITER_NODE(String string, String string2, String string3) {
        MIRDelimiterNode mIRDelimiterNode = MIRParserHelper.CREATE_DELIMITER_NODE(string, string2);
        mIRDelimiterNode.setDelimiter(string3);
        return mIRDelimiterNode;
    }

    public static MIRDelimiterNode CREATE_DELIMITER_NODE(String string, String string2, String string3, boolean bl) {
        MIRDelimiterNode mIRDelimiterNode = MIRParserHelper.CREATE_DELIMITER_NODE(string, string2, string3);
        mIRDelimiterNode.setBlock(bl);
        return mIRDelimiterNode;
    }

    public static MIROperatorNode CREATE_OPERATOR_NODE(String string, String string2) {
        MIROperatorNode mIROperatorNode = new MIROperatorNode();
        mIROperatorNode.setName(string);
        mIROperatorNode.setOriginalText(string2);
        return mIROperatorNode;
    }

    public static MIROperatorNode CREATE_OPERATOR_NODE(String string, String string2, MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2) {
        MIROperatorNode mIROperatorNode = MIRParserHelper.CREATE_OPERATOR_NODE(string, string2);
        mIROperatorNode.addLeftExpressionNode(mIRExpressionNode);
        mIROperatorNode.addRightExpressionNode(mIRExpressionNode2);
        return mIROperatorNode;
    }

    public static MIRQueryNode CREATE_QUERY_NODE(MIRElementNode mIRElementNode, MIRDelimiterNode mIRDelimiterNode, MIRStatementNode mIRStatementNode) {
        MIRQueryNode mIRQueryNode = new MIRQueryNode();
        if (mIRElementNode != null) {
            mIRQueryNode.addClassifierElementNode(mIRElementNode);
        }
        if (mIRDelimiterNode != null) {
            mIRQueryNode.addFeatureDelimiterNode(mIRDelimiterNode);
        }
        if (mIRStatementNode != null) {
            mIRQueryNode.addQueryStatementNode(mIRStatementNode);
        }
        return mIRQueryNode;
    }

    public static MIRStatementNode CREATE_STATEMENT_NODE(int n) {
        MIRStatementNode mIRStatementNode = new MIRStatementNode();
        mIRStatementNode.setStatementType(n);
        return mIRStatementNode;
    }

    public static MIRConstantNode CREATE_CONSTANT_NODE(MIRToken mIRToken) {
        MIRConstantNode mIRConstantNode = new MIRConstantNode();
        mIRConstantNode.setName(mIRToken.getText());
        mIRConstantNode.setOriginalText(mIRToken.getOriginalText());
        return mIRConstantNode;
    }

    public static MIRConstantNode CREATE_CONSTANT_NODE(MIRElementNode mIRElementNode) {
        MIRConstantNode mIRConstantNode = new MIRConstantNode();
        mIRConstantNode.setName(mIRElementNode.getName());
        mIRConstantNode.setOriginalText(mIRElementNode.getOriginalText());
        return mIRConstantNode;
    }

    public static MIRConstantNode CREATE_CONSTANT_NODE(String string, String string2) {
        MIRConstantNode mIRConstantNode = new MIRConstantNode();
        mIRConstantNode.setName(string);
        mIRConstantNode.setOriginalText(string2);
        return mIRConstantNode;
    }

    public static MIRConstantNode CREATE_CONSTANT_NODE(String string) {
        MIRConstantNode mIRConstantNode = new MIRConstantNode();
        mIRConstantNode.setName(string);
        return mIRConstantNode;
    }

    public static void MERGE(MIRElementNode mIRElementNode, MIRElementNode mIRElementNode2) {
        mIRElementNode.setName(mIRElementNode.getName() + mIRElementNode2.getName());
        mIRElementNode.setOriginalText(mIRElementNode.getOriginalText() + mIRElementNode2.getOriginalText());
        short s = (short)mIRElementNode.getElementNamePartCount();
        while (mIRElementNode2.getElementNamePartCount() > 0) {
            MIRElementNamePart mIRElementNamePart = mIRElementNode2.getElementNamePartByPosition().get(0);
            mIRElementNode2.removeElementNamePart(mIRElementNamePart);
            mIRElementNamePart.setPosition((short)(s + mIRElementNamePart.getPosition()));
            mIRElementNode.addElementNamePart(mIRElementNamePart);
        }
    }

    public static void TRIM(MIRElementNode mIRElementNode, int n) {
        if (mIRElementNode.getElementNamePartCount() <= n) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        mIRElementNode.removeElementNameParts();
        Iterator<MIRElementNamePart> iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext() && n2 < n) {
            MIRElementNamePart mIRElementNamePart = iterator.next();
            if (n2++ > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(mIRElementNamePart.getName());
            mIRElementNode.addElementNamePart(mIRElementNamePart);
        }
        mIRElementNode.setName(stringBuilder.toString());
    }

    private static MIRExpressionNode getFirstLeaf(List<MIRExpressionNode> list) {
        ArrayList<MIRExpressionNode> arrayList = new ArrayList<MIRExpressionNode>();
        for (int i = 0; i < list.size(); ++i) {
            MIRExpressionNode mIRExpressionNode = list.get(i);
            if (!(mIRExpressionNode instanceof MIRStatementNode) || ((MIRStatementNode)mIRExpressionNode).getStatementType() != 6 || ((MIRStatementNode)mIRExpressionNode).getBlock()) {
                return i == 0 ? null : mIRExpressionNode;
            }
            MIROperatorNode mIROperatorNode = (MIROperatorNode)((MIRStatementNode)mIRExpressionNode).getExpressionNodeByPosition().get(0);
            arrayList.add(mIROperatorNode.getLeftExpressionNode());
            arrayList.add(mIROperatorNode.getRightExpressionNode());
        }
        return MIRParserHelper.getFirstLeaf(arrayList);
    }

    private static MIRExpressionNode removeFromOperator(MIRExpressionNode mIRExpressionNode) {
        mIRExpressionNode.removeLeftOfOperatorNode();
        mIRExpressionNode.removeRightOfOperatorNode();
        return mIRExpressionNode;
    }

    public static MIRExpressionNode GET_FIRST_CHILD(MIRStatementNode mIRStatementNode) {
        return mIRStatementNode.getExpressionNodeByPosition().get(0);
    }

    public static String GET_POSITIONAL() {
        return "POSITIONAL";
    }

    public static MIRExpressionNode GET_FEATURES(MIRExpressionNode mIRExpressionNode) {
        MIRElementNode mIRElementNode = null;
        MIRExpressionNode mIRExpressionNode2 = mIRExpressionNode;
        do {
            MIROperatorNode mIROperatorNode;
            MIRExpressionNode mIRExpressionNode3;
            if (!(mIRExpressionNode2 instanceof MIROperatorNode) || !mIRExpressionNode2.getName().equals("=") || !((mIRExpressionNode3 = (mIROperatorNode = (MIROperatorNode)mIRExpressionNode2).getLeftExpressionNode()) instanceof MIRElementNode)) continue;
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode3);
            MIRElementNode mIRElementNode2 = MIRParserHelper.CREATE_ELEMENT_NODE(mIRExpressionNode3.getName(), mIRExpressionNode3.getOriginalText(), mIRElementNamePart.getQuoted());
            MIRParserHelper.SET_ELEMENT_NODE_KIND(mIRElementNode2, (byte)2);
            MIRParserHelper.ADD_REFERENCED_NODE(mIRElementNode2, mIROperatorNode.getRightExpressionNode());
            if (mIRElementNode == null) {
                mIRElementNode = mIRElementNode2;
                continue;
            }
            MIRParserHelper.ADD_TO_LAST_NODE(mIRElementNode, mIRElementNode2);
        } while ((mIRExpressionNode2 = mIRExpressionNode2.getNextExpressionNode()) != null);
        return mIRElementNode;
    }

    public static MIRElementNamePart GET_FIRST_NAME_PART(MIRElementNode mIRElementNode) {
        return mIRElementNode.getElementNamePartByPosition().get(0);
    }

    public static MIRElementNamePart GET_LAST_NAME_PART(MIRElementNode mIRElementNode) {
        return mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
    }

    public static void resolveHierarchicalNode(MIRElementNode mIRElementNode, MIRConstantNode mIRConstantNode) {
        String string = mIRConstantNode.getName();
        String string2 = string.substring(2);
        String[] stringArray = string2.split("\\.");
        short s = (short)mIRElementNode.getElementNamePartCount();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            MIRElementNode mIRElementNode2 = MIRParserHelper.CREATE_ELEMENT_NODE(string3, string3, false);
            short s2 = s;
            s = (short)(s + 1);
            mIRElementNode2.setPosition(s2);
            mIRElementNode.setName(mIRElementNode.getName() + ".");
            mIRElementNode.setOriginalText(mIRElementNode.getOriginalText() + ".");
            MIRParserHelper.MERGE(mIRElementNode, mIRElementNode2);
        }
    }
}

