/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.lexer;

import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.lexer.MIRFlexLexer;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

class MIRTableauFlexLexer
extends MIRFlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int INITIAL = 0;
    public static final int pound_date = 2;
    public static final int quote_string = 4;
    public static final int equote_string = 6;
    public static final int dquote_string = 8;
    public static final int bquote_name = 10;
    public static final int dquote_name = 12;
    public static final int sbracket_name = 14;
    public static final int cbracket_name = 16;
    public static final int star_comment = 18;
    public static final int dash_comment = 20;
    public static final int slash_comment = 22;
    public static final int simple_string = 24;
    public static final int lod_expression = 26;
    public static final int pound_literal = 28;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] ZZ_CMAP_TOP = MIRTableauFlexLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u0001\u0100\u0004\u0200\u0001\u0300\u0001\u0400\u0001\u0200\u0005\u0500\u0001\u0600\u0001\u0700\u0001\u0800\u0005\u0200\u0001\u0900\u0001\u0a00\u0001\u0b00\u0001\u0c00\u0001\u0d00\u0001\u0e00\u0001\u0f00\u0003\u0200\u0001\u1000\u000f\u0200\u0001\u1100u\u0200\u0001\u0700\u0001\u0200\u0001\u1200\u0001\u1300\u0001\u1400\u0001\u1500,\u0200\b\u1600\u001f\u0200\u0001\u1700\u0004\u0200\u0001\u1800\b\u0200\u0001\u1900\u0002\u0200\u0001\u1a00\u0001\u1b00\u0001\u1500\u0001\u0200\u0001\u0600\u0001\u0200\u0001\u1c00\u0001\u1900\u0001\u0a00\u0003\u0200\u0001\u1400\u0001\u1d00L\u0200\u0001\u1e00\u0001\u1400k\u0200\u0001\u1f00\t\u0200\u0001\u2000\u0001\u1500\u0006\u0200\u0001\u1400\u0f16\u0200";
    private static final int[] ZZ_CMAP_BLOCKS = MIRTableauFlexLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\u0001\u0000\b\u0001\u0001\u0002\u0001\u0003\u0001\u0002\u0001\u0004\u0001\u0005\u0012\u0001\u0001\u0002\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0002\u0006\u0001\n\u0002\u000b\u0001\f\u0001\r\u0001\u000b\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\t\u0012\u0001\u0013\u0001\u000b\u0003\u0006\u0001\u000b\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0002\u0001\u0001\u001b\u0002\u0001\u0001\u001c\u0001\u0001\u0001\u001d\u0005\u0001\u0001\u001e\u0001\u001f\u0002\u0001\u0001 \u0001\u0001\u0001!\u0001\"\u0001#\u0001$\u0001\u0006\u0001\u0001\u0001%\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0002\u0001\u0001\u001b\u0002\u0001\u0001\u001c\u0001\u0001\u0001\u001d\u0005\u0001\u0001\u001e\u0001\u001f\u0002\u0001\u0001 \u0001\u0001\u0001!\u0001&\u0001\u0006\u0001'\u0001\u0006\u0001\u0001\u0001(\u0004)\u0001*\u001a)\u0001+\u001f)\u0002\u0001\u0001,\u0001-\f\u0001\u0002.\u0010\u0001\u0001/\u00010L\u0001\u0002\u001b\u022e\u0001\n1\u0086\u0001\n1\u00c6\u0001\n1\u009c\u0001\n1v\u0001\n1`\u0001\n1v\u0001\n1F\u0001\n1\u0116\u0001\n1F\u0001\n1\u00e6\u0001\u0001\u0004\u015f\u0001\n1&\u0001\n1\u012c\u0001\n1\u0080\u0001\n1\u00a6\u0001\n1\u0006\u0001\n1\u00b6\u0001\n1V\u0001\n1\u0086\u0001\n1\u0006\u0001\n1\u00a6\u0001\u000b\u0004\u001d\u0001\u0002\u0004\u0005\u0001\u0001\u0004/\u0001\u0001\u0004\u00a0\u0001\u0001\u0002\u01cf\u0001\n1&\u0001\n1\u00c6\u0001\n1\u0016\u0001\n1V\u0001\n1\u0196\u0001\n1\u0006\u0001\u01002\f\u0001\u0001\u000b\u0003\u0001\n1\u0186\u0001\n1\u0086\u0001\n1\u012c\u0001\n1\u0080\u0001\n1<\u0001\n1\u0090\u0001\n1v\u0001\n1f\u0001\n1\u0086\u0001\n1F\u0001\n1\u00b6\u0001\n1\u0164\u000121@\u0001\n1\u00b6\u0001";
    private static final int[] ZZ_ACTION = MIRTableauFlexLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0003\u0001\u0001\u0002\u0001\u0003\u0003\u0001\u0005\u0000\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u0006\u0001\t\u0001\u0006\u0002\u000b\u0002\u0005\u0001\f\u0001\r\u0001\u000e\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0001\u0001\u000f\u0001\u0001\u0001\u0010\u0001\u0000\u0001\u0001\u0001\u0010\u0001\u0001\u0001\u0002\u0001\u0010\u0001\u0000\u0001\u0003\u0001\u0011\u0001\u0012\u0001\u0001\u0001\u0013\u0001\u0000\u0001\u0001\u0001\u0013\u0001\u0001\u0001\u0013\u0003\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0016\u0001\u0017\u0001\u0016\u0001\u0017\u0001\u0016\u0001\u0018\u0001\u0019\u0001\u001a\u0002\u0016\u0001\u001a\u0001\u0016\u0001\u001a\u0001\u0016\u0004\u0000\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u001f\u0005\u0000\u0002\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001 \u0001!\u0003\u0000\u0001\"\u0004\u0000\u0002\u0017\u0001\u0000\u0001#\u0004\u0000\u0001#\u0005\u0000\u0002\u001a\u0002\u0000\u0001\u000b\u0002\u0000\u0001$\u0004\u0000\u0001\u0005\u0001%\u0004\u0000\u0001\u000b\u0006\u0000\u0001\u0005\u0002\u0000\u0001\u000b\b\u0000\u0001&\t\u0000\u0001'\u0001(\u0002\u0000\u0001&\u0016\u0000\u0001)\u0007\u0000";
    private static final int[] ZZ_ROWMAP = MIRTableauFlexLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00003\u0000f\u0000\u0099\u0000\u00cc\u0000\u00ff\u0000\u0132\u0000\u0165\u0000\u0198\u0000\u01cb\u0000\u01fe\u0000\u0231\u0000\u0264\u0000\u0297\u0000\u02ca\u0000\u02fd\u0000\u02ca\u0000\u02ca\u0000\u0330\u0000\u02ca\u0000\u02ca\u0000\u0363\u0000\u0396\u0000\u03c9\u0000\u03fc\u0000\u042f\u0000\u0462\u0000\u0495\u0000\u02ca\u0000\u02ca\u0000\u04c8\u0000\u04fb\u0000\u052e\u0000\u0561\u0000\u0594\u0000\u05c7\u0000\u05fa\u0000\u062d\u0000\u02ca\u0000\u0660\u0000\u0693\u0000\u06c6\u0000\u06f9\u0000\u072c\u0000\u075f\u0000\u0792\u0000\u07c5\u0000\u07f8\u0000\u082b\u0000\u02ca\u0000\u02ca\u0000\u085e\u0000\u02ca\u0000\u0891\u0000\u08c4\u0000\u08f7\u0000\u092a\u0000\u095d\u0000\u02ca\u0000\u0990\u0000\u09c3\u0000\u02ca\u0000\u02ca\u0000\u09f6\u0000\u0a29\u0000\u0a5c\u0000\u0a8f\u0000\u0ac2\u0000\u0af5\u0000\u02ca\u0000\u02ca\u0000\u0b28\u0000\u0b5b\u0000\u0b8e\u0000\u0bc1\u0000\u0bf4\u0000\u0c27\u0000\u0c5a\u0000\u04fb\u0000\u0561\u0000\u05c7\u0000\u0c8d\u0000\u02ca\u0000\u0cc0\u0000\u02ca\u0000\u02ca\u0000\u0396\u0000\u0cf3\u0000\u0d26\u0000\u0d59\u0000\u0d8c\u0000\u02ca\u0000\u04c8\u0000\u0dbf\u0000\u0df2\u0000\u0e25\u0000\u0e58\u0000\u0e8b\u0000\u0ebe\u0000\u0ef1\u0000\u0f24\u0000\u0f57\u0000\u02ca\u0000\u02ca\u0000\u072c\u0000\u0f8a\u0000\u0fbd\u0000\u02ca\u0000\u0ff0\u0000\u0a29\u0000\u0a8f\u0000\u0af5\u0000\u1023\u0000\u1056\u0000\u1089\u0000\u0b28\u0000\u0b5b\u0000\u0b8e\u0000\u0bf4\u0000\u0c5a\u0000\u0b5b\u0000\u10bc\u0000\u10ef\u0000\u1122\u0000\u1155\u0000\u1188\u0000\u11bb\u0000\u11ee\u0000\u1221\u0000\u1254\u0000\u1287\u0000\u12ba\u0000\u12ed\u0000\u12ed\u0000\u1320\u0000\u1353\u0000\u1386\u0000\u13b9\u0000\u13ec\u0000\u02ca\u0000\u141f\u0000\u1452\u0000\u1485\u0000\u14b8\u0000\u14eb\u0000\u151e\u0000\u1551\u0000\u1584\u0000\u15b7\u0000\u15ea\u0000\u161d\u0000\u1650\u0000\u1683\u0000\u16b6\u0000\u16e9\u0000\u171c\u0000\u174f\u0000\u1782\u0000\u17b5\u0000\u17e8\u0000\u181b\u0000\u184e\u0000\u1881\u0000\u02ca\u0000\u18b4\u0000\u18e7\u0000\u191a\u0000\u194d\u0000\u1980\u0000\u19b3\u0000\u19e6\u0000\u1a19\u0000\u1a4c\u0000\u02ca\u0000\u02ca\u0000\u1a7f\u0000\u1ab2\u0000\u1320\u0000\u1ae5\u0000\u1b18\u0000\u1b4b\u0000\u1b7e\u0000\u1bb1\u0000\u1be4\u0000\u1c17\u0000\u1c4a\u0000\u1c7d\u0000\u1cb0\u0000\u1ce3\u0000\u1d16\u0000\u1d49\u0000\u1d7c\u0000\u1daf\u0000\u1de2\u0000\u1e15\u0000\u1e48\u0000\u1e7b\u0000\u1eae\u0000\u1ee1\u0000\u1f14\u0000\u02ca\u0000\u1f47\u0000\u1f7a\u0000\u1fad\u0000\u1fe0\u0000\u2013\u0000\u2046\u0000\u2079";
    private static final int[] ZZ_TRANS = MIRTableauFlexLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u000f\u0001\u0010\u0002\u000f\u0001\u0010\u0001\u000f\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0014\u0002\u0011\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0002\u0014\u0001\u0010\u0001\u001b\u0002\u0010\u0001\u001c\u0003\u0010\u0001\u001b\u0004\u0010\u0001\u001d\u0001\u0010\u0001\u0014\u0001\u001e\u0001\u001f\u0001\u0014\u0003\u0010\u0001\u000f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001\u0010\b&\u0001'*&\n(\u0001)\u0018(\u0001*\u000f(\n+\u0001,\u0018+\u0001-\u000f+\u0007.\u0001/\u001b.\u00010\u000f.\u000f1\u00012\u00151\u00013\r1\u00074\u00015\u001b4\u00016\u000f4$7\u00018\u000e7'9\u0001:\u000b9\f;\u0001<\u0003;\u0001=!;\u0001\u0000\u0003;\u0001>\u0001;\u0001>,;\u0001\u0000\u0001?\u0001@\u0002?\u0001@\u0003?\u0002@\u0007?\u0002@\u0001?\u000e@\u0001?\u0001@\u0004?\u0003@\u0001?\u0001A\u0001B\u0001C\u0001D\u0001E\u0002@\u0001\u000f\u0001\u0010\u0002\u000f\u0001\u0010\u0001\u000f\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0014\u0002\u0011\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001F\u0001\u0014\u0001\u0010\u0001\u001b\u0002\u0010\u0001\u001c\u0003\u0010\u0001\u001b\u0004\u0010\u0001\u001d\u0001\u0010\u0001\u0014\u0001\u001e\u0001\u001f\u0001G\u0003\u0010\u0001\u000f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001\u0010\u0001?\u0001H\u0002?\u0001H\u0003?\u0002H\u0004?\u0001H\u0001?\u0001I\u0002H\u0001?\u000eH\u0001?\u0001H\u0004?\u0003H\u0001?\u0001J\u0001K\u0001L\u0001M\u0001N\u0002H4\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0007\u0000\u0002\u0010\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0002\u0010\u0011\u0000\u0002R\u001e\u0000\u0001R\u000f\u0000\u0001S5\u0000\u0002T,\u0000\u0001U\u0003\u0000\u0001V1\u0000\u0001W\u0001\u0000\u0002X\u0006\u0000\u0001Y\u0006\u0000\u0001Z\u0010\u0000\u0001[\u0010\u0000\u0001W\u0001\u0000\u0002X\u0006\u0000\u0001Y\u0017\u0000\u0001[\u0002\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0001\u0015\u0006\u0000\u0002\u0010\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0002\u0010\u0001\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0001\\\u0006\u0000\u0002\u0010\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0002\u0010\u0002\u0000\u0004]\n\u0000\u0001^\b\u0000\u0001_\u0001`\u0001a\u000e\u0000\u0002]\u0007\u0000+\u0010\u0001\u0000/\u0010\u0001b\u0003\u0010\u0001#\u0001!\u0001c\u0001#\u0001!\u0002\u0010(\u0000\u0004\u0010\u0007\u0000+\u0010\u0001\u0000\u0001#\u0001!\u0001c\u0001#\u0001!*\u0010\u0001d\n\u0010\u0001\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0007\u0000\u0002e\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0001e\u0001\u0010\b&\u0001\u0000*&\n(\u0001\u0000\u0018(\u0001f\u000f(\n\u0000\u0001g(\u0000\n(\u0001h((\n+\u0001i\u0018+\u0001-\u000f+\n\u0000\u0001+(\u0000\n+\u0001-\u0018+\u0001-\u000f+\u0007.\u0001\u0000\u001b.\u0001j\u000f.\u0007\u0000\u0001g+\u0000\u0007.\u0001h+.\u000f1\u0001\u0000\u00151\u0001\u0000\r1\u00074\u0001\u0000\u001b4\u0001k\u00164\u0001h+4$7\u0001\u0000\u000e7$\u0000\u0001g\u000e\u0000'9\u0001\u0000\u000b9'\u0000\u0001g\u001b\u0000\u0001l.\u0000\u0001m'\u0000\u0001@\u0002\u0000\u0001@\u0003\u0000\u0002@\u0007\u0000\u0002@\u0001\u0000\u000e@\u0001\u0000\u0001@\u0004\u0000\u0003@\u0001\u0000\u0001n\u0001B\u0001o\u0001D\u0001p-@\u0001\u0000/@\u0001q\u0003@\u0001D\u0001B\u0001r\u0001D\u0001B\u0002@(\u0000\u0004@\u0007\u0000+@\u0001\u0000\u0001D\u0001B\u0001r\u0001D\u0001B*@\u0001s\n@\u0001\u0000\u0001H\u0002\u0000\u0001H\u0003\u0000\u0001t\u0001H\u0004\u0000\u0001H\u0001\u0000\u0001u\u0002H\u0001\u0000\u000eH\u0001\u0000\u0001H\u0004\u0000\u0003H\u0001\u0000\u0001v\u0001K\u0001w\u0001M\u0001x\u0002H\u0001\u0000\u0001u\u0002\u0000\u0001u\u0003\u0000\u0001y\u0001u\u0004\u0000\u0001u\u0001\u0000\u0003u\u0001\u0000\u000eu\u0001\u0000\u0001u\u0004\u0000\u0003u\u0001\u0000\u0001z\u0001{\u0001|\u0001}\u0001~\u0002u+H\u0001\u0000\u000fH\u0001t\u001fH\u0001\u007f\u0003H\u0001M\u0001K\u0001\u0080\u0001M\u0001K\u0002H(\u0000\u0004H\u0007\u0000\bH\u0001t\"H\u0001\u0000\u0001M\u0001K\u0001\u0080\u0001M\u0001K*H\u0001\u0081\nH\u0011\u0000\u0002\u0082\u001e\u0000\u0001\u0082\u0012\u0000\u0002T\u0006\u0000\u0001Y(\u0000\u0001W\u0001\u0000\u0002\u0083\u0006\u0000\u0001Y\u0017\u0000\u0001\u0084\u000e\u0000\u0002\u0085\u0002\u0000\u0002\u00861\u0000\u0002Z\u0002\u0000\u0006Z)\u0000\u0002\u0084\u001e\u0000\u0001\u0084\u0011\u0000\u0001\u0087B\u0000\u0001\u0088-\u0000\u0001\u00894\u0000\u0001\u008a\u0015\u0000,\u0010\u0001#\u0001!\u0001c\u0001#\u0001!\u0002\u0010\u0001\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0007\u0000\u0002\u0010\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0004\u0010\u0001O\u0001!\u0001P\u0001#\u0001Q*\u0010\u0001\u0000\n\u0010\u0001\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0007\u0000\u0002\u008b\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0001\u008b\u0001\u0010\n(\u0001\u0000((\u0007.\u0001\u0000+.\u00074\u0001\u0000+4\u0010\u008c\u0001\u0000\"\u008c,@\u0001D\u0001B\u0001r\u0001D\u0001B\u0002@\u0001\u0000\u0001@\u0002\u0000\u0001@\u0003\u0000\u0002@\u0007\u0000\u0002@\u0001\u0000\u000e@\u0001\u0000\u0001@\u0004\u0000\u0004@\u0001n\u0001B\u0001o\u0001D\u0001p*@\u0001\u0000\n@+u\u0001\u0000\u000fu\u0001y\u001fu\u0001\u008d\u0003u\u0001}\u0001{\u0001\u008e\u0001}\u0001{\u0002u(\u0000\u0004u\u0007\u0000\bu\u0001y\"u\u0001\u0000\u0001}\u0001{\u0001\u008e\u0001}\u0001{*u\u0001\u008f\nu\bH\u0001t#H\u0001M\u0001K\u0001\u0080\u0001M\u0001K\u0002H\u0001\u0000\u0001H\u0002\u0000\u0001H\u0003\u0000\u0001t\u0001H\u0004\u0000\u0001H\u0001\u0000\u0001u\u0002H\u0001\u0000\u000eH\u0001\u0000\u0001H\u0004\u0000\u0004H\u0001v\u0001K\u0001w\u0001M\u0001x*H\u0001\u0000\nH\u0011\u0000\u0002\u0090\u001e\u0000\u0001\u0090\u0010\u0000\u0001W\u0001\u0000\u0002\u0091\u0006\u0000\u0001Y\u0017\u0000\u0001\u0092\u0012\u0000\u0002\u0092\u001e\u0000\u0001\u0092\u0012\u0000\u0002\u0086 \u0000\u0003\u0087\u0001\u0093\u0001\u0087\u0001\u0094,\u0087\u0018\u0000\u0001\u0095;\u0000\u0001\u0096)\u0000\u0001\u0097\u001c\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0007\u0000\u0002\u0098\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0001\u0098\u0001\u0010\bu\u0001y#u\u0001}\u0001{\u0001\u008e\u0001}\u0001{\u0002u\u0001\u0000\u0001u\u0002\u0000\u0001u\u0003\u0000\u0001y\u0001u\u0004\u0000\u0001u\u0001\u0000\u0003u\u0001\u0000\u000eu\u0001\u0000\u0001u\u0004\u0000\u0004u\u0001z\u0001{\u0001|\u0001}\u0001~*u\u0001\u0000\nu\u0011\u0000\u0002\u0099\u001e\u0000\u0001\u0099\u000f\u0000\u0001\u009a\u0001W\u0001\u0000\u0002\u009b\u0006\u0000\u0001Y'\u0000\u0001\u009a&\u0000\u0004\u0093\n\u0000\u0001^\t\u0000\u0001`\u000f\u0000\u0002\u0093\u0007\u0000\u0002\u0087\u0001\u0094\u0001\u0093\u0002\u0094\u0014\u0087\u0001\u009c\u000f\u0087\u0002\u0094\u0006\u0087\u001d\u0000\u0001\u009d/\u0000\u0001\u009e5\u0000\u0001\u009f\u0017\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0003\u0000\u0002\u0010\u0004\u0000\u0001\u009a\u0002\u0000\u0002\u0010\u0002\u0000\r\u0010\u0001\u0000\u0001\u0010\u0004\u0000\u0003\u0010\u0001\u0000\u0001O\u0001!\u0001P\u0001#\u0001Q\u0002\u0010\u000e\u0000\u0001\u00a05\u0000\u0002\u00a1\u001e\u0000\u0001\u00a1\u0010\u0000\u0001W\u0001\u0000\u0002\u009b\u0006\u0000\u0001Y\u0019\u0000\u0003\u0087\u0001\u0093\u0001\u0087\u0001\u0094\u0015\u0087\u0001\u00a2\u0016\u0087 \u0000\u0001\u00a3+\u0000\u0001\u00a49\u0000\u0001\u00a5$\u0000\u0002\u00a6\u001e\u0000\u0001\u00a6\u0012\u0000\u0002\u00a7\u001e\u0000\u0001\u00a7\u0001\u0000\u0003\u0087\u0001\u0093\u0001\u0087\u0001\u0094\u001a\u0087\u0001\u00a8\u0011\u0087\u0019\u0000\u0001\u00a92\u0000\u0001\u00aa+\u0000\u0002\u00ab\u001e\u0000\u0001\u00ab\u000f\u0000\u0001\u00ac$\u0000\u0003\u0087\u0001\u0093\u0001\u0087\u0001\u0094\u0013\u0087\u0001\u00ad\u0018\u0087\u001a\u0000\u0001\u00ae2\u0000\u0001\u00af'\u0000\u0001\u00b05\u0000\u0002\u00b1\u001e\u0000\u0001\u00b1\u0001\u0000\u0003\u0087\u0001\u0093\u0001\u0087\u0001\u0094\u0012\u0087\u0001\u00b2\u0019\u0087\u0012\u0000\u0002\u00b3\u001e\u0000\u0001\u00b3\u0012\u0000\u0002\u00b4\u001e\u0000\u0001\u00b4\u0012\u0000\u0002\u00b5\u001e\u0000\u0001\u00b5\u001f\u0000\u0001\u00b6\u0016\u0000\u0004\u00b7$\u0000\u0002\u00b7\u0018\u0000\u0002\u00b8\u001e\u0000\u0001\u00b8\u0003\u0000\u0004\u00b7\u000b\u0000\u0002\u00b9\u0017\u0000\u0002\u00b7\u0005\u0000\u0001\u00b9\u0012\u0000\u0002\u00ba\u001e\u0000\u0001\u00ba\u0012\u0000\u0002\u00bb\u001e\u0000\u0001\u00bb\u0014\u0000\u0001\u00bc2\u0000\u0001\u00bd0\u0000\u0002\u00be\u001e\u0000\u0001\u00be\u0012\u0000\u0002\u00bf\u001e\u0000\u0001\u00bf\u0012\u0000\u0002\u00c0\u001e\u0000\u0001\u00c0\u0012\u0000\u0002\u00c1\u001e\u0000\u0001\u00c1\u0014\u0000\u0001\u00c22\u0000\u0001\u00c30\u0000\u0002\u00c4\u001e\u0000\u0001\u00c4\u0012\u0000\u0002\u00c5\u001e\u0000\u0001\u00c5\u0012\u0000\u0002\u00c6\u001e\u0000\u0001\u00c6\u0012\u0000\u0002\u00c7\u001e\u0000\u0001\u00c7\u0010\u0000\u0001\u00c8+\u0000\u0001\u00c9\u0006\u0000\u0001\u00ca4\u0000\u0002\u00cb\u001e\u0000\u0001\u00cb\u0012\u0000\u0002\u00cc\u001e\u0000\u0001\u00cc\u0012\u0000\u0002\u00cd\u001e\u0000\u0001\u00cd\u0012\u0000\u0002\u00ce\u001e\u0000\u0001\u00ce\u0012\u0000\u0002\u00cf\u001e\u0000\u0001\u00cf\u0012\u0000\u0002\u00d0\u001e\u0000\u0001\u00d0\"\u0000\u0001\u00c9\u0019\u0000\u0001\u00c9*\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MIRTableauFlexLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\b\u0001\u0005\u0000\u0001\t\u0001\u0001\u0002\t\u0001\u0001\u0002\t\u0007\u0001\u0002\t\b\u0001\u0001\t\u0002\u0001\u0001\u0000\u0005\u0001\u0001\u0000\u0001\u0001\u0002\t\u0001\u0001\u0001\t\u0001\u0000\u0004\u0001\u0001\t\u0002\u0001\u0002\t\u0006\u0001\u0002\t\u0007\u0001\u0004\u0000\u0001\t\u0001\u0001\u0002\t\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\t\u0005\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\t\u0003\u0000\u0001\t\u0004\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u0005\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u0001\t\u0004\u0000\u0001\u0001\u0006\u0000\u0001\u0001\u0002\u0000\u0001\u0001\b\u0000\u0001\t\t\u0000\u0002\t\u0002\u0000\u0001\u0001\u0016\u0000\u0001\t\u0007\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private int yylineno = 1;
    Stack<Integer> states = new Stack();

    private static int[] zzUnpackcmap_top() {
        int[] nArray = new int[4352];
        int n = 0;
        n = MIRTableauFlexLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackcmap_top(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] nArray = new int[8448];
        int n = 0;
        n = MIRTableauFlexLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackcmap_blocks(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAction() {
        int[] nArray = new int[208];
        int n = 0;
        n = MIRTableauFlexLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackRowMap() {
        int[] nArray = new int[208];
        int n = 0;
        n = MIRTableauFlexLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackRowMap(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++) << 16;
            nArray[n3++] = n5 | string.charAt(n2++);
        }
        return n3;
    }

    private static int[] zzUnpackTrans() {
        int[] nArray = new int[8364];
        int n = 0;
        n = MIRTableauFlexLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackTrans(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            int n6 = string.charAt(n2++);
            do {
                nArray[n3++] = --n6;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAttribute() {
        int[] nArray = new int[208];
        int n = 0;
        n = MIRTableauFlexLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAttribute(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    @Override
    protected void init(Reader reader) {
        this.yyreset(reader);
        if (!this.zzAtBOL) {
            this.zzAtBOL = true;
        }
        this.yylineno = 1;
        this.states.empty();
    }

    @Override
    protected int getLineNumber() {
        return this.yylineno;
    }

    @Override
    protected char[] matchText() {
        return this.zzBuffer;
    }

    @Override
    protected int matchLength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    @Override
    protected int matchPos() {
        return this.zzStartRead;
    }

    protected int matchAt(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    protected void rescan() {
        this.zzMarkedPos = this.zzStartRead;
    }

    protected void rescan(MIRFlexLexer.LexBuffer lexBuffer) {
        String string = lexBuffer.toString();
        for (int i = 0; i < string.length() && this.zzMarkedPos > 0; ++i) {
            this.zzBuffer[this.zzMarkedPos--] = string.charAt(lexBuffer.length() - i - 1);
        }
    }

    public void yy_push_state(int n) {
        this.states.push(this.yystate());
        this.yybegin(n);
    }

    public void yy_pop_state() {
        this.yybegin(this.states.pop());
    }

    public void correct_yylineno() {
        if (this.zzBuffer[this.zzMarkedPos] == '\n') {
            --this.yylineno;
        }
    }

    MIRTableauFlexLexer(Reader reader, MIRParserOptions mIRParserOptions) {
        super(mIRParserOptions);
        this.zzReader = reader;
    }

    private static int zzCMap(int n) {
        int n2 = n & 0xFF;
        return n2 == n ? ZZ_CMAP_BLOCKS[n2] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[n >> 8] | n2];
    }

    private boolean zzRefill() throws IOException {
        int n;
        int n2;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] cArray = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((n2 = this.zzReader.read(this.zzBuffer, this.zzEndRead, n = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (n2 > 0) {
            this.zzEndRead += n2;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (n2 == n) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int n3 = this.zzReader.read();
                    if (n3 == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)n3;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public void yypushback(int n) {
        if (n > this.yylength()) {
            MIRTableauFlexLexer.zzScanError(2);
        }
        this.zzMarkedPos -= n;
    }

    @Override
    public int yylex() throws IOException {
        int n;
        int n2 = this.zzEndRead;
        char[] cArray = this.zzBuffer;
        int[] nArray = ZZ_TRANS;
        int[] nArray2 = ZZ_ROWMAP;
        int[] nArray3 = ZZ_ATTRIBUTE;
        do {
            int n3;
            int n4 = this.zzMarkedPos;
            int n5 = -1;
            this.zzCurrentPos = this.zzStartRead = n4;
            int n6 = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int n7 = nArray3[this.zzState];
            if ((n7 & 1) == 1) {
                n5 = this.zzState;
            }
            while (true) {
                if (n6 < n2) {
                    n = Character.codePointAt(cArray, n6, n2);
                    n6 += Character.charCount(n);
                } else {
                    if (this.zzAtEOF) {
                        n = -1;
                        break;
                    }
                    this.zzCurrentPos = n6;
                    this.zzMarkedPos = n4;
                    n3 = this.zzRefill() ? 1 : 0;
                    n6 = this.zzCurrentPos;
                    n4 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n2 = this.zzEndRead;
                    if (n3 != 0) {
                        n = -1;
                        break;
                    }
                    n = Character.codePointAt(cArray, n6, n2);
                    n6 += Character.charCount(n);
                }
                n3 = nArray[nArray2[this.zzState] + MIRTableauFlexLexer.zzCMap(n)];
                if (n3 == -1) break;
                this.zzState = n3;
                n7 = nArray3[this.zzState];
                if ((n7 & 1) != 1) continue;
                n5 = this.zzState;
                n4 = n6;
                if ((n7 & 8) == 8) break;
            }
            this.zzMarkedPos = n4;
            for (n3 = this.zzStartRead; n3 < this.zzMarkedPos; ++n3) {
                if (this.zzBuffer[n3] != '\n') continue;
                ++this.yylineno;
            }
            if (n == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            switch (n5 < 0 ? n5 : ZZ_ACTION[n5]) {
                case 1: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                }
                case 42: {
                    break;
                }
                case 2: {
                    this.originalText.append(this.matchText());
                    this.text.append(this.matchText());
                }
                case 43: {
                    break;
                }
                case 3: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    if (this.options.supportPseudoBacktickName()) {
                        return 258;
                    }
                }
                case 44: {
                    break;
                }
                case 4: {
                    this.text.empty();
                    this.originalText.set(this.matchText());
                    return 256;
                }
                case 45: {
                    break;
                }
                case 5: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 258;
                }
                case 46: {
                    break;
                }
                case 6: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    if (this.matchLength() == 1) {
                        return this.matchAt(0);
                    }
                    return 259;
                }
                case 47: {
                    break;
                }
                case 7: {
                    if (this.options.supportDoubleQuoteString()) {
                        this.yy_push_state(8);
                    } else {
                        this.yy_push_state(12);
                    }
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 48: {
                    break;
                }
                case 8: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    this.yy_push_state(28);
                }
                case 49: {
                    break;
                }
                case 9: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return this.matchAt(0);
                }
                case 50: {
                    break;
                }
                case 10: {
                    this.yy_push_state(4);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 51: {
                    break;
                }
                case 11: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 263;
                }
                case 52: {
                    break;
                }
                case 12: {
                    this.originalText.set(this.matchText());
                    if (!this.options.supportSquareBracketName()) {
                        this.text.set(this.matchText());
                        return this.matchAt(0);
                    }
                    this.yy_push_state(14);
                    this.text.empty();
                }
                case 53: {
                    break;
                }
                case 13: {
                    this.yy_push_state(10);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 54: {
                    break;
                }
                case 14: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    this.yy_push_state(26);
                    return this.matchAt(0);
                }
                case 55: {
                    break;
                }
                case 15: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 261;
                }
                case 56: {
                    break;
                }
                case 16: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 265;
                }
                case 57: {
                    break;
                }
                case 17: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    if (this.options.supportPseudoBacktickName()) {
                        return this.matchAt(0);
                    }
                }
                case 58: {
                    break;
                }
                case 18: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    if (this.options.supportPseudoBacktickName()) {
                        this.text.empty();
                        return 256;
                    }
                    return 270;
                }
                case 59: {
                    break;
                }
                case 19: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 270;
                }
                case 60: {
                    break;
                }
                case 20: {
                    this.originalText.append(this.matchText());
                }
                case 61: {
                    break;
                }
                case 21: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 267;
                }
                case 62: {
                    break;
                }
                case 22: {
                    this.yy_pop_state();
                    this.rescan();
                    return 258;
                }
                case 63: {
                    break;
                }
                case 23: {
                    this.yy_pop_state();
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    return 258;
                }
                case 64: {
                    break;
                }
                case 24: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 44;
                }
                case 65: {
                    break;
                }
                case 25: {
                    this.yy_pop_state();
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return this.matchAt(0);
                }
                case 66: {
                    break;
                }
                case 26: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    return 258;
                }
                case 67: {
                    break;
                }
                case 27: {
                    this.yy_push_state(20);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 68: {
                    break;
                }
                case 28: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 262;
                }
                case 69: {
                    break;
                }
                case 29: {
                    this.yy_push_state(18);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 70: {
                    break;
                }
                case 30: {
                    this.yy_push_state(22);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 71: {
                    break;
                }
                case 31: {
                    if (this.options.supportEscapeStringConstants()) {
                        this.yy_push_state(6);
                        this.text.empty();
                        this.originalText.set(this.matchText());
                        break;
                    }
                    this.text.set("'");
                    this.rescan(this.text);
                    this.text.set(this.text.substring(0, 1));
                    return 258;
                }
                case 72: {
                    break;
                }
                case 32: {
                    this.text.append(this.matchText(), 1);
                    this.originalText.append(this.matchText());
                }
                case 73: {
                    break;
                }
                case 33: {
                    this.originalText.append(this.matchText());
                    if (!this.options.supportBackslashEscaping()) {
                        this.yy_pop_state();
                        this.text.append(this.matchText(), 1);
                        return 265;
                    }
                    this.text.append(this.matchText());
                }
                case 74: {
                    break;
                }
                case 34: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 267;
                }
                case 75: {
                    break;
                }
                case 35: {
                    this.yy_pop_state();
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    return 261;
                }
                case 76: {
                    break;
                }
                case 36: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 264;
                }
                case 77: {
                    break;
                }
                case 37: {
                    this.zzMarkedPos = Character.offsetByCodePoints(cArray, this.zzStartRead, this.zzEndRead - this.zzStartRead, this.zzStartRead, 2);
                    if (this.options.supportNestedStarComments()) {
                        this.yy_push_state(18);
                        break;
                    }
                    this.originalText.append(this.matchText());
                    this.correct_yylineno();
                }
                case 78: {
                    break;
                }
                case 38: {
                    this.text.set("{FIXED");
                    this.originalText.set(this.matchText());
                    this.yy_push_state(26);
                    return 258;
                }
                case 79: {
                    break;
                }
                case 39: {
                    this.text.set("{EXCLUDE");
                    this.originalText.set(this.matchText());
                    this.yy_push_state(26);
                    return 258;
                }
                case 80: {
                    break;
                }
                case 40: {
                    this.text.set("{INCLUDE");
                    this.originalText.set(this.matchText());
                    this.yy_push_state(26);
                    return 258;
                }
                case 81: {
                    break;
                }
                case 41: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 261;
                }
                case 82: {
                    break;
                }
                default: {
                    MIRTableauFlexLexer.zzScanError(1);
                }
            }
        } while (n != -1);
        return -1;
    }
}

