/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.lexer;

import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.lexer.MIRFlexLexer;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

class MIRJavaFlexLexer
extends MIRFlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int INITIAL = 0;
    public static final int pound_date = 2;
    public static final int quote_string = 4;
    public static final int equote_string = 6;
    public static final int dquote_string = 8;
    public static final int bquote_name = 10;
    public static final int dquote_name = 12;
    public static final int sbracket_name = 14;
    public static final int cbracket_name = 16;
    public static final int star_comment = 18;
    public static final int dash_comment = 20;
    public static final int slash_comment = 22;
    public static final int simple_string = 24;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 10, 10, 11, 11};
    private static final int[] ZZ_CMAP_TOP = MIRJavaFlexLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000/\u0100\u0001\u0200\u00a7\u0100\b\u0300\u001f\u0100\u0001\u0400\u1000\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = MIRJavaFlexLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\u0001\u0000\b\u0001\u0001\u0000\u0001\u0002\u0001\u0000\u0001\u0001\u0001\u0002\u0012\u0001\u0001\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0002\u0003\u0001\u0007\u0002\b\u0001\t\u0001\n\u0001\b\u0001\n\u0001\u000b\u0001\f\u0001\r\t\u000e\u0002\b\u0003\u0003\u0001\b\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0002\u0001\u0001\u0016\u0002\u0001\u0001\u0017\u0001\u0001\u0001\u0018\u0001\u0019\u0003\u0001\u0001\u001a\u0004\u0001\u0001\u001b\u0002\u0001\u0001\b\u0001\u001c\u0001\u001d\u0001\u0003\u0001\u0001\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\u0013\u0001\"\u0001\u0015\u0001#\u0001$\u0001%\u0001&\u0001\u0001\u0001'\u0001(\u0001)\u0001*\u0002\u0001\u0001+\u0001,\u0001-\u0001.\u0002\u0001\u0001\u001b\u0001/\u0001\u0001\u0001\b\u0001\u0003\u00010\u0001\u0003\u0001\u0001\u00011\u001f2\u00013\u001f2\u0002\u0001\u00014\u00015\f\u0001\u00026\u0010\u0001\u00017\u00018\u011c\u0001\u0001\u0000\u00ff\u0001\u01009\f\u0001\u0001\b\u00f3\u0001";
    private static final int[] ZZ_ACTION = MIRJavaFlexLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0003\u0001\u0001\u0002\u0001\u0003\u0003\u0001\u0003\u0000\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\b\u0001\u0006\u0002\n\u000e\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0001\u0001\u000b\u0001\u0001\u0001\f\u0001\u0000\u0001\u0001\u0001\f\u0001\u0001\u0001\u0002\u0001\f\u0001\u0000\u0001\u0003\u0001\r\u0001\u000e\u0001\u0001\u0001\u000f\u0001\u0000\u0001\u0001\u0001\u000f\u0001\u0001\u0001\u000f\u0003\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0012\u0001\u0013\u0001\u0012\u0001\u0013\u0001\u0012\u0003\u0000\u0001\u0014\u0001\u0015\u0001\u0016\u0002\u0000\u0002\n\u0004\u0005\u0001\u0017\u000b\u0005\u0002\u0000\u0001\u0018\u0001\u0019\u0003\u0000\u0001\u001a\u0004\u0000\u0002\u0013\u0002\u0000\u0001\u001b\f\u0005\u0001\u001c\u0001\u001d\n\u0005";
    private static final int[] ZZ_ROWMAP = MIRJavaFlexLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000:\u0000t\u0000\u00ae\u0000\u00e8\u0000\u0122\u0000\u015c\u0000\u0196\u0000\u01d0\u0000\u020a\u0000\u0244\u0000\u027e\u0000\u02b8\u0000\u02f2\u0000\u02b8\u0000\u02b8\u0000\u02b8\u0000\u02b8\u0000\u032c\u0000\u0366\u0000\u03a0\u0000\u03da\u0000\u0414\u0000\u044e\u0000\u0488\u0000\u04c2\u0000\u04fc\u0000\u0536\u0000\u0570\u0000\u05aa\u0000\u05e4\u0000\u061e\u0000\u0658\u0000\u0692\u0000\u06cc\u0000\u0706\u0000\u0740\u0000\u077a\u0000\u07b4\u0000\u07ee\u0000\u0828\u0000\u0862\u0000\u02b8\u0000\u089c\u0000\u08d6\u0000\u0910\u0000\u094a\u0000\u0984\u0000\u09be\u0000\u09f8\u0000\u0a32\u0000\u0a6c\u0000\u0aa6\u0000\u02b8\u0000\u02b8\u0000\u0ae0\u0000\u02b8\u0000\u0b1a\u0000\u0b54\u0000\u0b8e\u0000\u0bc8\u0000\u0c02\u0000\u02b8\u0000\u0c3c\u0000\u0c76\u0000\u02b8\u0000\u02b8\u0000\u0cb0\u0000\u0cea\u0000\u0d24\u0000\u0d5e\u0000\u0d98\u0000\u0dd2\u0000\u0740\u0000\u07b4\u0000\u0828\u0000\u0e0c\u0000\u02b8\u0000\u02b8\u0000\u032c\u0000\u0e46\u0000\u02b8\u0000\u0e80\u0000\u0eba\u0000\u0ef4\u0000\u0f2e\u0000\u0f68\u0000\u02b8\u0000\u0fa2\u0000\u0fdc\u0000\u1016\u0000\u1050\u0000\u108a\u0000\u10c4\u0000\u10fe\u0000\u1138\u0000\u1172\u0000\u11ac\u0000\u11e6\u0000\u1220\u0000\u125a\u0000\u02b8\u0000\u02b8\u0000\u0984\u0000\u1294\u0000\u12ce\u0000\u02b8\u0000\u1308\u0000\u0cea\u0000\u0d5e\u0000\u0dd2\u0000\u1342\u0000\u137c\u0000\u13b6\u0000\u13f0\u0000\u13f0\u0000\u142a\u0000\u1464\u0000\u149e\u0000\u14d8\u0000\u1512\u0000\u154c\u0000\u1586\u0000\u15c0\u0000\u15fa\u0000\u1634\u0000\u166e\u0000\u16a8\u0000\u02f2\u0000\u02b8\u0000\u16e2\u0000\u171c\u0000\u1756\u0000\u1790\u0000\u17ca\u0000\u1804\u0000\u183e\u0000\u1878\u0000\u18b2\u0000\u18ec";
    private static final int[] ZZ_TRANS = MIRJavaFlexLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\r\u0001\u000e\u0001\r\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0011\u0002\u000f\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0011\u0001\u000e\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0002\u000e\u0001\u0011\u0001\r\u0001\u000e\u0001\u0017\u0001!\u0001\u001a\u0002\u000e\u0001\"\u0001\u000e\u0001\u001d\u0001\u000e\u0001#\u0002\u000e\u0001$\u0003\u000e\u0001\u0011\u0002\u000e\u0001\r\u0001%\u0001&\u0001'\u0001(\u0001)\u0001\u000e\u0005*\u0001+4*\u0007,\u0001-\u0014,\u0001.\u001d,\u0007/\u00010\u0014/\u00011\u001d/\u00042\u00013\u00172\u00014\u001d2\u000b5\u00016\u00125\u00017\u001b5\u00048\u00019\u00178\u0001:\u001d8\u001d;\u0001<\u001c;0=\u0001>\t=\t?\u0001@\u0002?\u0001A,?\u0001\u0000\u0002?\u0001B6?\u0001\u0000\u0001C\u0001D\u0003C\u0002D\u0006C\u0010D\u0002C\u0011D\u0001C\u0002D\u0001C\u0001E\u0001F\u0001G\u0001H\u0001I\u0001D;\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0011\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\r\u0000\u0002M4\u0000\u0001N\u0002\u0000\u0001O8\u0000\u0001P\u0001\u0000\u0002\u0016\u0005\u0000\u0001Q\u0002\u0000\u0001R\u0003\u0000\u0001S\u0006\u0000\u0001Q\u0004\u0000\u0001R\u001d\u0000\u0001P\u0001\u0000\u0002\u0016\u0005\u0000\u0001Q\u0002\u0000\u0001R\n\u0000\u0001Q\u0004\u0000\u0001R\u0013\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0001\u0012\u0005\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000b\u000e\u0001T\u0004\u000e\u0001U\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0005\u000e\u0001V\u000b\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000b\u000e\u0001W\u0005\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0001X\u0005\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0011\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\b\u000e\u0001Y\b\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\n\u000e\u0001Z\u0006\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000b\u000e\u0001[\u0005\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0001\u0012\u0005\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000f\u000e\u0001\\\u0001\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001\u000e\u0001]\u000f\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0005\u000e\u0001^\b\u000e\u0001_\u0002\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0005\u000e\u0001`\u000b\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\n\u000e\u0001a\u0006\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0001\u0012\u0005\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0011\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0005\u000e\u0001^\u000b\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L4\u000e\u0001\u00007\u000e\u0001b\u0002\u000e\u0001(\u0001&\u0001c\u0001(\u0001&\u0001\u000e1\u0000\u0003\u000e\u0006\u00003\u000e\u0001\u0000\u0001(\u0001&\u0001c\u0001(\u0001&2\u000e\u0001d\b\u000e\u0005*\u0001\u00004*\u0007,\u0001\u0000\u0014,\u0001e\u001d,\u0007\u0000\u0001f2\u0000\u0007,\u0001g2,\u0007/\u0001h\u0014/\u00011\u001d/\u0007\u0000\u0001/2\u0000\u0007/\u00011\u0014/\u00011\u001d/\u00042\u0001\u0000\u00172\u0001i\u001d2\u0004\u0000\u0001f5\u0000\u00042\u0001g52\u000b5\u0001\u0000\u00125\u0001\u0000\u001b5\u00048\u0001\u0000\u00178\u0001j!8\u0001g58\u001d;\u0001\u0000\u001c;\u001d\u0000\u0001f\u001c\u00000=\u0001\u0000\t=0\u0000\u0001f\u0015\u0000\u0001k6\u0000\u0001l1\u0000\u0001D\u0003\u0000\u0002D\u0006\u0000\u0010D\u0002\u0000\u0011D\u0001\u0000\u0002D\u0001\u0000\u0001m\u0001F\u0001n\u0001H\u0001o4D\u0001\u00007D\u0001p\u0002D\u0001H\u0001F\u0001q\u0001H\u0001F\u0001D1\u0000\u0003D\u0006\u00003D\u0001\u0000\u0001H\u0001F\u0001q\u0001H\u0001F2D\u0001r\bD\r\u0000\u0002M\u0005\u0000\u0001Q\r\u0000\u0001Q!\u0000\u0001s\u0002\u0000\u0002t8\u0000\u0002S\u0001\u0000\u0006S\u0001\u0000\u0001R\u0007\u0000\u0004S\u0004\u0000\u0001R\u0013\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000b\u000e\u0001u\u0005\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000e\u000e\u0001v\u0002\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001w\u0010\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000f\u000e\u0001x\u0001\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000b\u000e\u0001y\u0005\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000e\u000e\u0001z\u0002\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\n\u000e\u0001{\u0006\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\t\u000e\u0001|\u0007\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0007\u000e\u0001}\t\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000b\u000e\u0001~\u0005\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\f\u000e\u0001\u007f\u0004\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001\u0080\u0010\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000e\u000e\u0001\u0081\u0002\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L5\u000e\u0001(\u0001&\u0001c\u0001(\u0001&\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0011\u000e\u0001\u0000\u0003\u000e\u0001J\u0001&\u0001K\u0001(\u0001L2\u000e\u0001\u0000\b\u000e\u0007,\u0001\u00002,\u00042\u0001\u000052\u00048\u0001\u000058\f\u0082\u0001\u0000-\u00824D\u0001H\u0001F\u0001q\u0001H\u0001F\u0001D\u0001\u0000\u0001D\u0003\u0000\u0002D\u0006\u0000\u0010D\u0002\u0000\u0011D\u0001\u0000\u0003D\u0001m\u0001F\u0001n\u0001H\u0001o2D\u0001\u0000\bD\r\u0000\u0002t,\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\b\u000e\u0001\u0083\b\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0003\u000e\u0001\u0081\r\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\f\u000e\u0001\u0084\u0004\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001\u000e\u0001\u0085\u000f\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001a\u0010\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0003\u000e\u0001\u0086\r\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0004\u000e\u0001\u0081\f\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001\u000e\u0001\u0087\u000f\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0003\u000e\u0001\u0088\r\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\f\u000e\u0001a\u0004\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0006\u000e\u0001[\n\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\f\u000e\u0001\u0081\u0004\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0003\u000e\u0001\u0089\r\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001\u008a\u0010\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\b\u000e\u0001v\b\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0004\u000e\u0001\u0087\f\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0003\u000e\u0001\u0080\r\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0002\u000e\u0001a\u000e\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0001\u008b\u0010\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u0002\u000e\u0001\u008c\u000e\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\n\u000e\u0001\u0081\u0006\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0002\u000e\u0006\u0000\u0002\u000e\u0001\u0000\r\u000e\u0002\u0000\u000e\u000e\u0001\u0087\u0002\u000e\u0001\u0000\u0002\u000e\u0001\u0000\u0001J\u0001&\u0001K\u0001(\u0001L\u0001\u000e";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MIRJavaFlexLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\b\u0001\u0003\u0000\u0001\t\u0001\u0001\u0004\t\u0018\u0001\u0001\t\u0002\u0001\u0001\u0000\u0005\u0001\u0001\u0000\u0001\u0001\u0002\t\u0001\u0001\u0001\t\u0001\u0000\u0004\u0001\u0001\t\u0002\u0001\u0002\t\u0006\u0001\u0003\u0000\u0001\u0001\u0002\t\u0002\u0000\u0001\t\u0005\u0001\u0001\t\u000b\u0001\u0002\u0000\u0002\t\u0003\u0000\u0001\t\u0004\u0000\u0002\u0001\u0002\u0000\u000e\u0001\u0001\t\n\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private int yylineno = 1;
    Stack<Integer> states = new Stack();

    private static int[] zzUnpackcmap_top() {
        int[] nArray = new int[4352];
        int n = 0;
        n = MIRJavaFlexLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackcmap_top(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] nArray = new int[1280];
        int n = 0;
        n = MIRJavaFlexLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackcmap_blocks(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAction() {
        int[] nArray = new int[140];
        int n = 0;
        n = MIRJavaFlexLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackRowMap() {
        int[] nArray = new int[140];
        int n = 0;
        n = MIRJavaFlexLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackRowMap(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++) << 16;
            nArray[n3++] = n5 | string.charAt(n2++);
        }
        return n3;
    }

    private static int[] zzUnpackTrans() {
        int[] nArray = new int[6438];
        int n = 0;
        n = MIRJavaFlexLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackTrans(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            int n6 = string.charAt(n2++);
            do {
                nArray[n3++] = --n6;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAttribute() {
        int[] nArray = new int[140];
        int n = 0;
        n = MIRJavaFlexLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAttribute(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    @Override
    protected void init(Reader reader) {
        this.yyreset(reader);
        if (!this.zzAtBOL) {
            this.zzAtBOL = true;
        }
        this.yylineno = 1;
        this.states.empty();
    }

    @Override
    protected int getLineNumber() {
        return this.yylineno;
    }

    @Override
    protected char[] matchText() {
        return this.zzBuffer;
    }

    @Override
    protected int matchLength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    @Override
    protected int matchPos() {
        return this.zzStartRead;
    }

    protected int matchAt(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    protected void rescan() {
        this.zzMarkedPos = this.zzStartRead;
    }

    protected void rescan(MIRFlexLexer.LexBuffer lexBuffer) {
        String string = lexBuffer.toString();
        for (int i = 0; i < string.length() && this.zzMarkedPos > 0; ++i) {
            this.zzBuffer[this.zzMarkedPos--] = string.charAt(lexBuffer.length() - i - 1);
        }
    }

    public void yy_push_state(int n) {
        this.states.push(this.yystate());
        this.yybegin(n);
    }

    public void yy_pop_state() {
        this.yybegin(this.states.pop());
    }

    public void correct_yylineno() {
        if (this.zzBuffer[this.zzMarkedPos] == '\n') {
            --this.yylineno;
        }
    }

    MIRJavaFlexLexer(Reader reader, MIRParserOptions mIRParserOptions) {
        super(mIRParserOptions);
        this.zzReader = reader;
    }

    private static int zzCMap(int n) {
        int n2 = n & 0xFF;
        return n2 == n ? ZZ_CMAP_BLOCKS[n2] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[n >> 8] | n2];
    }

    private boolean zzRefill() throws IOException {
        int n;
        int n2;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] cArray = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((n2 = this.zzReader.read(this.zzBuffer, this.zzEndRead, n = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (n2 > 0) {
            this.zzEndRead += n2;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (n2 == n) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int n3 = this.zzReader.read();
                    if (n3 == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)n3;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public void yypushback(int n) {
        if (n > this.yylength()) {
            MIRJavaFlexLexer.zzScanError(2);
        }
        this.zzMarkedPos -= n;
    }

    @Override
    public int yylex() throws IOException {
        int n;
        int n2 = this.zzEndRead;
        char[] cArray = this.zzBuffer;
        int[] nArray = ZZ_TRANS;
        int[] nArray2 = ZZ_ROWMAP;
        int[] nArray3 = ZZ_ATTRIBUTE;
        do {
            int n3;
            int n4 = this.zzMarkedPos;
            int n5 = -1;
            this.zzCurrentPos = this.zzStartRead = n4;
            int n6 = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int n7 = nArray3[this.zzState];
            if ((n7 & 1) == 1) {
                n5 = this.zzState;
            }
            while (true) {
                if (n6 < n2) {
                    n = Character.codePointAt(cArray, n6, n2);
                    n6 += Character.charCount(n);
                } else {
                    if (this.zzAtEOF) {
                        n = -1;
                        break;
                    }
                    this.zzCurrentPos = n6;
                    this.zzMarkedPos = n4;
                    n3 = this.zzRefill() ? 1 : 0;
                    n6 = this.zzCurrentPos;
                    n4 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n2 = this.zzEndRead;
                    if (n3 != 0) {
                        n = -1;
                        break;
                    }
                    n = Character.codePointAt(cArray, n6, n2);
                    n6 += Character.charCount(n);
                }
                n3 = nArray[nArray2[this.zzState] + MIRJavaFlexLexer.zzCMap(n)];
                if (n3 == -1) break;
                this.zzState = n3;
                n7 = nArray3[this.zzState];
                if ((n7 & 1) != 1) continue;
                n5 = this.zzState;
                n4 = n6;
                if ((n7 & 8) == 8) break;
            }
            this.zzMarkedPos = n4;
            for (n3 = this.zzStartRead; n3 < this.zzMarkedPos; ++n3) {
                if (this.zzBuffer[n3] != '\n') continue;
                ++this.yylineno;
            }
            if (n == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            switch (n5 < 0 ? n5 : ZZ_ACTION[n5]) {
                case 1: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                }
                case 30: {
                    break;
                }
                case 2: {
                    this.originalText.append(this.matchText());
                    this.text.append(this.matchText());
                }
                case 31: {
                    break;
                }
                case 3: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    if (this.options.supportPseudoBacktickName()) {
                        return 258;
                    }
                }
                case 32: {
                    break;
                }
                case 4: {
                    this.text.empty();
                    this.originalText.set(this.matchText());
                    return 256;
                }
                case 33: {
                    break;
                }
                case 5: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 258;
                }
                case 34: {
                    break;
                }
                case 6: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    if (this.matchLength() == 1) {
                        return this.matchAt(0);
                    }
                    return 259;
                }
                case 35: {
                    break;
                }
                case 7: {
                    this.yy_push_state(8);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 36: {
                    break;
                }
                case 8: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return this.matchAt(0);
                }
                case 37: {
                    break;
                }
                case 9: {
                    this.yy_push_state(4);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 38: {
                    break;
                }
                case 10: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 263;
                }
                case 39: {
                    break;
                }
                case 11: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 261;
                }
                case 40: {
                    break;
                }
                case 12: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 265;
                }
                case 41: {
                    break;
                }
                case 13: {
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    if (this.options.supportPseudoBacktickName()) {
                        return this.matchAt(0);
                    }
                }
                case 42: {
                    break;
                }
                case 14: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    if (this.options.supportPseudoBacktickName()) {
                        this.text.empty();
                        return 256;
                    }
                    return 270;
                }
                case 43: {
                    break;
                }
                case 15: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 270;
                }
                case 44: {
                    break;
                }
                case 16: {
                    this.originalText.append(this.matchText());
                }
                case 45: {
                    break;
                }
                case 17: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 267;
                }
                case 46: {
                    break;
                }
                case 18: {
                    this.yy_pop_state();
                    this.rescan();
                    return 258;
                }
                case 47: {
                    break;
                }
                case 19: {
                    this.yy_pop_state();
                    this.text.append(this.matchText());
                    this.originalText.append(this.matchText());
                    return 258;
                }
                case 48: {
                    break;
                }
                case 20: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 262;
                }
                case 49: {
                    break;
                }
                case 21: {
                    this.yy_push_state(18);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 50: {
                    break;
                }
                case 22: {
                    this.yy_push_state(22);
                    this.text.empty();
                    this.originalText.set(this.matchText());
                }
                case 51: {
                    break;
                }
                case 23: {
                    if (this.options.supportEscapeStringConstants()) {
                        this.yy_push_state(6);
                        this.text.empty();
                        this.originalText.set(this.matchText());
                        break;
                    }
                    this.text.set("'");
                    this.rescan(this.text);
                    this.text.set(this.text.substring(0, 1));
                    return 258;
                }
                case 52: {
                    break;
                }
                case 24: {
                    this.text.append(this.matchText(), 1);
                    this.originalText.append(this.matchText());
                }
                case 53: {
                    break;
                }
                case 25: {
                    this.originalText.append(this.matchText());
                    if (!this.options.supportBackslashEscaping()) {
                        this.yy_pop_state();
                        this.text.append(this.matchText(), 1);
                        return 265;
                    }
                    this.text.append(this.matchText());
                }
                case 54: {
                    break;
                }
                case 26: {
                    this.yy_pop_state();
                    this.originalText.append(this.matchText());
                    return 267;
                }
                case 55: {
                    break;
                }
                case 27: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 264;
                }
                case 56: {
                    break;
                }
                case 28: {
                    this.text.set(this.matchText());
                    this.originalText.set(this.matchText());
                    return 269;
                }
                case 57: {
                    break;
                }
                case 29: {
                    this.zzMarkedPos = Character.offsetByCodePoints(cArray, this.zzStartRead, this.zzEndRead - this.zzStartRead, this.zzStartRead, 2);
                    if (this.options.supportNestedStarComments()) {
                        this.yy_push_state(18);
                        break;
                    }
                    this.originalText.append(this.matchText());
                    this.correct_yylineno();
                }
                case 58: {
                    break;
                }
                default: {
                    MIRJavaFlexLexer.zzScanError(1);
                }
            }
        } while (n != -1);
        return -1;
    }
}

