/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.engine;

import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.engine.MIRParserError;
import MITI.expression.analyzer.engine.MIRParserFlags;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.engine.MIRToken;
import MITI.expression.analyzer.lexer.MIRFlexLexer;
import MITI.expression.analyzer.parser.MIRBisonParser;
import MITI.expression.analyzer.rules.MIRRuleEngine;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;
import java.util.List;

public class MIRParser {
    private final MIRParserOptions options;
    private final MIRParserFlags flags;
    private final MIRBisonParser parser;
    private final MIRFlexLexer lexer;
    private final MIRRuleEngine rules;
    private final ArrayList<MIRParserError> errors = new ArrayList();

    public MIRParser(MIRExpressionAnalyzer mIRExpressionAnalyzer) {
        this.options = new MIRParserOptions(mIRExpressionAnalyzer.getParserType(), mIRExpressionAnalyzer.getDatabaseType());
        this.options.supportDoubleQuoteString = mIRExpressionAnalyzer.supportDoubleQuoteStrings();
        this.options.isOperation = mIRExpressionAnalyzer.isOperation();
        this.flags = new MIRParserFlags();
        this.lexer = MIRFlexLexer.createLexer(this.options);
        if (mIRExpressionAnalyzer.getDatabaseType() == 6) {
            this.parser = MIRBisonParser.createMdxParser(this, mIRExpressionAnalyzer.getRecoverFromSyntaxErrors());
            this.rules = MIRRuleEngine.createMdxRuleEngine(this);
        } else {
            this.parser = MIRBisonParser.createGenericParser(this, mIRExpressionAnalyzer.getRecoverFromSyntaxErrors());
            this.rules = MIRRuleEngine.createGenericRuleEngine(this);
        }
    }

    public void reset(int n, int n2) {
        if (this.options.getLangType() != n2) {
            this.options.setLangType(n2);
            this.rules.init(true);
            this.flags.reset();
        }
    }

    public MIRParserOptions getOptions() {
        return this.options;
    }

    public MIRParserFlags getFlags() {
        return this.flags;
    }

    public MIRExpression parse(String string) {
        if (string.isEmpty()) {
            return null;
        }
        this.lexer.init(string);
        this.parser.init();
        this.rules.init(false);
        this.errors.clear();
        MIRExpression mIRExpression = this.parser.parseExpression();
        this.flags.reset();
        return mIRExpression;
    }

    public String getComments() {
        return this.lexer.getComments();
    }

    public List<String> getExtraOptions() {
        return this.lexer.getExtraOptions();
    }

    public void addParsingError(String string, String string2, String string3) {
        this.errors.add(new MIRParserError(string, string2, string3));
    }

    public void removeLastError() {
        if (!this.errors.isEmpty()) {
            this.errors.remove(this.errors.size() - 1);
        }
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public MIRParserError getError(int n) {
        return this.errors.get(n);
    }

    public MIRToken getBisonToken() {
        return this.rules.getNextToken();
    }

    public MIRToken getFlexToken() {
        return this.lexer.readFlexToken();
    }

    public void unput(MIRToken mIRToken) {
        this.rules.unput(mIRToken);
    }

    public int[] getStatementNodeLocation(MIRStatementNode mIRStatementNode) {
        return this.parser.getStatementNodeLocation(mIRStatementNode);
    }
}

