/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.decoration;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.parser.MIRParserHelper;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class MIRVariables {
    private MIRParserOptions options = null;
    private Stack<Variables> stack = new Stack();

    public MIRVariables(MIRParserOptions mIRParserOptions) {
        this.options = mIRParserOptions;
        this.stack.add(new Variables(null));
    }

    public MIRParserOptions getOptions() {
        return this.options;
    }

    public void pushStatement(MIRStatementNode mIRStatementNode) {
        this.stack.add(new Variables(mIRStatementNode));
    }

    public void popStatement() {
        int n = this.stack.size() - 1;
        if (n >= 0) {
            Variables variables = (Variables)this.stack.remove(n);
            if (n >= 1) {
                Variables variables2 = (Variables)this.stack.lastElement();
                variables2.addAll(variables);
            }
        }
    }

    public void pushBranch(boolean bl) {
        Variables variables;
        if (!this.stack.isEmpty() && (variables = (Variables)this.stack.lastElement()).getStatementType() == 19) {
            variables.branchCount++;
            Variables variables2 = variables;
            variables2.hasDefault = variables2.hasDefault | bl;
        }
        this.stack.add(new Variables(null));
    }

    public void popBranch() {
        this.popStatement();
    }

    public void declareArgument(MIRElementNode mIRElementNode, String string) {
        this.declare(mIRElementNode, false);
        String[] stringArray = MIRVariables.getVariableName(mIRElementNode);
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        this.declare(mIRElementNode, stringArray2);
    }

    public boolean handle(MIRElementNode mIRElementNode) {
        Object object;
        byte by = mIRElementNode.getKind();
        short s = mIRElementNode.getDestinationElementType();
        int n = ((Variables)this.stack.lastElement()).getStatementType();
        if (by == 0 || s == 24) {
            this.declare(mIRElementNode, false);
            return true;
        }
        if (by == 2) {
            if (s == 75) {
                if (n == 8 || n == 3 || n == 1) {
                    if (n == 1 || this.get(mIRElementNode) == null || (object = mIRElementNode.getRightOfOperatorNode()) != null && "AS".equals(((MIRObject)object).getName())) {
                        this.declare(mIRElementNode, true);
                        return false;
                    }
                } else if (n == 15 && this.set(mIRElementNode)) {
                    return true;
                }
            } else if (!(s != 77 && s != 0 || n != 0 && n != 1 && n != 15)) {
                if (this.options.supportSetVarDecl() && n == 15) {
                    this.declare(mIRElementNode, false);
                    return true;
                }
                object = mIRElementNode.getParent();
                if (((MIRObject)object).getElementType() == 115 && (((MIRObject)object).getName().equals("=") || ((MIRObject)object).getName().equals(":="))) {
                    if (this.set(mIRElementNode)) {
                        return true;
                    }
                } else if ((this.options.getLangType() == 4 || this.options.getLangType() == 20) && n == 1) {
                    this.declare(mIRElementNode, true);
                    return false;
                }
            }
        } else if (!(by != 3 || s != 75 || mIRElementNode.getName().isEmpty() || n != 8 && n != 3 && n != 1 || this.get(mIRElementNode) != null)) {
            this.declare(mIRElementNode, true);
            return false;
        }
        return (object = this.use(mIRElementNode)) != null && !((Variable)object).alias;
    }

    public MIRElementNode get(MIRObject mIRObject) {
        Variable variable = this.get(mIRObject, false);
        if (variable != null) {
            return (MIRElementNode)variable.nodes.get(0);
        }
        return null;
    }

    private Variable get(MIRObject mIRObject, boolean bl) {
        short s = mIRObject instanceof MIRElementNode ? ((MIRElementNode)mIRObject).getDestinationElementType() : (mIRObject instanceof MIRElementNamePart ? ((MIRElementNamePart)mIRObject).getSourceElementType() : (mIRObject instanceof MIROperationNode ? (short)23 : (short)mIRObject.getElementType()));
        return this.get(MIRVariables.getVariableName(mIRObject), s, bl);
    }

    private Variable get(String[] stringArray, short s, boolean bl) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Variables variables = (Variables)this.stack.get(i);
            Variable variable = variables.get(stringArray, s, bl);
            if (variable == null) continue;
            return variable;
        }
        return null;
    }

    private void declare(MIRElementNode mIRElementNode, boolean bl) {
        Variables variables = this.getHash();
        if (variables != null) {
            Variable variable = variables.add(mIRElementNode, true);
            variable.alias = bl;
        }
    }

    private void declare(MIRElementNode mIRElementNode, String[] stringArray) {
        Variables variables = this.getHash();
        if (variables != null) {
            Variable variable = variables.add(mIRElementNode, stringArray);
            variable.alias = false;
        }
    }

    public boolean declareGlobal(MIRElementNode mIRElementNode) {
        if (!this.stack.isEmpty()) {
            Variable variable = ((Variables)this.stack.get(0)).add(mIRElementNode, true);
            variable.alias = false;
            return true;
        }
        return false;
    }

    private Variables getHash() {
        int n;
        Variables variables = null;
        for (n = this.stack.size() - 1; n > 0 && ((variables = (Variables)this.stack.get(n)).getStatementType() == 12 || !this.options.supportVariableBlockScope() && variables.getStatementType() == 7 || this.options.supportSetVarDecl() && variables.getStatementType() == 15); --n) {
        }
        variables = (Variables)this.stack.get(n);
        return variables;
    }

    private boolean set(MIRElementNode mIRElementNode) {
        Variable variable;
        Variables variables = null;
        int n = this.stack.size() - 2;
        if (n >= 0) {
            variables = (Variables)this.stack.get(n);
        }
        if (variables != null && (variable = this.get(mIRElementNode, true)) != null && !variable.alias) {
            Variable variable2 = variables.add(mIRElementNode, false);
            if (variable2.type == 0) {
                variable2.type = variable.type;
            }
            if (variable.type == 24 && (variable.kind == 2 || variable.kind == 3)) {
                for (MIRElementNode mIRElementNode2 : variable.nodes) {
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                    if (mIRElementNamePart.containsReferencedElement(mIRElementNode2)) continue;
                    mIRElementNamePart.addReferencedElement(mIRElementNode2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean use(MIROperationNode mIROperationNode) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Variables variables = (Variables)this.stack.get(i);
            if (!variables.set(mIROperationNode)) continue;
            return true;
        }
        return false;
    }

    private Variable use(MIRElementNode mIRElementNode) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Variables variables = (Variables)this.stack.get(i);
            Variable variable = variables.set(mIRElementNode);
            if (variable == null || !variable.complete) continue;
            return variable;
        }
        return null;
    }

    private static String[] getVariableName(MIRObject mIRObject) {
        if (mIRObject == null) {
            return null;
        }
        List<MIRElementNamePart> list = null;
        if (mIRObject instanceof MIRElementNode) {
            list = ((MIRElementNode)mIRObject).getElementNamePartByPosition();
        } else if (mIRObject instanceof MIROperation) {
            list = ((MIROperationNode)mIRObject).getElementNamePartByPosition();
        } else {
            return new String[]{mIRObject.getName()};
        }
        String[] stringArray = new String[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i).getName();
        }
        return stringArray;
    }

    private class Variable
    extends VariableName {
        private short type;
        private short kind;
        private boolean declare;
        private boolean alias;
        private boolean complete;
        private ArrayList<MIRElementNode> nodes;

        Variable(MIRElementNode mIRElementNode, boolean bl) {
            super(MIRVariables.getVariableName(mIRElementNode));
            this.nodes = new ArrayList();
            this.type = mIRElementNode.getDestinationElementType();
            this.kind = mIRElementNode.getKind();
            this.declare = bl;
            this.complete = true;
            this.nodes.add(mIRElementNode);
        }

        Variable(MIRElementNode mIRElementNode, String[] stringArray) {
            super(stringArray);
            this.nodes = new ArrayList();
            this.type = mIRElementNode.getDestinationElementType();
            this.kind = mIRElementNode.getKind();
            this.declare = true;
            this.complete = true;
            this.nodes.add(mIRElementNode);
        }

        public void add(Variable variable) {
            this.complete &= variable.complete;
            this.nodes.addAll(variable.nodes);
        }

        public boolean isDeclared() {
            return this.declare;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean checkCompatible(short s) {
            return s == 0 || this.type == 0 || this.type == s || this.type == 23 && s == 75 || this.type == 75 && s == 23 || this.type == 24 && (s == 77 || s == 75);
        }

        public ArrayList<MIRElementNode> getValues() {
            return this.nodes;
        }
    }

    private class VariableName {
        private String[] name;

        VariableName(String[] stringArray) {
            this.name = stringArray;
        }

        public int hashCode() {
            int n = 1;
            for (String string : this.name) {
                n = 31 * n + string.toUpperCase().hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VariableName)) {
                return false;
            }
            VariableName variableName = (VariableName)object;
            if (this.name.length != variableName.name.length) {
                return false;
            }
            for (int i = 0; i < this.name.length && i < variableName.name.length; ++i) {
                if (MIRVariables.this.options.compareNames(this.name[i], false, variableName.name[i], false)) continue;
                return false;
            }
            return true;
        }
    }

    private class Variables {
        private MIRStatementNode stmt = null;
        private int branchCount = 0;
        private boolean hasDefault = false;
        private HashMap<VariableName, Variable> vars = new HashMap();

        Variables(MIRStatementNode mIRStatementNode) {
            this.stmt = mIRStatementNode;
        }

        int getStatementType() {
            if (this.stmt != null) {
                return this.stmt.getStatementType();
            }
            return -1;
        }

        void addAll(Variables variables) {
            if (this.getStatementType() == 6 || this.getStatementType() == 21 || this.getStatementType() == 32) {
                for (Variable variable : variables.vars.values()) {
                    if (variable.alias) continue;
                    this.vars.put(variable, variable);
                }
            } else {
                for (Variable variable : variables.vars.values()) {
                    if (variable.isDeclared()) continue;
                    Variable variable2 = this.vars.get(variable);
                    if (variables.getStatementType() == 19) {
                        Variable variable3 = variable;
                        variable3.complete = variable3.complete & (variables.hasDefault && variable.nodes.size() == variables.branchCount);
                    }
                    if (variable2 == null) {
                        this.vars.put(variable, variable);
                        continue;
                    }
                    if (variable.isComplete() && this.getStatementType() != 19) {
                        variable2.nodes.clear();
                    }
                    variable2.add(variable);
                }
            }
        }

        Variable get(String[] stringArray, short s, boolean bl) {
            Variable variable = this.vars.get(new VariableName(stringArray));
            if (variable != null && variable.checkCompatible(s) && (!bl || variable.isDeclared())) {
                return variable;
            }
            return null;
        }

        Variable add(MIRElementNode mIRElementNode, boolean bl) {
            Variable variable;
            Variable variable2 = new Variable(mIRElementNode, bl);
            if (!bl && (variable = this.vars.get(variable2)) != null && variable.declare) {
                variable2.declare = variable.declare;
                variable2.type = variable.type;
                variable2.alias = variable.alias;
            }
            this.vars.put(variable2, variable2);
            return variable2;
        }

        Variable add(MIRElementNode mIRElementNode, String[] stringArray) {
            Variable variable = new Variable(mIRElementNode, stringArray);
            this.vars.put(variable, variable);
            return variable;
        }

        Variable set(MIRElementNode mIRElementNode) {
            String[] stringArray = MIRVariables.getVariableName(mIRElementNode);
            Variable variable = this.get(stringArray, mIRElementNode.getDestinationElementType(), false);
            if (variable != null) {
                MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                short s = mIRElementNode.getDestinationElementType();
                for (MIRElementNode mIRElementNode2 : variable.getValues()) {
                    if (mIRElementNode.getKind() == 2 && (mIRElementNode2.getKind() == 1 || variable.alias)) continue;
                    if (mIRElementNode2.getQueryNode() != null) {
                        if (mIRElementNamePart.containsReferencedElement(mIRElementNode2.getQueryNode())) continue;
                        mIRElementNamePart.addReferencedElement(mIRElementNode2.getQueryNode());
                        continue;
                    }
                    if (mIRElementNamePart.containsReferencedElement(mIRElementNode2)) continue;
                    mIRElementNamePart.addReferencedElement(mIRElementNode2);
                    s = mIRElementNode2.getDestinationElementType();
                }
                if (mIRElementNode.getKind() == 2) {
                    if (mIRElementNode.getDestinationElementType() == 0) {
                        MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, s);
                    }
                    this.add(mIRElementNode, false);
                }
                return variable;
            }
            while (stringArray.length > 1) {
                MIRElementNode mIRElementNode3;
                Variable variable2 = this.get(stringArray = Arrays.copyOf(stringArray, stringArray.length - 1), (short)0, false);
                if (variable2 == null || (mIRElementNode3 = variable2.getValues().get(0)) == null) continue;
                MIRElementNamePart mIRElementNamePart = mIRElementNode.getElementNamePartByPosition().get(stringArray.length - 1);
                if (!mIRElementNamePart.containsReferencedElement(mIRElementNode3)) {
                    mIRElementNamePart.addReferencedElement(mIRElementNode3);
                }
                return variable2;
            }
            return null;
        }

        boolean set(MIROperationNode mIROperationNode) {
            Variable variable = this.get(MIRVariables.getVariableName(mIROperationNode), (short)0, false);
            if (variable != null) {
                for (MIRElementNode mIRElementNode : variable.getValues()) {
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIROperationNode);
                    if (mIRElementNode.getQueryNode() != null) {
                        if (mIRElementNamePart.containsReferencedElement(mIRElementNode.getQueryNode())) continue;
                        mIRElementNamePart.addReferencedElement(mIRElementNode.getQueryNode());
                        continue;
                    }
                    if (mIRElementNamePart.containsReferencedElement(mIRElementNode)) continue;
                    mIRElementNamePart.addReferencedElement(mIRElementNode);
                }
                return variable.complete;
            }
            return false;
        }
    }
}

