/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.decoration;

import MITI.expression.analyzer.decoration.MIRDecor;
import MITI.expression.analyzer.decoration.MIRDecors;
import MITI.expression.analyzer.decoration.MIRFeatureMapBuilder;
import MITI.expression.converter.MIRRefExpressionPrinter;
import MITI.expression.traversal.ReferenceTraversal;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;

public class MIRStatementOutput {
    private final String name;
    private final boolean isQuoted;
    private final boolean hasStar;
    final ArrayList<MIRExpressionNode> features = new ArrayList();

    public MIRStatementOutput(String string, boolean bl, boolean bl2) {
        this.name = string;
        this.isQuoted = bl;
        this.hasStar = bl2;
    }

    public MIRStatementOutput(MIRExpressionNode mIRExpressionNode) {
        this(mIRExpressionNode, null);
    }

    public MIRStatementOutput(MIRExpressionNode mIRExpressionNode, MIRDecors mIRDecors) {
        MIRExpressionNode mIRExpressionNode2 = this.getOutputNode(mIRExpressionNode);
        if (mIRExpressionNode2.getElementType() == 111) {
            MIRElementNode mIRElementNode = (MIRElementNode)mIRExpressionNode2;
            MIRElementNamePart mIRElementNamePart = mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
            this.name = mIRElementNamePart.getName();
            this.isQuoted = mIRElementNamePart.getQuoted();
            this.hasStar = this.initHasStar(mIRElementNode);
        } else {
            this.name = this.getOutputNodeName(mIRExpressionNode2, mIRDecors);
            this.isQuoted = false;
            this.hasStar = false;
        }
        this.features.add(mIRExpressionNode2);
    }

    private boolean initHasStar(MIRElementNode mIRElementNode) {
        MIRElementNamePart mIRElementNamePart = mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
        if (mIRElementNamePart.getReferencedElementCount() == 0) {
            return "*".equals(mIRElementNamePart.getName());
        }
        boolean bl = mIRElementNamePart.getReferencedElementCount() > 0;
        for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
            if (mIRElement instanceof MIRFeature) {
                return ((MIRFeature)mIRElement).hasLineageOption(256);
            }
            if (mIRElement instanceof MIRElementNode) {
                bl = bl && "*".equals(mIRElementNamePart.getName());
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public MIRStatementOutput(MIRStatementOutput mIRStatementOutput) {
        this.name = mIRStatementOutput.name;
        this.isQuoted = mIRStatementOutput.isQuoted;
        this.hasStar = mIRStatementOutput.hasStar;
        this.add(mIRStatementOutput);
    }

    public String getName() {
        return this.name;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public boolean hasStar() {
        return this.hasStar;
    }

    public void add(MIRStatementOutput mIRStatementOutput) {
        this.features.addAll(mIRStatementOutput.features);
    }

    public void qualifyFeature(MIRElementNamePart mIRElementNamePart) {
        for (MIRExpressionNode mIRExpressionNode : this.features) {
            if (mIRElementNamePart.containsReferencedElement(mIRExpressionNode)) continue;
            mIRElementNamePart.addReferencedElement(mIRExpressionNode);
        }
    }

    public void buildFeatureMap(MIRDecors mIRDecors, MIRFeatureMap mIRFeatureMap, boolean bl, boolean bl2, boolean bl3) {
        MIRStatementNode mIRStatementNode;
        MIRFeature mIRFeature = mIRFeatureMap.getDestinationFeature();
        MIRExpression mIRExpression = mIRFeatureMap.getExpression();
        if (mIRExpression == null) {
            mIRExpression = new MIRExpression();
            mIRStatementNode = new MIRStatementNode();
            mIRStatementNode.setStatementType(4);
            mIRExpression.addStatementNode(mIRStatementNode);
            mIRFeatureMap.addExpression(mIRExpression);
        }
        mIRStatementNode = mIRExpression.getStatementNodes().first();
        for (MIRExpressionNode object : this.features) {
            MIRExpressionNode mIRExpressionNode = this.getOutputNode(object);
            if (mIRExpressionNode.getElementType() == 111) {
                if (((MIRElementNode)mIRExpressionNode).getElement() != null) continue;
                ((MIRElementNode)mIRExpressionNode).addElement(mIRFeature);
            }
            MIRFeatureMapBuilder mIRFeatureMapBuilder = new MIRFeatureMapBuilder(mIRDecors, mIRFeatureMap, bl2, bl3);
            mIRFeatureMapBuilder.traverseExpression(object);
            mIRStatementNode.addReferencedExpressionNode(object);
        }
        if (mIRFeatureMap.getClassifierMap().getExpression().getStatementNodeCount() == 1 && (bl || mIRFeatureMap.getSourceFeatureCount() + mIRFeatureMap.getControlFeatureCount() > 0)) {
            MIRRefExpressionPrinter mIRRefExpressionPrinter = new MIRRefExpressionPrinter(bl);
            String string = mIRRefExpressionPrinter.convertExpression(mIRFeatureMap);
            if (!mIRRefExpressionPrinter.isSimple()) {
                mIRFeatureMap.setOperation(string);
            }
        }
        boolean bl4 = mIRFeatureMap.getDestinationFeature().hasLineageOption(256);
        for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
            if (!mIRFeature2.hasLineageOption(256)) continue;
            bl4 = true;
            break;
        }
        mIRFeatureMap.setBulk(bl4);
    }

    private MIRExpressionNode getOutputNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode.getElementType() == 118) {
            return this.getOutputNode(((MIRPredicateNode)mIRExpressionNode).getExpressionNode());
        }
        if (mIRExpressionNode.getElementType() == 115 && mIRExpressionNode.getName().equals("AS")) {
            return this.getOutputNode(((MIROperatorNode)mIRExpressionNode).getRightExpressionNode());
        }
        if (mIRExpressionNode.getElementType() == 115 && mIRExpressionNode.getName().equals("=")) {
            return this.getOutputNode(((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode());
        }
        return mIRExpressionNode;
    }

    private String getOutputNodeName(MIRExpressionNode mIRExpressionNode, MIRDecors mIRDecors) {
        if (mIRExpressionNode.getElementType() == 115 && mIRExpressionNode.getName().equals("OVER")) {
            return ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode().getName();
        }
        if (mIRExpressionNode.getElementType() == 134) {
            MIRDecor mIRDecor;
            if (mIRDecors != null && (mIRDecor = mIRDecors.getDecor(mIRExpressionNode)) != null && mIRDecor.getStatementDecor().getOutputCount() == 1) {
                return mIRDecor.getStatementDecor().getOutput(0).getName();
            }
            return "";
        }
        return mIRExpressionNode.getName();
    }

    public void setDataType(String string) {
        for (MIRExpressionNode mIRExpressionNode : this.features) {
            if (!mIRExpressionNode.getDataType().isEmpty()) continue;
            mIRExpressionNode.setDataType(string);
        }
    }

    public void resolveReferences(MIRDecors mIRDecors) {
        for (MIRExpressionNode mIRExpressionNode : this.features) {
            ReferenceTraversal.traverse(mIRExpressionNode, mIRDecors);
        }
    }
}

