/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.decoration;

import MITI.MIRException;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.decoration.MIRConditionalMapScanner;
import MITI.expression.analyzer.decoration.MIRDecor;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.decoration.MIRDecors;
import MITI.expression.analyzer.decoration.MIRExpressionTraversal;
import MITI.expression.analyzer.decoration.MIRFeatureMapBuilder;
import MITI.expression.analyzer.decoration.MIRStatementDecor;
import MITI.expression.analyzer.decoration.MIRStatementOutput;
import MITI.expression.analyzer.decoration.MIRVariables;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.parser.MIRParserHelper;
import MITI.expression.converter.MIRExpressionConverter;
import MITI.expression.converter.MIRRefExpressionPrinter;
import MITI.expression.datatypes.MIRExpressionDataType;
import MITI.expression.datatypes.MIRExpressionDataTypeInfo;
import MITI.expression.functions.FunctionImplementation;
import MITI.expression.traversal.Operation;
import MITI.expression.traversal.ReferenceTraversal;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;

public class MIRDecoration {
    MIRExpressionAnalyzer analyzer;
    MIRVariables variables;
    MIRParserOptions options;
    MIRDecors decors = new MIRDecors();
    List<MIROperationNode> operations = new LinkedList<MIROperationNode>();

    public MIRDecoration(MIRParserOptions mIRParserOptions, MIRExpressionAnalyzer mIRExpressionAnalyzer) {
        this.analyzer = mIRExpressionAnalyzer;
        this.variables = new MIRVariables(mIRParserOptions);
        this.options = mIRParserOptions;
    }

    public void run(MIRExpression mIRExpression) throws MIRException {
        if (mIRExpression == null || mIRExpression.getStatementNodeCount() == 0) {
            return;
        }
        this.decorateExpression(mIRExpression, true, false, false);
        if (!this.analyzer.hasFailed()) {
            if (mIRExpression.getClassifierMap() != null) {
                if (this.analyzer.isMultiStatement()) {
                    for (MIRClassifierMap mIRClassifierMap : Operation.getCms(mIRExpression, true)) {
                        this.processClassifierMap(mIRClassifierMap);
                    }
                    this.processOperationClassifierMap(mIRExpression.getClassifierMap());
                    if (this.analyzer.isMultiStatementQuery()) {
                        this.processQueryClassifierMap(mIRExpression.getClassifierMap());
                    }
                } else {
                    this.processClassifierMap(mIRExpression.getClassifierMap());
                }
            } else if (mIRExpression.getFeatureMap() != null) {
                new MIRFeatureMapBuilder(this.decors, mIRExpression.getFeatureMap(), this.analyzer.supportFunctionCalls()).traverseExpression(mIRExpression);
            }
            this.processOperations();
        }
    }

    private void processOperations() {
        if (!this.analyzer.supportFunctionCalls()) {
            return;
        }
        for (MIROperationNode mIROperationNode : this.operations) {
            MIRDataSet mIRDataSet;
            MIRElement mIRElement;
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIROperationNode);
            if (mIRElementNamePart.getReferencedElementCount() == 0 || !((mIRElement = mIRElementNamePart.getReferencedElementIterator().next()) instanceof MIRStoredProcedure) || (mIRDataSet = ((MIRStoredProcedure)mIRElement).getParametersDataSet()) == null) continue;
            MIRClassifierMap mIRClassifierMap = mIRDataSet.getClassifierMap();
            if (mIRClassifierMap == null) {
                mIRClassifierMap = new MIRClassifierMap();
                mIRClassifierMap.addDestinationClassifier(mIRDataSet);
                mIRDataSet.addClassifierMap(mIRClassifierMap);
            }
            for (MIRExpressionNode mIRExpressionNode : mIROperationNode.getExpressionNodeByPosition()) {
                MIRElementNode mIRElementNode;
                MIRElement mIRElement2;
                if (!(mIRExpressionNode instanceof MIROperatorNode) || !((mIRElement2 = MIRDecorUtil.getLastReference(mIRElementNode = (MIRElementNode)((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode())) instanceof MIRFeature)) continue;
                MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                mIRFeatureMap.addDestinationFeature((MIRFeature)mIRElement2);
                mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                new MIRFeatureMapBuilder(this.decors, mIRFeatureMap, this.analyzer.supportFunctionCalls()).traverseExpression(((MIROperatorNode)mIRExpressionNode).getRightExpressionNode());
            }
        }
    }

    private void processQueryClassifierMap(MIRClassifierMap mIRClassifierMap) throws MIRException {
        for (MIRStatementNode mIRStatementNode : mIRClassifierMap.getExpression().getStatementNodeByPosition()) {
            if (mIRStatementNode.getStatementType() != 1 && mIRStatementNode.getStatementType() != 6) continue;
            MIRDecor mIRDecor = this.getDecor(mIRStatementNode);
            MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
            mIRStatementNode = mIRStatementDecor.getOutputStatement();
            this.processStatement(mIRStatementNode, mIRClassifierMap);
        }
    }

    private void processOperationClassifierMap(MIRClassifierMap mIRClassifierMap) throws MIRException {
        MIRStatementNode mIRStatementNode = this.getOutputStatement(mIRClassifierMap.getExpression());
        MIRStatementDecor mIRStatementDecor = this.getDecor(mIRStatementNode).getStatementDecor();
        int n = mIRStatementDecor.getOutputCount();
        if (mIRStatementNode.getStatementType() == 36 && (mIRStatementNode.getExpressionNode("FUNCTION") != null || mIRStatementNode.getExpressionNode("PROCEDURE") != null)) {
            for (int i = 0; i < n; ++i) {
                MIRElement mIRElement2;
                MIRStatementOutput mIRStatementOutput = mIRStatementDecor.getOutput(i);
                MIRExpressionNode mIRExpressionNode = mIRStatementOutput.features.get(0);
                if (mIRExpressionNode.getElementType() != 111) continue;
                MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode);
                MIRFeature mIRFeature = null;
                for (MIRElement mIRElement2 : mIRElementNamePart.getReferencedElements()) {
                    if (!(mIRElement2 instanceof MIRFeature)) continue;
                    mIRFeature = (MIRFeature)mIRElement2;
                    break;
                }
                if (mIRFeature == null && (mIRFeature = this.analyzer.getDstFeature(mIRClassifierMap.getDestinationClassifier(), this.computeOptions(mIRStatementDecor, i, i + 1))) != null && ((MIRElementNode)mIRExpressionNode).getElement() == null) {
                    ((MIRElementNode)mIRExpressionNode).addElement(mIRFeature);
                }
                if (mIRFeature == null || mIRFeature.getClassifier().getDestinationOfClassifierMap() == null) continue;
                MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                mIRFeatureMap.addDestinationFeature(mIRFeature);
                mIRFeature.getClassifier().getDestinationOfClassifierMap().addFeatureMap(mIRFeatureMap);
                mIRElement2 = new MIRExpression();
                MIRStatementNode mIRStatementNode2 = new MIRStatementNode();
                mIRStatementNode2.setStatementType(4);
                ((MIRExpression)mIRElement2).addStatementNode(mIRStatementNode2);
                mIRFeatureMap.addExpression((MIRExpression)mIRElement2);
                mIRExpressionNode.addReferencedByStatementNode(mIRStatementNode2);
                for (MIRElementNamePart mIRElementNamePart2 : mIRExpressionNode.getReferencedByElementNameParts()) {
                    MIRExpressionNode mIRExpressionNode2 = this.getReferenceForOperationParameter(mIRExpressionNode, mIRElementNamePart2);
                    ReferenceTraversal.traverse(mIRExpressionNode2, this.decors);
                    if (mIRExpressionNode2 != null) {
                        new MIRFeatureMapBuilder(this.decors, mIRFeatureMap, this.analyzer.supportFunctionCalls()).traverseExpression(mIRExpressionNode2);
                    }
                    MIRRefExpressionPrinter mIRRefExpressionPrinter = new MIRRefExpressionPrinter();
                    String string = mIRRefExpressionPrinter.convertExpression(mIRFeatureMap);
                    if (mIRRefExpressionPrinter.isSimple()) continue;
                    mIRFeatureMap.setOperation(string);
                }
                if (mIRFeatureMap.getSourceFeatureCount() != 0 || mIRFeatureMap.getControlFeatureCount() != 0 || !mIRFeatureMap.getOperation().isEmpty()) continue;
                mIRFeatureMap.delete();
            }
            MIRExpressionNode mIRExpressionNode = mIRStatementNode.getExpressionNode("AS");
            if (mIRExpressionNode != null && mIRExpressionNode.getElementType() == 134) {
                this.processStatement((MIRStatementNode)mIRExpressionNode, mIRClassifierMap);
            }
        }
    }

    private MIRExpressionNode getReferenceForOperationParameter(MIRExpressionNode mIRExpressionNode, MIRElementNamePart mIRElementNamePart) {
        MIRExpressionNode mIRExpressionNode2 = null;
        LinkedList<MIRElementNode> linkedList = new LinkedList<MIRElementNode>(Arrays.asList(mIRElementNamePart.getElementNode()));
        while (!linkedList.isEmpty()) {
            MIRElement mIRElement = (MIRElement)linkedList.remove(0);
            if (mIRElement instanceof MIRElementNode && ((MIRElementNode)mIRElement).getDestinationElementType() == 75) {
                MIRElementNamePart mIRElementNamePart2 = MIRDecorUtil.getLastPart((MIRElementNode)mIRElement);
                linkedList.addAll(mIRElementNamePart2.getReferencedElements());
                continue;
            }
            if (mIRElement == mIRExpressionNode || !(mIRElement instanceof MIRExpressionNode)) continue;
            mIRExpressionNode2 = (MIRExpressionNode)mIRElement;
            break;
        }
        return mIRExpressionNode2;
    }

    private MIRStatementNode getOutputStatement(MIRExpression mIRExpression) {
        MIRStatementNode mIRStatementNode = mIRExpression.getStatementNodeByPosition().get(mIRExpression.getStatementNodeCount() - 1);
        MIRDecor mIRDecor = this.getDecor(mIRStatementNode);
        MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
        return mIRStatementDecor.getOutputStatement();
    }

    private void processClassifierMap(MIRClassifierMap mIRClassifierMap) throws MIRException {
        MIRExpression mIRExpression = mIRClassifierMap.getExpression();
        if (mIRExpression == null) {
            return;
        }
        MIRStatementNode mIRStatementNode = this.getOutputStatement(mIRExpression);
        this.processStatement(mIRStatementNode, mIRClassifierMap);
    }

    private boolean hasCondition(Set<MIRStatementDecor> set) {
        HashSet<MIRStatementDecor> hashSet = new HashSet<MIRStatementDecor>();
        Iterator<MIRStatementDecor> iterator = set.iterator();
        while (iterator.hasNext()) {
            for (MIRStatementDecor mIRStatementDecor = iterator.next(); mIRStatementDecor != null && hashSet.add(mIRStatementDecor); mIRStatementDecor = mIRStatementDecor.getParent()) {
                if (!mIRStatementDecor.hasCondition) continue;
                return true;
            }
        }
        return false;
    }

    private void addSourceFeature(MIRFeatureMap mIRFeatureMap, MIRFeature mIRFeature) {
        if (mIRFeatureMap != null && mIRFeature != null && !mIRFeatureMap.containsSourceFeature(mIRFeature)) {
            mIRFeatureMap.addSourceFeature(mIRFeature);
            this.addSourceClassifier(mIRFeatureMap.getClassifierMap(), mIRFeature.getClassifier());
        }
    }

    private void addSourceClassifier(MIRClassifierMap mIRClassifierMap, MIRClassifier mIRClassifier) {
        if (mIRClassifierMap != null && mIRClassifier != null && !mIRClassifierMap.containsSourceClassifier(mIRClassifier)) {
            mIRClassifierMap.addSourceClassifier(mIRClassifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void processStatement(MIRStatementNode mIRStatementNode, MIRClassifierMap mIRClassifierMap) throws MIRException {
        ArrayList<MIRFeatureMap> arrayList;
        if (mIRClassifierMap == null || mIRClassifierMap.getDestinationClassifier() == null) {
            return;
        }
        MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        MIRStatementDecor mIRStatementDecor = this.getDecor(mIRStatementNode).getStatementDecor();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            Iterator iterator;
            Object object5;
            Object object6;
            void object7;
            int n = mIRStatementNode.getStatementType() == 32 ? 6 : 1;
            int n2 = mIRStatementDecor.getOutputCount();
            boolean i = false;
            while (object7 < n2) {
                object6 = mIRStatementDecor.getOutput((int)object7);
                object5 = this.computeOptions(mIRStatementDecor, (int)object7, n);
                if (((LookupOptions)object5).isPositionBased()) {
                    ++n;
                }
                if ((iterator = this.analyzer.getDstFeature(mIRClassifier, (LookupOptions)object5)) != null) {
                    object42 = ((MIRFeature)((Object)iterator)).getDestinationOfFeatureMap();
                    if (object42 != null && ((MIRFeatureMap)object42).getClassifierMap() != mIRClassifierMap) {
                        object42 = null;
                    }
                    ((MIRStatementOutput)object6).resolveReferences(this.decors);
                    if (object42 == null) {
                        object42 = new MIRFeatureMap();
                        ((MIRFeatureMap)object42).addDestinationFeature((MIRFeature)((Object)iterator));
                        ((MIRFeatureMap)object42).setPosition((short)object7);
                        mIRClassifierMap.addFeatureMap((MIRFeatureMap)object42);
                    }
                    ((MIRStatementOutput)object6).buildFeatureMap(this.decors, (MIRFeatureMap)object42, this.analyzer.captureConstantExpressions(), this.analyzer.supportFunctionCalls(), this.analyzer.supportRecursiveLinks());
                    object3 = ((MIRFeature)((Object)iterator)).getType();
                    if (object3 != null) {
                        object2 = MIRBaseTypeList.getLogicalName(((MIRType)object3).getDataType());
                        object = new MIRExpressionDataType(MIRExpressionDataTypeInfo.fromName((String)object2), ((MIRType)object3).getLength(), ((MIRType)object3).getScale());
                        ((MIRStatementOutput)object6).setDataType(((MIRExpressionDataType)object).serialize());
                    }
                }
                ++object7;
            }
            Set<MIRStatementDecor> set = mIRStatementDecor.getOutputStatementDecors();
            if (set.size() == 0) {
                set.add(mIRStatementDecor);
            }
            if (this.hasCondition(set)) {
                object6 = new LinkedList();
                object5 = new HashMap();
                for (Object object42 : set) {
                    if (this.analyzer.captureConditionExpressions()) {
                        object3 = new MIRConditionalMapScanner(this.decors, this.analyzer.supportFunctionCalls());
                        ((MIRExpressionTraversal)object3).traverseExpressionPath(((MIRStatementDecor)object42).getOutputStatement());
                        object2 = ((MIRConditionalMapScanner)object3).getConditions();
                        object5.putAll(((MIRConditionalMapScanner)object3).getConditionNames());
                        object = object2.iterator();
                        while (object.hasNext()) {
                            MIRExpressionNode mIRExpressionNode = (MIRExpressionNode)object.next();
                            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                            mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                            MIRFeatureMapBuilder mIRFeatureMapBuilder = new MIRFeatureMapBuilder(this.decors, mIRFeatureMap, this.analyzer.supportFunctionCalls());
                            mIRFeatureMapBuilder.traverseExpressionPath(mIRExpressionNode);
                            this.analyzer.buildReference(mIRFeatureMap, mIRExpressionNode);
                            object6.add(mIRFeatureMap);
                        }
                        continue;
                    }
                    if (object6.isEmpty()) {
                        object3 = new MIRFeatureMap();
                        mIRClassifierMap.addFeatureMap((MIRFeatureMap)object3);
                        object6.add(object3);
                    } else {
                        object3 = (MIRFeatureMap)object6.get(0);
                    }
                    object2 = new MIRFeatureMapBuilder(this.decors, (MIRFeatureMap)object3, this.analyzer.supportFunctionCalls());
                    ((MIRExpressionTraversal)object2).traverseExpressionPath(((MIRStatementDecor)object42).getOutputStatement());
                }
                iterator = object6.iterator();
                while (iterator.hasNext()) {
                    object42 = (MIRFeatureMap)iterator.next();
                    if (((MIRFeatureMap)object42).getExpression() != null) {
                        object3 = new MIRRefExpressionPrinter(true);
                        object2 = ((MIRExpressionConverter)object3).convertExpression((MIRFeatureMap)object42);
                        ((MIRFeatureMap)object42).setOperation((String)object2);
                    }
                    while (((MIRFeatureMap)object42).getControlFeatureCount() > 0) {
                        object3 = ((MIRFeatureMap)object42).getControlFeatures().first();
                        ((MIRFeatureMap)object42).removeControlFeature((MIRFeature)object3);
                        if (((MIRFeatureMap)object42).containsSourceFeature((MIRFeature)object3)) continue;
                        ((MIRFeatureMap)object42).addSourceFeature((MIRFeature)object3);
                    }
                    if (((MIRFeatureMap)object42).getSourceFeatureCount() == 0) continue;
                    object3 = null;
                    if (((MIRFeatureMap)object42).getExpression() != null) {
                        object2 = ((MIRFeatureMap)object42).getExpression().getStatementNodeByPosition().get(0).getReferencedExpressionNodeIterator().next();
                        object3 = (String)object5.get(object2);
                    }
                    if ((object2 = this.analyzer.getDstCondition(mIRClassifierMap.getDestinationClassifier(), (String)object3)) == null) continue;
                    if (((MIRFeature)object2).getDestinationOfFeatureMap() == null) {
                        ((MIRFeatureMap)object42).addDestinationFeature((MIRFeature)object2);
                        continue;
                    }
                    while (((MIRFeatureMap)object42).getSourceFeatureCount() > 0) {
                        object = ((MIRFeatureMap)object42).getSourceFeatures().first();
                        ((MIRFeatureMap)object42).removeSourceFeature((MIRFeature)object);
                        if (((MIRFeature)object2).getDestinationOfFeatureMap().containsSourceFeature((MIRFeature)object)) continue;
                        this.addSourceFeature(((MIRFeature)object2).getDestinationOfFeatureMap(), (MIRFeature)object);
                    }
                }
            }
            arrayList = new ArrayList<MIRFeatureMap>();
        }
        catch (Throwable throwable) {
            ArrayList<MIRFeatureMap> arrayList2 = new ArrayList<MIRFeatureMap>();
            for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps()) {
                if (mIRFeatureMap.getDestinationFeature() != null && (mIRFeatureMap.getSourceFeatureCount() != 0 || mIRFeatureMap.getControlFeatureCount() != 0 || !mIRFeatureMap.getOperation().isEmpty())) continue;
                arrayList2.add(mIRFeatureMap);
            }
            for (MIRFeatureMap mIRFeatureMap : arrayList2) {
                mIRFeatureMap.delete();
            }
            throw throwable;
        }
        for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps()) {
            if (mIRFeatureMap.getDestinationFeature() != null && (mIRFeatureMap.getSourceFeatureCount() != 0 || mIRFeatureMap.getControlFeatureCount() != 0 || !mIRFeatureMap.getOperation().isEmpty())) continue;
            arrayList.add(mIRFeatureMap);
        }
        for (MIRFeatureMap mIRFeatureMap : arrayList) {
            mIRFeatureMap.delete();
        }
    }

    private void decorateExpression(MIRExpression mIRExpression, boolean bl, boolean bl2, boolean bl3) {
        for (MIRStatementNode mIRStatementNode : mIRExpression.getStatementNodeByPosition()) {
            this.decorateExpressionNode(mIRStatementNode, new ExpressionNodeArguments(bl, bl2, bl3, 0));
        }
    }

    private void decorateExpressionNode(MIRExpressionNode mIRExpressionNode, ExpressionNodeArguments expressionNodeArguments) {
        if (mIRExpressionNode == null || this.decors.hasDecor(mIRExpressionNode) || this.analyzer.hasFailed()) {
            return;
        }
        this.getDecor(mIRExpressionNode, expressionNodeArguments.isData, expressionNodeArguments.isCondition);
        switch (mIRExpressionNode.getElementType()) {
            case 103: {
                this.decorateBranchingNode((MIRBranchingNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 104: {
                this.decorateConstantNode((MIRConstantNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 107: {
                this.decorateDelimiterNode((MIRDelimiterNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 111: {
                this.decorateElementNode((MIRElementNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 114: {
                this.decorateOperationNode((MIROperationNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 115: {
                this.decorateOperatorNode((MIROperatorNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 118: {
                this.decoratePredicateNode((MIRPredicateNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 339: {
                this.decorateQueryNode((MIRQueryNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
            case 134: {
                this.decorateStatementNode((MIRStatementNode)mIRExpressionNode, expressionNodeArguments);
                break;
            }
        }
    }

    private void decorateBranchingNode(MIRBranchingNode mIRBranchingNode, ExpressionNodeArguments expressionNodeArguments) {
        this.decorateExpressionNode(mIRBranchingNode.getConditionExpressionNode(), new ExpressionNodeArguments(false, true, expressionNodeArguments.isOutput, 0));
        for (MIRExpressionNode mIRExpressionNode : mIRBranchingNode.getExpressionNodeByPosition()) {
            this.decorateExpressionNode(mIRExpressionNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, expressionNodeArguments.isOutput, 0, expressionNodeArguments.expectedElementType));
        }
        MIRExpressionDataType mIRExpressionDataType = this.getDataType(mIRBranchingNode);
        if (this.analyzer.getApplyDataTypes() && mIRExpressionDataType != null) {
            mIRBranchingNode.setDataType(mIRExpressionDataType.serialize());
        }
    }

    private void decorateConstantNode(MIRConstantNode mIRConstantNode, ExpressionNodeArguments expressionNodeArguments) {
    }

    private void decorateDelimiterNode(MIRDelimiterNode mIRDelimiterNode, ExpressionNodeArguments expressionNodeArguments) {
        MIRStatementDecor mIRStatementDecor;
        boolean bl;
        if (mIRDelimiterNode.getName().equals("*")) {
            this.processStarNode(mIRDelimiterNode, expressionNodeArguments.expectedOutputs);
        }
        boolean bl2 = bl = (mIRStatementDecor = this.getDecor(mIRDelimiterNode).getStatementDecor()).getStatementType() == 19 && (mIRDelimiterNode.getName().equals("THEN") || mIRDelimiterNode.getName().equals("ELSE"));
        if (bl) {
            this.variables.pushBranch(mIRDelimiterNode.getName().equals("ELSE"));
        }
        for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodeByPosition()) {
            this.decorateExpressionNode(mIRExpressionNode, expressionNodeArguments);
        }
        if (bl) {
            this.variables.popBranch();
        }
        this.decorateExpressionNode(mIRDelimiterNode.getConditionExpressionNode(), new ExpressionNodeArguments(false, true, expressionNodeArguments.isOutput, 0));
    }

    private String getRoutineName(MIRStatementDecor mIRStatementDecor) {
        MIRStatementNode mIRStatementNode = mIRStatementDecor.getOutputStatement();
        MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNodeByPosition().get(1);
        MIRElementNode mIRElementNode = (MIRElementNode)mIRDelimiterNode.getExpressionNodeByPosition().get(0);
        return mIRElementNode.getName();
    }

    /*
     * WARNING - void declaration
     */
    private void decorateElementNode(MIRElementNode mIRElementNode, ExpressionNodeArguments expressionNodeArguments) {
        ArrayList<MIRElementNode> arrayList;
        MIRElementNamePart mIRElementNamePart;
        block50: {
            LinkedHashSet<MIRClassifier> linkedHashSet;
            MIRStatementDecor mIRStatementDecor;
            MIRDecor mIRDecor;
            block49: {
                if (!expressionNodeArguments.isData && !expressionNodeArguments.isCondition) {
                    return;
                }
                if (mIRElementNode.getDestinationElementType() == 0) {
                    MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, expressionNodeArguments.expectedElementType);
                }
                mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                mIRDecor = this.getDecor(mIRElementNode);
                mIRStatementDecor = mIRDecor.getStatementDecor();
                if (mIRStatementDecor.getStatementType() == 36 && mIRElementNode.getDestinationElementType() == 24) {
                    linkedHashSet = new LinkedHashSet();
                    if (!this.analyzer.isOperation()) {
                        for (MIRElementNode object22 : mIRStatementDecor.getClassifiers()) {
                            MIRElement mIRElement = MIRDecorUtil.getReference(object22, (short)23);
                            if (!(mIRElement instanceof MIRClassifier)) continue;
                            linkedHashSet.add((MIRClassifier)mIRElement);
                        }
                    }
                    LinkedHashSet linkedHashSet2 = new LinkedHashSet();
                    this.analyzer.getSrcElements(mIRElementNode, linkedHashSet, (Collection<MIRElement>)linkedHashSet2);
                    Iterator linkedHashSet3 = linkedHashSet2.iterator();
                    while (linkedHashSet3.hasNext()) {
                        MIRElement mIRElement = (MIRElement)linkedHashSet3.next();
                        if (mIRElement == null || mIRElementNamePart.containsReferencedElement(mIRElement)) continue;
                        mIRElementNamePart.addReferencedElement(mIRElement);
                    }
                    if (mIRElementNode.getKind() == 2 || mIRElementNode.getKind() == 3) {
                        mIRStatementDecor.addOutputElementNode(mIRElementNode);
                    }
                    String bl2 = this.variables.getOptions().getParameterAlias(mIRElementNode.getPosition());
                    String string = this.getRoutineName(mIRStatementDecor);
                    this.variables.declareArgument(mIRElementNode, string);
                    mIRDecor.isVariable = true;
                    if (bl2 != null) {
                        mIRElementNode.setName(bl2);
                        mIRElementNamePart.setName(bl2);
                        this.variables.handle(mIRElementNode);
                    }
                } else if (!mIRDecor.isGenerated(mIRElementNode)) {
                    MIRClass mIRClass;
                    if (mIRElementNode.getDestinationElementType() == 0 && mIRStatementDecor.getStatementType() == 12 && (linkedHashSet = this.analyzer.getDataType(mIRElementNode.getDataType())) != null && ("SQL_ARRAY".equals(((MIRType)((Object)linkedHashSet)).getDataType()) || linkedHashSet instanceof MIRClassType)) {
                        MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, (short)75);
                    }
                    boolean bl = false;
                    if (mIRDecor.getStatementDecor().getStatementType() == 1 && mIRElementNode.getKind() == 3 && mIRElementNode.getDestinationElementType() == 77 && mIRElementNode.getElementNamePartCount() == 1) {
                        LinkedHashSet mIRElementNode2 = new LinkedHashSet();
                        mIRStatementDecor.buildQualifierList(mIRElementNode, mIRElementNode2, false, false);
                        Iterator iterator = mIRElementNode2.iterator();
                        while (iterator.hasNext() && !(bl = ((MIRClassifier)((Object)(arrayList = (MIRClassifier)iterator.next()))).getFeature(mIRElementNamePart.getName()) != null)) {
                        }
                    }
                    boolean linkedHashSet4 = this.analyzer.getDatabaseType() == 1 && mIRElementNode.getRightOfOperatorNode() != null && "AS".equals(mIRElementNode.getRightOfOperatorNode().getName()) && this.analyzer.getClassifierMap() != null && this.analyzer.getClassifierMap().getDatabaseOperation() != null && MIRExpressionAnalyzerHelper.getItem(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), this.analyzer.getClassifierMap().getDatabaseOperation().getArguments(), this.analyzer.getCollationMode()) != null;
                    boolean bl2 = mIRDecor.isVariable = !bl && !linkedHashSet4 && this.variables.handle(mIRElementNode);
                    if (!mIRDecor.isVariable && mIRElementNode.getKind() == 2 && this.analyzer.getClassifierMap() != null && this.analyzer.getClassifierMap().getDatabaseOperation() != null && (mIRClass = this.analyzer.getClassifierMap().getDatabaseOperation().getAssociatedClass()) != null && MIRExpressionAnalyzerHelper.getItem(mIRElementNode.getName(), mIRElementNamePart.getQuoted(), mIRClass.getFeatures(), this.analyzer.getCollationMode()) != null) {
                        mIRDecor.isVariable = this.variables.declareGlobal(mIRElementNode);
                    }
                    if (mIRElementNode.getDestinationElementType() == 0) {
                        if (mIRDecor.isVariable) {
                            this.setDestinationElementType(mIRElementNode);
                        } else {
                            MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, (short)77);
                        }
                    }
                }
                if (mIRElementNamePart.getReferencedElementCount() == 0) {
                    mIRStatementDecor.qualifyClassifier(mIRElementNode, this.variables, false);
                    if (mIRElementNode.getDestinationElementType() == 77 && !mIRStatementDecor.generatedFeatures.contains(mIRElementNode)) {
                        linkedHashSet = mIRStatementDecor.qualifyFeature(mIRElementNode, expressionNodeArguments.isOutput, this.variables, this.options.supportHierarchies());
                        this.resolveQualifiedStars(mIRElementNode, mIRStatementDecor, (List<MIRElement>)((Object)linkedHashSet));
                    }
                }
                if (mIRElementNode.getKind() == 2 || mIRElementNode.getKind() == 3) {
                    mIRStatementDecor.addElementNode(mIRElementNode);
                }
                if ((mIRDecor.isVariable || !expressionNodeArguments.isOutput || mIRElementNode.getDestinationElementType() != 75 && mIRElementNode.getDestinationElementType() != 49 && mIRElementNode.getDestinationElementType() != 209) && mIRElementNode.getDestinationElementType() != 66 && (this.analyzer.isOperation() || mIRElementNode.getDestinationElementType() != 23)) break block49;
                switch (mIRStatementDecor.getStatementType()) {
                    case 27: {
                        if (this.analyzer.getClassifierMap() != null && this.analyzer.getClassifierMap().getOperation() != null && this.analyzer.getClassifierMap().getDiModel() == null) break;
                    }
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 18: 
                    case 21: 
                    case 29: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: {
                        byte by = mIRElementNode.getKind();
                        if (mIRElementNamePart.getReferencedElementCount() != 0) {
                            void var8_21;
                            MIRElement mIRElement = MIRDecorUtil.getLastReference(mIRElementNode);
                            Object mIRDecor2 = null;
                            while (mIRElement != null && (mIRElement.getElementType() == 111 || mIRElement.getElementType() == 134)) {
                                if (mIRElement.getElementType() == 111) {
                                    MIRElementNode mIRType = (MIRElementNode)mIRElement;
                                } else if (mIRElement.getElementType() == 134) {
                                    MIRDecor mIRDecor3 = this.getDecor((MIRStatementNode)mIRElement, true, false);
                                    arrayList = mIRDecor3.getStatementDecor().getClassifiers();
                                    MIRElementNode mIRElementNode2 = arrayList.size() > 0 ? (MIRElementNode)arrayList.get(0) : null;
                                }
                                mIRElement = MIRDecorUtil.getLastReference((MIRElementNode)var8_21);
                            }
                            if (var8_21 != null && !this.getDecor((MIRExpressionNode)var8_21).isVariable) {
                                mIRElementNode = var8_21;
                            }
                        }
                        mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                        MIRClassifier mIRClassifier = null;
                        if (this.analyzer.isMultiStatement()) {
                            LinkedHashSet<MIRClassifier> linkedHashSet2 = new LinkedHashSet<MIRClassifier>();
                            mIRStatementDecor.buildQualifierList(mIRElementNode, linkedHashSet2, false, false);
                            MIRClassifierMap mIRClassifierMap = this.analyzer.getOutput(mIRElementNode, linkedHashSet2, by);
                            if (mIRClassifierMap != null) {
                                mIRClassifier = mIRClassifierMap.getDestinationClassifier();
                                arrayList = new MIRStatementNode();
                                ((MIRStatementNode)((Object)arrayList)).setStatementType(4);
                                ((MIRStatementNode)((Object)arrayList)).addReferencedExpressionNode(mIRStatementDecor.getOutputStatement());
                                MIRExpression mIRExpression = new MIRExpression();
                                mIRExpression.addStatementNode((MIRStatementNode)((Object)arrayList));
                                mIRClassifierMap.addExpression(mIRExpression);
                                if (mIRClassifierMap.getOperation().isEmpty()) {
                                    mIRClassifierMap.setOperation(this.analyzer.getStatementMetaInfo(mIRStatementDecor.getOutputStatement()).getText());
                                }
                            }
                        } else {
                            this.analyzer.setDstClassifier(mIRElementNode);
                            mIRClassifier = this.analyzer.getClassifierMap().getDestinationClassifier();
                        }
                        if (mIRClassifier == null) break block50;
                        if (mIRElementNode.getElement() == null) {
                            mIRElementNode.addElement(mIRClassifier);
                        }
                        if (!(mIRStatementDecor.getStatementType() != 3 && mIRStatementDecor.getStatementType() != 8 && mIRStatementDecor.getStatementType() != 2 && mIRStatementDecor.getStatementType() != 18 && mIRStatementDecor.getStatementType() != 29 && mIRStatementDecor.getStatementType() != 35 && mIRStatementDecor.getStatementType() != 37 && mIRStatementDecor.getStatementType() != 36 || (mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode)).containsReferencedElement(mIRClassifier))) {
                            mIRElementNamePart.addReferencedElement(mIRClassifier);
                            break;
                        }
                        break block50;
                    }
                }
                break block50;
            }
            if (!(mIRDecor.isVariable && mIRElementNode.getElementNamePartCount() <= 1 || mIRElementNode.getKind() == 2 || mIRElementNamePart.getReferencedElementCount() != 0 || mIRElementNamePart.getName().equals("*") && !mIRStatementDecor.generatedFeatures.contains(mIRElementNode))) {
                linkedHashSet = new LinkedHashSet<MIRClassifier>();
                LinkedHashSet<MIRElement> linkedHashSet5 = new LinkedHashSet<MIRElement>();
                mIRStatementDecor.buildQualifierList(mIRElementNode, linkedHashSet, false, true);
                if (!mIRDecor.isVariable || !linkedHashSet.isEmpty()) {
                    MIRElement mIRElement;
                    MIRDecor mIRDecor4 = this.getDecor(mIRElementNode.getDelimiterNode());
                    LookupOptions lookupOptions = new LookupOptions(mIRElementNode, mIRStatementDecor.generatedFeatures.contains(mIRElementNode), mIRDecor4 != null && mIRDecor4.ambiguousStar, this.options.supportHierarchies());
                    if (linkedHashSet.isEmpty() && (arrayList = MIRDecorUtil.getFeaturePart(mIRElementNode)) != null && ((MIRElementNamePart)((Object)arrayList)).getReferencedElementCount() > 0 && (mIRElement = ((MIRElementNamePart)((Object)arrayList)).getReferencedElementIterator().next()) instanceof MIRFeature) {
                        linkedHashSet.add(((MIRFeature)mIRElement).getClassifier());
                    }
                    this.analyzer.getSrcElements(lookupOptions, linkedHashSet, linkedHashSet5);
                    this.processSrcElements(mIRElementNode, linkedHashSet5, expressionNodeArguments.isData, expressionNodeArguments.isCondition, expressionNodeArguments.isOutput);
                }
                if (mIRStatementDecor.getStatementType() == 16) {
                    if (mIRElementNode.getKind() == 3) {
                        this.analyzer.setDstClassifier(mIRElementNode);
                    }
                    if (this.analyzer.getClassifierMap() != null) {
                        for (MIRElement mIRElement : linkedHashSet5) {
                            if (mIRElement == null || !mIRElement.isInstanceOf((short)75)) continue;
                            arrayList = (MIRClassifier)mIRElement;
                            if (!this.analyzer.getClassifierMap().containsSourceClassifier((MIRClassifier)((Object)arrayList))) {
                                this.analyzer.getClassifierMap().addSourceClassifier((MIRClassifier)((Object)arrayList));
                            }
                            if (mIRElementNode.getKind() != 3 || this.analyzer.getClassifierMap().getDestinationClassifier() != null) continue;
                            this.analyzer.getClassifierMap().addDestinationClassifier((MIRClassifier)((Object)arrayList));
                        }
                    }
                }
            }
        }
        if (this.analyzer.getApplyDataTypes() && mIRElementNode.getDataType().isEmpty() && mIRElementNamePart.getReferencedElementCount() > 0) {
            MIRElement mIRElement = mIRElementNamePart.getReferencedElements().first();
            if (mIRElement.isInstanceOf((short)77)) {
                MIRFeature mIRFeature = (MIRFeature)mIRElement;
                MIRType mIRType = mIRFeature.getType();
                if (mIRType != null) {
                    String string = MIRBaseTypeList.getLogicalName(mIRType.getDataType());
                    arrayList = new MIRExpressionDataType(MIRExpressionDataTypeInfo.fromName(string), mIRType.getLength(), mIRType.getScale());
                    mIRElementNode.setDataType(((MIRExpressionDataType)((Object)arrayList)).serialize());
                }
            } else if (mIRElement.isInstanceOf((short)113)) {
                mIRElementNode.setDataType(((MIRExpressionNode)mIRElement).getDataType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void decorateOperationNode(MIROperationNode mIROperationNode, ExpressionNodeArguments expressionNodeArguments) {
        block30: {
            MIRElement mIRElement;
            Object object2;
            Cloneable cloneable;
            short s;
            MIRStatementDecor mIRStatementDecor;
            ArrayList<MIRElement> arrayList;
            FunctionImplementation functionImplementation;
            MIRDecor mIRDecor;
            block28: {
                void var11_22;
                void var11_18;
                block29: {
                    List<MIRExpressionNode> list;
                    mIRDecor = this.getDecor(mIROperationNode);
                    mIRDecor.isVariable = this.variables.use(mIROperationNode);
                    if (mIRDecor.isVariable) {
                        for (MIRExpressionNode mIRExpressionNode : mIROperationNode.getExpressionNodeByPosition()) {
                            this.decorateExpressionNode(mIRExpressionNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, expressionNodeArguments.isOutput, 0));
                        }
                        return;
                    }
                    functionImplementation = this.analyzer.getFunctions().getImplementation(mIROperationNode, mIROperationNode.getExpressionNodeCount());
                    arrayList = new ArrayList<MIRElement>();
                    if (functionImplementation == null || functionImplementation.isLookupFunction()) {
                        if (functionImplementation != null) {
                            mIROperationNode.setName(functionImplementation.getMirName());
                        } else {
                            this.analyzer.setUnknownOperation(mIROperationNode);
                        }
                        this.analyzer.getSrcElements(mIROperationNode, arrayList);
                        list = MIRDecorUtil.getLastPart(mIROperationNode);
                        for (MIRElement mIRElement2 : arrayList) {
                            if (((MIRElementNamePart)((Object)list)).containsReferencedElement(mIRElement2)) continue;
                            ((MIRElementNamePart)((Object)list)).addReferencedElement(mIRElement2);
                        }
                        this.operations.add(mIROperationNode);
                    }
                    list = mIROperationNode.getExpressionNodeByPosition();
                    mIROperationNode.removeExpressionNodes();
                    mIRStatementDecor = mIRDecor.getStatementDecor();
                    for (s = 0; s < list.size(); s = (short)((short)(s + 1))) {
                        cloneable = (MIRExpressionNode)list.get(s);
                        if (cloneable instanceof MIROperatorNode && "=".equals(((MIRObject)cloneable).getName()) && (functionImplementation != null && functionImplementation.isDynamicFunction() || this.options.supportNamedParameters())) {
                            object2 = (MIROperatorNode)cloneable;
                        } else {
                            MIRElementNode object4 = mIRStatementDecor.buildFeatureNode(null, "", false, mIROperationNode);
                            object4.setKind((byte)1);
                            object2 = new MIROperatorNode();
                            ((MIRObject)object2).setName("=");
                            ((MIROperatorNode)object2).addLeftExpressionNode(object4);
                            ((MIROperatorNode)object2).addRightExpressionNode((MIRExpressionNode)cloneable);
                            object4.setPosition(s);
                            ((MIRExpressionNode)object2).setPosition(s);
                        }
                        mIROperationNode.addExpressionNode((MIRExpressionNode)object2);
                    }
                    if (functionImplementation == null || functionImplementation.isLookupFunction()) break block28;
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIROperationNode);
                    int n = mIROperationNode.getExpressionNodeCount();
                    mIROperationNode.setName(functionImplementation.getMirName());
                    object2 = mIROperationNode.getElementNamePartByPosition();
                    object2.get(object2.size() - 1).setName(mIROperationNode.getName());
                    this.analyzer.setBuiltinOperation(mIROperationNode);
                    Object n2 = null;
                    list = mIROperationNode.getExpressionNodeByPosition();
                    for (int i = 0; i < mIROperationNode.getExpressionNodeCount(); ++i) {
                        Object object;
                        MIRExpressionNode mIRExpressionNode = list.get(i);
                        MIRParserHelper.ADD_REFERENCED_NODE(((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode(), ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode());
                        boolean bl = expressionNodeArguments.isData && functionImplementation.isDataArgument(i);
                        boolean bl2 = functionImplementation.isConditionArgument(i) || expressionNodeArguments.isCondition && functionImplementation.isDataArgument(i);
                        short s2 = functionImplementation.getArgumentElementType(i);
                        if (functionImplementation.isReturnValueArgument(i) && !mIRElementNamePart.containsReferencedElement((MIRElement)(object = ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode()))) {
                            mIRElementNamePart.addReferencedElement((MIRElement)object);
                        }
                        this.decorateExpressionNode(mIRExpressionNode, new ExpressionNodeArguments(bl, bl2, expressionNodeArguments.isOutput, 0, s2));
                        if (!functionImplementation.isReturnTypeArgument(i)) continue;
                        if (this.analyzer.getFunctions().isCast(functionImplementation.getName(), n)) {
                            object = this.analyzer.getDataType(mIRExpressionNode.getName());
                            if (object == null) continue;
                            String string = MIRBaseTypeList.getLogicalName(((MIRType)object).getDataType());
                            MIRExpressionDataType mIRExpressionDataType = new MIRExpressionDataType(MIRExpressionDataTypeInfo.fromName(string), ((MIRType)object).getLength(), ((MIRType)object).getScale());
                            continue;
                        }
                        object = MIRExpressionDataType.deserialize(mIRExpressionNode.getDataType());
                        MIRExpressionDataType mIRExpressionDataType = MIRExpressionDataType.convert((MIRExpressionDataType)var11_18, (MIRExpressionDataType)object, null);
                    }
                    if (!"table".equals(functionImplementation.getReturnType()) && !"array".equals(functionImplementation.getReturnType())) break block29;
                    mIROperationNode.setDataType(functionImplementation.getReturnType());
                    break block30;
                }
                if (!this.analyzer.getApplyDataTypes()) break block30;
                if (var11_18 == null) {
                    MIRExpressionDataType mIRExpressionDataType = MIRExpressionDataType.deserialize(functionImplementation.getReturnType());
                }
                if (var11_22 == null || var11_22.getInfo() == MIRExpressionDataTypeInfo.TYPE_UNDEFINED) break block30;
                Integer n = this.getFunctionReturnLength(functionImplementation, mIROperationNode);
                if (n != null) {
                    var11_22.setLength(n);
                }
                mIROperationNode.setDataType(var11_22.serialize());
                break block30;
            }
            short s3 = s = mIRDecor.getStatementDecor().getStatementType() == 11 ? (short)1 : 0;
            if (s != 0 && mIROperationNode.getParent() == mIRDecor.getStatementDecor().getOutputStatement() && this.analyzer.isMultiStatement()) {
                cloneable = new LinkedHashSet();
                mIRStatementDecor.buildQualifierList(mIROperationNode, cloneable);
                object2 = this.analyzer.getOutput(mIROperationNode, (Collection<MIRClassifier>)((Object)cloneable));
                if (object2 != null) {
                    MIRStatementNode mIRStatementNode = new MIRStatementNode();
                    mIRStatementNode.setStatementType(4);
                    mIRStatementNode.addReferencedExpressionNode(mIRStatementDecor.getOutputStatement());
                    mIRElement = new MIRExpression();
                    ((MIRExpression)mIRElement).addStatementNode(mIRStatementNode);
                    ((MIRClassifierMap)object2).addExpression((MIRExpression)mIRElement);
                    ((MIRClassifierMap)object2).setOperation(this.analyzer.getStatementMetaInfo(mIRStatementDecor.getOutputStatement()).getText());
                }
            }
            cloneable = new HashSet();
            for (MIRExpressionNode mIRExpressionNode : mIROperationNode.getExpressionNodeByPosition()) {
                mIRElement = (MIROperatorNode)mIRExpressionNode;
                MIRArgument mIRArgument = null;
                if (((MIROperatorNode)mIRElement).getLeftExpressionNode() instanceof MIRElementNode) {
                    if (mIRDecor.isGenerated((MIRElementNode)((MIROperatorNode)mIRElement).getLeftExpressionNode())) {
                        for (MIRElement mIRElement2 : arrayList) {
                            if (!(mIRElement2 instanceof MIRStoredProcedure) || ((MIRStoredProcedure)mIRElement2).getArgumentCount() <= ((MIROperatorNode)mIRElement).getLeftExpressionNode().getPosition()) continue;
                            mIRArgument = ((MIRStoredProcedure)mIRElement2).getArgumentByPosition().get(((MIROperatorNode)mIRElement).getLeftExpressionNode().getPosition());
                        }
                    } else {
                        for (MIRElement mIRElement2 : arrayList) {
                            if (!(mIRElement2 instanceof MIRStoredProcedure)) continue;
                            mIRArgument = ((MIRStoredProcedure)mIRElement2).getArgument(mIRElement2.getName());
                        }
                    }
                }
                if (!this.analyzer.supportFunctionCalls() || s != 0) {
                    MIRParserHelper.ADD_REFERENCED_NODE(((MIROperatorNode)mIRElement).getLeftExpressionNode(), ((MIROperatorNode)mIRElement).getRightExpressionNode());
                }
                if ((!(((MIROperatorNode)mIRElement).getRightExpressionNode() instanceof MIRPredicateNode) || ((MIRPredicateNode)((MIROperatorNode)mIRElement).getRightExpressionNode()).getPredicate("OUTPUT") == null) && (mIRArgument == null || mIRArgument.getKind() != 2 && mIRArgument.getKind() != 3)) continue;
                cloneable.add(mIRElement);
                MIRParserHelper.ADD_REFERENCED_NODE(((MIROperatorNode)mIRElement).getRightExpressionNode(), ((MIROperatorNode)mIRElement).getLeftExpressionNode());
                MIRParserHelper.SET_ELEMENT_NODE_KIND(((MIROperatorNode)mIRElement).getRightExpressionNode(), (byte)2);
            }
            object2 = mIROperationNode.getExpressionNodeByPosition().iterator();
            boolean bl = false;
            while (object2.hasNext()) {
                void var11_28;
                mIRElement = object2.next();
                boolean bl3 = expressionNodeArguments.isData && (functionImplementation == null || functionImplementation.isDataArgument((int)var11_28));
                boolean bl4 = expressionNodeArguments.isCondition || functionImplementation != null && functionImplementation.isConditionArgument((int)var11_28);
                short s4 = functionImplementation != null ? functionImplementation.getArgumentElementType((int)var11_28) : (short)0;
                this.decorateExpressionNode((MIRExpressionNode)mIRElement, new ExpressionNodeArguments(bl3, bl4, expressionNodeArguments.isOutput, s4));
                if (cloneable.contains(mIRElement)) {
                    MIRElement mIRElement3;
                    MIRElementNode mIRElementNode = (MIRElementNode)((MIROperatorNode)mIRElement).getLeftExpressionNode();
                    boolean bl5 = this.getDecor(mIRElementNode).isGenerated(mIRElementNode);
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                    LookupOptions lookupOptions = new LookupOptions(mIRElementNode, bl5, false, false);
                    LinkedList<MIRClassifier> linkedList = new LinkedList<MIRClassifier>();
                    for (MIRElement mIRElement4 : arrayList) {
                        if (!(mIRElement4 instanceof MIRStoredProcedure) || (mIRElement3 = ((MIRStoredProcedure)mIRElement4).getParametersDataSet()) == null) continue;
                        linkedList.add((MIRClassifier)mIRElement3);
                    }
                    if (!linkedList.isEmpty()) {
                        ArrayList arrayList2 = new ArrayList();
                        this.analyzer.getSrcElements(lookupOptions, linkedList, (Collection<MIRElement>)arrayList2);
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            mIRElement3 = (MIRElement)iterator.next();
                            if (mIRElement3 == null || mIRElementNamePart.containsReferencedElement(mIRElement3)) continue;
                            mIRElementNamePart.addReferencedElement(mIRElement3);
                        }
                    }
                }
                ++var11_28;
            }
        }
    }

    private void decorateOperatorNode(MIROperatorNode mIROperatorNode, ExpressionNodeArguments expressionNodeArguments) {
        Object object;
        MIRElementNamePart mIRElementNamePart;
        MIRExpressionNode mIRExpressionNode;
        if (mIROperatorNode.getLeftExpressionNode() != null && mIROperatorNode.getLeftExpressionNode().getElementType() == 111 && ((MIRElementNode)mIROperatorNode.getLeftExpressionNode()).getKind() == 2) {
            this.decorateExpressionNode(mIROperatorNode.getRightExpressionNode(), new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, expressionNodeArguments.isOutput, 0, expressionNodeArguments.expectedElementType));
            this.decorateExpressionNode(mIROperatorNode.getLeftExpressionNode(), new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, expressionNodeArguments.isOutput, 0, expressionNodeArguments.expectedElementType));
        } else {
            if (".".equals(mIROperatorNode.getName()) && mIROperatorNode.getRightExpressionNode() instanceof MIRElementNode && ((MIRElementNode)mIROperatorNode.getRightExpressionNode()).getElementNamePartCount() == 1 && mIROperatorNode.getLeftExpressionNode() instanceof MIROperationNode && this.variables.use((MIROperationNode)mIROperatorNode.getLeftExpressionNode())) {
                mIRExpressionNode = (MIRElementNode)mIROperatorNode.getRightExpressionNode();
                mIRElementNamePart = new MIRElementNamePart();
                mIRElementNamePart.setName(mIROperatorNode.getLeftExpressionNode().getName());
                mIRElementNamePart.addReferencedElement(mIROperatorNode.getLeftExpressionNode());
                object = new LinkedList<MIRElementNamePart>();
                object.add(mIRElementNamePart);
                object.addAll(((MIRElementNode)mIRExpressionNode).getElementNamePartByPosition());
                ((MIRElementNode)mIRExpressionNode).removeElementNameParts();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    MIRElementNamePart mIRElementNamePart2 = (MIRElementNamePart)iterator.next();
                    mIRElementNamePart2.setPosition((short)((MIRElementNode)mIRExpressionNode).getElementNamePartCount());
                    ((MIRElementNode)mIRExpressionNode).addElementNamePart(mIRElementNamePart2);
                }
            }
            this.decorateExpressionNode(mIROperatorNode.getLeftExpressionNode(), expressionNodeArguments);
            mIRExpressionNode = mIROperatorNode.getStatementNode();
            if (mIRExpressionNode != null && ((MIRStatementNode)mIRExpressionNode).getStatementType() == 6 && mIROperatorNode.getName().equals("EXCEPT")) {
                this.decorateExpressionNode(mIROperatorNode.getRightExpressionNode(), new ExpressionNodeArguments(false, true, false, expressionNodeArguments.expectedOutputs, expressionNodeArguments.expectedElementType));
            } else {
                this.decorateExpressionNode(mIROperatorNode.getRightExpressionNode(), expressionNodeArguments);
            }
        }
        this.decorateExpressionNode(mIROperatorNode.getConditionExpressionNode(), new ExpressionNodeArguments(false, true, expressionNodeArguments.isOutput, 0, expressionNodeArguments.expectedElementType));
        if (this.analyzer.getApplyDataTypes() && mIROperatorNode.getDataType().isEmpty() && (object = MIRExpressionDataType.convert((MIRExpressionDataType)((Object)(mIRExpressionNode = mIROperatorNode.getLeftExpressionNode() != null ? MIRExpressionDataType.deserialize(mIROperatorNode.getLeftExpressionNode().getDataType()) : null)), (MIRExpressionDataType)((Object)(mIRElementNamePart = mIROperatorNode.getRightExpressionNode() != null ? MIRExpressionDataType.deserialize(mIROperatorNode.getRightExpressionNode().getDataType()) : null)), mIROperatorNode.getName())) != null) {
            mIROperatorNode.setDataType(((MIRExpressionDataType)object).serialize());
        }
    }

    private void decoratePredicateNode(MIRPredicateNode mIRPredicateNode, ExpressionNodeArguments expressionNodeArguments) {
        this.decorateExpressionNode(mIRPredicateNode.getExpressionNode(), new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, expressionNodeArguments.isOutput, 0, expressionNodeArguments.expectedElementType));
    }

    private void decorateQueryNode(MIRQueryNode mIRQueryNode, ExpressionNodeArguments expressionNodeArguments) {
        MIRElementNode mIRElementNode = mIRQueryNode.getClassifierElementNode();
        MIRDelimiterNode mIRDelimiterNode = mIRQueryNode.getFeatureDelimiterNode();
        MIRStatementNode mIRStatementNode = mIRQueryNode.getQueryStatementNode();
        this.decorateExpressionNode(mIRElementNode, new ExpressionNodeArguments(true, false, expressionNodeArguments.isOutput, 0));
        if (mIRStatementNode != null) {
            this.decorateExpressionNode(mIRStatementNode, new ExpressionNodeArguments(true, false, false, mIRDelimiterNode.getExpressionNodeCount()));
        }
        MIRDecor mIRDecor = this.getDecor(mIRQueryNode);
        MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
        MIRElement mIRElement = MIRDecorUtil.getLastReference(mIRElementNode);
        if (mIRElement != null) {
            if (mIRElement.getElementType() == 111) {
                mIRStatementDecor.propagateFeatures((MIRElementNode)mIRElement, mIRDelimiterNode, null, false);
            } else if (mIRElement.getElementType() == 339 && mIRElement != mIRQueryNode) {
                mIRStatementDecor.propagateFeatures((MIRQueryNode)mIRElement, mIRDelimiterNode, null, true);
            }
        }
        mIRStatementDecor.propagateFeatures(mIRStatementNode, mIRDelimiterNode, null, true);
        this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(true, false, false, 0));
    }

    /*
     * WARNING - void declaration
     */
    private void decorateStatementNode(MIRStatementNode mIRStatementNode, ExpressionNodeArguments expressionNodeArguments) {
        Object object;
        Object object2;
        Object object3;
        MIRExpressionNode mIRExpressionNode;
        MIRElement mIRElement;
        Object object7;
        boolean bl;
        MIRDecor mIRDecor = this.getDecor(mIRStatementNode);
        MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
        boolean bl2 = true;
        MIRStatementDecor mIRStatementDecor2 = mIRStatementDecor.getParent();
        boolean bl3 = bl = mIRStatementDecor2 != null && mIRStatementDecor2.getStatementType() != 7 && mIRStatementDecor2.getStatementType() != 19;
        if (!bl) {
            bl2 = this.analyzer.startStatement(mIRStatementNode);
        }
        this.variables.pushStatement(mIRStatementNode);
        int n = mIRStatementNode.getStatementType();
        if (n == 1) {
            Object object4;
            int n2;
            object7 = new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0);
            MIRExpressionNode mIRExpressionNode2 = mIRStatementNode.getExpressionNode("USING");
            this.decorateExpressionNode(mIRExpressionNode2, (ExpressionNodeArguments)object7);
            mIRElement = mIRStatementNode.getExpressionNode("WITH");
            this.decorateExpressionNode((MIRExpressionNode)mIRElement, (ExpressionNodeArguments)object7);
            MIRExpressionNode object62 = mIRStatementNode.getExpressionNode("FROM");
            this.decorateExpressionNode(object62, (ExpressionNodeArguments)object7);
            MIRExpressionNode mIRExpressionNode3 = mIRStatementNode.getExpressionNode("EXPAND ON");
            this.decorateExpressionNode(mIRExpressionNode3, (ExpressionNodeArguments)object7);
            MIRExpressionNode mIRExpressionNode4 = mIRStatementNode.getExpressionNode("CONNECTION");
            this.decorateExpressionNode(mIRExpressionNode4, (ExpressionNodeArguments)object7);
            MIRExpressionNode mIRExpressionNode5 = mIRStatementNode.getExpressionNode("SELECT");
            this.preprocessOperationNodes((MIRDelimiterNode)mIRExpressionNode5);
            MIRExpressionNode mIRExpressionNode6 = mIRStatementNode.getExpressionNode("FOR");
            if (mIRExpressionNode6 != null) {
                SortedSet<MIRExpressionNode> sortedSet = ((MIRDelimiterNode)mIRExpressionNode5).getExpressionNodes();
                mIRExpressionNode = ((MIRDelimiterNode)mIRExpressionNode6).getExpressionNodes().first();
                for (MIRExpressionNode mIRExpressionNode7 : sortedSet) {
                    MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode, mIRExpressionNode7);
                }
            }
            if ((n2 = expressionNodeArguments.expectedOutputs) > 0) {
                int n3 = 0;
                object3 = ((MIRDelimiterNode)mIRExpressionNode5).getExpressionNodes();
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object4 = (MIRExpressionNode)iterator.next();
                    if ("*".equals(((MIRObject)object4).getName())) continue;
                    ++n3;
                }
                n2 = object3.size() - n3 == 1 ? (n2 -= n3) : 0;
            }
            this.decorateExpressionNode(mIRExpressionNode5, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, n2));
            this.decorateExpressionNode(mIRExpressionNode6, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 1));
            mIRExpressionNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("GROUP BY");
            if (mIRExpressionNode != null) {
                object3 = ((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeByPosition();
                List<MIRExpressionNode> list = ((MIRDelimiterNode)mIRExpressionNode5).getExpressionNodeByPosition();
                object4 = object3.iterator();
                while (object4.hasNext()) {
                    MIRExpressionNode mIRExpressionNode8 = (MIRExpressionNode)object4.next();
                    if (!(mIRExpressionNode8 instanceof MIRConstantNode) || !MIRExpressionDataTypeInfo.TYPE_INTEGER.getName().equals(((MIRConstantNode)mIRExpressionNode8).getDataType())) continue;
                    int n4 = 0;
                    try {
                        n4 = Integer.valueOf(mIRExpressionNode8.getName());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 <= 0 || list.size() < n4 || (object2 = list.get(n4 - 1)) == null) continue;
                    object = MIRParserHelper.CREATE_ELEMENT_NODE(null);
                    ((MIRObject)object).setName(mIRExpressionNode8.getName());
                    MIRDecorUtil.getLastPart((MIRElementNode)object).setName(((MIRObject)object).getName());
                    ((MIRExpressionNode)object).setPosition(mIRExpressionNode8.getPosition());
                    MIRParserHelper.SET_ELEMENT_NODE_TYPE((MIRExpressionNode)object, (short)77);
                    MIRParserHelper.ADD_REFERENCED_NODE((MIRExpressionNode)object, (MIRExpressionNode)object2);
                    ((MIRDelimiterNode)mIRExpressionNode).removeExpressionNode(mIRExpressionNode8);
                    ((MIRDelimiterNode)mIRExpressionNode).addExpressionNode((MIRExpressionNode)object);
                }
            }
            object3 = mIRStatementNode.getExpressionNodeByPosition().iterator();
            while (object3.hasNext()) {
                MIRExpressionNode mIRExpressionNode9 = (MIRExpressionNode)object3.next();
                if (mIRExpressionNode9 == mIRElement || mIRExpressionNode9 == mIRExpressionNode5 || mIRExpressionNode9 == object62 || mIRExpressionNode9 == mIRExpressionNode2 || mIRExpressionNode9 == mIRExpressionNode3) continue;
                boolean bl4 = mIRExpressionNode9.getName().equals("ORDER BY") || mIRExpressionNode9.getName().equals("HAVING");
                this.decorateExpressionNode(mIRExpressionNode9, new ExpressionNodeArguments(false, true, bl4, 0));
            }
            if (!bl && this.analyzer.isMultiStatementQuery() && (object3 = this.analyzer.getOutput(mIRStatementNode)) != null) {
                MIRStatementNode mIRStatementNode2 = new MIRStatementNode();
                mIRStatementNode2.setStatementType(4);
                mIRStatementNode2.addReferencedExpressionNode(mIRStatementNode);
                MIRExpression mIRExpression = new MIRExpression();
                mIRExpression.addStatementNode(mIRStatementNode2);
                ((MIRClassifierMap)object3).addExpression(mIRExpression);
                ((MIRClassifierMap)object3).setOperation(this.analyzer.getStatementMetaInfo(mIRStatementNode).getText());
            }
        } else if (n == 18) {
            object7 = mIRStatementNode.getExpressionNode("WITH");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode6 = mIRStatementNode.getExpressionNode("INTO");
            this.decorateExpressionNode(mIRExpressionNode6, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
            MIRExpressionNode mIRExpressionNode7 = ((MIRDelimiterNode)mIRExpressionNode6).getExpressionNodeByPosition().get(0);
            if (mIRExpressionNode7 instanceof MIROperatorNode) {
                mIRExpressionNode7 = ((MIROperatorNode)mIRExpressionNode7).getRightExpressionNode();
            }
            MIRExpressionNode n7 = mIRStatementNode.getExpressionNode("USING");
            this.decorateExpressionNode(n7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode10 = ((MIRDelimiterNode)n7).getExpressionNodeByPosition().get(0);
            if (mIRExpressionNode10 instanceof MIROperatorNode) {
                mIRExpressionNode10 = ((MIROperatorNode)mIRExpressionNode10).getRightExpressionNode();
            }
            MIRBranchingNode mIRBranchingNode = (MIRBranchingNode)mIRStatementNode.getExpressionNode("MERGE");
            for (MIRExpressionNode mIRExpressionNode11 : mIRBranchingNode.getExpressionNodes()) {
                MIRStatementNode mIRStatementNode3 = (MIRStatementNode)((MIRBranchingNode)mIRExpressionNode11).getExpressionNodeByPosition().get(0);
                switch (mIRStatementNode3.getStatementType()) {
                    case 2: {
                        mIRExpressionNode = (MIRDelimiterNode)mIRStatementNode3.getExpressionNode("INTO");
                        object3 = (MIRQueryNode)((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeByPosition().get(0);
                        this.addReferencedNode(((MIRQueryNode)object3).getClassifierElementNode(), mIRExpressionNode7);
                        MIRStatementNode mIRStatementNode4 = ((MIRQueryNode)object3).getQueryStatementNode();
                        this.addReferencedNode(mIRStatementNode4.getExpressionNodeByPosition().get(0), mIRExpressionNode10);
                        break;
                    }
                    case 3: {
                        MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode3.getExpressionNode("FROM");
                        this.addReferencedNode(mIRDelimiterNode.getExpressionNodeByPosition().get(0), mIRExpressionNode10);
                        MIRDelimiterNode mIRDelimiterNode2 = (MIRDelimiterNode)mIRStatementNode3.getExpressionNode("UPDATE");
                        this.addReferencedNode(mIRDelimiterNode2.getExpressionNodeByPosition().get(0), mIRExpressionNode7);
                        break;
                    }
                    case 8: {
                        MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode3.getExpressionNode("DELETE");
                        object2 = (MIRDelimiterNode)mIRDelimiterNode.getExpressionNode("FROM");
                        this.addReferencedNode(((MIRDelimiterNode)object2).getExpressionNodeByPosition().get(0), mIRExpressionNode7);
                    }
                }
            }
            this.decorateExpressionNode(mIRBranchingNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
        } else if (n == 3) {
            object7 = mIRStatementNode.getExpressionNode("USING");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode9 = mIRStatementNode.getExpressionNode("WITH");
            this.decorateExpressionNode(mIRExpressionNode9, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode10 = mIRStatementNode.getExpressionNode("FROM");
            this.decorateExpressionNode(mIRExpressionNode10, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode12 = mIRStatementNode.getExpressionNode("UPDATE");
            this.decorateExpressionNode(mIRExpressionNode12, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
            MIRExpressionNode mIRExpressionNode13 = mIRStatementNode.getExpressionNode("JOIN");
            this.decorateExpressionNode(mIRExpressionNode13, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode14 = mIRStatementNode.getExpressionNode("SET");
            this.decorateExpressionNode(mIRExpressionNode14, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            for (MIRExpressionNode mIRExpressionNode15 : mIRStatementNode.getExpressionNodeByPosition()) {
                if (mIRExpressionNode15 == mIRExpressionNode12 || mIRExpressionNode15 == mIRExpressionNode10 || mIRExpressionNode15 == mIRExpressionNode14) continue;
                boolean bl5 = mIRExpressionNode15.getName().equals("ORDER BY") || mIRExpressionNode15.getName().equals("HAVING");
                this.decorateExpressionNode(mIRExpressionNode15, new ExpressionNodeArguments(false, true, bl5, 0));
            }
        } else if (n == 8) {
            object7 = mIRStatementNode.getExpressionNode("USING");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode13 = mIRStatementNode.getExpressionNode("FROM");
            this.decorateExpressionNode(mIRExpressionNode13, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode14 = mIRStatementNode.getExpressionNode("DELETE");
            this.decorateExpressionNode(mIRExpressionNode14, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
            for (MIRExpressionNode mIRExpressionNode16 : mIRStatementNode.getExpressionNodeByPosition()) {
                if (mIRExpressionNode16 == mIRExpressionNode14 || mIRExpressionNode16 == mIRExpressionNode13) continue;
                boolean bl6 = mIRExpressionNode16.getName().equals("ORDER BY") || mIRExpressionNode16.getName().equals("HAVING");
                this.decorateExpressionNode(mIRExpressionNode16, new ExpressionNodeArguments(false, true, bl6, 0));
            }
        } else if (n == 10) {
            object7 = mIRStatementNode.getExpressionNode("FROM");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(true, false, false, 0));
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("SELECT");
            MIRDelimiterNode mIRDelimiterNode3 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("FOR");
            MIRDelimiterNode mIRDelimiterNode4 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("IN");
            for (MIRExpressionNode mIRExpressionNode17 : mIRDelimiterNode4.getExpressionNodes()) {
                for (MIRExpressionNode mIRExpressionNode18 : mIRDelimiterNode.getExpressionNodes()) {
                    if (mIRExpressionNode17 instanceof MIROperatorNode) {
                        MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode17;
                        mIRExpressionNode = mIROperatorNode.getRightExpressionNode();
                        MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode, mIRExpressionNode18);
                        continue;
                    }
                    MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode17, mIRExpressionNode18);
                }
                for (MIRExpressionNode mIRExpressionNode19 : mIRDelimiterNode3.getExpressionNodes()) {
                    MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode17, mIRExpressionNode19);
                }
            }
            this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(true, false, false, 0));
            this.decorateExpressionNode(mIRDelimiterNode3, new ExpressionNodeArguments(true, false, false, 0));
            this.decorateExpressionNode(mIRDelimiterNode4, new ExpressionNodeArguments(true, false, false, 0));
        } else if (n == 28) {
            object7 = mIRStatementNode.getExpressionNode("FROM");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(true, false, false, 0));
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("SELECT");
            MIRDelimiterNode mIRDelimiterNode4 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("FOR");
            MIRDelimiterNode mIRDelimiterNode5 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("IN");
            for (MIRExpressionNode mIRExpressionNode20 : mIRDelimiterNode.getExpressionNodes()) {
                for (MIRExpressionNode mIRExpressionNode21 : mIRDelimiterNode5.getExpressionNodes()) {
                    MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode20, mIRExpressionNode21);
                }
            }
            for (MIRExpressionNode mIRExpressionNode22 : mIRDelimiterNode4.getExpressionNodes()) {
                for (MIRExpressionNode mIRExpressionNode23 : mIRDelimiterNode5.getExpressionNodes()) {
                    MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode22, mIRExpressionNode23);
                }
            }
            this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(true, false, false, 0));
            this.decorateExpressionNode(mIRDelimiterNode4, new ExpressionNodeArguments(true, false, false, 0));
            this.decorateExpressionNode(mIRDelimiterNode5, new ExpressionNodeArguments(true, false, false, 0));
        } else if (n == 6) {
            Object object5;
            void var12_62;
            object7 = mIRStatementNode.getExpressionNode("WITH");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRStatementNode.getExpressionNodeByPosition().get(0);
            MIRExpressionNode mIRExpressionNode19 = null;
            MIROperatorNode mIROperatorNode2 = mIROperatorNode;
            while (var12_62 != null && (mIRExpressionNode19 = (MIRStatementNode)var12_62.getRightExpressionNode()) != null && ((MIRStatementNode)mIRExpressionNode19).getStatementType() == 6) {
                MIROperatorNode mIROperatorNode3 = (MIROperatorNode)((MIRStatementNode)mIRExpressionNode19).getExpressionNodeByPosition().get(0);
            }
            if (mIRExpressionNode19 != null && !mIRExpressionNode19.getBlock() && (object5 = ((MIRStatementNode)mIRExpressionNode19).getExpressionNode("ORDER BY")) != null) {
                ((MIRExpressionNode)object5).removeStatementNode();
                MIRParserHelper.ADD_TO_PARENT(mIRStatementNode, (MIRExpressionNode)object5, -1);
            }
            this.decorateExpressionNode(mIROperatorNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, expressionNodeArguments.expectedOutputs));
            object5 = mIRStatementNode.getExpressionNodeByPosition().iterator();
            while (object5.hasNext()) {
                MIRExpressionNode mIRExpressionNode24 = (MIRExpressionNode)object5.next();
                if (mIRExpressionNode24 == mIROperatorNode || mIRExpressionNode24 == object7) continue;
                boolean bl7 = mIRExpressionNode24.getName().equals("ORDER BY") || mIRExpressionNode24.getName().equals("HAVING");
                this.decorateExpressionNode(mIRExpressionNode24, new ExpressionNodeArguments(false, true, bl7, 0));
            }
            if (!bl && this.analyzer.isMultiStatementQuery() && (object5 = this.analyzer.getOutput(mIRStatementNode)) != null) {
                MIRStatementNode mIRStatementNode5 = new MIRStatementNode();
                mIRStatementNode5.setStatementType(4);
                mIRStatementNode5.addReferencedExpressionNode(mIRStatementNode);
                MIRExpression mIRExpression = new MIRExpression();
                mIRExpression.addStatementNode(mIRStatementNode5);
                ((MIRClassifierMap)object5).addExpression(mIRExpression);
                ((MIRClassifierMap)object5).setOperation(this.analyzer.getStatementMetaInfo(mIRStatementNode).getText());
            }
        } else if (n == 5 || n == 13) {
            MIRExpressionNode mIRExpressionNode25;
            Object object12;
            MIRDelimiterNode mIRDelimiterNode;
            object7 = mIRStatementNode.getExpressionNode("LOCATION");
            if (this.analyzer.supportLocation() && object7 != null && (mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("TABLE")) != null && (object12 = mIRDelimiterNode.getExpressionNodeByPosition().get(0)) instanceof MIRQueryNode) {
                MIRQueryNode mIRQueryNode = (MIRQueryNode)object12;
                if (mIRQueryNode.getQueryStatementNode() == null) {
                    mIRExpressionNode25 = new MIRStatementNode();
                    ((MIRStatementNode)mIRExpressionNode25).setStatementType(9);
                    mIRStatementNode.removeExpressionNode((MIRExpressionNode)object7);
                    MIRParserHelper.ADD_ALL_NODES(mIRExpressionNode25, object7);
                    MIRDelimiterNode mIRDelimiterNode6 = MIRParserHelper.CREATE_DELIMITER_NODE("*", "");
                    MIRElementNode mIRElementNode = MIRParserHelper.CREATE_ELEMENT_NODE(null);
                    MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, (short)77);
                    MIRParserHelper.ADD_ALL_NODES(mIRDelimiterNode6, mIRElementNode);
                    MIRParserHelper.ADD_ALL_NODES(mIRExpressionNode25, mIRDelimiterNode6);
                    mIRQueryNode.addQueryStatementNode((MIRStatementNode)mIRExpressionNode25);
                } else {
                    mIRExpressionNode25 = MIRParserHelper.CREATE_DELIMITER_NODE("", "");
                    MIRParserHelper.ADD_ALL_NODES(object7, mIRExpressionNode25);
                    this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
                    for (MIRExpressionNode mIRExpressionNode26 : mIRQueryNode.getFeatureDelimiterNode().getExpressionNodeByPosition()) {
                        MIRStatementOutput mIRStatementOutput = new MIRStatementOutput(mIRExpressionNode26);
                        MIRElementNode mIRElementNode = mIRStatementDecor.buildFeatureNode((MIRDelimiterNode)mIRExpressionNode25, mIRStatementOutput.getName(), mIRStatementOutput.isQuoted(), (MIRElementNode)((MIRDelimiterNode)object7).getExpressionNodeByPosition().get(0));
                        mIRElementNode.setKind((byte)3);
                    }
                    mIRStatementDecor.propagateFeatures((MIRDelimiterNode)mIRExpressionNode25, mIRQueryNode.getFeatureDelimiterNode(), null, true);
                }
            }
            if ((mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("EXTERNAL DATA SOURCE")) != null) {
                object12 = mIRDelimiterNode.getExpressionNodeByPosition().get(0);
                MIRDelimiterNode mIRDelimiterNode7 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("WITH");
                mIRExpressionNode25 = (MIROperatorNode)mIRDelimiterNode7.getExpressionNodeByPosition().get(0);
                if (mIRExpressionNode25 != null) {
                    MIRConstantNode mIRConstantNode = (MIRConstantNode)((MIROperatorNode)mIRExpressionNode25).getRightExpressionNode();
                    String string = mIRConstantNode.getName();
                    ((MIRExpressionNode)object12).setDataType(string);
                }
                this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
            for (MIRExpressionNode mIRExpressionNode27 : mIRStatementNode.getExpressionNodeByPosition()) {
                boolean bl8 = mIRExpressionNode27.getName().equals("TABLE") || mIRExpressionNode27.getName().equals("VIEW") || mIRExpressionNode27.getName().equals("RECORD");
                this.decorateExpressionNode(mIRExpressionNode27, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, bl8, 0));
            }
        } else if (n == 36) {
            for (MIRExpressionNode mIRExpressionNode21 : mIRStatementNode.getExpressionNodeByPosition()) {
                boolean bl9 = mIRExpressionNode21.getName().equals("PROCEDURE");
                if (!bl2 && "AS".equals(mIRExpressionNode21.getName())) continue;
                this.decorateExpressionNode(mIRExpressionNode21, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, bl9, 0));
            }
        } else if (n == 35) {
            for (MIRExpressionNode mIRExpressionNode22 : mIRStatementNode.getExpressionNodeByPosition()) {
                boolean bl10 = mIRExpressionNode22.getName().equals("ON");
                this.decorateExpressionNode(mIRExpressionNode22, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, bl10, 0));
            }
        } else if (n == 37) {
            object7 = mIRStatementNode.getExpressionNode("SYNONYM");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
            MIRExpressionNode mIRExpressionNode23 = mIRStatementNode.getExpressionNode("FOR");
            this.decorateExpressionNode(mIRExpressionNode23, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            for (MIRExpressionNode mIRExpressionNode28 : mIRStatementNode.getExpressionNodeByPosition()) {
                boolean bl9 = mIRExpressionNode28.getName().equals("SYNONYM");
                this.decorateExpressionNode(mIRExpressionNode28, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, bl9, 0));
            }
        } else if (n == 29) {
            object7 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("RENAME");
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("TABLE");
            MIRElementNode mIRElementNode = mIRDelimiterNode != null && mIRDelimiterNode.getExpressionNodeCount() == 1 ? (MIRElementNode)mIRDelimiterNode.getExpressionNodeByPosition().get(0) : null;
            Object object6 = object7;
            if (object6 == null) {
                MIRDelimiterNode mIRDelimiterNode8 = mIRDelimiterNode;
            } else {
                MIRParserHelper.SET_ELEMENT_NODE_KIND(mIRElementNode, (byte)1);
            }
            for (MIRExpressionNode mIRExpressionNode29 : mIRStatementNode.getExpressionNodeByPosition()) {
                void var12_72;
                this.decorateExpressionNode(mIRExpressionNode29, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, mIRExpressionNode29 == var12_72, 0));
            }
            if (object7 != null && ((MIRDelimiterNode)object7).getExpressionNodeCount() == 1) {
                MIRElementNode mIRElementNode2 = (MIRElementNode)((MIRDelimiterNode)object7).getExpressionNodeByPosition().get(0);
                MIRClassifier mIRClassifier = (MIRClassifier)MIRDecorUtil.getReference(mIRElementNode, (short)75);
                if (mIRClassifier != null) {
                    this.analyzer.move(mIRClassifier, (MIRClassifier)MIRDecorUtil.getReference(mIRElementNode2, (short)75));
                }
            }
        } else if (n == 33) {
            object7 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("REMOVE");
            if (object7 != null) {
                MIRElementNode mIRElementNode;
                MIRElementNode mIRElementNode3 = mIRElementNode = ((MIRDelimiterNode)object7).getExpressionNodeCount() == 1 ? (MIRElementNode)((MIRDelimiterNode)object7).getExpressionNodeByPosition().get(0) : null;
                if (mIRElementNode != null) {
                    LinkedHashSet<MIRClassifier> linkedHashSet = new LinkedHashSet<MIRClassifier>();
                    LinkedHashSet<MIRElement> linkedHashSet2 = new LinkedHashSet<MIRElement>();
                    this.analyzer.getSrcElements(mIRElementNode, linkedHashSet, linkedHashSet2);
                }
            }
        } else if (n == 26) {
            object7 = mIRStatementNode.getExpressionNode("FROM");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)object7;
            for (MIRExpressionNode mIRExpressionNode30 : mIRStatementNode.getExpressionNodeByPosition()) {
                if (mIRExpressionNode30 instanceof MIRStatementNode) {
                    MIRStatementNode mIRStatementNode6 = (MIRStatementNode)mIRExpressionNode30;
                    MIRDelimiterNode mIRDelimiterNode9 = (MIRDelimiterNode)mIRStatementNode6.getExpressionNodeByPosition().get(1);
                    MIRQueryNode mIRQueryNode = (MIRQueryNode)mIRDelimiterNode9.getExpressionNodeByPosition().get(0);
                    MIRStatementNode mIRStatementNode7 = mIRQueryNode.getQueryStatementNode();
                    MIRDelimiterNode mIRDelimiterNode10 = (MIRDelimiterNode)mIRStatementNode7.getExpressionNode("FROM");
                    if (mIRDelimiterNode10 == null) {
                        mIRDelimiterNode10 = new MIRDelimiterNode();
                        mIRDelimiterNode10.setName("FROM");
                        mIRDelimiterNode10.setOriginalText("FROM");
                        mIRDelimiterNode10.setBlock(true);
                        mIRDelimiterNode10.setDelimiter(",");
                        MIRParserHelper.ADD_ALL_NODES(mIRStatementNode7, mIRDelimiterNode10);
                        mIRExpressionNode = MIRParserHelper.CREATE_ELEMENT_NODE(null);
                        MIRParserHelper.SET_ELEMENT_NODE_KIND(mIRExpressionNode, (byte)3);
                        MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRExpressionNode, (short)75);
                        MIRParserHelper.ADD_ALL_NODES(mIRDelimiterNode10, mIRExpressionNode);
                    }
                    mIRExpressionNode = (MIRElementNode)mIRDelimiterNode10.getExpressionNodeByPosition().get(0);
                    this.addReferencedNode(mIRExpressionNode, MIRParserHelper.GET_OUTPUT_NODE(mIRDelimiterNode.getExpressionNodeByPosition().get(0)));
                }
                this.decorateExpressionNode(mIRExpressionNode30, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
        } else if (n == 2) {
            MIRExpressionNode mIRExpressionNode24;
            object7 = mIRStatementNode.getExpressionNode("USING");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("WITH");
            if (mIRDelimiterNode != null && (mIRExpressionNode24 = mIRDelimiterNode.getExpressionNode("DATA_SOURCE")) != null) {
                this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
            mIRExpressionNode24 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("INTO");
            MIRDelimiterNode mIRDelimiterNode11 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("PARTITION");
            for (MIRExpressionNode mIRExpressionNode31 : mIRStatementNode.getExpressionNodeByPosition()) {
                boolean bl10 = mIRExpressionNode31 == mIRExpressionNode24 || mIRExpressionNode31 == mIRDelimiterNode11;
                this.decorateExpressionNode(mIRExpressionNode31, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, bl10, 0));
            }
            if (mIRDelimiterNode11 != null && !this.containsStarFeature(mIRStatementDecor.generatedFeatures)) {
                ArrayList arrayList = new ArrayList();
                for (MIRExpressionNode mIRExpressionNode32 : mIRDelimiterNode11.getExpressionNodeByPosition()) {
                    if (!(mIRExpressionNode32 instanceof MIRElementNode)) continue;
                    arrayList.add(mIRExpressionNode32);
                }
                if (!arrayList.isEmpty() && ((MIRDelimiterNode)mIRExpressionNode24).getExpressionNodeByPosition().get(0) instanceof MIRQueryNode) {
                    List<MIRExpressionNode> list = ((MIRQueryNode)((MIRDelimiterNode)mIRExpressionNode24).getExpressionNodeByPosition().get(0)).getFeatureDelimiterNode().getExpressionNodeByPosition();
                    if (!mIRStatementDecor.generatedFeatures.isEmpty()) {
                        int n5;
                        int n6 = arrayList.size();
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        for (n5 = 0; n5 < n6; ++n5) {
                            mIRExpressionNode = mIRStatementDecor.generatedFeatures.get(mIRStatementDecor.generatedFeatures.size() - n6 + n5);
                            if (mIRExpressionNode.getName().equals("*")) continue;
                            object3 = mIRStatementDecor.removeOutput(mIRStatementDecor.getOutputCount() - n6 + n5);
                            arrayList2.add(object3);
                        }
                        for (n5 = 0; n5 < n6; ++n5) {
                            mIRExpressionNode = mIRStatementDecor.generatedFeatures.get(mIRStatementDecor.generatedFeatures.size() - n6 + n5);
                            if (mIRExpressionNode.getName().equals("*")) continue;
                            mIRStatementDecor.generatedFeatures.remove(mIRExpressionNode);
                            object3 = (MIRExpressionNode)arrayList.get(n5);
                            MIRStatementOutput mIRStatementOutput = new MIRStatementOutput((MIRExpressionNode)object3);
                            String string = mIRStatementOutput.getName();
                            boolean bl11 = mIRStatementOutput.isQuoted();
                            boolean bl12 = mIRStatementOutput.hasStar();
                            object2 = new MIRStatementOutput(string, bl11, bl12);
                            object = (MIRStatementOutput)arrayList2.get(n5);
                            ((MIRStatementOutput)object2).add((MIRStatementOutput)object);
                            mIRStatementDecor.addStatementOutput((MIRStatementOutput)object2);
                            MIRExpressionNode mIRExpressionNode33 = list.get(list.size() - n6 + n5);
                            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode33);
                            mIRElementNamePart.setName(string);
                            mIRExpressionNode33.setName(string);
                        }
                    }
                }
            }
        } else if (n == 21) {
            object7 = (MIRStatementNode)mIRStatementNode.getExpressionNodeByPosition().get(0);
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRElementNode mIRElementNode = this.getDestinationElementNode((MIRStatementNode)object7);
            mIRStatementDecor.addElementNode(mIRElementNode);
            MIRExpressionNode mIRExpressionNode27 = mIRStatementNode.getExpressionNode("OUTPUT");
            MIRExpressionNode mIRExpressionNode34 = mIRStatementNode.getExpressionNode("INTO");
            mIRStatementDecor.propagateFeatures((MIRDelimiterNode)mIRExpressionNode27, (MIRDelimiterNode)mIRExpressionNode34, null, true);
            this.decorateExpressionNode(mIRExpressionNode27, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            if (mIRExpressionNode34 != null) {
                if (((MIRDelimiterNode)mIRExpressionNode34).getExpressionNodes().first().getElementType() == 339) {
                    MIRQueryNode mIRQueryNode = (MIRQueryNode)((MIRDelimiterNode)mIRExpressionNode34).getExpressionNodeByPosition().get(0);
                    mIRStatementDecor.propagateFeatures((MIRDelimiterNode)mIRExpressionNode27, mIRQueryNode.getFeatureDelimiterNode(), null, true);
                }
                this.decorateExpressionNode(mIRExpressionNode34, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
            }
        } else if (n == 32) {
            for (MIRExpressionNode mIRExpressionNode28 : mIRStatementNode.getExpressionNodeByPosition()) {
                if ("INTO".equals(mIRExpressionNode28.getName())) {
                    this.decorateExpressionNode(mIRExpressionNode28, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, true, 0));
                    MIRQueryNode mIRQueryNode = (MIRQueryNode)((MIRDelimiterNode)mIRExpressionNode28).getExpressionNodeByPosition().get(0);
                    mIRStatementDecor.propagateFeatures(mIRQueryNode.getFeatureDelimiterNode(), (MIRDelimiterNode)mIRStatementNode.getExpressionNodeByPosition().get(0), null, true);
                    continue;
                }
                this.decorateExpressionNode(mIRExpressionNode28, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
        } else if (n == 22) {
            object7 = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("FOR");
            this.decorateExpressionNode((MIRExpressionNode)object7, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            MIRExpressionNode mIRExpressionNode29 = ((MIRDelimiterNode)object7).getExpressionNodeByPosition().get(0);
            if (mIRExpressionNode29 != null && mIRExpressionNode29 instanceof MIROperatorNode && ((MIROperatorNode)mIRExpressionNode29).getLeftExpressionNode() instanceof MIRDelimiterNode) {
                MIRExpressionNode mIRExpressionNode30 = ((MIROperatorNode)mIRExpressionNode29).getRightExpressionNode();
                MIRExpressionNode mIRExpressionNode35 = ((MIROperatorNode)mIRExpressionNode29).getLeftExpressionNode();
                if (mIRExpressionNode35 instanceof MIRDelimiterNode) {
                    if (mIRExpressionNode30 instanceof MIRStatementNode) {
                        mIRStatementDecor.propagateFeatures((MIRStatementNode)mIRExpressionNode30, (MIRDelimiterNode)mIRExpressionNode35, null, true);
                    } else if (mIRExpressionNode30 instanceof MIRElementNode) {
                        mIRStatementDecor.propagateFeatures((MIRElementNode)mIRExpressionNode30, (MIRDelimiterNode)mIRExpressionNode35, null, true);
                    }
                }
            }
            for (MIRExpressionNode mIRExpressionNode36 : mIRStatementNode.getExpressionNodeByPosition()) {
                if (mIRExpressionNode36 == object7) continue;
                this.decorateExpressionNode(mIRExpressionNode36, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
        } else if (n == 15) {
            MIRExpressionNode mIRExpressionNode31;
            object7 = mIRStatementNode.getExpressionNodeByPosition();
            if (object7.size() > 1 && "INTO".equals(object7.get(1).getName())) {
                MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)object7.get(1);
                mIRExpressionNode31 = (MIRExpressionNode)object7.get(0);
                this.decorateExpressionNode(mIRExpressionNode31, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
                for (MIRExpressionNode mIRExpressionNode37 : mIRDelimiterNode.getExpressionNodeByPosition()) {
                    this.setDestinationElementType((MIRElementNode)mIRExpressionNode37);
                }
                if (mIRDelimiterNode.getExpressionNodeCount() == 1) {
                    MIRParserHelper.ADD_REFERENCED_NODE(mIRDelimiterNode.getExpressionNodeByPosition().get(0), mIRExpressionNode31);
                } else if (mIRExpressionNode31.getElementType() == 134) {
                    mIRStatementDecor.propagateFeatures((MIRStatementNode)mIRExpressionNode31, mIRDelimiterNode, null, true);
                } else if (mIRExpressionNode31.getElementType() == 111 && !mIRStatementDecor.propagateFeatures((MIRElementNode)mIRExpressionNode31, mIRDelimiterNode, null, true) && ((MIRElementNode)mIRExpressionNode31).getDestinationElementType() == 75 && "FETCH".equalsIgnoreCase(mIRStatementNode.getName())) {
                    for (MIRExpressionNode mIRExpressionNode37 : mIRDelimiterNode.getExpressionNodeByPosition()) {
                        MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode37, mIRExpressionNode31);
                    }
                }
                this.decorateExpressionNode(mIRDelimiterNode, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            } else {
                for (int i = 0; i < object7.size(); ++i) {
                    MIRExpressionNode mIRExpressionNode38;
                    mIRExpressionNode31 = (MIRExpressionNode)object7.get(i);
                    if (mIRExpressionNode31 instanceof MIROperatorNode && (mIRExpressionNode38 = ((MIROperatorNode)mIRExpressionNode31).getLeftExpressionNode()) instanceof MIRElementNode) {
                        this.setDestinationElementType((MIRElementNode)mIRExpressionNode38);
                    }
                    this.decorateExpressionNode(mIRExpressionNode31, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
                }
            }
        } else if (n == 14) {
            if (mIRStatementNode.getExpressionNodeCount() > 0) {
                if (mIRStatementNode.getExpressionNodeCount() == 1) {
                    MIRElementNode mIRElementNode;
                    MIRExpressionNode mIRExpressionNode33;
                    MIRExpressionNode mIRExpressionNode34;
                    while (mIRStatementDecor2 != null && mIRStatementDecor2.getStatementType() != 5 && mIRStatementDecor2.getStatementType() != 36) {
                        mIRStatementDecor2 = mIRStatementDecor2.getParent();
                    }
                    if (mIRStatementDecor2 != null && (mIRExpressionNode34 = (MIRDelimiterNode)((MIRStatementNode)(object7 = mIRStatementDecor2.getOutputStatement())).getExpressionNode("RETURN")) != null && ((MIRDelimiterNode)mIRExpressionNode34).getExpressionNodeCount() > 0 && (mIRExpressionNode33 = ((MIRDelimiterNode)mIRExpressionNode34).getExpressionNodeByPosition().get(0)) instanceof MIRQueryNode && (mIRElementNode = this.variables.get(((MIRQueryNode)mIRExpressionNode33).getClassifierElementNode())) != null) {
                        MIRElementNode mIRElementNode4 = MIRParserHelper.CREATE_ELEMENT_NODE(null);
                        mIRElementNode4.getElementNamePartByPosition().get(0).setName(mIRElementNode.getName());
                        mIRElementNode4.setName(mIRElementNode.getName());
                        MIRParserHelper.ADD_ALL_NODES(mIRStatementNode, mIRElementNode4);
                        this.setDestinationElementType(mIRElementNode4);
                    }
                } else {
                    object7 = mIRStatementNode.getExpressionNodeByPosition().get(mIRStatementNode.getExpressionNodeCount() - 1);
                    if (((MIRExpressionNode)object7).getElementType() == 111) {
                        this.setDestinationElementType((MIRElementNode)object7);
                    }
                }
            }
            for (MIRExpressionNode mIRExpressionNode34 : mIRStatementNode.getExpressionNodeByPosition()) {
                this.decorateExpressionNode(mIRExpressionNode34, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
        } else if (n == 9) {
            for (MIRExpressionNode mIRExpressionNode35 : mIRStatementNode.getExpressionNodeByPosition()) {
                boolean bl15 = expressionNodeArguments.isCondition || mIRExpressionNode35.getName().equals("WHERE");
                this.decorateExpressionNode(mIRExpressionNode35, new ExpressionNodeArguments(expressionNodeArguments.isData, bl15, false, expressionNodeArguments.expectedOutputs));
            }
        } else {
            for (MIRExpressionNode mIRExpressionNode36 : mIRStatementNode.getExpressionNodeByPosition()) {
                this.decorateExpressionNode(mIRExpressionNode36, new ExpressionNodeArguments(expressionNodeArguments.isData, expressionNodeArguments.isCondition, false, 0));
            }
        }
        mIRStatementDecor.computeOutputFeatures(this.options.supportTableValuedExpressions());
        object7 = mIRStatementNode.getReferencedByStatementNode();
        if (object7 != null && ((MIRStatementNode)object7).getExpression() != null) {
            MIRExpression mIRExpression = ((MIRStatementNode)object7).getExpression();
            mIRElement = mIRExpression.getClassifierMap().getDestinationClassifier();
            boolean bl13 = true;
            for (int i = 0; i < mIRStatementDecor.getOutputCount(); ++i) {
                void var12_88;
                LookupOptions lookupOptions = this.computeOptions(mIRStatementDecor, i, (int)var12_88);
                if (lookupOptions.isPositionBased()) {
                    ++var12_88;
                }
                this.analyzer.getDstFeature((MIRClassifier)mIRElement, lookupOptions);
            }
        }
        mIRStatementDecor.propagate(expressionNodeArguments.isCondition);
        this.variables.popStatement();
    }

    List<MIRElement> getRefExpressionNodes(MIRElementNode mIRElementNode) {
        LinkedList<MIRElement> linkedList = new LinkedList<MIRElement>();
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
        for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
            if (!(mIRElement instanceof MIRExpressionNode)) continue;
            linkedList.add(mIRElement);
        }
        return linkedList;
    }

    private void resolveQualifiedStars(MIRElementNode mIRElementNode, MIRStatementDecor mIRStatementDecor, List<MIRElement> list) {
        Object object;
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getFeaturePart(mIRElementNode);
        if (mIRElementNamePart == null || mIRElementNamePart.getReferencedElementCount() == 0) {
            return;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        mIRStatementDecor.buildQualifierList(mIRElementNode, linkedHashSet, false, false);
        if (linkedHashSet.size() > 1) {
            LinkedList<MIRElement> linkedList = new LinkedList<MIRElement>(mIRElementNamePart.getReferencedElements());
            for (MIRElement mIRElement : linkedList) {
                if (!(mIRElement instanceof MIRElementNode) || !"*".equals(MIRDecorUtil.getFeaturePart((MIRElementNode)mIRElement).getName())) continue;
                mIRElementNamePart.removeReferencedElement(mIRElement);
            }
            return;
        }
        LinkedList<MIRElementNode> linkedList = new LinkedList<MIRElementNode>();
        LinkedList<MIRElement> linkedList2 = new LinkedList<MIRElement>(mIRElementNamePart.getReferencedElements());
        while (!linkedList2.isEmpty()) {
            MIRElement mIRElement = (MIRElement)linkedList2.remove(0);
            if (!(mIRElement instanceof MIRElementNode) || !"*".equals(MIRDecorUtil.getFeaturePart((MIRElementNode)mIRElement).getName())) continue;
            MIRElementNode mIRElementNode2 = (MIRElementNode)mIRElement;
            object = this.getRefExpressionNodes(mIRElementNode2);
            if (!object.isEmpty()) {
                linkedList2.addAll((Collection<MIRElement>)object);
                continue;
            }
            linkedList.add(mIRElementNode2);
        }
        if (!linkedList.isEmpty()) {
            mIRElementNamePart.removeReferencedElements();
        }
        for (MIRElementNode mIRElementNode2 : linkedList) {
            object = this.getDecor(mIRElementNode2);
            MIRStatementDecor mIRStatementDecor2 = ((MIRDecor)object).getStatementDecor();
            if (mIRStatementDecor2.getStatementType() != 1) continue;
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementDecor2.getOutputStatement().getExpressionNode("SELECT");
            MIRExpressionNode mIRExpressionNode = mIRDelimiterNode.getExpressionNode(mIRElementNamePart.getName());
            if (mIRExpressionNode == null) {
                mIRExpressionNode = mIRStatementDecor2.buildFeatureNode(mIRDelimiterNode, mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), mIRElementNode2);
                mIRStatementDecor2.generatedFeatures.remove(mIRExpressionNode);
                this.decorateExpressionNode(mIRExpressionNode, new ExpressionNodeArguments(true, false, false, 0));
                mIRStatementDecor2.addOutputElementNode((MIRElementNode)mIRExpressionNode);
            }
            if (mIRElementNamePart.containsReferencedElement(mIRExpressionNode)) continue;
            mIRElementNamePart.addReferencedElement(mIRExpressionNode);
        }
    }

    private boolean containsStarFeature(ArrayList<MIRElementNode> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MIRElementNode mIRElementNode = arrayList.get(i);
            if (!mIRElementNode.getName().equals("*")) continue;
            return true;
        }
        return false;
    }

    private int processSrcElements(MIRElementNode mIRElementNode, Collection<MIRElement> collection, boolean bl, boolean bl2, boolean bl3) {
        int n;
        block4: {
            block3: {
                n = 0;
                for (MIRElement object2 : collection) {
                    if (!(object2 instanceof MIRFeature) || ((MIRFeature)object2).hasLineageOption(1)) continue;
                    ++n;
                }
                if (n <= true || !this.analyzer.supportRegexColumns()) break block3;
                MIRDecor mIRDecor = this.getDecor(mIRElementNode);
                MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
                int n2 = mIRElementNode.getPosition();
                MIRDelimiterNode mIRDelimiterNode = mIRElementNode.getDelimiterNode();
                if (mIRDelimiterNode == null) break block4;
                mIRElementNode.delete();
                for (MIRElement mIRElement : collection) {
                    MIRElementNode mIRElementNode2 = mIRStatementDecor.buildFeatureNode(mIRDelimiterNode, mIRElement.getName(), false, (MIRElementNode)null);
                    this.setPosition(mIRElementNode2, n2++);
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode2);
                    mIRElementNamePart.addReferencedElement(mIRElement);
                    this.decorateExpressionNode(mIRElementNode2, new ExpressionNodeArguments(bl, bl2, bl3, 0));
                }
                break block4;
            }
            n = 0;
            for (MIRElement mIRElement : collection) {
                MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                if (mIRElement == null || mIRElementNamePart.containsReferencedElement(mIRElement)) continue;
                mIRElementNamePart.addReferencedElement(mIRElement);
            }
        }
        return n;
    }

    private void setPosition(MIRElementNode mIRElementNode, int n) {
        MIRDelimiterNode mIRDelimiterNode = mIRElementNode.getDelimiterNode();
        mIRElementNode.setPosition((short)n);
        List<MIRExpressionNode> list = mIRDelimiterNode.getExpressionNodeByPosition();
        int n2 = n;
        for (MIRExpressionNode mIRExpressionNode : list) {
            if (mIRExpressionNode.getPosition() < n || mIRExpressionNode == mIRElementNode || ++n2 <= mIRExpressionNode.getPosition()) continue;
            mIRExpressionNode.setPosition((short)n2);
        }
    }

    private void addReferencedNode(MIRExpressionNode mIRExpressionNode, MIRExpressionNode mIRExpressionNode2) {
        MIRParserHelper.ADD_REFERENCED_NODE(mIRExpressionNode, mIRExpressionNode2);
        if (mIRExpressionNode instanceof MIRElementNode && (mIRExpressionNode.getName() == null || mIRExpressionNode.getName().isEmpty())) {
            mIRExpressionNode.setName(mIRExpressionNode2.getName());
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode);
            if (mIRElementNamePart != null && (mIRElementNamePart.getName() == null || mIRElementNamePart.getName().isEmpty())) {
                mIRElementNamePart.setName(mIRExpressionNode2.getName());
            }
        }
    }

    private void setDestinationElementType(MIRElementNode mIRElementNode) {
        if (mIRElementNode.getDestinationElementType() != 0) {
            return;
        }
        MIRElementNode mIRElementNode2 = this.variables.get(mIRElementNode);
        if (mIRElementNode2 != null && mIRElementNode2 != mIRElementNode && mIRElementNode2.getDestinationElementType() != 24) {
            MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, mIRElementNode2.getDestinationElementType());
        } else if (mIRElementNode2 != null && mIRElementNode2 != mIRElementNode && mIRElementNode2.getDestinationElementType() == 24 && mIRElementNode2.getPredicateNode() != null && mIRElementNode2.getPredicateNode().getName() != null && mIRElementNode2.getPredicateNode().getName().equals("COMPLEX_DATATYPE_FORMAT")) {
            MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, (short)75);
        } else {
            MIRParserHelper.SET_ELEMENT_NODE_TYPE(mIRElementNode, (short)77);
        }
    }

    /*
     * WARNING - void declaration
     */
    private LookupOptions computeOptions(MIRStatementDecor mIRStatementDecor, int n, int n2) {
        void var7_13;
        MIRElement mIRElement;
        MIRExpressionNode mIRExpressionNode;
        MIRStatementOutput mIRStatementOutput = mIRStatementDecor.getOutput(n);
        boolean bl = false;
        if (mIRStatementDecor.getStatementType() == 2 || mIRStatementDecor.getStatementType() == 18 || mIRStatementDecor.getStatementType() == 32 || mIRStatementDecor.getStatementType() == 11) {
            for (MIRExpressionNode object22 : mIRStatementOutput.features) {
                if (object22.getElementType() != 111 || !this.getDecor(object22).isGenerated((MIRElementNode)object22)) continue;
                bl = true;
                break;
            }
        }
        Object object3 = "";
        if (this.analyzer.getApplyDataTypes()) {
            for (MIRExpressionNode mIRExpressionNode2 : mIRStatementOutput.features) {
                if (mIRExpressionNode2.getElementType() != 111 || !((String)object3).isEmpty()) continue;
                object3 = mIRExpressionNode2.getDataType();
            }
        }
        Object var7_10 = null;
        if (mIRStatementOutput.features.size() == 1 && (mIRExpressionNode = mIRStatementOutput.features.get(0)) instanceof MIRElementNode && (mIRElement = MIRDecorUtil.getLastReference((MIRElementNode)mIRExpressionNode)) instanceof MIRExpressionNode) {
            MIRExpressionNode mIRExpressionNode3 = (MIRExpressionNode)mIRElement;
        }
        String string = var7_13 != null ? var7_13.getDescription() : null;
        boolean bl2 = !mIRStatementOutput.features.isEmpty() ? "AS".equalsIgnoreCase(mIRStatementOutput.features.get(0).getParent().getName()) : false;
        return new LookupOptions(var7_13 instanceof MIRElementNode ? (MIRElementNode)var7_13 : null, mIRStatementOutput.getName(), (String)object3, string, bl ? n2 : n + 1, bl, mIRStatementOutput.isQuoted(), mIRStatementOutput.hasStar(), false, bl2);
    }

    private MIRElementNode getDestinationElementNode(MIRStatementNode mIRStatementNode) {
        MIRStatementDecor mIRStatementDecor = this.getDecor(mIRStatementNode).getStatementDecor();
        MIRStatementNode mIRStatementNode2 = mIRStatementNode.getReferencedByStatementNode();
        if (mIRStatementNode2 == null) {
            return null;
        }
        MIRClassifier mIRClassifier = mIRStatementNode2.getExpression().getClassifierMap().getDestinationClassifier();
        for (MIRElementNamePart mIRElementNamePart : mIRClassifier.getReferencedByElementNameParts()) {
            MIRDecor mIRDecor = this.getDecor(mIRElementNamePart.getElementNode());
            if (mIRDecor.getStatementDecor() != mIRStatementDecor) continue;
            return mIRElementNamePart.getElementNode();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void processStarNode(MIRDelimiterNode mIRDelimiterNode, int n) {
        int n2 = mIRDelimiterNode.getExpressionNodeCount();
        if (n2 == 1) {
            SequencedCollection<MIRExpressionNode> sequencedCollection;
            boolean bl;
            MIRElementNode mIRElementNode = (MIRElementNode)mIRDelimiterNode.getExpressionNodes().first();
            mIRElementNode.removeDelimiterNode();
            MIRExpressionNode mIRExpressionNode = (MIRExpressionNode)mIRDelimiterNode.getParent();
            if (mIRExpressionNode instanceof MIROperatorNode && "=".equals(mIRExpressionNode.getName())) {
                mIRExpressionNode = (MIRExpressionNode)mIRExpressionNode.getParent();
            }
            if (mIRExpressionNode instanceof MIROperationNode && "COUNT".equalsIgnoreCase(mIRExpressionNode.getName())) {
                mIRElementNode.delete();
                mIRDelimiterNode.addExpressionNode(MIRParserHelper.CREATE_CONSTANT_NODE("*"));
                return;
            }
            MIRDecor mIRDecor = this.getDecor(mIRDelimiterNode);
            MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
            MIRElementNode mIRElementNode2 = mIRStatementDecor.qualifyClassifier(mIRElementNode, this.variables, true);
            if (mIRElementNode2 != null) {
                bl = mIRStatementDecor.propagateFeatures(mIRElementNode2, mIRDelimiterNode, mIRElementNode, false);
            } else {
                sequencedCollection = mIRStatementDecor.propagateFeatures(mIRElementNode, false);
                bl = !sequencedCollection.isEmpty();
                for (MIRExpressionNode linkedHashSet : sequencedCollection) {
                    mIRDelimiterNode.addExpressionNode(linkedHashSet);
                }
            }
            if (!bl) {
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        MIRElementNode mIRElementNode3 = mIRStatementDecor.buildFeatureNode(mIRDelimiterNode, "", false, mIRElementNode2);
                        mIRElementNode3.setPosition((short)i);
                    }
                } else {
                    MIRFeature mIRFeature;
                    MIRClassifier mIRClassifier;
                    Object object;
                    sequencedCollection = new LinkedHashSet();
                    mIRStatementDecor.buildQualifierList(mIRElementNode, sequencedCollection, false, false);
                    boolean bl2 = !((HashSet)((Object)sequencedCollection)).isEmpty();
                    for (MIRClassifier mIRClassifier2 : sequencedCollection) {
                        if (this.analyzer.isClassifierDefined(mIRClassifier2)) continue;
                        bl2 = false;
                        break;
                    }
                    LinkedHashSet<MIRElement> linkedHashSet = new LinkedHashSet<MIRElement>();
                    if (bl2) {
                        linkedHashSet.addAll(sequencedCollection);
                    } else {
                        if (this.analyzer.getClassifierMap() != null && !(mIRDelimiterNode.getParent().getParent() instanceof MIROperationNode)) {
                            void var13_19;
                            MIRStatementDecor mIRStatementDecor2;
                            int n3;
                            MIRStatementDecor mIRStatementDecor3 = mIRStatementDecor;
                            int n4 = -1;
                            while ((n3 = (mIRStatementDecor2 = var13_19.getParent()) != null ? mIRStatementDecor2.getStatementType() : -1) == 6) {
                            }
                            if (this.analyzer.isMultiStatement() || n3 == -1 || n3 == 1 || n3 == 5) {
                                object = null;
                                if (this.analyzer.isMultiStatement()) {
                                    Object object2;
                                    MIRElement mIRElement;
                                    if (mIRStatementDecor2 != null) {
                                        mIRElement = mIRStatementDecor2.getOutputStatement();
                                        if (((MIRExpressionNode)mIRElement).getReferencedByStatementNode() != null) {
                                            mIRElement = ((MIRExpressionNode)mIRElement).getReferencedByStatementNode();
                                        }
                                    } else {
                                        mIRElement = mIRStatementDecor.getOutputStatement();
                                        if (((MIRExpressionNode)mIRElement).getReferencedByStatementNode() != null) {
                                            mIRElement = ((MIRExpressionNode)mIRElement).getReferencedByStatementNode();
                                        }
                                    }
                                    if (mIRElement != null && (object2 = ((MIRStatementNode)mIRElement).getExpression()) != null) {
                                        object = ((MIRExpression)object2).getClassifierMap();
                                    }
                                } else {
                                    object = this.analyzer.getClassifierMap();
                                }
                                if (object != null && n3 != 1 && (!this.analyzer.isMultiStatement() || this.analyzer.isClassifierDefined(((MIRClassifierMap)object).getDestinationClassifier()))) {
                                    linkedHashSet.add(((MIRClassifierMap)object).getDestinationClassifier());
                                }
                            }
                        }
                        if (linkedHashSet.isEmpty() && !((HashSet)((Object)sequencedCollection)).isEmpty()) {
                            for (MIRClassifier mIRClassifier3 : sequencedCollection) {
                                object = this.analyzer.getStarFeature(mIRClassifier3, mIRDelimiterNode.getDelimiterNode() != null ? mIRDelimiterNode.getDelimiterNode().getExpressionNodeCount() - 1 : 0);
                                if (object == null) continue;
                                linkedHashSet.add(mIRClassifier3);
                            }
                        }
                    }
                    Object var13_24 = null;
                    if (linkedHashSet.isEmpty() || linkedHashSet.size() == 1 && (mIRClassifier = (MIRClassifier)linkedHashSet.iterator().next()).getFeatureCount() == 1 && (mIRFeature = mIRClassifier.getFeatureByPosition().get(0)).hasLineageOption(256)) {
                        void var13_26;
                        mIRDelimiterNode.addExpressionNode(mIRElementNode);
                        if (var13_26 != null) {
                            object = MIRDecorUtil.getLastPart(mIRElementNode);
                            ((MIRElementNamePart)object).addReferencedElement((MIRElement)var13_26);
                        }
                    } else {
                        for (MIRElement mIRElement : linkedHashSet) {
                            for (MIRFeature mIRFeature2 : ((MIRClassifier)mIRElement).getFeatureByPosition()) {
                                if (!this.analyzer.isStarCandidate(mIRFeature2, bl2)) continue;
                                String string = mIRFeature2.getPhysicalName();
                                if (string.isEmpty()) {
                                    string = mIRFeature2.getName();
                                }
                                MIRElementNode mIRElementNode3 = mIRStatementDecor.buildFeatureNode(mIRDelimiterNode, string, mIRFeature2.hasLineageOption(4096), mIRElementNode);
                                if (bl2) {
                                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode3);
                                    mIRElementNamePart.addReferencedElement(mIRFeature2);
                                    continue;
                                }
                                mIRDecor.ambiguousStar = mIRDelimiterNode.getDelimiterNode() != null && mIRDelimiterNode.getDelimiterNode().getExpressionNodeCount() > 1;
                            }
                        }
                    }
                }
            }
            if (mIRElementNode.getDelimiterNode() == null) {
                mIRElementNode.delete();
            }
        }
    }

    private MIRDecor getDecor(MIRExpressionNode mIRExpressionNode) {
        return this.getDecor(mIRExpressionNode, true, false);
    }

    private MIRDecor getDecor(MIRExpressionNode mIRExpressionNode, boolean bl, boolean bl2) {
        if (mIRExpressionNode == null) {
            return null;
        }
        MIRDecor mIRDecor = this.decors.getDecor(mIRExpressionNode);
        if (mIRDecor == null) {
            mIRDecor = this.decors.buildDecor(mIRExpressionNode, bl, bl2);
        }
        return mIRDecor;
    }

    private MIRExpressionDataType getDataType(MIRExpressionNode mIRExpressionNode) {
        Object object;
        if (mIRExpressionNode == null) {
            return null;
        }
        if (!mIRExpressionNode.getDataType().isEmpty()) {
            return MIRExpressionDataType.deserialize(mIRExpressionNode.getDataType());
        }
        MIRExpressionDataType mIRExpressionDataType = null;
        List<MIRExpressionNode> list = null;
        if (mIRExpressionNode.getElementType() == 103) {
            list = ((MIRBranchingNode)mIRExpressionNode).getExpressionNodeByPosition();
        } else if (mIRExpressionNode.getElementType() == 107) {
            list = ((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeByPosition();
        } else if (mIRExpressionNode.getElementType() == 134 && ((MIRStatementNode)mIRExpressionNode).getStatementType() == 1) {
            object = ((MIRStatementNode)mIRExpressionNode).getExpressionNode("SELECT");
            mIRExpressionDataType = this.getDataType((MIRExpressionNode)object);
        } else if (mIRExpressionNode.getElementType() == 134 && ((MIRStatementNode)mIRExpressionNode).getStatementType() == 17) {
            object = ((MIRStatementNode)mIRExpressionNode).getExpressionNode("*");
            mIRExpressionDataType = this.getDataType((MIRExpressionNode)object);
        }
        if (list != null) {
            for (MIRExpressionNode mIRExpressionNode2 : list) {
                MIRExpressionDataType mIRExpressionDataType2 = this.getDataType(mIRExpressionNode2);
                mIRExpressionDataType = MIRExpressionDataType.convert(mIRExpressionDataType, mIRExpressionDataType2, null);
            }
        }
        return mIRExpressionDataType;
    }

    private Integer getFunctionReturnLength(FunctionImplementation functionImplementation, MIROperationNode mIROperationNode) {
        Integer n = null;
        if (functionImplementation == null || functionImplementation.getReturnLength().isEmpty() || mIROperationNode == null) {
            return n;
        }
        List<MIRExpressionNode> list = mIROperationNode.getExpressionNodeByPosition();
        String[] stringArray = functionImplementation.getReturnLength().split("[\\+]");
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n3;
            String string = stringArray[i];
            if (string.startsWith("$")) {
                int n4 = Integer.valueOf(string.substring(1));
                MIRExpressionNode mIRExpressionNode = list.get(n4 - 1);
                MIRExpressionDataType mIRExpressionDataType = MIRExpressionDataType.deserialize(mIRExpressionNode.getDataType());
                if (mIRExpressionDataType == null || !mIRExpressionDataType.hasLength()) {
                    return null;
                }
                n3 = mIRExpressionDataType.getLength();
            } else {
                n3 = Integer.valueOf(string);
            }
            if (n == null) {
                n = n3;
            } else {
                if (!"+".equals(functionImplementation.getReturnLength().substring(n2, n2 + 1))) {
                    return null;
                }
                n = n + n3;
                ++n2;
            }
            n2 += string.length();
        }
        return n;
    }

    private void preprocessOperationNodes(MIRDelimiterNode mIRDelimiterNode) {
        if (this.options.supportCastColumnNameAlias()) {
            for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodeByPosition()) {
                MIRElementNamePart mIRElementNamePart;
                MIROperationNode mIROperationNode;
                MIRExpressionNode mIRExpressionNode2;
                if (!(mIRExpressionNode instanceof MIROperationNode) || !"CAST".equalsIgnoreCase(mIRExpressionNode.getName()) || !((mIRExpressionNode2 = (mIROperationNode = (MIROperationNode)mIRExpressionNode).getExpressionNodeByPosition().get(0)) instanceof MIRElementNode) || (mIRElementNamePart = MIRDecorUtil.getFeaturePart((MIRElementNode)mIRExpressionNode2)) == null) continue;
                MIRElementNode mIRElementNode = MIRParserHelper.CREATE_ELEMENT_NODE(mIRElementNamePart.getName(), "", false);
                MIROperatorNode mIROperatorNode = MIRParserHelper.CREATE_OPERATOR_NODE("AS", "", mIROperationNode, mIRElementNode);
                MIRParserHelper.ADD_TO_PARENT(mIRDelimiterNode, mIROperatorNode, mIRExpressionNode.getPosition());
                MIRParserHelper.ADD_REFERENCED_NODE(mIRElementNode, mIROperationNode);
                mIRDelimiterNode.removeExpressionNode(mIRExpressionNode);
                mIRExpressionNode.setPosition((short)0);
            }
        }
    }

    private static class ExpressionNodeArguments {
        final boolean isData;
        final boolean isCondition;
        final boolean isOutput;
        final int expectedOutputs;
        final short expectedElementType;

        ExpressionNodeArguments(boolean bl, boolean bl2, boolean bl3, int n) {
            this(bl, bl2, bl3, n, 0);
        }

        ExpressionNodeArguments(boolean bl, boolean bl2, boolean bl3, int n, short s) {
            this.isData = bl;
            this.isCondition = bl2;
            this.isOutput = bl3;
            this.expectedOutputs = n;
            this.expectedElementType = s;
        }
    }
}

