/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.decoration;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.decoration.MIRDecors;
import MITI.expression.analyzer.decoration.MIRExpressionTraversal;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperationNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class MIRConditionalMapScanner
extends MIRExpressionTraversal {
    private final List<MIRExpressionNode> conditions = new LinkedList<MIRExpressionNode>();
    private final Map<MIRExpressionNode, String> conditionNames = new HashMap<MIRExpressionNode, String>();
    private MIRExpressionNode currentCondition;

    MIRConditionalMapScanner(MIRDecors mIRDecors, boolean bl) {
        super(mIRDecors, bl, true);
    }

    @Override
    void traverseExpressionNode(MIRExpressionNode mIRExpressionNode, boolean bl, boolean bl2) {
        if (mIRExpressionNode != null && bl2 && this.currentCondition == null) {
            String string;
            this.currentCondition = mIRExpressionNode;
            super.traverseExpressionNode(mIRExpressionNode, bl, bl2);
            String string2 = string = mIRExpressionNode.getConditionOfParserNode() != null ? mIRExpressionNode.getConditionOfParserNode().getName() : mIRExpressionNode.getName();
            if (mIRExpressionNode instanceof MIRDelimiterNode && ((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeCount() == 1) {
                mIRExpressionNode = ((MIRDelimiterNode)mIRExpressionNode).getExpressionNodeIterator().next();
            }
            this.conditions.add(mIRExpressionNode);
            this.conditionNames.put(mIRExpressionNode, string);
            this.currentCondition = null;
        } else {
            super.traverseExpressionNode(mIRExpressionNode, bl, bl2);
        }
    }

    @Override
    void processElementNode(MIRElementNode mIRElementNode, boolean bl, boolean bl2, List<MIRExpressionNode> list) {
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
        for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
            if (!(mIRElement instanceof MIRExpressionNode)) continue;
            list.add((MIRExpressionNode)mIRElement);
        }
    }

    @Override
    void processOperationNode(MIROperationNode mIROperationNode, boolean bl, boolean bl2, List<MIRExpressionNode> list) {
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIROperationNode);
        for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
            if (!(mIRElement instanceof MIRExpressionNode)) continue;
            list.add((MIRExpressionNode)mIRElement);
        }
    }

    List<MIRExpressionNode> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    String getConditionName(MIRExpressionNode mIRExpressionNode) {
        return this.conditionNames.get(mIRExpressionNode);
    }

    Map<MIRExpressionNode, String> getConditionNames() {
        return Collections.unmodifiableMap(this.conditionNames);
    }
}

