/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer;

import MITI.expression.analyzer.engine.CollationMode;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRRepository;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRSynonym;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class MIRExpressionAnalyzerHelper {
    private static final String SEPARATOR = "\u2028";
    public static final String LIVE_TABLE = "LIVE";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    public static String getCanonicalName(String string, boolean bl, int n) {
        if (bl) {
            return string;
        }
        switch (n) {
            case 1: 
            case 3: 
            case 4: {
                return string.toUpperCase();
            }
            case 5: 
            case 21: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    public static <T extends MIRObject> T getItem(String string, boolean bl, Collection<T> collection, CollationMode collationMode) {
        List<T> list = MIRExpressionAnalyzerHelper.getItems(string, bl, collection, collationMode);
        return (T)(list == null || list.isEmpty() ? null : (MIRObject)list.get(0));
    }

    public static <T extends MIRObject> List<T> getItems(String string, boolean bl, Collection<T> collection, CollationMode collationMode) {
        if (string == null || collection == null) {
            return null;
        }
        ArrayList<MIRObject> arrayList = new ArrayList<MIRObject>();
        block4: for (MIRObject mIRObject : collection) {
            String string2 = MIRExpressionAnalyzerHelper.getPhysicalName(mIRObject);
            switch (collationMode) {
                case CaseSensitive: {
                    if (!string.equals(string2)) continue block4;
                    arrayList.add(mIRObject);
                    continue block4;
                }
                case QuotedCaseSensitive: {
                    if (!bl && string.equalsIgnoreCase(string2)) {
                        if (mIRObject instanceof MIRClassifier && ((MIRClassifier)mIRObject).hasLineageOption(4096) || mIRObject instanceof MIRFeature && ((MIRFeature)mIRObject).hasLineageOption(4096)) {
                            if (!string.equals(string2)) continue block4;
                            arrayList.add(mIRObject);
                            continue block4;
                        }
                        arrayList.add(mIRObject);
                        continue block4;
                    }
                    if (!bl || !string.equals(string2)) continue block4;
                    arrayList.add(mIRObject);
                    continue block4;
                }
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            arrayList.add(mIRObject);
        }
        return arrayList;
    }

    public static void setCollationLineageOption(MIRObject mIRObject, boolean bl, CollationMode collationMode) {
        if (collationMode == CollationMode.CaseSensitive || bl && collationMode == CollationMode.QuotedCaseSensitive) {
            if (mIRObject instanceof MIRFeature) {
                ((MIRFeature)mIRObject).setLineageOption(4096);
            } else if (mIRObject instanceof MIRClassifier) {
                ((MIRClassifier)mIRObject).setLineageOption(4096);
            }
        }
    }

    public static boolean isCreateTmpTable(MIRObject mIRObject, int n) {
        String[] stringArray;
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        if (mIRStatementNode == null || mIRStatementNode.getStatementType() != 5) {
            return false;
        }
        if (n == 11 && mIRStatementNode.getExpressionNodeByPosition().get(0).getOriginalText().equalsIgnoreCase("CACHE")) {
            return true;
        }
        if (n == 2) {
            return mIRObject.getName().startsWith("#");
        }
        String string = n == 4 ? "VOLATILE" : "TEMP";
        for (String string2 : stringArray = mIRStatementNode.getExpressionNodeByPosition().get(mIRStatementNode.getExpressionNodeCount() - 1).getOriginalText().toUpperCase().split(" ")) {
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCreateStatement(MIRObject mIRObject) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        return mIRStatementNode != null && (mIRStatementNode.getStatementType() == 5 || mIRStatementNode.getStatementType() == 36 || mIRStatementNode.getStatementType() == 37 || mIRStatementNode.getStatementType() == 35);
    }

    public static boolean isCreateTable(MIRObject mIRObject) {
        return MIRExpressionAnalyzerHelper.isCreateStatement(mIRObject);
    }

    public static boolean isCreateView(MIRObject mIRObject) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        return mIRStatementNode != null && mIRStatementNode.getStatementType() == 5 && "VIEW".equals(mIRStatementNode.getExpressionNodeByPosition().get(mIRStatementNode.getExpressionNodeCount() - 1).getName());
    }

    public static boolean isDropTable(MIRObject mIRObject) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        return mIRStatementNode != null && mIRStatementNode.getStatementType() == 13;
    }

    public static boolean isCreateSynonym(MIRObject mIRObject) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        return mIRStatementNode != null && mIRStatementNode.getStatementType() == 37;
    }

    public static String getSynonymReferencedTable(MIRElementNode mIRElementNode) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRElementNode);
        MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("FOR");
        MIRElementNode mIRElementNode2 = (MIRElementNode)mIRDelimiterNode.getExpressionNodes().first();
        return mIRElementNode2.getName();
    }

    public static boolean isRenameTable(MIRObject mIRObject) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        return mIRStatementNode != null && mIRStatementNode.getStatementType() == 31;
    }

    public static boolean isRemoveFile(MIRObject mIRObject) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRObject);
        return mIRStatementNode != null && mIRStatementNode.getStatementType() == 33;
    }

    public static boolean isInClassifierContext(MIRExpressionNode mIRExpressionNode) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRExpressionNode);
        MIRExpressionNode mIRExpressionNode2 = (MIRExpressionNode)mIRExpressionNode.getParent();
        if (mIRExpressionNode2 instanceof MIROperatorNode && "AS".equals(mIRExpressionNode2.getName())) {
            mIRExpressionNode2 = (MIRExpressionNode)mIRExpressionNode2.getParent();
        }
        return mIRStatementNode != null && mIRStatementNode.getStatementType() == 1 && "FROM".equals(mIRExpressionNode2.getName());
    }

    public static boolean isInCallContext(MIROperationNode mIROperationNode) {
        return mIROperationNode.getParent() instanceof MIRStatementNode && ((MIRStatementNode)mIROperationNode.getParent()).getStatementType() == 11;
    }

    public static MIRClassifier getClassifier(MIRElement mIRElement, MIRClassifierMap mIRClassifierMap, boolean bl) {
        Comparable<StringBuilder> comparable;
        if (mIRElement instanceof MIRClassifier) {
            return (MIRClassifier)mIRElement;
        }
        if (!(mIRElement instanceof MIRSynonym)) {
            return null;
        }
        MIRNamespaceElement mIRNamespaceElement = mIRClassifierMap.getDatabaseOperation();
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = mIRClassifierMap.getDestinationClassifier();
        }
        if (mIRNamespaceElement != null) {
            if (mIRNamespaceElement.getClientOfElementMapCount() > 0) {
                comparable = mIRNamespaceElement.getClientOfElementMapIterator().next();
            } else {
                comparable = new MIRElementMap();
                ((MIRElementMap)comparable).addClientElement(mIRNamespaceElement);
            }
            if (!((MIRElementMap)comparable).containsSupplierElement(mIRElement)) {
                ((MIRElementMap)comparable).addSupplierElement(mIRElement);
            }
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(MIRExpressionAnalyzerHelper.escapeName(MIRExpressionAnalyzerHelper.getPackageName(mIRElement)) + "." + MIRExpressionAnalyzerHelper.escapeName(mIRElement.getName()));
        MIRModelObject mIRModelObject = (MIRModelObject)mIRElement;
        while (mIRModelObject instanceof MIRSynonym) {
            ((StringBuilder)comparable).append(SEPARATOR);
            mIRModelObject = ((MIRSynonym)mIRModelObject).getModelObject();
            ((StringBuilder)comparable).append(MIRExpressionAnalyzerHelper.escapeName(MIRExpressionAnalyzerHelper.getPackageName(mIRModelObject)) + "." + MIRExpressionAnalyzerHelper.escapeName(mIRModelObject.getName()));
        }
        if (mIRModelObject != null && mIRModelObject != mIRElement && mIRClassifierMap != null && ((StringBuilder)comparable).length() > 0) {
            MIRPropertyType mIRPropertyType = MIRExpressionAnalyzerHelper._fetchPropertyType(mIRElement.getRootModel(), mIRClassifierMap.getElementType(), bl ? "SourceSynonyms" : "DestinationSynonym", (byte)0, "Synonym Lineage", "", "SQL_VARCHAR", true, null);
            String string = MIRExpressionAnalyzerHelper.getPropertyValueValue(mIRPropertyType, mIRClassifierMap);
            String[] stringArray = string.split("\r\n");
            boolean bl2 = true;
            for (String string2 : stringArray) {
                if (!string2.equals(((StringBuilder)comparable).toString())) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                MIRExpressionAnalyzerHelper.setPropertyValue(mIRPropertyType, (!string.isEmpty() ? string + "\r\n" : "") + ((StringBuilder)comparable).toString(), mIRClassifierMap);
            }
        }
        return mIRModelObject instanceof MIRClassifier ? (MIRClassifier)mIRModelObject : null;
    }

    private static String getPackageName(MIRObject mIRObject) {
        mIRObject = mIRObject.getParent();
        while (mIRObject instanceof MIRSynonym || mIRObject instanceof MIRClassifier) {
            mIRObject = mIRObject.getParent();
        }
        return mIRObject != null ? mIRObject.getName() : null;
    }

    private static String getPhysicalName(MIRObject mIRObject) {
        if (mIRObject != null) {
            MIRModelObject mIRModelObject;
            if (mIRObject instanceof MIRModelObject && !(mIRModelObject = (MIRModelObject)mIRObject).getPhysicalName().isEmpty()) {
                return mIRModelObject.getPhysicalName();
            }
            return mIRObject.getName();
        }
        return "";
    }

    public static MIRStatementNode getStatementNode(MIRObject mIRObject) {
        while (mIRObject.getElementType() != 134) {
            if ((mIRObject = mIRObject.getParent()) != null && mIRObject instanceof MIRExpressionNode) continue;
            return null;
        }
        return (MIRStatementNode)mIRObject;
    }

    private static MIRDelimiterNode getTableDelimiterNode(MIRObject mIRObject) {
        while (mIRObject.getElementType() != 134 || ((MIRStatementNode)mIRObject).getStatementType() != 5) {
            if ((mIRObject = mIRObject.getParent()) != null && mIRObject instanceof MIRExpressionNode) continue;
            return null;
        }
        MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRObject;
        MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNode("TABLE");
        return mIRDelimiterNode;
    }

    public static boolean isLiveTable(MIRObject mIRObject) {
        String string;
        MIRDelimiterNode mIRDelimiterNode = MIRExpressionAnalyzerHelper.getTableDelimiterNode(mIRObject);
        return mIRDelimiterNode != null && (string = mIRDelimiterNode.getOriginalText()).toUpperCase().contains(LIVE_TABLE);
    }

    public static MIRQueryTable getQueryTableOfCreateStmnt(MIRObject mIRObject) {
        MIRQueryNode mIRQueryNode;
        MIRElementNode mIRElementNode;
        MIRElement mIRElement;
        MIRDelimiterNode mIRDelimiterNode = MIRExpressionAnalyzerHelper.getTableDelimiterNode(mIRObject);
        if (mIRDelimiterNode != null && (mIRElement = (mIRElementNode = (mIRQueryNode = (MIRQueryNode)mIRDelimiterNode.getExpressionNodeByPosition().get(0)).getClassifierElementNode()).getElement()) instanceof MIRQueryTable) {
            return (MIRQueryTable)mIRElement;
        }
        return null;
    }

    private static String escapeName(String string) {
        if (string == null) {
            return string;
        }
        if (!NAME_PATTERN.matcher(string).matches()) {
            return "\"" + string.replace("\"", "\\\"") + "\"";
        }
        return string;
    }

    private static MIRPropertyType _fetchPropertyType(MIRObject mIRObject, short s, String string, byte by, String string2, String string3, String string4, boolean bl, String string5) {
        MIRPropertyElementTypeScope mIRPropertyElementTypeScope = MIRExpressionAnalyzerHelper.fetchPropertyElementTypeScope(mIRObject, s, bl);
        if (mIRPropertyElementTypeScope == null) {
            return null;
        }
        MIRPropertyType mIRPropertyType = null;
        MIRPropertyType mIRPropertyType2 = null;
        Iterator<MIRPropertyType> iterator = mIRPropertyElementTypeScope.getPropertyTypeIterator();
        while (iterator.hasNext()) {
            mIRPropertyType2 = iterator.next();
            if (mIRPropertyType2.getName().compareTo(string) != 0 || mIRPropertyType2.getUsage().compareTo(string2) != 0 || mIRPropertyType2.getGroup().compareTo(string3) != 0) continue;
            if (mIRPropertyType2.getDesignLevel() == 0 || mIRPropertyType2.getDesignLevel() == by) {
                return mIRPropertyType2;
            }
            if (by != 0) continue;
            mIRPropertyType = mIRPropertyType2;
        }
        if (mIRPropertyType != null) {
            return mIRPropertyType;
        }
        if (bl) {
            mIRPropertyType = new MIRPropertyType();
            mIRPropertyType.setName(string);
            mIRPropertyType.setDesignLevel(by);
            mIRPropertyType.setUsage(string2);
            mIRPropertyType.setGroup(string3);
            mIRPropertyType.setDataType(string4);
            mIRPropertyType.addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            if (string5 != null && string5.length() != 0) {
                mIRPropertyType.setInitialValue(string5);
            }
            return mIRPropertyType;
        }
        return null;
    }

    static MIRPropertyElementTypeScope fetchPropertyElementTypeScope(MIRObject mIRObject, short s, boolean bl) {
        MIRPropertyElementTypeScope mIRPropertyElementTypeScope = null;
        Iterator<MIRPropertyElementTypeScope> iterator = null;
        if (mIRObject instanceof MIRModel) {
            iterator = ((MIRModel)mIRObject).getPropertyElementTypeScopeIterator();
        } else if (mIRObject instanceof MIRRepository) {
            iterator = ((MIRRepository)mIRObject).getPropertyElementTypeScopeIterator();
        } else if (mIRObject instanceof MIRMappingModel) {
            iterator = ((MIRMappingModel)mIRObject).getPropertyElementTypeScopeIterator();
        } else {
            return null;
        }
        while (iterator.hasNext()) {
            mIRPropertyElementTypeScope = iterator.next();
            if (mIRPropertyElementTypeScope.getScope() != s) continue;
            return mIRPropertyElementTypeScope;
        }
        if (bl) {
            mIRPropertyElementTypeScope = new MIRPropertyElementTypeScope();
            mIRPropertyElementTypeScope.setScope(s);
            if (mIRObject instanceof MIRModel) {
                ((MIRModel)mIRObject).addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            } else if (mIRObject instanceof MIRRepository) {
                ((MIRRepository)mIRObject).addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            }
            return mIRPropertyElementTypeScope;
        }
        return null;
    }

    static String getPropertyValueValue(MIRPropertyType mIRPropertyType, MIRElement mIRElement) {
        MIRPropertyValue mIRPropertyValue = MIRExpressionAnalyzerHelper.getPropertyValue(mIRPropertyType, mIRElement);
        if (mIRPropertyValue != null) {
            return mIRPropertyValue.getValue();
        }
        return new String("");
    }

    static MIRPropertyValue getPropertyValue(MIRPropertyType mIRPropertyType, MIRElement mIRElement) {
        Iterator<MIRPropertyValue> iterator = mIRElement.getPropertyValueIterator();
        while (iterator.hasNext()) {
            MIRPropertyValue mIRPropertyValue = iterator.next();
            if (mIRPropertyValue.getPropertyType() != mIRPropertyType) continue;
            return mIRPropertyValue;
        }
        return null;
    }

    static MIRPropertyValue setPropertyValue(MIRPropertyType mIRPropertyType, String string, MIRElement mIRElement) {
        MIRPropertyValue mIRPropertyValue = MIRExpressionAnalyzerHelper.getPropertyValue(mIRPropertyType, mIRElement);
        if (mIRPropertyValue == null) {
            if (!mIRPropertyType.getInitialValue().equals(string)) {
                mIRPropertyValue = new MIRPropertyValue();
                mIRPropertyValue.setValue(string);
                mIRPropertyValue.addPropertyType(mIRPropertyType);
                mIRPropertyValue.addElement(mIRElement);
            }
        } else {
            mIRPropertyValue.setValue(string);
        }
        return mIRPropertyValue;
    }
}

