/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.dav.client;

import com.sas.svcs.dav.client.ContentID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ContentDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TEXT_CONTENT = "PLAIN_TEXT";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final String CHARSET_SEPARATOR = "charset=";
    private ContentID id;
    private int subID;
    private String type;
    private String charset;
    private String path;
    private String fileName;
    private String docType;
    private transient InputStream streamContents;
    private transient Serializable serializableContents;
    private transient String stringContents;
    private byte[] contents;

    public ContentID getTypedId() {
        return this.id;
    }

    public void setTypedId(ContentID id) {
        this.id = id;
    }

    public void setId(Integer id) {
        this.id = new ContentID(id);
    }

    public byte[] getContents() {
        return this.contents;
    }

    public Serializable getSerializable() {
        if (null != this.serializableContents) {
            return this.serializableContents;
        }
        if (null != this.contents) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.contents);
                ObjectInputStream ois = new ObjectInputStream(bais);
                return (Serializable)ois.readObject();
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Unable to convert byte[] contents to serialized object.", e);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to convert byte[] contents to serialized object.", e);
            }
        }
        return null;
    }

    public InputStream getInputStream() {
        if (null != this.streamContents) {
            return this.streamContents;
        }
        if (null != this.contents) {
            return new ByteArrayInputStream(this.contents);
        }
        return null;
    }

    public String getContentAsString() {
        if (null != this.stringContents) {
            return this.stringContents;
        }
        if (null != this.contents) {
            try {
                if (this.charset == null || this.charset.equals("")) {
                    return new String(this.contents, DEFAULT_CHARSET);
                }
                return new String(this.contents, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.contents);
            }
        }
        return null;
    }

    public void setContents(Object o) {
        if (o instanceof byte[]) {
            this.setContents((byte[])o);
        } else if (o instanceof InputStream) {
            this.setContentsAsInputStream((InputStream)o);
        } else if (o instanceof String) {
            this.setContentsAsString((String)o);
        } else if (o instanceof Serializable) {
            this.setContentsAsSerializable((Serializable)o);
        } else {
            throw new IllegalArgumentException("setContents was called with an invalid type; use  byte[], InputStream, String, or Serializable.");
        }
    }

    public void setContents(byte[] contents) {
        this.serializableContents = null;
        this.stringContents = null;
        this.streamContents = null;
        this.contents = contents;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getType() {
        return this.type;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public void setType(String type) {
        String split;
        this.type = type;
        if (this.type != null && this.type.contains("charset=") && (split = this.type.split("charset=")[1]) != null && !split.equals("")) {
            this.charset = split;
        }
    }

    public String getPath() {
        return this.path == null ? this.type : this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        if (this.id == null) {
            return this.fileName;
        }
        return this.fileName == null ? this.id.toString() : this.fileName;
    }

    public int getSubID() {
        return this.subID;
    }

    public void setSubID(int subID) {
        this.subID = subID;
    }

    public void setContentsAsInputStream(InputStream is) {
        this.serializableContents = null;
        this.stringContents = null;
        this.contents = null;
        this.streamContents = is;
    }

    public void setContentsAsString(String input) {
        this.serializableContents = null;
        this.contents = null;
        this.streamContents = null;
        this.stringContents = input;
    }

    public void setContentsAsSerializable(Serializable object) {
        this.contents = null;
        this.stringContents = null;
        this.streamContents = null;
        this.serializableContents = object;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (null != this.serializableContents) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream ois = new ObjectOutputStream(baos);
                ois.writeObject(this.serializableContents);
                this.contents = baos.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to convert provided object into transportable byte array.", e);
            }
        }
        if (null != this.stringContents) {
            this.contents = this.charset == null || this.charset.equals("") ? this.stringContents.getBytes(DEFAULT_CHARSET) : this.stringContents.getBytes(this.charset);
        } else if (null != this.streamContents) {
            try {
                int len;
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
                byte[] buf = new byte[1024];
                while ((len = this.streamContents.read(buf)) > 0) {
                    byteStream.write(buf, 0, len);
                }
                this.contents = byteStream.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to convert provided input stream into transportable byte array.", e);
            }
        }
        out.defaultWriteObject();
    }
}

