/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parsing;

import MITI.bridges.bridgelib.parsers.DiParser;
import MITI.expression.analyzer.LookupOptions;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryFilter;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRTransformationDataSet;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class SqlQueryClassifierMapParser
extends DiParser {
    private boolean isRegexStar = false;

    public SqlQueryClassifierMapParser(MIRDiModel mIRDiModel, int n, int n2) {
        super(MIRLogger.getLogger(), mIRDiModel, null, n, n2);
    }

    private MIRSqlQuery getSqlQuery() {
        MIRObject mIRObject;
        MIRSqlQuery mIRSqlQuery = null;
        MIRClassifierMap mIRClassifierMap = this.getClassifierMap();
        if (mIRClassifierMap != null && (mIRObject = mIRClassifierMap.getParent()) != null && mIRObject.isInstanceOf((short)318)) {
            mIRSqlQuery = (MIRSqlQuery)mIRObject;
        }
        return mIRSqlQuery;
    }

    @Override
    public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(new LookupOptions(mIRElementNode, false), collection, collection2);
    }

    @Override
    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        List<MIRElementNamePart> list;
        MIRElementNode mIRElementNode = lookupOptions.getNode();
        if (mIRElementNode.getDestinationElementType() == 75) {
            MIRSqlQuery mIRSqlQuery = this.getSqlQuery();
            if (mIRSqlQuery != null) {
                MIRElementNamePart mIRElementNamePart;
                List<MIRElementNamePart> list2 = mIRElementNode.getElementNamePartByPosition();
                MIRElementNamePart mIRElementNamePart2 = mIRElementNamePart = list2.size() - 1 >= 0 ? list2.get(list2.size() - 1) : null;
                if (mIRElementNamePart == null) {
                    return;
                }
                MIRTransformationDataSet mIRTransformationDataSet = this.getItem(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), mIRSqlQuery.getInputTransformationDataSets());
                MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, true);
                if (mIRTransformationDataSet == null) {
                    mIRTransformationDataSet = new MIRQueryTable();
                    mIRTransformationDataSet.setName(mIRElementNamePart.getName());
                    mIRSqlQuery.addInputTransformationDataSet(mIRTransformationDataSet);
                    if (mIRConnectionPackage != null) {
                        mIRConnectionPackage.addClassifier(mIRTransformationDataSet);
                    }
                    this.setCollationLineageOption(mIRTransformationDataSet, mIRElementNamePart.getQuoted());
                }
                collection2.add(mIRTransformationDataSet);
            }
        } else if (mIRElementNode.getDestinationElementType() == 77 && (list = mIRElementNode.getElementNamePartByPosition()).size() > 0) {
            MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
            Collection<MIRFeature> collection3 = this.getFeatures(mIRElementNamePart, collection);
            if (collection3.isEmpty()) {
                boolean bl = collection.size() > 1;
                for (MIRClassifier mIRClassifier : collection) {
                    MIRQueryColumn mIRQueryColumn = new MIRQueryColumn();
                    mIRQueryColumn.setName(mIRElementNamePart.getName());
                    if (this.isRegexStar(mIRElementNamePart.getQuoted())) {
                        mIRQueryColumn.setLineageOption(256);
                    }
                    if (bl) {
                        mIRQueryColumn.setLineageOption(1);
                    }
                    mIRClassifier.addFeature(mIRQueryColumn);
                    this.setCollationLineageOption(mIRQueryColumn, mIRElementNamePart.getQuoted());
                    collection3.add(mIRQueryColumn);
                }
            } else if (collection3.size() == 1 && this.isRegexStar(mIRElementNamePart.getQuoted())) {
                MIRFeature mIRFeature = collection3.iterator().next();
                mIRElementNamePart.setName(mIRFeature.getName());
                mIRElementNamePart.setQuoted(mIRFeature.hasLineageOption(4096));
            }
            collection2.addAll(collection3);
        }
    }

    @Override
    public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        MIRFeature mIRFeature = null;
        if (this.isRegexStar(lookupOptions.isQuoted()) || lookupOptions.hasStar()) {
            for (MIRFeature mIRFeature2 : mIRClassifier.getFeatures()) {
                if (mIRFeature2.getPosition() != lookupOptions.getPosition() || !mIRFeature2.hasLineageOption(256)) continue;
                mIRFeature = mIRFeature2;
                break;
            }
            if (mIRFeature == null) {
                mIRFeature = new MIRQueryColumn();
                mIRFeature.setName(lookupOptions.getName());
                mIRFeature.setPosition((short)lookupOptions.getPosition());
                mIRFeature.setLineageOption(256);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
            }
        } else {
            String string = lookupOptions.getName();
            if (lookupOptions.isPositionBased()) {
                for (MIRFeature mIRFeature3 : mIRClassifier.getFeatures()) {
                    if (mIRFeature3.getPosition() != lookupOptions.getPosition()) continue;
                    mIRFeature = mIRFeature3;
                    break;
                }
            } else {
                mIRFeature = this.getItem(string, lookupOptions.isQuoted(), mIRClassifier.getFeatures());
            }
            if (mIRFeature == null) {
                mIRFeature = new MIRQueryColumn();
                mIRFeature.setName(string);
                mIRFeature.setPosition((short)lookupOptions.getPosition());
                if (lookupOptions.isPositionBased()) {
                    mIRFeature.setLineageOption(512);
                }
                mIRClassifier.addFeatureUniqueName(mIRFeature);
            }
        }
        return mIRFeature;
    }

    @Override
    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        MIRFeature mIRFeature = mIRClassifier.getFeature("SQL CONDITION");
        if (mIRFeature == null || !mIRFeature.isInstanceOf((short)333)) {
            MIRQueryFilter mIRQueryFilter = new MIRQueryFilter();
            mIRQueryFilter.setName("SQL CONDITION");
            mIRClassifier.addFeatureUniqueName(mIRQueryFilter, '_');
            mIRQueryFilter.setPosition((short)Short.MAX_VALUE);
            mIRFeature = mIRQueryFilter;
        }
        return mIRFeature;
    }

    @Override
    public void setDstClassifier(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list;
        String string;
        MIRTransformationDataSet mIRTransformationDataSet;
        MIRSqlQuery mIRSqlQuery = this.getSqlQuery();
        if (mIRSqlQuery != null && (mIRTransformationDataSet = mIRSqlQuery.getOutputTransformationDataSet(string = (list = mIRElementNode.getElementNamePartByPosition()).size() - 1 >= 0 ? list.get(list.size() - 1).getName() : "")) == null) {
            mIRTransformationDataSet = new MIRQueryTable();
            mIRTransformationDataSet.setName(string);
            mIRSqlQuery.addOutputTransformationDataSet(mIRTransformationDataSet);
        }
    }

    @Override
    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            return false;
        }
        if (mIRClassifier.hasLineageOption(2048)) {
            return true;
        }
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (!mIRFeature.hasLineageOption(512) && !mIRFeature.hasLineageOption(256)) continue;
            return true;
        }
        MIRQueryColumn mIRQueryColumn = mIRClassifier instanceof MIRQueryTable ? new MIRQueryColumn() : new MIRQueryColumn();
        mIRQueryColumn.setName("*");
        mIRQueryColumn.setLineageOption(256);
        mIRClassifier.addFeature(mIRQueryColumn);
        return true;
    }

    @Override
    public boolean isMultiStatement() {
        return false;
    }

    @Override
    protected MIRClassifier getDstClassifier(MIRElementNode mIRElementNode) {
        return null;
    }

    @Override
    public boolean supportRegexColumns() {
        return true;
    }

    private Collection<MIRFeature> getFeatures(MIRElementNamePart mIRElementNamePart, Collection<MIRClassifier> collection) {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        if (mIRElementNamePart == null) {
            return arrayList;
        }
        if (!this.isRegexStar(mIRElementNamePart.getQuoted())) {
            return this.getFeatures(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), collection);
        }
        Pattern pattern = Pattern.compile(mIRElementNamePart.getName());
        for (MIRClassifier mIRClassifier : collection) {
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                if (!pattern.matcher(mIRFeature.getName()).matches()) continue;
                arrayList.add(mIRFeature);
            }
        }
        return arrayList;
    }

    private boolean isRegexStar(boolean bl) {
        return this.isRegexStar;
    }

    public void setIsRegexStar(boolean bl) {
        this.isRegexStar = bl;
    }
}

