/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.BasicParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.INode;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlParameterFile
extends BasicParameterFile
implements IParameterFile {
    @Override
    public void read(InputStream inputStream, IParameterModel iParameterModel) {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(inputStream);
        for (Map.Entry entry : map.entrySet()) {
            INode iNode;
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Map) {
                iNode = iParameterModel.getDomain(string);
                if (iNode == null) {
                    iNode = iParameterModel.createDomain(string, "");
                    iParameterModel.addDomain((IDomain)iNode);
                }
                Map map2 = (Map)v;
                for (Map.Entry entry2 : map2.entrySet()) {
                    INode iNode2;
                    Object k = entry2.getKey();
                    Object v2 = entry2.getValue();
                    if (v2 instanceof Map) {
                        iNode2 = iNode.getDomain(k.toString());
                        if (iNode2 == null) {
                            iNode2 = iParameterModel.createDomain(k.toString(), "");
                            iNode.addDomain((IDomain)iNode2);
                        }
                        Map map3 = (Map)v2;
                        for (Map.Entry entry3 : map3.entrySet()) {
                            Object k2 = entry3.getKey();
                            Object v3 = entry3.getValue();
                            IParameter iParameter = iNode2.getParameter(k2.toString());
                            if (iParameter != null) continue;
                            iParameter = iParameterModel.createParameter(k2.toString(), v3.toString());
                            iNode2.addParameter(iParameter);
                        }
                        continue;
                    }
                    iNode2 = iNode.getParameter(k.toString());
                    if (iNode2 != null) continue;
                    iNode2 = iParameterModel.createParameter(k.toString(), v2.toString());
                    iNode.addParameter((IParameter)iNode2);
                }
                continue;
            }
            iNode = iParameterModel.createParameter(string, v.toString());
            iParameterModel.addParameter((IParameter)iNode);
        }
    }

    @Override
    protected void printDomainName(PrintWriter printWriter, String string) {
        if (!YamlParameterFile.isNullOrEmpty(string)) {
            printWriter.println(this.canonizeName(string) + ":");
        }
    }

    private String canonizeName(String string) {
        if (string.contains(".") || string.contains(" ") || string.contains(":") || string.contains("$") || string.contains("#")) {
            return "'" + string + "'";
        }
        return string;
    }

    @Override
    protected String printValue(Object object, int n) {
        String string = "";
        if (object instanceof String) {
            String string2 = (String)object;
            string = ("|-" + System.lineSeparator() + string2).replaceAll(System.lineSeparator(), System.lineSeparator() + YamlParameterFile.getIndentString(n + 1));
        } else {
            string = object.toString();
        }
        return string;
    }

    @Override
    protected void printParameterName(PrintWriter printWriter, String string) {
        if (!YamlParameterFile.isNullOrEmpty(string)) {
            printWriter.print(this.canonizeName(string) + ": ");
        }
    }
}

