/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.AbstractNode;
import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParameterModel
implements IParameterModel {
    List<IDomain> domains = new ArrayList<IDomain>();

    @Override
    public IDomain getDomain(String string) {
        return this.domains.stream().filter(iDomain -> iDomain.getName().equals(string)).findFirst().orElse(null);
    }

    @Override
    public void addDomain(IDomain iDomain) {
        this.domains.add(iDomain);
        iDomain.setModel(this);
    }

    @Override
    public IDomain removeDomain(String string) {
        IDomain iDomain = this.getDomain(string);
        if (iDomain != null) {
            this.domains.remove(iDomain);
            iDomain.setModel(null);
        }
        return iDomain;
    }

    @Override
    public IDomain createDomain(String string) {
        return this.createDomain(string, "");
    }

    @Override
    public IDomain createDomain(String string, String string2) {
        return new Domain(string, string2);
    }

    @Override
    public IParameter getParameter(String string) {
        IDomain iDomain = this.getDomain("");
        return iDomain != null ? iDomain.getParameter(string) : null;
    }

    @Override
    public void addParameter(IParameter iParameter) {
        IDomain iDomain = iParameter.getDomain();
        if (iDomain == null && (iDomain = this.getDomain("")) == null) {
            iDomain = this.createDomain("");
        }
        iParameter.setDomain(iDomain);
        if (iDomain != null && !this.domains.contains(iDomain)) {
            this.domains.add(iDomain);
        }
    }

    @Override
    public IParameter removeParameter(String string) {
        IParameter iParameter = this.getParameter(string);
        if (iParameter != null) {
            iParameter.getDomain().removeParameter(iParameter);
        }
        return iParameter;
    }

    @Override
    public IParameter createParameter(String string, String string2) {
        return this.createParameter(string, string2, "");
    }

    @Override
    public IParameter createParameter(String string, String string2, String string3) {
        return new Parameter(string, string2, string3);
    }

    @Override
    public List<IDomain> getDomains() {
        return this.domains;
    }

    @Override
    public int getDomainCount() {
        return this.domains.size();
    }

    @Override
    public List<IParameter> getParameters() {
        ArrayList<IParameter> arrayList = new ArrayList<IParameter>();
        IDomain iDomain = this.getDomain("");
        if (iDomain != null) {
            arrayList.addAll(iDomain.getParameters());
        }
        return arrayList;
    }

    @Override
    public void addParameter(String string, String string2) {
        this.addParameter(string, string2, "");
    }

    @Override
    public void addParameter(String string, String string2, String string3) {
        IParameter iParameter = this.createParameter(string, string2, string3);
        this.addParameter(iParameter);
    }

    public class Domain
    extends AbstractNode
    implements IDomain {
        private List<IParameter> parameters = new ArrayList<IParameter>();
        private List<IDomain> domains = new ArrayList<IDomain>();

        Domain(String string, String string2) {
            this.setName(string);
            this.setDescription(string2);
        }

        @Override
        public IDomain setDomain(IDomain iDomain) {
            if (iDomain == null) {
                return iDomain;
            }
            if (this.domain == iDomain) {
                return iDomain;
            }
            IDomain iDomain2 = this.domain;
            if (iDomain2 != null) {
                iDomain2.removeDomain(this);
            }
            this.domain = iDomain;
            if (iDomain != null) {
                iDomain.addDomain(this);
            }
            return iDomain2;
        }

        @Override
        public void addParameter(IParameter iParameter) {
            if (!this.parameters.contains(iParameter)) {
                this.parameters.add(iParameter);
                iParameter.setDomain(this);
            }
        }

        @Override
        public IParameter getParameter(String string) {
            return this.parameters.stream().filter(iParameter -> iParameter.getName().equals(string)).findFirst().orElse(null);
        }

        @Override
        public void removeParameter(IParameter iParameter) {
            if (iParameter != null) {
                this.parameters.remove(iParameter);
            }
        }

        @Override
        public IParameter removeParameter(String string) {
            IParameter iParameter = this.getParameter(string);
            this.removeParameter(iParameter);
            return iParameter;
        }

        @Override
        public IParameter replaceParameter(String string, IParameter iParameter) {
            IParameter iParameter2 = this.removeParameter(string);
            this.addParameter(iParameter);
            return iParameter2;
        }

        @Override
        public void addDomain(IDomain iDomain) {
            if (!this.domains.contains(iDomain)) {
                this.domains.add(iDomain);
                iDomain.setModel(this.getModel());
            }
        }

        @Override
        public IDomain getDomain(String string) {
            return this.domains.stream().filter(iDomain -> iDomain.getName().equals(this.name)).findFirst().orElse(null);
        }

        @Override
        public void removeDomain(IDomain iDomain) {
            if (iDomain != null) {
                this.domains.remove(iDomain);
            }
        }

        @Override
        public IDomain removeDomain(String string) {
            IDomain iDomain = this.getDomain(string);
            this.removeDomain(iDomain);
            return iDomain;
        }

        @Override
        public IDomain replaceDomain(String string, IDomain iDomain) {
            IDomain iDomain2 = this.removeDomain(string);
            this.domains.add(iDomain);
            return iDomain2;
        }

        @Override
        public Collection<IParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public int getParameterCount() {
            return this.parameters.size();
        }

        @Override
        public Collection<IDomain> getDomains() {
            return this.domains;
        }
    }

    public static class Parameter
    extends AbstractNode
    implements IParameter {
        private Boolean isInternal;
        private Object value;

        Parameter(String string, String string2, String string3) {
            this.setName(string);
            this.setDescription(string3);
            this.setValue(string2);
        }

        @Override
        public IDomain setDomain(IDomain iDomain) {
            if (iDomain == null) {
                return iDomain;
            }
            if (iDomain == this.domain) {
                return iDomain;
            }
            IDomain iDomain2 = this.domain;
            if (iDomain2 != null) {
                iDomain2.removeParameter(this);
            }
            this.domain = iDomain;
            if (iDomain != null) {
                iDomain.addParameter(this);
            }
            return iDomain2;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        @Override
        public boolean isInternal() {
            return this.isInternal;
        }

        @Override
        public void setIsInternal(boolean bl) {
            this.isInternal = bl;
        }
    }
}

