/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import MITI.EtlBridgeLib.parameterProcessor.ParameterModel;
import MITI.EtlBridgeLib.parameterProcessor.YamlParameterFile;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRParameterContext;
import MITI.sdk.MIRParameterDefinition;
import MITI.sdk.MIR_Object;
import MITI.sdk.util.ObjectCollector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

public class ParameterFileWriter {
    protected String getModelFilePath(MIRDiModel mIRDiModel) {
        return mIRDiModel.getName();
    }

    protected boolean isPrintableParameter(MIRParameterDefinition mIRParameterDefinition) {
        return true;
    }

    public void printModelParameters(MIRDiModel mIRDiModel, File file) {
        ParameterModel parameterModel = new ParameterModel();
        ObjectCollector objectCollector = new ObjectCollector(new short[]{304});
        Set set = objectCollector.collect(mIRDiModel);
        for (Comparable<MIR_Object> comparable : set) {
            if (!this.isPrintableParameter((MIRParameterDefinition)comparable)) continue;
            this.loadParameterDefinition((MIRParameterDefinition)comparable, parameterModel);
        }
        if (file != null) {
            Path path = Paths.get(file.toString(), this.getModelFilePath(mIRDiModel) + ".yaml");
            try {
                Comparable<MIR_Object> comparable;
                comparable = path.toFile();
                File file2 = ((File)comparable).getParentFile();
                file2.mkdirs();
                ((File)comparable).createNewFile();
                try (FileOutputStream fileOutputStream = new FileOutputStream((File)comparable);){
                    new YamlParameterFile().write(parameterModel, fileOutputStream);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected String getParameterName(MIRParameterDefinition mIRParameterDefinition) {
        return mIRParameterDefinition.getName();
    }

    protected IParameter createParameter(MIRParameterDefinition mIRParameterDefinition, IParameterModel iParameterModel) {
        return iParameterModel.createParameter(this.getParameterName(mIRParameterDefinition), mIRParameterDefinition.getValue(), mIRParameterDefinition.getDescription());
    }

    protected String getDomainName(MIRParameterDefinition mIRParameterDefinition) {
        String string = "";
        for (MIRParameterContext mIRParameterContext = mIRParameterDefinition.getParameterContext(); mIRParameterContext != null; mIRParameterContext = mIRParameterContext.getParentParameterContext()) {
            string = string.isEmpty() ? mIRParameterContext.getName() : mIRParameterContext.getName() + "." + string;
        }
        return string;
    }

    protected void loadParameterDefinition(MIRParameterDefinition mIRParameterDefinition, IParameterModel iParameterModel) {
        IParameter iParameter;
        String string = this.getDomainName(mIRParameterDefinition);
        IDomain iDomain = iParameterModel.getDomain(string);
        if (iDomain == null) {
            iDomain = iParameterModel.createDomain(string, this.getDomainDescription(mIRParameterDefinition));
            iParameterModel.addDomain(iDomain);
        }
        if ((iParameter = this.createParameter(mIRParameterDefinition, iParameterModel)) != null) {
            iParameter.setDomain(iDomain);
            iParameterModel.addParameter(iParameter);
        }
    }

    protected String getDomainDescription(MIRParameterDefinition mIRParameterDefinition) {
        return "";
    }

    protected boolean isInternalParameter(MIRParameterDefinition mIRParameterDefinition) {
        return false;
    }
}

