/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.INIParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import MITI.EtlBridgeLib.parameterProcessor.ParameterModel;
import MITI.EtlBridgeLib.parameterProcessor.YamlParameterFile;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRNamedParameterContext;
import MITI.sdk.MIRParameterDefinition;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ParameterFileReader {
    public static final String NAME_PART_DELIMETER = ".";
    private static Map<String, Class<? extends IParameterFile>> fileExtensionHandlers = new HashMap<String, Class<? extends IParameterFile>>();
    private Set<MIRDiModel> diModels;
    private File rootFolder;

    public static void putExtenstionHandler(String string, Class<? extends IParameterFile> clazz) {
        fileExtensionHandlers.put(string, clazz);
    }

    private static IParameterFile getExtensionHandler(String string) {
        Class clazz = fileExtensionHandlers.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().equals(string.toLowerCase())).map(entry -> (Class)entry.getValue()).findFirst().orElse(null);
        IParameterFile iParameterFile = null;
        if (clazz != null) {
            try {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                iParameterFile = (IParameterFile)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                BLIB.DBG_DEBUG.log("Failed to create instance for type " + string, exception);
            }
        }
        return iParameterFile;
    }

    public void readModelParameters(Set<MIRDiModel> set, File file) {
        if (set == null || file == null || !file.exists()) {
            return;
        }
        this.diModels = set;
        this.rootFolder = file;
        this.traverseFiles(file);
        this.traverseTree(file);
    }

    private void traverseTree(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            this.traverseFiles(file2);
            this.traverseTree(file2);
        }
    }

    private void traverseFiles(File file) {
        File[] fileArray = file.listFiles(this.getFileFilter());
        if (fileArray.length > 0) {
            for (File file2 : fileArray) {
                IParameterModel iParameterModel = this.readParameterModel(file2);
                String string = file2.getAbsolutePath().substring(this.rootFolder.getAbsolutePath().length());
                ParameterFileDescriptor parameterFileDescriptor = new ParameterFileDescriptor(file2.getAbsolutePath(), string);
                this.onParameterModelRead(parameterFileDescriptor, iParameterModel, this.diModels);
            }
        }
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                return file.isFile() && (string.endsWith(".txt") || string.endsWith(".prm") || string.endsWith(".csv") || string.endsWith(".yaml"));
            }
        };
    }

    public static String getExtension(String string) {
        int n;
        int n2;
        String string2 = "";
        if (string != null && (n2 = string.lastIndexOf(NAME_PART_DELIMETER)) > (n = string.lastIndexOf(File.separator))) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    public static String getFileName(String string) {
        String string2 = string;
        if (string != null) {
            int n;
            int n2 = string2.lastIndexOf(NAME_PART_DELIMETER);
            if (n2 > 0) {
                string2 = string2.substring(0, n2);
            }
            if ((n = string.lastIndexOf(File.separator)) >= 0) {
                string2 = string2.substring(n + 1);
            }
        }
        return string2;
    }

    private IParameterModel readParameterModel(File file) {
        BLIB.DBG_DEBUG.log("Reading file " + file.getAbsolutePath());
        IParameterFile iParameterFile = ParameterFileReader.getExtensionHandler(ParameterFileReader.getExtension(file.getName()));
        ParameterModel parameterModel = new ParameterModel();
        if (iParameterFile != null) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                iParameterFile.read(fileInputStream, parameterModel);
            }
            catch (Exception exception) {
                BLIB.DBG_DEBUG.log("Failed to read file " + file.getAbsolutePath(), exception);
            }
        }
        return parameterModel;
    }

    protected void onParameterModelRead(ParameterFileDescriptor parameterFileDescriptor, IParameterModel iParameterModel, Set<MIRDiModel> set) {
        for (IDomain iNode : iParameterModel.getDomains()) {
            this.onDomainRead(parameterFileDescriptor, iNode, set);
        }
        for (IParameter iParameter : iParameterModel.getParameters()) {
            this.processParameter(parameterFileDescriptor, iParameter, this.getTargetModels(parameterFileDescriptor, iParameter, set));
        }
    }

    protected void onDomainRead(ParameterFileDescriptor parameterFileDescriptor, IDomain iDomain, Set<MIRDiModel> set) {
        for (IParameter iNode : iDomain.getParameters()) {
            this.processParameter(parameterFileDescriptor, iNode, this.getTargetModels(parameterFileDescriptor, iNode, set));
        }
        for (IDomain iDomain2 : iDomain.getDomains()) {
            this.onDomainRead(parameterFileDescriptor, iDomain2, set);
        }
    }

    protected Collection<MIRDiModel> getTargetModels(ParameterFileDescriptor parameterFileDescriptor, IParameter iParameter, Collection<MIRDiModel> collection) {
        HashSet<MIRDiModel> hashSet = new HashSet<MIRDiModel>();
        MIRDiModel mIRDiModel2 = collection.stream().filter(mIRDiModel -> mIRDiModel.getName().equals(parameterFileDescriptor.fileName)).findFirst().orElse(null);
        if (mIRDiModel2 != null) {
            hashSet.add(mIRDiModel2);
        }
        return hashSet;
    }

    protected void processParameter(ParameterFileDescriptor parameterFileDescriptor, IParameter iParameter, Collection<MIRDiModel> collection) {
        for (MIRDiModel mIRDiModel : collection) {
            String[] stringArray = this.getNameParts(iParameter);
            Object object = mIRDiModel;
            for (int i = 0; i < stringArray.length && object != null; ++i) {
                Object object2;
                Object object3 = null;
                if (i < stringArray.length - 1) {
                    object2 = stringArray[i];
                    MIRNamedParameterContext mIRNamedParameterContext = new MIRNamedParameterContext();
                    mIRNamedParameterContext.setName((String)object2);
                    object3 = mIRNamedParameterContext;
                } else {
                    object3 = object2 = this.createParameterDefinition(parameterFileDescriptor, iParameter);
                }
                if (object3 == null || (object2 = this.addElement((MIRElement)object3, (MIRElement)object)) == null) continue;
                object = object2;
            }
        }
    }

    protected MIRElement addElement(MIRElement mIRElement, MIRElement mIRElement2) {
        if (mIRElement == null || mIRElement2 == null) {
            return null;
        }
        MIRDiModel mIRDiModel = null;
        MIRNamedParameterContext mIRNamedParameterContext = null;
        MIRNamedParameterContext mIRNamedParameterContext2 = null;
        MIRParameterDefinition mIRParameterDefinition = null;
        if (mIRElement2.getElementType() == 258) {
            mIRDiModel = (MIRDiModel)mIRElement2;
        } else if (mIRElement2.getElementType() == 302) {
            mIRNamedParameterContext = (MIRNamedParameterContext)mIRElement2;
        }
        if (mIRElement.getElementType() == 302) {
            mIRNamedParameterContext2 = (MIRNamedParameterContext)mIRElement;
        } else if (mIRElement.getElementType() == 304) {
            mIRParameterDefinition = (MIRParameterDefinition)mIRElement;
        }
        MIRElement mIRElement3 = null;
        if (mIRDiModel != null && mIRNamedParameterContext2 != null && (mIRElement3 = mIRDiModel.getParameterContext(mIRNamedParameterContext2.getName())) == null) {
            mIRDiModel.addParameterContext(mIRNamedParameterContext2);
            mIRElement3 = mIRNamedParameterContext2;
        }
        if (mIRDiModel != null && mIRParameterDefinition != null && (mIRElement3 = mIRDiModel.getParameterDefinition(mIRParameterDefinition.getName())) == null) {
            mIRDiModel.addParameterDefinition(mIRParameterDefinition);
            mIRElement3 = mIRParameterDefinition;
        }
        if (mIRNamedParameterContext != null && mIRNamedParameterContext2 != null && (mIRElement3 = mIRNamedParameterContext.getChildParameterContext(mIRNamedParameterContext2.getName())) == null) {
            mIRNamedParameterContext.addChildParameterContext(mIRNamedParameterContext2);
            mIRElement3 = mIRNamedParameterContext2;
        }
        if (mIRNamedParameterContext != null && mIRParameterDefinition != null && (mIRElement3 = mIRNamedParameterContext.getParameterDefinition(mIRParameterDefinition.getName())) == null) {
            mIRNamedParameterContext.addParameterDefinition(mIRParameterDefinition);
            mIRElement3 = mIRParameterDefinition;
        }
        if (((MIRElement)mIRElement3).getElementType() == 304 && mIRElement3 != mIRParameterDefinition) {
            ((MIRParameterDefinition)mIRElement3).setValue(mIRParameterDefinition.getValue());
        }
        return mIRElement3;
    }

    private String[] getNameParts(IParameter iParameter) {
        IDomain iDomain = iParameter.getDomain();
        String string = "";
        if (iDomain != null && !iDomain.getName().isEmpty()) {
            string = iDomain.getName() + NAME_PART_DELIMETER;
        }
        string = string + iParameter.getName();
        return string.split(Pattern.quote(NAME_PART_DELIMETER));
    }

    protected MIRParameterDefinition createParameterDefinition(ParameterFileDescriptor parameterFileDescriptor, IParameter iParameter) {
        MIRParameterDefinition mIRParameterDefinition = new MIRParameterDefinition();
        mIRParameterDefinition.setName(this.getParameterName(parameterFileDescriptor, iParameter));
        mIRParameterDefinition.setDescription(iParameter.getDescription());
        mIRParameterDefinition.setValue(iParameter.getValue() == null ? "" : iParameter.getValue().toString());
        return mIRParameterDefinition;
    }

    protected String getParameterName(ParameterFileDescriptor parameterFileDescriptor, IParameter iParameter) {
        String[] stringArray = this.getNameParts(iParameter);
        return stringArray[stringArray.length - 1];
    }

    static {
        fileExtensionHandlers.put("yaml", YamlParameterFile.class);
        fileExtensionHandlers.put("prm", INIParameterFile.class);
        fileExtensionHandlers.put("txt", INIParameterFile.class);
        fileExtensionHandlers.put("ini", INIParameterFile.class);
        fileExtensionHandlers.put("csv", INIParameterFile.class);
    }

    public static class ParameterFileDescriptor {
        public List<String> relativeFolders = new ArrayList<String>();
        public String fileName = "";
        public String fileExtension = "";
        public String absolutePath = "";
        public String relativePath = "";

        public ParameterFileDescriptor(String string2, String string3) {
            this.absolutePath = string2;
            this.relativePath = string3;
            int n = string3.lastIndexOf(File.separator);
            if (n > 0) {
                List<String> list = Arrays.asList(string3.substring(0, n).split(Pattern.quote(File.separator)));
                this.relativeFolders = list.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
            }
            this.fileExtension = ParameterFileReader.getExtension(string2);
            this.fileName = ParameterFileReader.getFileName(string3);
        }
    }
}

