/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.executionScript;

import MITI.MIRException;
import MITI.sdk.MIRDiDesignContent;
import MITI.sdk.MIRDiEmbedding;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIREmbeddedCallStep;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRParameterDefinition;
import MITI.sdk.mix.MIRMixManager;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.util.TreeSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public interface ExecutionScript {
    public static final String PARAMETERS_MODEL = "parameters_set.prm";

    default public void loadExecutionScriptFile(File file, MIRMixManager mIRMixManager) throws MIRException {
        JSONParser jSONParser = new JSONParser();
        Object object = null;
        try {
            object = jSONParser.parse((Reader)new FileReader(file));
        }
        catch (IOException | ParseException throwable) {
            throw new MIRException(throwable);
        }
        if (!(object instanceof JSONArray)) {
            throw new InvalidParameterException();
        }
        JSONArray jSONArray = (JSONArray)object;
        TreeSet<MIRDiDesignContent> treeSet = new TreeSet<MIRDiDesignContent>();
        for (Object object2 : jSONArray) {
            JSONObject jSONObject = (JSONObject)object2;
            String string = (String)jSONObject.get((Object)"executable");
            JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"instances");
            if (null == jSONArray2) continue;
            for (Object e : jSONArray2) {
                MIRDiDesignContent mIRDiDesignContent;
                MIRElement mIRElement;
                JSONObject jSONObject2 = (JSONObject)e;
                String string2 = (String)jSONObject2.get((Object)"name");
                if (null == string2 || string2.isEmpty() || null == (mIRElement = this.getExecution(string))) continue;
                String string3 = (String)jSONObject2.get((Object)"parameter_file");
                JSONArray jSONArray3 = (JSONArray)jSONObject2.get((Object)"parameters");
                MIRDiEmbedding mIRDiEmbedding = null;
                if (mIRElement.isInstanceOf((short)312)) {
                    mIRDiEmbedding = this.createInstance((MIRDiEmbedding)mIRElement, string2);
                } else if (mIRElement.isInstanceOf((short)278)) {
                    mIRDiDesignContent = this.createDesignActivity((MIRDiDesignContent)mIRElement);
                    treeSet.add(mIRDiDesignContent);
                    mIRDiEmbedding = this.createInstance((MIRDiDesignContent)mIRElement, mIRDiDesignContent, string2);
                }
                if (null == mIRDiEmbedding) continue;
                if (null != string3 && !string3.isEmpty() && null != (mIRDiDesignContent = this.getParameterModel(mIRDiEmbedding, string3))) {
                    mIRDiEmbedding.addParameterDiDesignContent(mIRDiDesignContent);
                    this.onSaveModel((MIRDiModel)mIRDiDesignContent.getModel());
                    mIRMixManager.saveModel(mIRDiDesignContent);
                }
                if (null != jSONArray3 && null != (mIRDiDesignContent = this.createParameterModel(PARAMETERS_MODEL, jSONArray3))) {
                    mIRDiEmbedding.addParameterDiDesignContent(mIRDiDesignContent);
                    MIRObject mIRObject = mIRDiEmbedding.getClientDiDesignContent().getParent();
                    if (mIRObject.isInstanceOf((short)157)) {
                        ((MIRFolder)mIRObject).addFolderContentUniqueName(mIRDiDesignContent);
                    }
                    this.onSaveModel((MIRDiModel)mIRDiDesignContent.getModel());
                    mIRMixManager.saveModel(mIRDiDesignContent);
                }
                this.onInstanceCreated(string, mIRDiEmbedding);
            }
        }
        for (MIRDiDesignContent mIRDiDesignContent : treeSet) {
            this.onSaveModel((MIRDiModel)mIRDiDesignContent.getModel());
            mIRMixManager.saveModel(mIRDiDesignContent);
        }
    }

    default public MIRDiDesignContent createParameterModel(String string, JSONArray jSONArray) {
        MIRDiDesignContent mIRDiDesignContent = new MIRDiDesignContent();
        mIRDiDesignContent.setName(string);
        MIRDiModel mIRDiModel = new MIRDiModel();
        mIRDiModel.setName(mIRDiDesignContent.getName());
        mIRDiDesignContent.addModel(mIRDiModel);
        for (Object e : jSONArray) {
            JSONObject jSONObject = (JSONObject)e;
            for (Object e2 : jSONObject.keySet()) {
                String string2 = (String)jSONObject.get(e2);
                MIRParameterDefinition mIRParameterDefinition = new MIRParameterDefinition();
                mIRParameterDefinition.setName((String)e2);
                mIRParameterDefinition.setValue(string2);
                mIRDiModel.addParameterDefinition(mIRParameterDefinition);
            }
        }
        return mIRDiDesignContent;
    }

    default public MIRDiEmbedding createInstance(MIRDiDesignContent mIRDiDesignContent, MIRDiDesignContent mIRDiDesignContent2, String string) {
        MIRDiEmbedding mIRDiEmbedding = new MIRDiEmbedding();
        mIRDiEmbedding.setName(string);
        mIRDiEmbedding.addSupplierDiDesignContent(mIRDiDesignContent);
        mIRDiEmbedding.setNativeType(mIRDiDesignContent.getNativeType());
        mIRDiDesignContent2.addClientOfDiEmbeddingUniqueName(mIRDiEmbedding);
        MIREmbeddedCallStep mIREmbeddedCallStep = new MIREmbeddedCallStep();
        mIREmbeddedCallStep.setName(mIRDiEmbedding.getName());
        mIREmbeddedCallStep.setNativeType(mIRDiEmbedding.getNativeType());
        ((MIRDiModel)mIRDiDesignContent2.getModel()).addActivityStep(mIREmbeddedCallStep);
        return mIRDiEmbedding;
    }

    default public MIRDiEmbedding createInstance(MIRDiEmbedding mIRDiEmbedding, String string) {
        MIRDiEmbedding mIRDiEmbedding2 = new MIRDiEmbedding();
        mIRDiEmbedding2.setName(string);
        mIRDiEmbedding2.addClientDiDesignContent(mIRDiEmbedding.getClientDiDesignContent());
        mIRDiEmbedding2.addSupplierDiDesignContent(mIRDiEmbedding.getSupplierDiDesignContent());
        mIRDiEmbedding2.setNativeType(mIRDiEmbedding.getNativeType());
        mIRDiEmbedding2.setDescription(mIRDiEmbedding.getName());
        return mIRDiEmbedding2;
    }

    default public MIRDiDesignContent createDesignActivity(MIRDiDesignContent mIRDiDesignContent) {
        String string = this.getDesignActivityName(mIRDiDesignContent);
        MIRFolder mIRFolder = (MIRFolder)mIRDiDesignContent.getParent();
        MIRDiDesignContent mIRDiDesignContent2 = (MIRDiDesignContent)mIRFolder.getFolderContent(string);
        if (null == mIRDiDesignContent2) {
            mIRDiDesignContent2 = new MIRDiDesignContent();
            mIRDiDesignContent2.setName(string);
            mIRDiDesignContent2.setNativeType(mIRDiDesignContent.getNativeType());
            MIRDiModel mIRDiModel = new MIRDiModel();
            mIRDiModel.setName(mIRDiDesignContent2.getName());
            mIRDiModel.setNativeType(mIRDiDesignContent2.getNativeType());
            mIRDiDesignContent2.addModel(mIRDiModel);
            mIRDiDesignContent2.setExecutable(true);
            mIRFolder.addFolderContent(mIRDiDesignContent2);
        }
        return mIRDiDesignContent2;
    }

    default public String getDesignActivityName(MIRDiDesignContent mIRDiDesignContent) {
        return mIRDiDesignContent.getName() + "_INSTANCES";
    }

    public MIRElement getExecution(String var1);

    public MIRDiDesignContent getParameterModel(MIRDiEmbedding var1, String var2);

    default public void onInstanceCreated(String string, MIRDiEmbedding mIRDiEmbedding) {
    }

    default public void onSaveModel(MIRDiModel mIRDiModel) {
    }
}

