/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

class Transformation
implements Drawable {
    double[] darray;
    int id;
    static final int LoadIdentity = 1;
    static final int Scale = 2;
    static final int Rotate = 3;
    static final int CenterRotate = 4;
    static final int Translate = 5;
    static final int PushMatrix = 6;
    static final int PopMatrix = 7;
    static final int LoadMatrix = 8;

    @Override
    public boolean isClipped() {
        return true;
    }

    Transformation(int id, double[] darr) {
        this.id = id;
        this.darray = darr;
    }

    @Override
    public boolean pick(Graphics gc, Rectangle pickmatrix) {
        return false;
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        return false;
    }

    @Override
    public Stack getNameList() {
        return null;
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        TransInfo tr = ch.trans;
        StateLite state = ch.getState();
        int render_mode = state.render_mode;
        Vector list = state.displaylist;
        switch (this.id) {
            case 1: {
                tr.LoadIdentity(render_mode, list);
                break;
            }
            case 2: {
                tr.Scale(this.darray[0], this.darray[1], render_mode, list);
                break;
            }
            case 3: {
                tr.Rotate(this.darray[0], render_mode, list);
                break;
            }
            case 4: {
                tr.Rotate(this.darray[0], this.darray[1], this.darray[2], render_mode, list);
                break;
            }
            case 5: {
                tr.Translate(this.darray[0], this.darray[1], render_mode, list);
                break;
            }
            case 6: {
                tr.PushMatrix(render_mode, list);
                break;
            }
            case 7: {
                tr.PopMatrix(render_mode, list);
                break;
            }
            case 8: {
                tr.LoadMatrix(this.darray, render_mode, list);
                break;
            }
            default: {
                System.out.println("Error: Unknown transformation found on displaylist");
            }
        }
        return true;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        return true;
    }
}

