/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.Matrix3;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.RasterText;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

class TextFan
implements Drawable {
    Point3 origin;
    Point3 oscr;
    Vector model = new Vector();
    boolean clip;
    int size = 0;
    boolean pickable;
    boolean optimized;
    Stack namelist;

    TextFan() {
    }

    void center(double x, double y) {
        this.origin = new Point3(x, y, 1.0);
    }

    void vertex(StateLite st, String str, double x, double y) {
        RasterText text = new RasterText(st, str, x, y);
        this.model.addElement(text);
        ++this.size;
        this.pickable = false;
    }

    void vertex(StateLite st, String str, double x, double y, boolean pickable) {
        RasterText text = new RasterText(st, str, x, y);
        text.setPickable(st, pickable);
        this.model.addElement(text);
        ++this.size;
        this.pickable = pickable;
    }

    void end(StateLite state) {
        ChannelLite ch;
        if (state.render_mode == 3) {
            boolean bl = this.optimized = state.render_mode == 3;
            if (this.optimized) {
                ch = state.ch;
                Matrix3 w2m = ch.trans.w2m;
                this.origin.postMultiply(w2m);
            }
        }
        this.oscr = new Point3();
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            ch = state.ch;
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
        }
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        StateLite state = ch.getState();
        if (state.render_mode == 1) {
            return !this.clip;
        }
        this.clip = false;
        TransInfo tr = ch.trans;
        this.oscr.copy(this.origin);
        if (this.optimized) {
            tr.Model2Screen(this.oscr);
        } else {
            tr.World2Screen(this.oscr);
        }
        if (state.capabilities[2]) {
            double rfac;
            double sint;
            double cost;
            double fac;
            double dist;
            double theta;
            double tempy;
            double tempx;
            Viewport view = tr.GetViewport();
            double lens = state.lensFactor;
            if (state.dirtyLensFlag) {
                view.computeLogR(lens);
                tr.computeRadialFactor(state.thetaLensFac);
                state.dirtyLensFlag = false;
            }
            double maxR = view.maxR;
            double logR = view.logR;
            if (state.capabilities[3] && tr.moved) {
                double PI = Math.PI;
                double thetaLens = tr.getRadialFactor(state.thetaLensFac);
                Point3 worg = tr.getWorldOrigin(state.thetaLensFac);
                tempx = this.oscr.x - worg.x;
                tempy = (this.oscr.y - worg.y) / view.aspect;
                theta = Math.atan2(tempy, tempx);
                dist = Math.sqrt(tempx * tempx + tempy * tempy);
                double relTheta = (theta + tr.movingDir) / PI;
                if (relTheta < -1.0) {
                    relTheta += 2.0;
                } else if (relTheta > 1.0) {
                    relTheta -= 2.0;
                }
                fac = relTheta < 0.0 ? -(thetaLens + 1.0) / (thetaLens - 1.0 / relTheta) : (relTheta > 0.0 ? (thetaLens + 1.0) / (thetaLens + 1.0 / relTheta) : relTheta);
                theta = fac * PI - tr.movingDir;
                cost = Math.cos(theta);
                sint = Math.sin(theta);
                this.oscr.x = dist * cost + worg.x;
                this.oscr.y = dist * sint * view.aspect + worg.y;
            }
            double newrad = (rfac = (fac = Math.log(lens * (dist = Math.sqrt((tempx = this.oscr.x - view.wby2) * tempx + (tempy = this.oscr.y / view.aspect - view.wby2) * tempy)) + 1.0)) / logR) < 1.0 ? rfac * maxR : maxR;
            theta = Math.atan2(tempy, tempx);
            cost = Math.cos(theta);
            sint = Math.sin(theta);
            this.oscr.x = newrad * cost + view.wby2;
            this.oscr.y = newrad * sint * view.aspect + view.hby2;
        }
        for (int i = 0; i < this.size; ++i) {
            RasterText tx = (RasterText)this.model.elementAt(i);
            tx.computeScreen(ch);
        }
        return !this.clip;
    }

    @Override
    public final boolean render(StateLite state, Graphics bgc) {
        if (this.clip) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            RasterText tx = (RasterText)this.model.elementAt(i);
            Point3 loc = tx.getLocation();
            bgc.setColor(tx.getLineColor());
            bgc.drawLine((int)this.oscr.x, (int)this.oscr.y, (int)loc.x, (int)loc.y);
            tx.render(state, bgc);
        }
        return true;
    }

    final int size() {
        return this.size();
    }

    @Override
    public boolean pick(Graphics gc, Rectangle pickmatrix) {
        if (!this.pickable) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            RasterText tx = (RasterText)this.model.elementAt(i);
            if (!tx.pick(gc, pickmatrix)) continue;
            this.namelist = tx.getNameList();
            return true;
        }
        return false;
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (!this.pickable) {
            return false;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            RasterText tx = (RasterText)this.model.elementAt(i);
            if (!tx.pick(gc, pickmatrix)) continue;
            this.namelist = tx.getNameList();
            return true;
        }
        return false;
    }

    @Override
    public Stack getNameList() {
        return this.namelist;
    }

    @Override
    public final boolean isClipped() {
        return this.clip;
    }
}

