/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.CompositeTextRectangle;
import com.sas.graphics.util.j2d.CompoundedText;
import com.sas.graphics.util.j2d.DisplayList;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.JLine;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.JRectangle;
import com.sas.graphics.util.j2d.LineFan;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.RasterImage;
import com.sas.graphics.util.j2d.RasterText;
import com.sas.graphics.util.j2d.Stipple;
import com.sas.graphics.util.j2d.TextFan;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;

class StateLite {
    protected boolean[] capabilities;
    protected boolean useGlobalRenderMode;
    ChannelLite ch;
    Color color;
    Color edgecolor;
    int fillmode;
    JPolygon pbuffer;
    TextFan tbuffer;
    Vector displaylist;
    Vector list;
    boolean primitive_mode = false;
    int render_mode;
    boolean textFlag;
    int lineWidth;
    int capStyle;
    int lensDirection = 0;
    protected boolean pickAllHits;
    protected boolean pickFullLine;
    Stack selectbuffer;
    Rectangle pickmatrix;
    Stack namelist;
    boolean namelist_used;
    boolean hit;
    Drawable phit;
    Font font;
    int halign;
    int valign;
    int rhalign;
    int rvalign;
    RasterText text;
    RasterImage rim;
    int outlineMode = 0;
    double lensFactor = 0.03;
    double thetaLensFac = 5.0;
    double minAngle = -Math.PI;
    double maxAngle = Math.PI;
    boolean dirtyLensFlag = true;
    double[] lensWorldAreaPercentages = null;
    double lensScreenAreaPercentage = 0.0;
    Point3 pt1 = new Point3();
    Point3 pt2 = new Point3();
    Point3 pt3 = new Point3();
    Point3 pt4 = new Point3();
    Point3 pt5 = new Point3();
    Point3 pt6 = new Point3();
    Point3 prevpt = null;
    int[] tempRasterInfo;
    int[] tempTextWidth;
    int[] wideLineX = new int[4];
    int[] wideLineY = new int[4];
    boolean border = true;
    int textBorderType = 3;
    Color textBorderColor = Color.white;
    int borderType = 1;
    Color borderColor = Color.black;
    Color textLineColor = Color.white;
    Color textHandleColor = Color.white;
    double textBorderCutoff = 1.0;
    double textCutoff = 0.4;
    double textSpreadCutoff = 1.0;
    Color textColor = Color.black;
    int[] stipplePattern;
    int[] stippleHistory = new int[2];
    boolean tempFlag = false;

    StateLite(ChannelLite ch) {
        this.list = new Vector();
        this.ch = ch;
        this.capabilities = new boolean[10];
        this.capabilities[0] = true;
        this.capabilities[1] = true;
        this.fillmode = 3;
        this.color = new Color(1.0f, 1.0f, 1.0f);
        this.edgecolor = new Color(0.0f, 0.0f, 0.0f);
        this.render_mode = 0;
        this.font = null;
        this.halign = 0;
        this.valign = 2;
        this.rhalign = 0;
        this.rvalign = 2;
        this.pickAllHits = false;
        this.pickFullLine = false;
        this.namelist = new Stack();
        this.namelist_used = false;
        this.lineWidth = 1;
        this.capStyle = 0;
        this.setStipple(1, -256);
        this.useGlobalRenderMode = false;
    }

    void CallList(ChannelLite ch, Graphics bgc, long lid, boolean rebuild) {
        int i;
        int size = this.list.size();
        if (size == 0) {
            return;
        }
        DisplayList dl = null;
        for (i = 0; i < size; ++i) {
            dl = (DisplayList)this.list.elementAt(i);
            if (lid == dl.id) break;
        }
        if (this.render_mode >= 3) {
            if (i == size) {
                dl = new DisplayList(lid);
                this.list.addElement(dl);
            }
            this.displaylist.addElement(dl);
            return;
        }
        if (i == size || dl == null) {
            return;
        }
        if (rebuild) {
            this.tempFlag = false;
            dl.computeScreen(ch);
        }
        this.displaylist = dl.list;
        this.Finish(bgc);
    }

    void NewList(long lid) {
        this.NewList(lid, false);
    }

    void NewList(long lid, boolean optimized) {
        int i;
        if (this.render_mode == 3) {
            System.out.println("Nested Display lists not allowed. glNewList() ignored.");
        } else {
            this.render_mode = optimized ? 3 : 4;
        }
        int size = this.list.size();
        DisplayList dl = null;
        for (i = 0; i < size; ++i) {
            dl = (DisplayList)this.list.elementAt(i);
            if (lid == dl.id) break;
        }
        if (i == size || dl == null) {
            dl = new DisplayList(lid);
            this.displaylist = dl.list;
            this.list.addElement(dl);
        } else {
            this.displaylist = dl.list;
            this.displaylist.removeAllElements();
        }
    }

    void DeleteList(long lid) {
        int i;
        int size = this.list.size();
        if (size == 0) {
            return;
        }
        DisplayList dl = null;
        for (i = 0; i < size; ++i) {
            dl = (DisplayList)this.list.elementAt(i);
            if (lid == dl.id) break;
        }
        if (i < size && dl != null) {
            dl.list.removeAllElements();
        }
    }

    void EndList() {
        if (this.render_mode >= 3) {
            this.render_mode = 0;
            this.displaylist = null;
        } else {
            System.out.println("No Display list is open. glEndList() ignored.");
        }
    }

    void Begin(int mode) {
        switch (mode) {
            case 4: {
                this.tbuffer = new TextFan();
                this.textFlag = true;
                break;
            }
            case 3: {
                this.pbuffer = new LineFan();
                break;
            }
            case 1: {
                this.prevpt = null;
                this.pbuffer = null;
                break;
            }
            default: {
                this.pbuffer = new JPolygon(mode);
            }
        }
        this.namelist_used = true;
        this.primitive_mode = true;
    }

    void Disable(int cap) {
        this.capabilities[cap] = false;
    }

    void Color(Color c) {
        this.color = new Color(c.getRGB());
    }

    void EdgeColor(Color c) {
        this.edgecolor = new Color(c.getRGB());
    }

    void Enable(int cap) {
        this.capabilities[cap] = true;
    }

    void End(Graphics bgc) {
        if (!this.primitive_mode) {
            return;
        }
        this.primitive_mode = false;
        if (this.textFlag) {
            this.tbuffer.end(this);
            this.tbuffer = null;
            this.textFlag = false;
        } else if (this.pbuffer != null) {
            this.pbuffer.end(this);
            this.pbuffer = null;
        }
    }

    void Finish(Graphics bgc) {
        int num = this.displaylist.size();
        if (this.render_mode == 1) {
            this.phit = null;
            if (!this.pickAllHits) {
                for (int i = num - 1; i >= 0; --i) {
                    boolean ishit = false;
                    Drawable obj = (Drawable)this.displaylist.elementAt(i);
                    if (obj.isClipped() || !(ishit = obj.pickInRevOrder(bgc, this.pickmatrix))) continue;
                    this.phit = obj;
                    break;
                }
                if (this.phit != null) {
                    this.selectbuffer.removeAllElements();
                    Stack mylist = this.phit.getNameList();
                    int size = mylist.size();
                    for (int j = 1; j <= size; ++j) {
                        this.selectbuffer.push(mylist.elementAt(size - j));
                    }
                    this.hit = true;
                } else {
                    this.hit = false;
                }
            } else {
                this.selectbuffer.removeAllElements();
                this.hit = false;
                for (int i = num - 1; i >= 0; --i) {
                    boolean ishit = false;
                    Drawable obj = (Drawable)this.displaylist.elementAt(i);
                    if (obj.isClipped() || !(ishit = obj.pick(bgc, this.pickmatrix)) || obj == null) continue;
                    this.hit = true;
                    Stack mylist = obj.getNameList();
                    int size = mylist.size();
                    for (int j = 1; j <= size; ++j) {
                        this.selectbuffer.push(mylist.elementAt(size - j));
                    }
                }
            }
            return;
        }
        for (int i = 0; i < num; ++i) {
            Drawable obj = (Drawable)this.displaylist.elementAt(i);
            obj.render(this, bgc);
        }
    }

    void InitNames() {
        if (this.namelist_used) {
            this.namelist = new Stack();
        } else {
            this.namelist.removeAllElements();
        }
        this.namelist_used = false;
    }

    void LoadName(Object name) {
        if (this.namelist_used) {
            this.namelist = (Stack)this.namelist.clone();
        }
        try {
            this.namelist.pop();
        }
        catch (EmptyStackException e) {
            System.out.println("Namelist empty. glPushName used instead of glLoadName.");
        }
        this.namelist.push(name);
        this.namelist_used = false;
    }

    void PickMatrix(int curx, int cury, int width, int height) {
        this.pickmatrix = new Rectangle(curx, cury, width, height);
    }

    void PolygonMode(int fill) {
        this.fillmode = fill;
    }

    int getPolygonMode() {
        return this.fillmode;
    }

    void PopName() {
        if (this.namelist_used) {
            this.namelist = (Stack)this.namelist.clone();
        }
        try {
            this.namelist.pop();
        }
        catch (EmptyStackException e) {
            System.out.println("Namelist empty. glPushName used instead of glLoadName.");
        }
        this.namelist_used = false;
    }

    void PushName(Object name) {
        if (this.namelist == null) {
            this.namelist = new Stack();
        } else if (this.namelist_used) {
            this.namelist = (Stack)this.namelist.clone();
        }
        this.namelist.push(name);
        this.namelist_used = false;
    }

    void Select2DFont(Font newfont) {
        this.font = newfont;
    }

    void Select2DFont(String name, int style) {
        this.font = new Font(name, style, this.font.getSize());
    }

    void TextHeight(double height) {
        Point3 p1 = RasterText.p1;
        p1.set(0.0, height, 1.0);
        Point3 p2 = RasterText.p2;
        p2.set(0.0, 0.0, 1.0);
        this.ch.trans.World2Screen(p1);
        this.ch.trans.World2Screen(p2);
        p2.sub(p1);
        int size = (int)Math.sqrt(p2.x * p2.x + p2.y * p2.y);
        this.font = new Font(this.font.getName(), this.font.getStyle(), size);
    }

    void TextHeight(int size) {
        this.font = new Font(this.font.getName(), this.font.getStyle(), size);
    }

    void TextAlign(int h, int v) {
        this.halign = h;
        this.valign = v;
    }

    void RectAlign(int h, int v) {
        this.rhalign = h;
        this.rvalign = v;
    }

    boolean RenderMode(int mode) {
        if (this.render_mode == 1) {
            if (mode == 1) {
                return false;
            }
            this.selectbuffer = null;
            this.render_mode = mode;
            return this.hit;
        }
        if (mode == 1) {
            this.hit = false;
            this.phit = null;
        }
        this.render_mode = mode;
        return true;
    }

    void SelectBuffer(Stack buffer) {
        this.selectbuffer = buffer;
    }

    CompoundedText RectangleText(String string, double x, double y, double width, double height) {
        CompoundedText text = new CompoundedText(this, string, x, y, width, height);
        return text;
    }

    CompoundedText RectangleText(String string, double x, double y, double width, double height, boolean pickable) {
        CompoundedText text = new CompoundedText(this, string, x, y, width, height);
        if (pickable) {
            text.setPickable(this, true);
            this.namelist_used = true;
        }
        return text;
    }

    CompositeTextRectangle CompositeText(String string, double x, double y, double width, double height, Image icon) {
        CompositeTextRectangle cr = new CompositeTextRectangle(this, string, x, y, width, height, icon);
        return cr;
    }

    CompositeTextRectangle CompositeText(String string, double x, double y, double width, double height, Image icon, boolean pickable) {
        CompositeTextRectangle cr = this.CompositeText(string, x, y, width, height, icon);
        if (pickable) {
            cr.setPickable(this, true);
            this.namelist_used = true;
        }
        return cr;
    }

    RasterText Text2D(String string, double x, double y) {
        this.text = new RasterText(this, string, x, y);
        return this.text;
    }

    RasterText Text2D(String string, double xo, double yo, double x1, double y1) {
        this.text = new RasterText(this, string, x1, y1);
        this.text.setLineOrigin(this, xo, yo);
        return this.text;
    }

    RasterText Text2D(String string, double x, double y, boolean pickable) {
        this.text = new RasterText(this, string, x, y);
        if (pickable) {
            this.text.setPickable(this, true);
            this.namelist_used = true;
        }
        return this.text;
    }

    RasterImage Image(Image im, double x, double y) {
        this.rim = new RasterImage(this, im, x, y);
        this.namelist_used = true;
        return this.rim;
    }

    RasterImage Image(Image im, double x, double y, boolean raised) {
        this.rim = new RasterImage(this, im, x, y, raised);
        this.namelist_used = true;
        return this.rim;
    }

    JRectangle Rect(double x, double y, double width, double height) {
        JRectangle rect = new JRectangle(this, x, y, width, height);
        this.namelist_used = true;
        return rect;
    }

    JRectangle Rect(double x, double y, double width, double height, boolean raised) {
        JRectangle rect = new JRectangle(this, x, y, width, height, raised);
        this.namelist_used = true;
        return rect;
    }

    JLine Line(double x1, double y1, double x2, double y2) {
        JLine rect = new JLine(this, x1, y1, x2, y2);
        this.namelist_used = true;
        return rect;
    }

    JLine Line(double x1, double y1, double x2, double y2, boolean raised) {
        JLine rect = new JLine(this, x1, y1, x2, y2, raised);
        this.namelist_used = true;
        return rect;
    }

    RasterImage Image(Vector list, int id, double x, double y) {
        this.rim = new RasterImage(this, list, id, x, y);
        this.namelist_used = true;
        return this.rim;
    }

    RasterImage Image(Vector list, int id, double x, double y, boolean raised) {
        this.rim = new RasterImage(this, list, id, x, y, raised);
        this.namelist_used = true;
        return this.rim;
    }

    void Vertex(double x, double y) {
        if (this.pbuffer != null) {
            this.pbuffer.vertex(this, x, y);
        } else {
            JLine line = null;
            if (this.prevpt == null) {
                this.prevpt = this.pt1;
            } else {
                line = new JLine(this, this.prevpt.x, this.prevpt.y, x, y, this.borderType != 0);
            }
            this.prevpt.x = x;
            this.prevpt.y = y;
        }
    }

    void Center(double x, double y) {
        this.tbuffer.center(x, y);
    }

    void Vertex(String str, double x, double y) {
        this.tbuffer.vertex(this, str, x, y);
    }

    void Vertex(String str, double x, double y, boolean pflag) {
        this.tbuffer.vertex(this, str, x, y, pflag);
    }

    void setUseGlobalRenderMode(boolean useGlobal) {
        this.useGlobalRenderMode = useGlobal;
    }

    void setOutlineMode(int mode) {
        this.outlineMode = mode;
    }

    int getOutlineMode() {
        return this.outlineMode;
    }

    void setThetaLensAngles(double min, double max) {
        this.minAngle = min;
        this.maxAngle = max;
    }

    void setLensFactor(double fac) {
        this.lensFactor = fac / 100.0;
        this.dirtyLensFlag = true;
    }

    double getLensFactor() {
        return this.lensFactor * 100.0;
    }

    void setLensWorldAreaPercentageFactors(double[] facs) {
        this.lensWorldAreaPercentages = facs;
    }

    void setLensScreenAreaPercentageFactor(double fac) {
        this.lensScreenAreaPercentage = fac;
    }

    double getLensScreenAreaPercentageFactor() {
        return this.lensScreenAreaPercentage;
    }

    void setThetaLensFactor(double fac) {
        this.thetaLensFac = fac;
    }

    double getThetaLensFactor() {
        return this.thetaLensFac;
    }

    void setTextBorderFlag(boolean flag) {
        this.border = flag;
    }

    void setTextBorderType(int type) {
        this.textBorderType = type;
    }

    int getTextBorderType() {
        return this.textBorderType;
    }

    void setTextBorderColor(Color color) {
        this.textBorderColor = color;
    }

    void setTextColor(Color color) {
        this.textColor = color;
    }

    void setBorderType(int type) {
        this.borderType = type;
    }

    int getBorderType() {
        return this.borderType;
    }

    void setTextLineColor(Color color) {
        this.textLineColor = color;
    }

    void setTextHandleColor(Color color) {
        this.textHandleColor = color;
    }

    void setTextCutoff(double fac, double angle) {
        this.textCutoff = fac;
        this.textSpreadCutoff = angle;
    }

    void setBorderCutoff(double fac) {
        this.textBorderCutoff = fac;
    }

    void setStipple(int factor, int mask) {
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] pattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            pattern[i] = dashes[index];
            ++i;
            --index;
        }
        if (this.render_mode == 0) {
            this.stipplePattern = pattern;
        } else {
            this.stipplePattern = pattern;
            Stipple stipple = new Stipple(pattern);
            this.displaylist.addElement(stipple);
        }
    }

    void lineWidth(int pixels) {
        this.lineWidth = pixels;
    }

    void capStyle(int capStyle) {
        this.capStyle = capStyle;
    }
}

