/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Stack;
import java.util.Vector;

public class RasterText
implements Drawable {
    Color color;
    Font font;
    Point3 loc;
    Point3 origin;
    Point3 oscr;
    Point3 dscr;
    int halign;
    int valign;
    boolean clip;
    boolean clipText;
    Stack namelist;
    boolean pickable;
    boolean optimized;
    boolean line;
    boolean clean;
    boolean handle;
    static Point3 p1 = new Point3(0.0, 0.0, 1.0);
    static Point3 p2 = new Point3(0.0, 0.0, 1.0);
    boolean border;
    int borderType;
    Color borderColor;
    Color lineColor;
    Color handleColor;
    double borderCutoff;
    double radialCutoff;
    double spreadCutoff;
    Color textColor;
    int borderWidth;
    Rectangle bbox;
    private static char newline = (char)10;
    private static final int multiLineOffsetIndex = 7;
    private Vector string;
    private int[] textWidth;
    private int maxTextWidth;
    private int textLines;
    protected double borderHeight = 1.0;
    private StateLite state;
    private static final int X = 0;
    private static final int Y = 1;

    RasterText(StateLite state, String str, double x, double y) {
        this(state, str, x, y, 1);
    }

    RasterText(StateLite state, String str, double x, double y, int borderwidth) {
        this.state = state;
        ChannelLite ch = state.ch;
        TransInfo tr = ch.trans;
        this.font = state.font;
        this.clip = false;
        this.pickable = false;
        this.clean = true;
        this.handleColor = state.textHandleColor;
        this.loc = new Point3(x, y, 1.0);
        boolean bl = this.optimized = state.render_mode == 3;
        if (this.optimized) {
            this.loc.postMultiply(tr.w2m);
        }
        this.string = RasterText.makeMultiLine(str);
        this.textLines = this.string.size();
        this.textWidth = null;
        this.halign = state.halign;
        this.valign = state.valign;
        this.color = state.color;
        this.borderWidth = borderwidth;
        this.border = state.border;
        this.borderType = state.textBorderType;
        this.borderColor = state.textBorderColor;
        this.lineColor = state.textLineColor;
        this.textColor = state.textColor;
        this.radialCutoff = state.textCutoff;
        this.spreadCutoff = state.textSpreadCutoff;
        this.borderCutoff = state.textBorderCutoff;
        this.dscr = new Point3(0.0, 0.0, 1.0);
        this.bbox = new Rectangle();
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
            ch.glRefresh();
        }
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        StateLite state = ch.getState();
        if (state.render_mode == 1) {
            return !this.clip;
        }
        this.clipText = false;
        this.clip = false;
        TransInfo tr = ch.trans;
        this.dscr.copy(this.loc);
        if (this.line) {
            this.oscr.copy(this.origin);
        }
        if (state.capabilities[2]) {
            int fnHeight;
            Viewport view = tr.GetViewport();
            this.clean = false;
            double lens = state.lensFactor;
            double thetaLens = tr.getRadialFactor(state.thetaLensFac);
            if (state.dirtyLensFlag) {
                view.computeLogR(lens);
                state.dirtyLensFlag = false;
            }
            Point3 lensOrgLoc = tr.getLensOriginalLocation(state.thetaLensFac);
            double tfac = 0.0;
            if (state.capabilities[3] && tr.moved) {
                tfac = JPolygon.angularDistortion(this.dscr, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
            }
            if (this.optimized) {
                tr.Model2Screen(this.dscr);
            } else {
                tr.World2Screen(this.dscr);
            }
            double rfac = 0.5;
            if (state.lensDirection == 6) {
                rfac = JPolygon.verticalDistortion(this.dscr, view, tr, state.lensFactor);
                double[] cutoffs = tr.cutoffs;
                double[] range = tr.lensRange;
                int index = 0;
                while (this.dscr.y > range[index]) {
                    ++index;
                }
                this.radialCutoff = cutoffs[index];
            } else {
                rfac = state.lensDirection == 0 ? JPolygon.radialDistortion(this.dscr, lensOrgLoc, view, tr.movingDir, state.lensFactor) : JPolygon.conalDistortion(this.dscr, lensOrgLoc, view, tr.movingDir, state.lensFactor, state.lensDirection);
            }
            int n = fnHeight = this.font == null ? 12 : Toolkit.getDefaultToolkit().getFontMetrics(this.font).getHeight();
            if (this.border) {
                if (rfac > this.borderCutoff) {
                    this.clip = true;
                } else if (rfac > this.radialCutoff || tfac > this.spreadCutoff) {
                    this.clipText = true;
                    int dd = (int)Math.round((double)fnHeight * (1.0 - Math.sqrt(rfac)));
                    this.bbox.x = (int)this.dscr.x - dd / 2;
                    this.bbox.width = dd;
                    if (state.lensDirection == 6) {
                        this.bbox.y = (int)this.dscr.y - (int)((double)fnHeight * this.borderHeight) / 2;
                        this.bbox.height = (int)((double)fnHeight * this.borderHeight);
                    } else {
                        this.bbox.y = (int)this.dscr.y - dd / 2;
                        this.bbox.height = dd;
                    }
                }
            } else if (rfac > this.radialCutoff || tfac > this.spreadCutoff) {
                this.clipText = true;
            }
            if (!this.clip && this.clipText) {
                int dd = (int)Math.round((double)fnHeight * (1.0 - Math.sqrt(rfac)));
                this.bbox.x = (int)this.dscr.x - dd / 2;
                this.bbox.width = dd;
                if (state.lensDirection == 6) {
                    this.bbox.y = (int)this.dscr.y - (int)((double)fnHeight * this.borderHeight) / 2;
                    this.bbox.height = (int)((double)fnHeight * this.borderHeight);
                } else {
                    this.bbox.y = (int)this.dscr.y - dd / 2;
                    this.bbox.height = dd;
                }
            }
            if (this.line) {
                if (state.capabilities[3] && tr.moved && tr.movingDir > state.minAngle && tr.movingDir < state.maxAngle) {
                    JPolygon.angularDistortion(this.oscr, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
                }
                if (this.optimized) {
                    tr.Model2Screen(this.oscr);
                } else {
                    this.oscr.copy(this.origin);
                }
                JPolygon.radialDistortion(this.oscr, lensOrgLoc, view, tr.movingDir, state.lensFactor);
            }
        } else if (this.optimized) {
            tr.Model2Screen(this.dscr);
            if (this.line) {
                tr.Model2Screen(this.oscr);
            }
        } else {
            tr.World2Screen(this.dscr);
            if (this.line) {
                tr.World2Screen(this.oscr);
            }
        }
        return !this.clip;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        if (this.clip) {
            return false;
        }
        if (this.line) {
            bgc.setColor(this.lineColor);
            bgc.drawLine((int)this.oscr.x, (int)this.oscr.y, (int)this.dscr.x, (int)this.dscr.y);
        }
        if (this.clipText) {
            if (this.border) {
                if (state.capabilities[6] && state.ch.component != null) {
                    int xo = this.bbox.x;
                    int yo = this.bbox.y;
                    int pw = this.bbox.width;
                    int ph = this.bbox.height;
                    state.ch.shadow(xo, yo, pw, ph);
                }
                bgc.setColor(this.color);
                switch (this.borderType) {
                    case 3: {
                        bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                    }
                    case 1: {
                        bgc.setColor(this.borderColor);
                        bgc.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                        break;
                    }
                    case 2: {
                        bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                        break;
                    }
                }
                if (this.handle) {
                    bgc.setColor(this.handleColor);
                    if (this.bbox.width > 2) {
                        bgc.fillRect(this.bbox.x + this.bbox.width / 2 - 1, this.bbox.y + this.bbox.height / 2 - 1, 2, 2);
                    } else {
                        bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                    }
                }
            }
            return true;
        }
        if (this.font != null) {
            bgc.setFont(this.font);
        }
        Font fn = bgc.getFont();
        FontMetrics fm = bgc.getFontMetrics();
        int[] info = this.computeAlignmentInfo(state, bgc, (int)this.dscr.x, (int)this.dscr.y, this.handle);
        int yPad = state.lensDirection == 6 ? (int)Math.max(1.0, (this.borderHeight - 1.0) * (double)fm.getHeight() / 2.0) : 1;
        this.bbox.x = info[0] - 2;
        this.bbox.y = info[4] - yPad;
        this.bbox.width = info[2] + 4;
        this.bbox.height = info[3] + 2 * yPad;
        int xoff = 0;
        if (fn.isItalic() && fn.getName().startsWith("Dialog")) {
            xoff = fm.getDescent() / 2;
            this.bbox.width += fm.getAscent() / 2;
        }
        if (this.border) {
            bgc.setColor(this.color);
            if (state.capabilities[6] && state.ch.component != null) {
                int sx = this.bbox.x;
                int sy = this.bbox.y;
                int pw = this.bbox.width;
                int ph = this.bbox.height;
                state.ch.shadow(sx, sy, pw, ph);
            }
            switch (this.borderType) {
                case 3: {
                    bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                }
                case 1: {
                    bgc.setColor(this.borderColor);
                    bgc.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                    if (this.borderWidth <= 1) break;
                    int bw = this.borderWidth - 1;
                    for (int w = 1; w <= bw; ++w) {
                        bgc.drawRect(this.bbox.x - w, this.bbox.y - w, this.bbox.width + 2 * w, this.bbox.height + 2 * w);
                    }
                    break;
                }
                case 2: {
                    bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                    break;
                }
            }
        }
        if (this.handle) {
            bgc.setColor(this.handleColor);
            bgc.drawString(" + ", info[0] - xoff, info[1] + (this.textLines - 1) * info[5] / 2);
        }
        bgc.setColor(this.textColor);
        String thisLine = null;
        for (int i = 0; i < this.textLines; ++i) {
            thisLine = (String)this.string.elementAt(i);
            bgc.drawString(thisLine, info[0] + info[7 + i] - xoff, info[1]);
            info[1] = info[1] + info[5];
        }
        return true;
    }

    @Override
    public Stack getNameList() {
        return this.namelist;
    }

    @Override
    public boolean pick(Graphics bgc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        if (!this.clean) {
            this.clean = true;
            this.bbox = new Rectangle(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        if (!this.clean) {
            this.clean = true;
            this.bbox = new Rectangle(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    void setBorderFlag(boolean flag) {
        this.border = flag;
    }

    void setBorderCutoff(double fac) {
        this.borderCutoff = fac;
    }

    void setTextCutoff(double fac) {
        this.radialCutoff = fac;
    }

    void setSpreadTextCutoff(double fac) {
        this.spreadCutoff = fac;
    }

    public void setBorderType(int type) {
        this.borderType = type;
    }

    public void setBorderColor(Color clr) {
        this.borderColor = clr;
    }

    public void setLineColor(Color clr) {
        this.lineColor = clr;
    }

    Color getLineColor() {
        return this.lineColor;
    }

    Point3 getLocation() {
        return this.dscr;
    }

    static void getWorldPixelCorners(TransInfo trans, Point3 ll, Point3 ur, int direction) {
        ll.set(0.0, 0.0, 1.0);
        trans.World2Screen(ll);
        if (direction == 0) {
            ur.set(ll.x + 1.0, ll.y, 1.0);
        } else {
            ur.set(ll.x, ll.y - 1.0, 1.0);
        }
        trans.Screen2World(ll);
        trans.Screen2World(ur);
    }

    static double getWorldPixelWidth(StateLite state) {
        Point3 ll = state.pt1;
        Point3 ur = state.pt2;
        RasterText.getWorldPixelCorners(state.ch.trans, ll, ur, 0);
        ur.sub(ll);
        return ur.length();
    }

    static double getWorldPixelHeight(StateLite state) {
        Point3 ll = state.pt1;
        Point3 ur = state.pt2;
        RasterText.getWorldPixelCorners(state.ch.trans, ll, ur, 1);
        ur.sub(ll);
        return ur.length();
    }

    static double getWidth(StateLite state, Graphics gc, Font font, String string) {
        int w = 0;
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        Vector list = RasterText.makeMultiLine(string);
        for (int i = 0; i < list.size(); ++i) {
            w = Math.max(w, fm.stringWidth((String)list.elementAt(i)));
        }
        return (double)w * RasterText.getWorldPixelWidth(state);
    }

    static double getAscent(StateLite state, Graphics gc, Font font) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        double ascent = fm.getAscent();
        double pixel = RasterText.getWorldPixelHeight(state);
        return ascent * pixel;
    }

    static double getDescent(StateLite state, Graphics gc, Font font) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        double descent = fm.getDescent();
        double pixel = RasterText.getWorldPixelHeight(state);
        return descent * pixel;
    }

    static double getHeight(StateLite state, Graphics gc, Font font) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        double h = fm.getHeight();
        double pixel = RasterText.getWorldPixelHeight(state);
        return h * pixel;
    }

    static double getSize(StateLite state, Graphics gc, Font font) {
        FontMetrics fm = null;
        if (gc == null) {
            fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        } else {
            gc.setFont(font);
            fm = gc.getFontMetrics();
        }
        double h = fm.getHeight();
        double pixel = RasterText.getWorldPixelHeight(state);
        return h * pixel;
    }

    static double getHeight(StateLite state, Graphics gc, Font font, String string) {
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        Vector list = RasterText.makeMultiLine(string);
        int h = fm.getHeight() * list.size();
        return (double)h * RasterText.getWorldPixelHeight(state);
    }

    private static Vector makeMultiLine(String text) {
        int nlIndex = 0;
        Vector<String> multiLine = new Vector<String>();
        if (text != null && text.length() > 0) {
            int i = 0;
            while (nlIndex >= 0) {
                nlIndex = text.indexOf(newline, i);
                String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                multiLine.addElement(line);
                i = 1 + nlIndex;
            }
        }
        return multiLine;
    }

    private static int[] getInfoBuffer(StateLite state, int lineCount) {
        int infoLength = 7 + lineCount;
        if (state.tempRasterInfo == null || state.tempRasterInfo.length < infoLength) {
            state.tempRasterInfo = new int[infoLength];
        }
        return state.tempRasterInfo;
    }

    private static int computeWidths(Vector string, int[] widths, FontMetrics fm) {
        int max = Integer.MIN_VALUE;
        int lineCount = string.size();
        for (int i = 0; i < lineCount; ++i) {
            widths[i] = fm.stringWidth((String)string.elementAt(i));
            max = Math.max(max, widths[i]);
        }
        return max;
    }

    protected int[] computeAlignmentInfo(StateLite state, Graphics gc, int x, int y, boolean handle) {
        gc.setFont(this.font);
        FontMetrics fm = gc.getFontMetrics();
        if (this.textWidth == null || state.capabilities[2]) {
            this.textWidth = new int[this.textLines];
            this.maxTextWidth = RasterText.computeWidths(this.string, this.textWidth, fm);
        }
        int[] alignInfo = RasterText.getInfoBuffer(state, this.textLines);
        int hnwidth = 0;
        if (handle) {
            hnwidth = fm.stringWidth(" + ");
        }
        this.maxTextWidth += hnwidth;
        RasterText.computeAlignmentInfo(alignInfo, this.textWidth, this.maxTextWidth, this.string.size(), fm, this.halign, this.valign, hnwidth, x, y);
        return alignInfo;
    }

    static int[] computeAlignmentInfo(StateLite state, Graphics gc, Vector string, Font font, int halign, int valign, boolean handle, int x, int y) {
        int lineCount = string.size();
        int[] textWidth = state.tempTextWidth;
        if (textWidth == null || textWidth.length < lineCount) {
            textWidth = state.tempTextWidth = new int[lineCount];
        }
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        int maxTextWidth = RasterText.computeWidths(string, textWidth, fm);
        int hnwidth = 0;
        if (handle) {
            hnwidth = fm.stringWidth(" + ");
        }
        int[] info = RasterText.getInfoBuffer(state, lineCount);
        RasterText.computeAlignmentInfo(info, textWidth, maxTextWidth += hnwidth, string.size(), fm, halign, valign, hnwidth, x, y);
        return info;
    }

    private static void computeAlignmentInfo(int[] info, int[] widths, int w, int lineCount, FontMetrics fm, int halign, int valign, int hnwidth, int x, int y) {
        int descent;
        info[0] = 0;
        info[1] = 0;
        int ascent = fm.getAscent();
        info[6] = descent = fm.getDescent();
        int lineHeight = fm.getHeight();
        int h = lineHeight * lineCount;
        switch (valign) {
            case 0: {
                info[1] = info[1] + ascent;
                break;
            }
            case 1: {
                info[1] = info[1] + (ascent - h / 2);
                break;
            }
            case 3: {
                info[1] = info[1] - (h - ascent);
                break;
            }
        }
        info[0] = -w;
        info[2] = w;
        info[3] = h;
        info[4] = y + info[1] - ascent;
        switch (halign) {
            default: {
                info[0] = 0;
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = hnwidth;
                }
                break;
            }
            case 1: {
                info[0] = info[0] / 2;
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = hnwidth + (w - hnwidth - widths[i - 7]) / 2;
                }
                break;
            }
            case 2: {
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = w - widths[i - 7] - hnwidth;
                }
            }
        }
        info[0] = info[0] + x;
        info[1] = info[1] + y;
        info[5] = lineHeight;
    }

    void setLineOrigin(StateLite state, double xo, double yo) {
        this.origin = new Point3(xo, yo, 1.0);
        this.oscr = new Point3(0.0, 0.0, 1.0);
        this.line = true;
        boolean bl = this.optimized = state.render_mode == 3;
        if (this.optimized) {
            this.origin.postMultiply(state.ch.trans.w2m);
        }
    }

    public void setBorderHeight(double ht) {
        this.borderHeight = ht;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    void setPickable(StateLite state, boolean flag) {
        this.pickable = flag;
        this.namelist = flag ? state.namelist : null;
    }

    public void setHandleVisible(boolean flag) {
        this.handle = flag;
    }

    public void setHandleColor(Color c) {
        this.handleColor = c;
    }
}

