/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.JRectangle;
import com.sas.graphics.util.j2d.RasterText;
import com.sas.graphics.util.j2d.StateLite;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

class RasterImage
extends JRectangle {
    Image im;
    Vector list;
    int id;

    RasterImage(StateLite state, Image img, double x, double y) {
        super(state, x, y);
        this.im = img;
    }

    RasterImage(StateLite state, Vector imlist, int imid, double x, double y) {
        super(state, x, y);
        this.list = imlist;
        this.id = imid;
    }

    RasterImage(StateLite state, Image img, double x, double y, boolean flag) {
        super(state, x, y, flag);
        this.im = img;
    }

    RasterImage(StateLite state, Vector imlist, int imid, double x, double y, boolean flag) {
        super(state, x, y, flag);
        this.list = imlist;
        this.id = imid;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        if (this.clip) {
            return false;
        }
        bgc.drawImage(this.im, this.bbox.x, this.bbox.y, null);
        return this.renderBorder(state, bgc);
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        if (this.list != null) {
            this.im = (Image)this.list.elementAt(this.id);
        }
        this.height = this.im.getHeight(null);
        this.width = this.im.getWidth(null);
        return super.computeScreen(ch);
    }

    static double getHeight(StateLite state, Image im) {
        double h = im.getHeight(null);
        double pixel = RasterText.getWorldPixelHeight(state);
        return h * pixel;
    }

    static double getWidth(StateLite state, Image im) {
        double w = im.getWidth(null);
        return w * RasterText.getWorldPixelWidth(state);
    }
}

