/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.Matrix3;

final class Point3 {
    double x;
    double y;
    double t;
    static Point3 tmp = new Point3();

    Point3(double x, double y, double t) {
        this.x = x;
        this.y = y;
        this.t = t;
    }

    Point3() {
        this(0.0, 0.0, 0.0);
    }

    Point3(Point3 p) {
        this(p.x, p.y, p.t);
    }

    public void set(double x, double y, double t) {
        this.x = x;
        this.y = y;
        this.t = t;
    }

    public void copy(Point3 p) {
        this.x = p.x;
        this.y = p.y;
        this.t = p.t;
    }

    void normalize() {
        double length = this.length();
        if (length == 1.0) {
            return;
        }
        this.x /= length;
        this.y /= length;
    }

    double dot(Point3 p) {
        double rc = p.x * this.x + p.y * this.y;
        return rc;
    }

    double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    Point3 add(Point3 p) {
        this.x += p.x;
        this.y += p.y;
        this.t = 0.0;
        return this;
    }

    Point3 sub(Point3 p) {
        this.x -= p.x;
        this.y -= p.y;
        this.t = 0.0;
        return this;
    }

    Point3 scale(double s) {
        if (s == 1.0) {
            return this;
        }
        this.x *= s;
        this.y *= s;
        this.t *= s;
        return this;
    }

    Point3 postMultiply(Matrix3 m) {
        Point3.tmp.x = this.x;
        Point3.tmp.y = this.y;
        Point3.tmp.t = this.t;
        this.x = Point3.tmp.x * m.e[0][0] + Point3.tmp.y * m.e[1][0] + this.t * m.e[2][0];
        this.y = Point3.tmp.x * m.e[0][1] + Point3.tmp.y * m.e[1][1] + this.t * m.e[2][1];
        this.t = Point3.tmp.x * m.e[0][2] + Point3.tmp.y * m.e[1][2] + this.t * m.e[2][2];
        return this;
    }

    public String toString() {
        return "[" + this.x + "\t" + this.y + "\t" + this.t + "]";
    }
}

