/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.Point3;

final class Matrix3 {
    double[][] e;
    double[] t = new double[3];

    Matrix3() {
        this.e = new double[3][];
        this.e[0] = new double[3];
        this.e[1] = new double[3];
        this.e[2] = new double[3];
    }

    Matrix3(Matrix3 m) {
        this();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.e[i][j] = m.e[i][j];
            }
        }
    }

    Matrix3 scale(double s) {
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = this.e[i];
                int n = j++;
                dArray[n] = dArray[n] * s;
            }
        }
        return this;
    }

    Matrix3 scale(double sx, double sy) {
        for (int i = 0; i < 3; ++i) {
            double[] dArray = this.e[i];
            dArray[0] = dArray[0] * sx;
            double[] dArray2 = this.e[i];
            dArray2[1] = dArray2[1] * sy;
        }
        return this;
    }

    Matrix3 inverse() {
        Matrix3 m = this.adjoint();
        double det = this.det();
        return m.scale(1.0 / det);
    }

    Matrix3 preMultiply(Matrix3 mi) {
        for (int i = 0; i < 3; ++i) {
            this.t[0] = this.e[0][i];
            this.t[1] = this.e[1][i];
            this.t[2] = this.e[2][i];
            for (int j = 0; j < 3; ++j) {
                this.e[j][i] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = this.e[j];
                    int n = i;
                    dArray[n] = dArray[n] + mi.e[j][k] * this.t[k];
                }
            }
        }
        return this;
    }

    Point3 preMultiply(Point3 p) {
        Point3 m = new Point3();
        m.x = p.x * this.e[0][0] + p.y * this.e[1][0] + p.t * this.e[2][0];
        m.y = p.x * this.e[0][1] + p.y * this.e[1][1] + p.t * this.e[2][1];
        m.t = p.x * this.e[0][2] + p.y * this.e[1][2] + p.t * this.e[2][2];
        return m;
    }

    Matrix3 rotate(double angle) {
        Matrix3 uu = new Matrix3();
        uu.setIdentity();
        double a = angle * 0.01745329252;
        uu.e[0][0] = Math.cos(a);
        uu.e[0][1] = Math.sin(a);
        uu.e[1][0] = -uu.e[0][1];
        uu.e[1][1] = uu.e[0][0];
        this.preMultiply(uu);
        return this;
    }

    void set(double[] values) {
        this.e[0][0] = values[0];
        this.e[0][1] = values[1];
        this.e[0][2] = values[2];
        this.e[1][0] = values[3];
        this.e[1][1] = values[4];
        this.e[1][2] = values[5];
        this.e[2][0] = values[6];
        this.e[2][1] = values[7];
        this.e[2][2] = values[8];
    }

    void copy(Matrix3 m) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.e[i][j] = m.e[i][j];
            }
        }
    }

    void set(int i, int j, double s) {
        try {
            this.e[i][j] = s;
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            System.out.println("Invalid array index");
            System.exit(0);
        }
    }

    void setIdentity() {
        this.e[0][0] = 1.0;
        this.e[0][1] = 0.0;
        this.e[0][2] = 0.0;
        this.e[1][0] = 0.0;
        this.e[1][1] = 1.0;
        this.e[1][2] = 0.0;
        this.e[2][0] = 0.0;
        this.e[2][1] = 0.0;
        this.e[2][2] = 1.0;
    }

    Matrix3 translate(double x, double y) {
        double[] dArray = this.e[2];
        dArray[0] = dArray[0] + (this.e[0][0] * x + this.e[1][0] * y);
        double[] dArray2 = this.e[2];
        dArray2[1] = dArray2[1] + (this.e[0][1] * x + this.e[1][1] * y);
        double[] dArray3 = this.e[2];
        dArray3[2] = dArray3[2] + (this.e[0][2] * x + this.e[1][2] * y);
        return this;
    }

    Matrix3 transpose() {
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j < 3; ++j) {
                double temp = this.e[i][j];
                this.e[i][j] = this.e[j][i];
                this.e[j][i] = temp;
            }
        }
        return this;
    }

    private Matrix3 adjoint() {
        return this.cofactors().transpose();
    }

    private Matrix3 cofactors() {
        Matrix3 m = new Matrix3();
        m.e[0][0] = this.e[1][1] * this.e[2][2] - this.e[1][2] * this.e[2][1];
        m.e[0][1] = -(this.e[1][0] * this.e[2][2] - this.e[1][2] * this.e[2][0]);
        m.e[0][2] = this.e[1][0] * this.e[2][1] - this.e[1][1] * this.e[2][0];
        m.e[1][0] = -(this.e[0][1] * this.e[2][2] - this.e[0][2] * this.e[2][1]);
        m.e[1][1] = this.e[0][0] * this.e[2][2] - this.e[0][2] * this.e[2][0];
        m.e[1][2] = -(this.e[0][0] * this.e[2][1] - this.e[0][1] * this.e[2][0]);
        m.e[2][0] = this.e[0][1] * this.e[1][2] - this.e[0][2] * this.e[1][1];
        m.e[2][1] = -(this.e[0][0] * this.e[1][2] - this.e[0][2] * this.e[1][0]);
        m.e[2][2] = this.e[0][0] * this.e[1][1] - this.e[0][1] * this.e[1][0];
        return m;
    }

    double det() {
        double d0 = this.e[0][0] * (this.e[1][1] * this.e[2][2] - this.e[1][2] * this.e[2][1]);
        double d1 = this.e[0][1] * (this.e[1][0] * this.e[2][2] - this.e[1][2] * this.e[2][0]);
        double d2 = this.e[0][2] * (this.e[1][0] * this.e[2][1] - this.e[1][1] * this.e[2][0]);
        return d0 - d1 + d2;
    }
}

