/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.StateLite;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

class LineFan
extends JPolygon {
    Vector colors = new Vector();
    Vector linewidths = new Vector();
    Vector stipplePatterns = new Vector();

    LineFan() {
        super(3);
        this.optimized = false;
    }

    @Override
    void vertex(StateLite state, double x, double y) {
        super.vertex(state, x, y);
        this.colors.addElement(state.color);
        this.linewidths.addElement(new Integer(state.lineWidth));
        if (state.capabilities[7]) {
            this.stipplePatterns.addElement(state.stipplePattern);
        } else {
            int[] patterns = new int[]{0};
            this.stipplePatterns.addElement(patterns);
        }
    }

    @Override
    public final boolean render(StateLite state, Graphics bgc) {
        if (this.clip || this.size == 0) {
            return false;
        }
        bgc.setColor(this.color);
        for (int j = 1; j < this.size; ++j) {
            bgc.setColor((Color)this.colors.elementAt(j));
            this.lineWidth = (Integer)this.linewidths.elementAt(j);
            int[] stipplePattern = (int[])this.stipplePatterns.elementAt(j);
            if (stipplePattern[0] != 0) {
                LineFan.stipple(state, bgc, stipplePattern, state.stippleHistory, this.dscr[0].x, this.dscr[0].y, this.dscr[j].x, this.dscr[j].y, this.lineWidth);
                continue;
            }
            LineFan.drawSegment(state, bgc, this.dscr[0].x, this.dscr[0].y, this.dscr[j].x, this.dscr[j].y, this.lineWidth);
        }
        return true;
    }
}

