/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Stack;

class JRectangle
implements Drawable {
    Point3 loc;
    Point3 origin;
    Point3 oscr;
    Point3 dscr;
    int width;
    int height;
    double ww;
    double wh;
    int halign;
    int valign;
    boolean clip;
    Stack namelist;
    boolean pickable;
    boolean optimized;
    int borderWidth;
    static Point3 p1 = new Point3(0.0, 0.0, 1.0);
    static Point3 p2 = new Point3(0.0, 0.0, 1.0);
    static int[] xpoints = new int[6];
    static int[] ypoints = new int[6];
    static final Color dark = Color.darkGray;
    static final Color light = new Color(222, 222, 222);
    int border;
    Color borderColor;
    Color color;
    boolean raised = true;
    Rectangle bbox;

    JRectangle(StateLite state, double x, double y, double wid, double ht, boolean flag) {
        this(state, x, y, wid, ht);
        this.raised = flag;
    }

    JRectangle(StateLite state, double x, double y, double wid, double ht) {
        this(state, x, y);
        this.ww = wid;
        this.wh = ht;
        if (this.optimized) {
            p1.set(x + wid, y, 1.0);
            p2.set(x, y + ht, 1.0);
            p1.postMultiply(state.ch.trans.w2m);
            p2.postMultiply(state.ch.trans.w2m);
            this.ww = p1.sub(this.loc).length();
            this.wh = p2.sub(this.loc).length();
        }
    }

    JRectangle(StateLite state, double x, double y, boolean flag) {
        this(state, x, y);
        this.raised = flag;
    }

    JRectangle(StateLite state, double x, double y) {
        ChannelLite ch = state.ch;
        TransInfo tr = ch.trans;
        this.clip = false;
        this.namelist = state.namelist;
        this.pickable = state.capabilities[0];
        this.borderWidth = state.lineWidth;
        this.loc = new Point3(x, y, 1.0);
        boolean bl = this.optimized = state.render_mode == 3;
        if (this.optimized) {
            this.loc.postMultiply(tr.w2m);
        }
        this.halign = state.rhalign;
        this.valign = state.rvalign;
        this.wh = 0.0;
        this.ww = 0.0;
        this.border = state.borderType;
        this.borderColor = state.edgecolor;
        this.color = state.color;
        this.dscr = new Point3(0.0, 0.0, 1.0);
        this.bbox = new Rectangle();
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
            ch.glRefresh();
        }
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        StateLite state = ch.getState();
        if (state.render_mode == 1) {
            return !this.clip;
        }
        this.clip = false;
        TransInfo tr = ch.trans;
        this.dscr.copy(this.loc);
        if (state.capabilities[2]) {
            Viewport view = tr.GetViewport();
            double lens = state.lensFactor;
            double thetaLens = tr.getRadialFactor(state.thetaLensFac);
            if (state.dirtyLensFlag) {
                view.computeLogR(lens);
                state.dirtyLensFlag = false;
            }
            Point3 lensOrgLoc = tr.getLensOriginalLocation(state.thetaLensFac);
            if (state.capabilities[3] && tr.moved) {
                JPolygon.angularDistortion(this.dscr, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
            }
            if (this.optimized) {
                if (this.ww != 0.0) {
                    p1.set(this.dscr.x + this.ww, this.dscr.y, 1.0);
                    p2.set(this.dscr.x, this.dscr.y + this.wh, 1.0);
                    tr.Model2Screen(p1);
                    tr.Model2Screen(p2);
                    tr.Model2Screen(this.dscr);
                    this.width = (int)p1.sub(this.dscr).length();
                    this.height = (int)p2.sub(this.dscr).length();
                } else {
                    tr.Model2Screen(this.dscr);
                }
            } else if (this.ww != 0.0) {
                p1.set(this.loc.x + this.ww, this.loc.y, 1.0);
                p2.set(this.loc.x, this.loc.y + this.wh, 1.0);
                tr.World2Screen(p1);
                tr.World2Screen(p2);
                tr.World2Screen(this.dscr);
                this.width = (int)p1.sub(this.dscr).length();
                this.height = (int)p2.sub(this.dscr).length();
            } else {
                tr.World2Screen(this.dscr);
            }
            double rfac = 0.0;
            if (state.lensDirection == 6) {
                JPolygon.verticalDistortion(this.dscr, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
            } else if (state.lensDirection == 0) {
                JPolygon.radialDistortion(this.dscr, lensOrgLoc, view, tr.movingDir, state.lensFactor);
            } else {
                JPolygon.conalDistortion(this.dscr, lensOrgLoc, view, tr.movingDir, state.lensFactor, state.lensDirection);
            }
            this.width = (int)((double)this.width * (1.0 - rfac));
            this.height = (int)((double)this.height * (1.0 - rfac));
        } else {
            if (this.ww != 0.0) {
                p1.set(this.loc.x + this.ww, this.loc.y, 1.0);
                p2.set(this.loc.x, this.loc.y + this.wh, 1.0);
            }
            if (this.optimized) {
                tr.Model2Screen(this.dscr);
                if (this.ww != 0.0) {
                    tr.Model2Screen(p1);
                    tr.Model2Screen(p2);
                    this.width = (int)p1.sub(this.dscr).length();
                    this.height = (int)p2.sub(this.dscr).length();
                }
            } else {
                tr.World2Screen(this.dscr);
                if (this.ww != 0.0) {
                    tr.World2Screen(p1);
                    tr.World2Screen(p2);
                    this.width = (int)p1.sub(this.dscr).length();
                    this.height = (int)p2.sub(this.dscr).length();
                }
            }
        }
        switch (this.halign) {
            case 0: {
                this.bbox.x = (int)this.dscr.x;
                break;
            }
            default: {
                this.bbox.x = (int)this.dscr.x - this.width / 2;
                break;
            }
            case 2: {
                this.bbox.x = (int)this.dscr.x - this.width;
            }
        }
        this.bbox.width = this.width;
        switch (this.valign) {
            case 0: {
                this.bbox.y = (int)this.dscr.y;
                break;
            }
            default: {
                this.bbox.y = (int)this.dscr.y - this.height / 2;
                break;
            }
            case 2: 
            case 3: {
                this.bbox.y = (int)this.dscr.y - this.height;
            }
        }
        this.bbox.height = this.height;
        return !this.clip;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        if (this.clip) {
            return false;
        }
        bgc.setColor(this.color);
        bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        return this.renderBorder(state, bgc);
    }

    public boolean renderBorder(StateLite state, Graphics bgc) {
        switch (this.border) {
            default: {
                break;
            }
            case 1: {
                bgc.setColor(this.borderColor);
                if (this.borderWidth <= 1) {
                    bgc.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                    break;
                }
                int[] x = new int[6];
                int[] y = new int[6];
                x[0] = x[5] = this.bbox.x + this.bbox.width;
                x[1] = x[2] = this.bbox.x;
                x[3] = x[4] = x[1] + this.borderWidth;
                y[0] = y[1] = this.bbox.y;
                y[2] = y[3] = this.bbox.y + this.bbox.height;
                y[4] = y[5] = y[0] + this.borderWidth;
                bgc.fillPolygon(x, y, 6);
                x[0] = x[1] = this.bbox.x;
                x[2] = x[3] = this.bbox.x + this.bbox.width;
                x[4] = x[5] = x[2] - this.borderWidth;
                y[0] = y[5] = this.bbox.y + this.bbox.height - this.borderWidth;
                y[1] = y[2] = this.bbox.y + this.bbox.height;
                y[3] = y[4] = this.bbox.y;
                bgc.fillPolygon(x, y, 6);
                break;
            }
            case 2: {
                bgc.setColor(light);
                bgc.draw3DRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, this.raised);
                break;
            }
            case 3: {
                int x1 = this.bbox.x - 1;
                int x2 = x1 + this.bbox.width + 2;
                int y1 = this.bbox.y - 1;
                int y2 = y1 + this.bbox.height + 2;
                JRectangle.xpoints[0] = x1;
                JRectangle.ypoints[0] = y2;
                JRectangle.xpoints[1] = x1;
                JRectangle.ypoints[1] = y1;
                JRectangle.xpoints[2] = x2;
                JRectangle.ypoints[2] = y1;
                JRectangle.xpoints[3] = x2;
                JRectangle.ypoints[3] = y1 + 2;
                JRectangle.xpoints[4] = x1 + 2;
                JRectangle.ypoints[4] = y1 + 2;
                JRectangle.xpoints[5] = x1 + 2;
                JRectangle.ypoints[5] = y2;
                if (this.raised) {
                    bgc.setColor(light);
                } else {
                    bgc.setColor(dark);
                }
                bgc.fillPolygon(xpoints, ypoints, 6);
                JRectangle.xpoints[0] = x2;
                JRectangle.ypoints[0] = y1;
                JRectangle.xpoints[1] = x2 - 2;
                JRectangle.ypoints[1] = y1 + 2;
                JRectangle.xpoints[2] = x2 - 2;
                JRectangle.ypoints[2] = y2 - 2;
                JRectangle.xpoints[3] = x1 + 2;
                JRectangle.ypoints[3] = y2 - 2;
                JRectangle.xpoints[4] = x1;
                JRectangle.ypoints[4] = y2;
                JRectangle.xpoints[5] = x2;
                JRectangle.ypoints[5] = y2;
                if (this.raised) {
                    bgc.setColor(dark);
                } else {
                    bgc.setColor(light);
                }
                bgc.fillPolygon(xpoints, ypoints, 6);
            }
        }
        return true;
    }

    @Override
    public Stack getNameList() {
        return this.namelist;
    }

    @Override
    public boolean pick(Graphics bgc, Rectangle pickmatrix) {
        if (this.clip) {
            return false;
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (this.clip) {
            return false;
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    void setBorderType(int flag) {
        this.border = flag;
    }

    Point3 getLocation() {
        return this.dscr;
    }
}

