/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.Matrix3;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

class JPolygon
implements Drawable {
    Polygon screen;
    Vector model = new Vector();
    boolean clip;
    int size;
    int type;
    Color color;
    Color edgecolor;
    Stack namelist;
    int fillmode;
    boolean pickable;
    boolean optimized;
    boolean clean;
    int lineWidth;
    int[] stipplePattern;
    Point3[] dscr;
    static Point3 tpnt = new Point3();
    private static double RADIAL_AREA_USE_FACTOR = 1.0;
    static final double FZERO = 1.0E-15;
    private static double _margin = 0.0;

    JPolygon() {
        this.type = 2;
        this.optimized = false;
    }

    JPolygon(int type) {
        this.type = type;
        this.optimized = false;
    }

    void vertex(StateLite state, double x, double y) {
        Point3 v = new Point3(x, y, 1.0);
        this.model.addElement(v);
        ++this.size;
    }

    void end(StateLite state) {
        ChannelLite ch = state.ch;
        this.color = state.color;
        this.lineWidth = state.lineWidth;
        this.edgecolor = state.edgecolor;
        this.stipplePattern = (int[])(ch.state.capabilities[7] ? (int[])ch.state.stipplePattern.clone() : null);
        int[] x = new int[this.size];
        int[] y = new int[this.size];
        this.screen = new Polygon(x, y, this.size);
        this.dscr = new Point3[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.dscr[i] = new Point3();
        }
        this.namelist = state.namelist;
        this.clean = true;
        this.fillmode = state.fillmode;
        this.pickable = state.capabilities[0];
        if (this.type != 2) {
            this.pickable &= state.capabilities[1];
        }
        if (state.render_mode == 3) {
            this.optimized = true;
            Matrix3 w2m = ch.trans.w2m;
            for (int i = 0; i < this.size; ++i) {
                Point3 pi = (Point3)this.model.elementAt(i);
                pi.postMultiply(w2m);
            }
        }
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
        }
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        StateLite state = ch.state;
        TransInfo tr = ch.trans;
        Vector mymodel = this.model;
        Polygon myscreen = this.screen;
        this.clip = false;
        this.clean = false;
        Viewport view = tr.GetViewport();
        double lens = state.lensFactor;
        double thetaLens = tr.getRadialFactor(state.thetaLensFac);
        if (state.dirtyLensFlag) {
            view.computeLogR(lens);
            state.dirtyLensFlag = false;
        }
        Point3 lensOrgLoc = tr.getLensOriginalLocation(thetaLens);
        for (int i = 0; i < this.size; ++i) {
            tpnt.copy((Point3)mymodel.elementAt(i));
            if (state.capabilities[2]) {
                if (state.capabilities[3] && tr.moved && tr.movingDir > state.minAngle && tr.movingDir < state.maxAngle) {
                    JPolygon.angularDistortion(tpnt, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
                }
                if (this.optimized) {
                    tr.Model2Screen(tpnt);
                } else {
                    tr.World2Screen(tpnt);
                }
                if (state.lensDirection == 6) {
                    JPolygon.verticalDistortion(tpnt, view, tr, state.lensFactor);
                } else if (state.lensDirection == 0) {
                    JPolygon.radialDistortion(tpnt, lensOrgLoc, view, tr.movingDir, state.lensFactor);
                } else {
                    JPolygon.conalDistortion(tpnt, lensOrgLoc, view, tr.movingDir, state.lensFactor, state.lensDirection);
                }
            } else if (this.optimized) {
                tr.Model2Screen(tpnt);
            } else {
                tr.World2Screen(tpnt);
            }
            this.dscr[i].x = JPolygon.tpnt.x;
            this.dscr[i].y = JPolygon.tpnt.y;
            myscreen.xpoints[i] = (int)JPolygon.tpnt.x;
            myscreen.ypoints[i] = (int)JPolygon.tpnt.y;
        }
        return !this.clip;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        if (this.clip || this.size == 0) {
            return false;
        }
        bgc.setColor(this.color);
        block0 : switch (this.type) {
            case 0: {
                for (int j = 0; j < this.size; ++j) {
                    bgc.drawOval(this.screen.xpoints[j], this.screen.ypoints[j], 2, 2);
                }
                break;
            }
            case 1: {
                this.doLine(state, bgc);
                break;
            }
            case 3: {
                for (int j = 1; j < this.size; ++j) {
                    bgc.drawLine(this.screen.xpoints[0], this.screen.ypoints[0], this.screen.xpoints[j], this.screen.ypoints[j]);
                }
                break;
            }
            default: {
                switch (this.fillmode) {
                    case 0: {
                        break block0;
                    }
                    case 2: {
                        bgc.drawPolygon(this.screen);
                        this.doLine(state, bgc);
                        break block0;
                    }
                    case 1: {
                        for (int j = 0; j < this.size; ++j) {
                            bgc.drawOval(this.screen.xpoints[j], this.screen.ypoints[j], 2, 2);
                        }
                        break block0;
                    }
                    default: {
                        bgc.fillPolygon(this.screen);
                        if (this.size != 3) break block0;
                        bgc.drawPolygon(this.screen);
                        break block0;
                    }
                    case 4: {
                        bgc.fillPolygon(this.screen);
                        bgc.setColor(this.edgecolor);
                        bgc.drawPolygon(this.screen);
                        this.doLine(state, bgc);
                    }
                }
            }
        }
        return true;
    }

    private void doLine(StateLite state, Graphics bgc) {
        int points = this.screen.xpoints.length - 1;
        if (this.stipplePattern != null) {
            state.stippleHistory[1] = 0;
            state.stippleHistory[0] = 0;
            for (int i = 0; i < points; ++i) {
                JPolygon.stipple(state, bgc, this.stipplePattern, state.stippleHistory, this.dscr[i].x, this.dscr[i].y, this.dscr[i + 1].x, this.dscr[i + 1].y, this.lineWidth);
            }
        } else {
            for (int i = 0; i < points; ++i) {
                JPolygon.drawSegment(state, bgc, this.dscr[i].x, this.dscr[i].y, this.dscr[i + 1].x, this.dscr[i + 1].y, this.lineWidth);
            }
        }
    }

    final int size() {
        return this.size();
    }

    @Override
    public final Stack getNameList() {
        return this.namelist;
    }

    @Override
    public boolean pick(Graphics gc, Rectangle pickmatrix) {
        if (!this.pickable) {
            return false;
        }
        return this.intersects(pickmatrix);
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (!this.pickable) {
            return false;
        }
        return this.intersects(pickmatrix);
    }

    @Override
    public final boolean isClipped() {
        return this.clip;
    }

    final boolean intersects(Rectangle r) {
        Rectangle bbox;
        if (!this.clean) {
            this.screen = new Polygon(this.screen.xpoints, this.screen.ypoints, this.screen.npoints);
            this.clean = true;
        }
        if ((bbox = this.screen.getBounds()).intersects(r)) {
            switch (this.type) {
                case 0: {
                    for (int i = 0; i < this.size; ++i) {
                        if (!r.contains(this.screen.xpoints[i], this.screen.ypoints[i])) continue;
                        return true;
                    }
                    break;
                }
                case 1: {
                    int xx = r.x;
                    int yy = r.y;
                    int dx = xx + r.width;
                    int dy = yy + r.height;
                    for (int ix = xx; ix < dx; ++ix) {
                        for (int iy = yy; iy < dy; ++iy) {
                            if (!this.screen.contains(ix, iy)) continue;
                            return true;
                        }
                    }
                    break;
                }
                default: {
                    int xo = r.x;
                    int yo = r.y;
                    int x1 = xo + r.width;
                    int y1 = yo + r.height;
                    if (r.width == 1 && r.height == 1) {
                        return this.screen.contains(xo, yo);
                    }
                    if (r.contains(this.screen.xpoints[0], this.screen.ypoints[0])) {
                        return true;
                    }
                    if (this.inside(xo, yo)) {
                        return true;
                    }
                    if (this.lineIntersects(xo, yo, x1, yo)) {
                        return true;
                    }
                    if (this.lineIntersects(x1, yo, x1, y1)) {
                        return true;
                    }
                    if (this.lineIntersects(x1, y1, xo, y1)) {
                        return true;
                    }
                    if (!this.lineIntersects(xo, y1, xo, yo)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean pointOnSides(int xo, int yo) {
        int vo = this.screen.xpoints[this.size - 1];
        int wo = this.screen.ypoints[this.size - 1];
        for (int i = 0; i < this.size; ++i) {
            int v1 = this.screen.xpoints[i];
            int w1 = this.screen.ypoints[i];
            int a = (xo - vo) * (vo - w1);
            int b = (yo - wo) * (w1 - wo);
            if (a >= 0 && a <= 1 && a == b) {
                return true;
            }
            vo = v1;
            wo = w1;
        }
        return false;
    }

    private final boolean lineIntersects(int xo, int yo, int x1, int y1) {
        int vo = this.screen.xpoints[this.size - 1];
        int wo = this.screen.ypoints[this.size - 1];
        for (int i = 0; i < this.size; ++i) {
            double t;
            int v1 = this.screen.xpoints[i];
            int w1 = this.screen.ypoints[i];
            int a = (v1 - vo) * (yo - wo);
            int b = (vo - xo) * (w1 - wo);
            int c = (x1 - xo) * (w1 - wo);
            int d = (v1 - vo) * (y1 - yo);
            if ((float)Math.abs(c - d) <= Float.MIN_VALUE || (t = (double)(a + b) / (double)(c - d)) < 0.0 || t > 1.0) continue;
            double s = ((double)(x1 - xo) * t + (double)(xo - vo)) / (double)(v1 - vo);
            if (s >= 0.0 && s <= 1.0) {
                return true;
            }
            vo = v1;
            wo = w1;
        }
        return false;
    }

    private final boolean inside(int x, int y) {
        Rectangle bbox = this.screen.getBounds();
        if (bbox.contains(x, y)) {
            int hits = 0;
            int[] xpoints = this.screen.xpoints;
            int[] ypoints = this.screen.ypoints;
            int npoints = this.screen.npoints;
            for (int i = 0; i < npoints; ++i) {
                float s;
                int j = (i + 1) % npoints;
                int dx = xpoints[j] - xpoints[i];
                int dy = ypoints[j] - ypoints[i];
                if (dy == 0) continue;
                int rx = x - xpoints[i];
                int ry = y - ypoints[i];
                if (ypoints[i] == y) {
                    --ry;
                }
                if (ypoints[j] == y) {
                    ++dy;
                }
                if (!((double)(s = (float)ry / (float)dy) >= 0.0) || !((double)s <= 1.0) || (int)(s * (float)dx) <= rx) continue;
                ++hits;
            }
            return hits % 2 != 0;
        }
        return false;
    }

    static void drawSegment(StateLite state, Graphics gc, double x1, double y1, double x2, double y2, int lineWidth) {
        if (lineWidth <= 1) {
            int[] x = new int[]{(int)x1, (int)x2};
            int[] y = new int[]{(int)y1, (int)y2};
            if (x1 < -32768.0 || x1 > 32767.0 || x2 < -32768.0 || x2 > 32767.0) {
                return;
            }
            gc.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        } else {
            JPolygon.makeWideLine(state, state.wideLineX, state.wideLineY, x1, y1, x2, y2, lineWidth);
            gc.fillPolygon(state.wideLineX, state.wideLineY, state.wideLineX.length);
            if (state.capStyle == 1) {
                double halfWidth = (double)lineWidth / 2.0 - 0.5;
                gc.fillOval((int)(x1 - halfWidth), (int)(y1 - halfWidth), lineWidth, lineWidth);
                gc.fillOval((int)(x2 - halfWidth), (int)(y2 - halfWidth), lineWidth, lineWidth);
            }
        }
    }

    static void makeWideLine(StateLite state, int[] wideX, int[] wideY, double x1, double y1, double x2, double y2, int lineWidth) {
        double halfWidth = (double)lineWidth / 2.0;
        Point3 dir = state.pt1;
        Point3 crossDir = state.pt2;
        Point3 v = state.pt3;
        dir.set(x2 - x1, y2 - y1, 1.0);
        double slope = dir.y / dir.x;
        if (slope > 0.0) {
            crossDir.set(-dir.y, dir.x, 1.0);
        } else {
            crossDir.set(dir.y, -dir.x, 1.0);
        }
        crossDir.normalize();
        crossDir.scale(halfWidth);
        v.set(x1, y1, 1.0);
        v.add(crossDir);
        wideX[0] = (int)(v.x + 0.5);
        wideY[0] = (int)(v.y + 0.5);
        Point3 v1 = new Point3(v.x, v.y, 1.0);
        v.add(dir);
        wideX[1] = (int)(v.x + 0.5);
        wideY[1] = (int)(v.y + 0.5);
        Point3 v2 = new Point3(v.x, v.y, 1.0);
        crossDir.normalize();
        crossDir.scale(-lineWidth);
        v.add(crossDir);
        wideX[2] = (int)(v.x + 0.5);
        wideY[2] = (int)(v.y + 0.5);
        Point3 v3 = new Point3(v.x, v.y, 1.0);
        v.sub(dir);
        wideX[3] = (int)(v.x + 0.5);
        wideY[3] = (int)(v.y + 0.5);
        Point3 v4 = new Point3(v.x, v.y, 1.0);
    }

    static void stipple(StateLite state, Graphics gc, int[] pattern, int[] remainder, double beginX, double beginY, double endX, double endY, int lineWidth) {
        double drawn;
        double x = beginX;
        double y = beginY;
        double dx = endX - beginX;
        double dy = endY - beginY;
        double length = Math.sqrt(dx * dx + dy * dy);
        dx /= length;
        dy /= length;
        int index = remainder[0];
        double d = drawn = remainder[1] > 0 ? (double)remainder[1] : (double)Math.abs(pattern[index]);
        while (length > drawn) {
            endX = beginX + dx * drawn;
            endY = beginY + dy * drawn;
            if (pattern[index] > 0) {
                JPolygon.drawSegment(state, gc, x, y, endX, endY, lineWidth);
            } else {
                x = beginX + dx * (drawn + 1.0);
                y = beginY + dy * (drawn + 1.0);
            }
            index = (index + 1) % pattern.length;
            drawn += (double)Math.abs(pattern[index]);
        }
        if (pattern[index] > 0) {
            JPolygon.drawSegment(state, gc, x, y, beginX + dx * length, beginY + dy * length, lineWidth);
        }
        remainder[0] = index;
        remainder[1] = (int)(drawn - length);
    }

    static double angularDistortion(Point3 loc, double movingDir, double thetaLens, double minang, double maxang) {
        double tempx = -loc.x;
        double tempy = -loc.y;
        double dist = Math.sqrt(loc.x * loc.x + loc.y * loc.y);
        if (dist != 0.0) {
            double theta = Math.atan2(loc.y, loc.x);
            double relTheta = 1.0;
            if (maxang - minang >= 5.969026041820607) {
                relTheta = (theta - movingDir) / Math.PI;
                if (relTheta < -1.0) {
                    relTheta += 2.0;
                } else if (relTheta > 1.0) {
                    relTheta -= 2.0;
                }
                double fac = relTheta < 0.0 ? -(thetaLens + 1.0) / (thetaLens - 1.0 / relTheta) : (relTheta > 0.0 ? (thetaLens + 1.0) / (thetaLens + 1.0 / relTheta) : 0.0);
                theta = fac * Math.PI + movingDir;
            } else if (maxang > Math.PI && (theta > minang || theta < maxang - Math.PI * 2)) {
                if (movingDir < 0.0) {
                    movingDir += Math.PI * 2;
                }
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                if ((relTheta = theta < movingDir ? (theta - movingDir) / (movingDir - minang) : (theta > movingDir ? (theta - movingDir) / (maxang - movingDir) : 0.0)) < 0.0) {
                    double fac = -(thetaLens + 1.0) / (thetaLens - 1.0 / relTheta);
                    theta = movingDir + fac * (movingDir - minang);
                } else if (relTheta > 0.0) {
                    double fac = (thetaLens + 1.0) / (thetaLens + 1.0 / relTheta);
                    theta = movingDir + fac * (maxang - movingDir);
                } else {
                    theta = movingDir;
                }
            } else if (theta > minang && theta < maxang) {
                relTheta = theta < movingDir ? (theta - movingDir) / (movingDir - minang) : (theta > movingDir ? (theta - movingDir) / (maxang - movingDir) : 0.0);
                if (relTheta < 0.0) {
                    double fac = -(thetaLens + 1.0) / (thetaLens - 1.0 / relTheta);
                    theta = movingDir + fac * (movingDir - minang);
                } else if (relTheta > 0.0) {
                    double fac = (thetaLens + 1.0) / (thetaLens + 1.0 / relTheta);
                    theta = movingDir + fac * (maxang - movingDir);
                } else {
                    theta = movingDir;
                }
            }
            double cost = Math.cos(theta);
            double sint = Math.sin(theta);
            loc.x = dist * cost;
            loc.y = dist * sint;
            return Math.abs(relTheta * dist);
        }
        return 0.0;
    }

    static double radialDistortion(Point3 loc, Point3 ref, Viewport view, double movingDir, double lens) {
        double tempx = loc.x > ref.x ? (loc.x - ref.x) * (view.wby2 / ref.x) : (loc.x - ref.x) * (view.wby2 / ((double)view.width - ref.x));
        double tempy = loc.y > ref.y ? (loc.y - ref.y) * (view.hby2 / ref.y) / view.aspect : (loc.y - ref.y) * (view.hby2 / ((double)view.height - ref.y)) / view.aspect;
        double dist = Math.sqrt(tempx * tempx + tempy * tempy);
        double fac = Math.log(lens * dist + 1.0);
        double rfac = fac / view.logR;
        double newrad = (rfac < 1.0 ? rfac * view.maxR : view.maxR) * RADIAL_AREA_USE_FACTOR;
        double theta = 0.0;
        if (dist == 0.0) {
            loc.x = ref.x;
            loc.y = ref.y;
        } else {
            theta = Math.atan2(tempy, tempx);
            double cost = Math.cos(theta);
            double sint = Math.sin(theta);
            loc.x = cost > 0.0 ? newrad * cost * ((double)view.width - ref.x) / view.wby2 + ref.x : newrad * cost * (ref.x / view.wby2) + ref.x;
            loc.y = sint > 0.0 ? view.aspect * newrad * sint * ((double)view.height - ref.y) / view.hby2 + ref.y : view.aspect * newrad * sint * (ref.y / view.hby2) + ref.y;
        }
        return dist / view.maxR;
    }

    static double conalDistortion(Point3 loc, Point3 ref, Viewport view, double movingDir, double lens, int dir) {
        double tempx = loc.x > ref.x ? (loc.x - ref.x) * (view.wby2 / ref.x) : (loc.x - ref.x) * (view.wby2 / ((double)view.width - ref.x));
        double tempy = loc.y > ref.y ? (loc.y - ref.y) * (view.hby2 / ref.y) / view.aspect : (loc.y - ref.y) * (view.hby2 / ((double)view.height - ref.y)) / view.aspect;
        double dist = Math.sqrt(tempx * tempx + tempy * tempy);
        double adj = 1.0;
        switch (dir) {
            default: {
                break;
            }
            case 4: {
                adj = loc.y / (double)view.height;
                break;
            }
            case 3: {
                adj = ((double)view.height - loc.y) / (double)view.height;
                break;
            }
            case 2: {
                adj = loc.x / (double)view.width;
                break;
            }
            case 1: {
                adj = ((double)view.width - loc.x) / (double)view.width;
            }
        }
        double fac = Math.log((lens *= Math.pow(adj, 2.0)) * dist + 1.0);
        double logR = Math.log(lens * view.maxR + 1.0);
        double rfac = fac / logR;
        double newrad = rfac < 1.0 ? rfac * view.maxR : view.maxR;
        double theta = 0.0;
        if (dist == 0.0) {
            loc.x = ref.x;
            loc.y = ref.y;
        } else {
            theta = Math.atan2(tempy, tempx);
            double cost = Math.cos(theta);
            double sint = Math.sin(theta);
            loc.x = cost > 0.0 ? newrad * cost * ((double)view.width - ref.x) / view.wby2 + ref.x : newrad * cost * (ref.x / view.wby2) + ref.x;
            loc.y = sint > 0.0 ? view.aspect * newrad * sint * ((double)view.height - ref.y) / view.hby2 + ref.y : view.aspect * newrad * sint * (ref.y / view.hby2) + ref.y;
        }
        return dist / view.maxR;
    }

    static double verticalDistortion(Point3 loc, Viewport view, TransInfo tr, double lens) {
        double dist;
        double[] locs = tr.lensLocs;
        double[] range = tr.lensRange;
        double[] values = tr.lensValues;
        int index = 0;
        if (loc.y > range[range.length - 1]) {
            index = range.length - 1;
        } else {
            while (loc.y > range[index]) {
                ++index;
            }
        }
        lens = values[index];
        double totWidth = Math.sqrt(lens);
        double wbyX = view.width / 10;
        double delta = wbyX / totWidth;
        double ratio = 0.0;
        if (lens <= 1.0) {
            return 1.0;
        }
        if (loc.x == locs[index]) {
            return 1.0;
        }
        if (loc.x > locs[index]) {
            if (loc.x > locs[index] + delta) {
                dist = Math.max(0.0, Math.min(0.95, (loc.x - locs[index] - delta) / ((double)view.width - locs[index] - delta)));
                double fac = Math.log(lens * dist + 1.0) / Math.log(lens + 1.0);
                loc.x = locs[index] + wbyX + ((double)view.width - locs[index] - wbyX) * fac;
                ratio = fac;
            } else {
                loc.x = locs[index] + wbyX * (loc.x - locs[index]) / delta;
            }
        } else if (loc.x < locs[index] - delta) {
            dist = Math.max(0.0, Math.min(0.95, (locs[index] - delta - loc.x) / (locs[index] - delta)));
            double fac = Math.log(lens * dist + 1.0) / Math.log(lens + 1.0);
            loc.x = locs[index] - wbyX - (locs[index] - wbyX) * fac;
            ratio = fac;
        } else {
            loc.x = locs[index] - wbyX * (locs[index] - loc.x) / delta;
        }
        double MARGIN = _margin;
        if (loc.x < MARGIN) {
            loc.x = MARGIN;
        }
        if (loc.x > (double)view.width - MARGIN) {
            loc.x = (double)view.width - MARGIN;
        }
        return ratio;
    }

    static double verticalDistortion(Point3 loc, Viewport view, TransInfo tr, double lens, double lensScreenUseArea, StateLite state) {
        double dist;
        if (state.lensWorldAreaPercentages == null || lensScreenUseArea == 0.0) {
            return JPolygon.verticalDistortion(loc, view, tr, lens);
        }
        lensScreenUseArea /= 2.0;
        double[] locs = tr.lensLocs;
        double[] range = tr.lensRange;
        double[] values = tr.lensValues;
        int index = 0;
        if (loc.y > range[range.length - 1]) {
            index = range.length - 1;
        } else {
            while (loc.y > range[index]) {
                ++index;
            }
        }
        double screenWidth = (double)view.width * 0.85;
        double margin = ((double)view.width - screenWidth) / 2.0;
        lens = values[index];
        double lwp = 0.0;
        if (index < state.lensWorldAreaPercentages.length) {
            lwp = state.lensWorldAreaPercentages[index];
        }
        double worldMargin = screenWidth * lwp;
        double screenMargin = screenWidth * lensScreenUseArea;
        double ratio = 0.0;
        if (lens <= 1.0 || index > state.lensWorldAreaPercentages.length) {
            ratio = 1.0;
        } else if (loc.x == locs[index]) {
            ratio = 1.0;
        } else if (loc.x > locs[index]) {
            if (loc.x > locs[index] + worldMargin) {
                dist = Math.max(0.0, Math.min(0.95, (loc.x - locs[index] - worldMargin) / ((double)view.width - margin - locs[index] - worldMargin)));
                double fac = Math.log(lens * dist + 1.0) / Math.log(lens + 1.0);
                loc.x = locs[index] + screenMargin + ((double)view.width - margin - locs[index] - screenMargin) * fac;
                ratio = fac;
            } else {
                double fac = lensScreenUseArea / lwp;
                loc.x = locs[index] + (loc.x - locs[index]) * fac;
                ratio = fac;
            }
        } else if (loc.x < locs[index] - worldMargin) {
            dist = Math.max(0.0, Math.min(0.95, (locs[index] - worldMargin - loc.x) / (locs[index] - worldMargin + margin)));
            double fac = Math.log(lens * dist + 1.0) / Math.log(lens + 1.0);
            loc.x = locs[index] + margin - screenMargin - (locs[index] - screenMargin) * fac;
            ratio = fac;
        } else {
            double fac = lensScreenUseArea / lwp;
            loc.x = locs[index] - (locs[index] - loc.x) * fac;
            ratio = fac;
        }
        double MARGIN = _margin;
        if (loc.x < MARGIN) {
            loc.x = MARGIN;
        }
        if (loc.x > (double)view.width - MARGIN) {
            loc.x = (double)view.width - MARGIN;
        }
        return ratio;
    }

    public static void setVerticalLensMargin(double margin) {
        _margin = margin;
    }

    public static double getRadialAreaUseFactor() {
        return RADIAL_AREA_USE_FACTOR;
    }

    public static void setRadialAreaUseFactor(double radial_area_use_factor) {
        RADIAL_AREA_USE_FACTOR = radial_area_use_factor;
    }
}

